package com.ella.user.dto;

import com.ella.frame.common.util.HeadParamTl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.io.Serializable;

/**
 * @author ZLN
 * @create 2018-08-10 17:07
 **/
@Data
@ApiModel("第三方绑定账号入参")
public class PlatformBindMobileReq extends HeadParamTl implements Serializable {
    private static final long serialVersionUID = 8899166223574214954L;

    @ApiModelProperty(notes = "手机号", required = true)
    @NotEmpty(message = "手机号为空")
    private String customerName;

    @ApiModelProperty(notes = "密码", required = true)
    private String password;

    @ApiModelProperty("验证码")
    private String chekCode;

    @NotEmpty
    @ApiModelProperty("第三方")
    private String uid;

    @NotEmpty
    @ApiModelProperty("第三方平台类型：WEIXIN,QQ,SINA")
    private String platformType;
}
