package com.ella.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("查询用户评论列表请求")
public class ListUserReviewRequest extends PageDto {

	private static final long serialVersionUID = 1781868421283815607L;

	@ApiModelProperty(value = "用户UID(CURRENT表示当前登录用户)", required = false)
	private String userId;

	@ApiModelProperty(value = "资源ID", required = false)
	private String resId;

	@ApiModelProperty(value = "资源类型（BOOK-绘本）", required = false)
	private String resType;

	@ApiModelProperty(value = "资源名称", required = false)
	private String resName;

	@ApiModelProperty(value = "评论类型（TEXT-文本,VOICE-语音）", required = false)
	private String reviewType;

	@ApiModelProperty(value = "评论星级(0-5)", required = false)
	private Short reviewLevel;

	@ApiModelProperty(value = "评论内容", required = false)
	private String reviewContent;

	@ApiModelProperty(value = "是否精彩评论(N-否，Y-是)", required = false)
	private String isPerfect;

	@ApiModelProperty(value = "评论审批状态 (WAIT_APPROVAL-未审批，APPROVAL_YES-审批通过，APPROVAL_NO-审批拒绝)", required = false)
	private String approvalStatus;

	@ApiModelProperty(value = "创建人", required = false, hidden = true)
	private String createBy;

	@ApiModelProperty(value = "修改人(CURRENT表示当前登录管理员)", required = false)
	private String updateBy;

	@ApiModelProperty(value = "数据状态(NORMAL-正常,DELETE-删除)", required = false)
	private String status;

	@ApiModelProperty(value = "搜索关键字（精确匹配-用户昵称、用户账号、评论书籍，模糊匹配-评论内容）", required = false)
	private String searchKey;
}
