package com.ella.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("用户反馈列表查询请求")
@Data
public class ListUserFeedbackRequest extends PageDto {

	private static final long serialVersionUID = 4866577957080380957L;
	
	@ApiModelProperty("反馈用户的ID（='CURRENT'时，服务端获取当前登录用户ID）")
	private String uid;
	
	@ApiModelProperty("用户名(注册手机号)")
	private String uname;
	
	@ApiModelProperty("反馈内容（模糊匹配）")
	private String content;

	@ApiModelProperty("反馈渠道")
	private String channel;

	@ApiModelProperty("设备型号")
	private String deviceModel;

	@ApiModelProperty("版本号")
	private String version;

	@ApiModelProperty("处理状态(WAIT_APPROVAL-未处理,RECEIVED-已接收，CONNECTING-联系中，RESOLVED-已解决)")
	private String approvalStatus;

	@ApiModelProperty("数据状态(NORMAL-正常,DELETE-删除)")
	private String status;
}
