package com.ella.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@ApiModel("查询昵称列表请求参数")
@Data
@EqualsAndHashCode(callSuper = false)
public class ListNicknameCfgRequest extends PageDto implements Serializable {
	private static final long serialVersionUID = 1829857318989925834L;

	@ApiModelProperty("英文昵称")
	private String eName;

	@ApiModelProperty("中文昵称")
	private String cName;

	@ApiModelProperty("性别（男:MALE  女:FEMALE）")
	private String gender;

	@ApiModelProperty("创建人")
	private String createBy;

	@ApiModelProperty("更新人")
	private String updateBy;

	@ApiModelProperty("排序(1:随机,2:英文名顺序,3:英文名倒序,4：使用次数顺序,5：使用次数倒叙 ,6：添加时间顺序,7：添加时间倒序)，默认5")
	private Integer orderBy;

	@ApiModelProperty("状态")
	private String status;
}
