package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("历史蓝思评测信息")
@EqualsAndHashCode

public class LexileLevelHistoryDto implements Serializable{

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "评测历史自增ID")
	private Integer id;

	@ApiModelProperty(notes = "用户uid")
	private String uid;

	@ApiModelProperty(notes = "测评id")
	private Integer evaluationId;

	@ApiModelProperty(notes = "年龄")
	private Integer age;

	@ApiModelProperty(notes = "题目数量")
	private Integer testNum;

	@ApiModelProperty(notes = "答题正确数量")
	private Integer correctNum;

	@ApiModelProperty(notes = "等级")
	private String levelCode;

	@ApiModelProperty(notes = "蓝思原始分值")
	private Integer lexileScore;

	@ApiModelProperty(notes = "标准误差")
	private Integer lexileSem;

	@ApiModelProperty(notes = "蓝思值")
	private String lexileLevel;

	@ApiModelProperty(notes = "开始时间")
	private Date startTime;

	@ApiModelProperty(notes = "完成时间")
	private Date endTime;

	@ApiModelProperty(notes = "状态")
	private String status;

	@ApiModelProperty(value = "是否晋级")
	private Boolean promotion;

	@ApiModelProperty(notes = "界面展示时间")
	private String showTime;
	
	@ApiModelProperty(notes = "超过了全国多少同龄的儿童")
	private String lexileRank;
	
	@ApiModelProperty(notes = "蓝思等级信息")
	private LexileLevelDto levelDto;
	
	@ApiModelProperty(notes = "错题关卡信息")
	private List<Map<String, Object>> missionInfo;
}
