package com.ella.user.dto;

import com.ella.frame.common.util.HeadParamTl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;

import java.io.Serializable;

/**
 * @author ZLN
 * @create 2018-08-10 15:53
 **/
@Data
@ApiModel("第三方登录")
public class BindAndLoginVo extends HeadParamTl implements Serializable{
    private static final long serialVersionUID = 7119645718566777868L;
    @ApiModelProperty("用户手机号")
    private String customerName;
    @ApiModelProperty("密码")
    private String password;
    @ApiModelProperty("客户端版本")
    private String clientVersion;
    @ApiModelProperty("国家编码")
    private String countryCode;

    @ApiModelProperty("设备token（友盟消息推送使用）APP登录必传")
    private String deviceToken;

    @ApiModelProperty("用户唯一标识 第三方用户的授权id")
    private String uid;
    @ApiModelProperty(" 用户唯一标识 第三方用户的授权id")
    private String unionID;
    @ApiModelProperty("第三方用户名称")
    private String idname;
    @ApiModelProperty("性别")
    private String gender;
    @ApiModelProperty("用户头像")
    private String iconurl;
    @ApiModelProperty("第三方平台类型：WEIXIN,QQ,SINA")
    private String platformType;
    @ApiModelProperty("国家")
    private String country;
    @ApiModelProperty("省份")
    private String province;
    @ApiModelProperty("城市")
    private String city;
    @ApiModelProperty("用户登录验证类型0.不需要验证码登录1.需要验证码登录   直接0")
    private String loginVerificationType;
    @ApiModelProperty("用户登录验证类型0.不需要验证码登录1.需要验证码登录")
    private String checkCode;
    @ApiModelProperty("三方登录绑定:0  个人中心绑定:1")
    private Integer loginFrom;
    /**
     * 用于app我的中心中 绑定:别的第三方
     */
    @ApiModelProperty(hidden = true)
    private String appUid;
}
