package com.ella.user.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("添加用户评论请求")
public class AddUserReviewRequest implements Serializable {
	private static final long serialVersionUID = -6443152164496999697L;

	@ApiModelProperty(value = "用户ID", hidden = true)
	private String uid;

	@NotNull
	@ApiModelProperty(value = "资源ID（BOOK_CODE）", required = true)
	private String resId;

	@NotNull
	@ApiModelProperty(value = "资源类型（BOOK-绘本）", required = true)
	private String resType;

	@NotNull
	@ApiModelProperty(value = "资源名称", required = true)
	private String resName;

	@NotNull
	@ApiModelProperty(value = "评论类型（TEXT-文本,VOICE-语音）", required = true)
	private String reviewType;

	@NotNull
	@ApiModelProperty(value = "评论星级(0-5)", required = true)
	private Short reviewLevel;

	@NotNull
	@ApiModelProperty(value = "评论内容", required = true)
	private String reviewContent;
}
