package com.ella.user.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("用户反馈请求")
public class AddUserFeedbackRequest implements Serializable {
	private static final long serialVersionUID = 7243917569207225686L;
	@ApiModelProperty(value = "用户ID", hidden = true)
	private String uid;

	@ApiModelProperty(value = "反馈内容", required = true)
	@NotNull
	private String content;

	@ApiModelProperty("附图1")
	private String attach1;

	@ApiModelProperty("附图2")
	private String attach2;

	@ApiModelProperty("附图3")
	private String attach3;

	@ApiModelProperty("反馈渠道")
	private String channel;

	@ApiModelProperty("设备型号")
	private String deviceModel;

	@ApiModelProperty("版本号")
	private String version;

	@ApiModelProperty("联系方式")
	private String contact;
}
