package com.ella.user.api.learn;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.dictionary.DictionaryAndUserLearnDto;
import com.ella.user.dto.dictionary.DictionaryDto;
import com.ella.user.dto.request.dictionary.QueryWordInCourseRequest;
import com.ella.user.dto.request.dictionary.QueryWordRequest;

@FeignClient(value = "en-user-service")
public interface DictionaryService {
	
	/**
	 * 查看单词翻译
	 * 
	 */
	@RequestMapping(value = "/v1/dictionaryService/queryWord", method = RequestMethod.POST)
	ResponseParams<DictionaryDto> queryWord(@RequestBody QueryWordRequest request);
	
	/**
	 * 自学模式-查看单词翻译及用户跟读信息
	 * 
	 */
	@RequestMapping(value = "/v1/dictionaryService/queryWordAndUserVoiceInCourse", method = RequestMethod.POST)
	ResponseParams<DictionaryAndUserLearnDto> queryWordAndUserVoiceInCourse(@RequestBody QueryWordInCourseRequest request);
}
