package com.ella.user.api.auth;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.VisitorsDto;
import com.ella.user.dto.user.Session;
import com.ella.user.dto.user.UserLoginRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient("en-user-service")
public interface SecurityService {

    @RequestMapping(value = "/v1/login", method = RequestMethod.POST)
    ResponseParams<Session> login(@RequestBody UserLoginRequest req);

    @RequestMapping(value = "/v1/verificationCode", method = RequestMethod.GET)
    ResponseParams sendVerificationCode(@RequestParam("phone") String phone, @RequestParam("type") String type);

    /**
     * 游客登录
     *
     * @param dto VisitorsDto
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/enVisitorsLogin", method = RequestMethod.POST)
    ResponseParams<Session> enVisitorsLogin(@RequestBody VisitorsDto dto);
}
