package com.ella.user.api.auth;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.BindAndLoginVo;
import com.ella.user.dto.PlatformBindMobileReq;
import com.ella.user.dto.request.account.UnBindReq;
import com.ella.user.dto.user.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户
 *
 * @author ZLN
 * @create 2018-07-23 15:09
 **/
@FeignClient("en-user-service")
public interface AccountService {

    @RequestMapping(value = "newPlatformBindMobile/v1", method = RequestMethod.POST)
    ResponseParams newPlatformBindMobile(@RequestBody PlatformBindMobileReq req);

    /**
     * 第三方平台解除绑定
     *
     * @param req
     * @return ResponseParams
     */
    @RequestMapping(value = "v1/unBind", method = RequestMethod.POST)
    ResponseParams unBind(@RequestBody UnBindReq req);

    @RequestMapping(value = "platformBindMobile/v1", method = RequestMethod.POST)
    ResponseParams platformBindMobile(@RequestBody PlatformBindMobileReq req);

    @RequestMapping(value = "otherPlatformLogin/v1", method = RequestMethod.POST)
    ResponseParams otherPlatformLogin(@RequestBody BindAndLoginVo vo);


    @RequestMapping(value = "v1/logout", method = RequestMethod.GET)
    ResponseParams logout(@RequestParam("token") String token);

    /**
     * 通过用户名及客户端类型
     * 注：该接口只供服务端之间使用。不暴露给外部用户
     * clientRole : app - app用户  ,visitor -app游客, ots - 运营工具
     */
    @RequestMapping(value = "v1/logoutForInner", method = RequestMethod.GET)
    ResponseParams<Boolean> logoutForInner(@RequestParam("username") String username, @RequestParam("clientRole") String clientRole);

    @RequestMapping(value = "v1/perfectKidInfo", method = RequestMethod.POST)
    ResponseParams perfectKidInfo(@RequestBody PerfectKidInfoRequest request) throws Exception;

    /**
     * 修改密验证码校验
     */
    @RequestMapping(value = "v1/checkCodeConfirm", method = RequestMethod.POST)
    ResponseParams checkCodeConfirm(@RequestBody CheckCodeConfirmRequest request);

    /**
     * 重置密码
     */
    @RequestMapping(value = "v1/resetPassword", method = RequestMethod.POST)
    ResponseParams resetPassword(@RequestBody ResetPasswordRequest request);

    /**
     * APP登录
     */
    @RequestMapping(value = "v1/applogin", method = RequestMethod.POST)
    ResponseParams applogin(@RequestBody UserLoginRequest request);

    /**
     * APP注册
     */
    @RequestMapping(value = "/v1/register", method = RequestMethod.POST)
    ResponseParams regiser(@RequestBody RegisterRequest request);

    /**
     * 校验书籍
     */
    @RequestMapping(value = "/v1/verifyUserBook", method = RequestMethod.POST)
    void verifyUserBook(@RequestParam("uid") String uid);

    /**
     * 游客登录
     *
     * @param request RegisterRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/visitorsLogin", method = RequestMethod.POST)
    ResponseParams visitorsLogin(@RequestBody RegisterRequest request);

    @RequestMapping(value = "/v1/visitorsLoginElla", method = RequestMethod.POST)
    String visitorsLoginElla(@RequestParam("uid") String uid);

    /**
     * APP登录
     */
    @RequestMapping(value = "v1/apploginElla", method = RequestMethod.POST)
    String apploginElla(@RequestParam("uid") String uid, @RequestParam("mobile") String mobile, @RequestParam("email") String email);

    /**
     * 修改用户蓝思评测次数
     * @param uid
     * @return
     */
    @RequestMapping(value = "/v1/updateEvaluationTime" , method = RequestMethod.POST)
    ResponseParams<Boolean> updateEvaluationTime(@RequestParam("uid")String uid , @RequestParam("num")Integer num);

    @RequestMapping(value = "/v1/getEvaluationTime" , method = RequestMethod.POST)
    Integer getEvaluationTime(@RequestParam("uid")String uid);

    @RequestMapping(value = "/v1/registerByEllabook", method = RequestMethod.POST)
    String registerByEllabook(@RequestParam("uid") String uid, @RequestParam("role") String role);
}
