package com.ella.user.api;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.userots.AddUserOtsRequest;
import com.ella.user.dto.userots.EditUserOtsRequest;
import com.ella.user.dto.userots.ListUserOtsRequest;
import com.ella.user.dto.userots.UserOtsDto;
import com.github.pagehelper.PageInfo;

@FeignClient("en-user-service")
public interface UserOtsService {

	@RequestMapping(value = "/v1/user-ots/add", method = RequestMethod.POST)
	ResponseParams<Boolean> add(@RequestBody AddUserOtsRequest request);

	@RequestMapping(value = "/v1/user-ots/edit", method = RequestMethod.POST)
	ResponseParams<Boolean> edit(@RequestBody EditUserOtsRequest request);

	@RequestMapping(value = "/v1/user-ots/list", method = RequestMethod.POST)
	ResponseParams<PageInfo<UserOtsDto>> list(@RequestBody ListUserOtsRequest request);
}
