package com.ella.user.api;

import java.util.List;
import java.util.Map;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.AccountDto;
import com.ella.user.dto.LearnReportDetailDto;
import com.ella.user.dto.LearnReportDto;
import com.ella.user.dto.UserCourseDto;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.WordFollowRecordListDto;
import com.ella.user.dto.WordQueryRecordListDto;
import com.ella.user.dto.request.userinfo.AreaRequest;
import com.ella.user.dto.request.userinfo.FindUserByIdRequest;
import com.ella.user.dto.request.userinfo.GetLearnReportRequest;
import com.ella.user.dto.request.userinfo.GetReportDetailRequest;
import com.ella.user.dto.request.userinfo.ListUserInfoRequest;
import com.ella.user.dto.request.userinfo.ReportWordRequest;
import com.ella.user.dto.request.userinfo.UpdateUserInfoRequest;
import com.ella.user.dto.request.userinfo.UpdateUserLevelRequest;
import com.ella.user.dto.user.UserDetailDto;
import com.ella.user.dto.user.UserListDto;
import com.github.pagehelper.PageInfo;

@FeignClient("en-user-service")
public interface UserInfoService {
	/**
	 * 获取用户信息 ->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/getUserInfoById", method = RequestMethod.POST)
	ResponseParams<UserInfoDto> getUserInfoById(FindUserByIdRequest request);
	
	/**
	 * 查询用户账户信息 ->chenshuai
	 * @param uid
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/getUserAccountInfo", method = RequestMethod.POST)
	ResponseParams<AccountDto> getUserAccountInfo(@RequestParam("uid")String uid);

	/**
	 * 编辑用户->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/updateUser", method = RequestMethod.POST)
	ResponseParams<Boolean> updateUser(UpdateUserInfoRequest request);

	/**
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/update-level", method = RequestMethod.POST)
	ResponseParams<Boolean> updateUserLevelInfo(UpdateUserLevelRequest request);

	/**
	 * 根据uid获取用户基础信息
	 *
	 * @param uid
	 *            uid
	 * @return ResponseParams ResponseParams
	 */
	@RequestMapping(value = "/v1/user-info/selectUserByUid", method = RequestMethod.POST)
	ResponseParams<UserInfoDto> selectUserByUid(@RequestParam("uid") String uid);

	/**
	 * 获取学习报告->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/getLearnReport", method = RequestMethod.POST)
	ResponseParams<LearnReportDto> getLearnReport(GetLearnReportRequest request);

	/**
	 * 获取所在地址->zhaojl
	 * @param area
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/getAreaInfo", method = RequestMethod.POST)
	ResponseParams<List<Map<String, Object>>> getAreaInfo(AreaRequest area);

	/**
	 * 学习报告体验页->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/getLearnReportMainDetail", method = RequestMethod.POST)
	ResponseParams<LearnReportDetailDto> getLearnReportMainDetail(GetReportDetailRequest request);

	/**
	 * 学习报告lv级别->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/getLearnReportLVDetail", method = RequestMethod.POST)
	ResponseParams<List<UserCourseDto>> getLearnReportLVDetail(GetReportDetailRequest request);

	/**
	 * 跟读信息->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/getLearnReportFollowDetail", method = RequestMethod.POST)
	ResponseParams<WordFollowRecordListDto> getLearnReportFollowDetail(ReportWordRequest request);

	/**
	 * 查询词汇信息->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-info/getLearnReportQueryDetail", method = RequestMethod.POST)
	ResponseParams<WordQueryRecordListDto> getLearnReportQueryDetail(ReportWordRequest request);

	@RequestMapping(value = "/v1/user-info/list")
	ResponseParams<PageInfo<UserListDto>> listUserInfo(@RequestBody ListUserInfoRequest request);

	@RequestMapping(value = "/v1/user-info/detail", method = RequestMethod.GET)
	ResponseParams<UserDetailDto> detail(@RequestParam(value = "uid", required = true) String uid);

	@RequestMapping(value = "/v1/user-info/getUserByMobile", method = RequestMethod.GET)
	UserInfoDto getUserByMobile(@RequestParam(value = "mobile") String mobile);

	@RequestMapping(value = "/v1/user-info/getEvaluationTime", method = RequestMethod.GET)
	ResponseParams<Map<String , Integer>> getEvaluationTime(@RequestParam("uid") String uid);
}
