package com.ella.user.api;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.AddUserFeedbackHandleRecordRequest;
import com.ella.user.dto.AddUserFeedbackRequest;
import com.ella.user.dto.GetUserFeedbackDetailRequest;
import com.ella.user.dto.ListUserFeedbackRequest;
import com.ella.user.dto.UserFeedbackDto;
import com.ella.user.dto.UserFeedbackHandleRecordDto;
import com.github.pagehelper.PageInfo;

/**
 * 用户反馈Api接口
 * 
 * @author maofengHan
 *
 */
@FeignClient(value = "en-user-service")
public interface UserFeedbackService {

	/**
	 * 新增用户反馈
	 * 
	 * @param request
	 *            用户反馈内容
	 * @return
	 */
	@RequestMapping(path = "/v1/user-feeedback/add", method = RequestMethod.POST)
	ResponseParams<Boolean> feedback(@RequestBody AddUserFeedbackRequest feedback);

	/**
	 * 根据ID查询一条反馈记录详情,包含处理记录
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(path = "/v1/user-feeedback/detail", method = RequestMethod.POST)
	ResponseParams<UserFeedbackDto> detail(GetUserFeedbackDetailRequest request);

	/**
	 * 查询用户反馈列表
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(path = "/v1/user-feeedback/list", method = RequestMethod.POST)
	ResponseParams<PageInfo<UserFeedbackDto>> listUserFeedback(@RequestBody ListUserFeedbackRequest request);

	/**
	 * 添加用户反馈处理记录
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(path = "/v1/user-feedback/handle", method = RequestMethod.POST)
	ResponseParams<UserFeedbackHandleRecordDto> handle(@RequestBody AddUserFeedbackHandleRecordRequest request);
}
