package com.ella.user.api;

import java.util.Map;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.AddNicknameCfgRequest;
import com.ella.user.dto.AddNicknameCfgUseNumRequest;
import com.ella.user.dto.ListNicknameCfgRequest;
import com.ella.user.dto.NicknameCfgDto;
import com.ella.user.dto.UpdateNicknameCfgRequest;
import com.github.pagehelper.PageInfo;

/**
 * 用户昵称配置操作接口
 * <p>
 * 添加/删除/批量插入操作需要后台管理员相关权限
 * </p>
 * 
 * @author maofengHan
 *
 */
@FeignClient(value = "en-user-service")
public interface NicknameCfgService {

	/**
	 * 添加一项用户昵称配置
	 * 
	 * @param request
	 *            配置信息
	 * @return NicknameCfgDto 成功，Null 失败
	 */
	@RequestMapping(value = "/v1/nickname-cfg/add-one", method = RequestMethod.POST)
	ResponseParams<NicknameCfgDto> addNickname(AddNicknameCfgRequest request);

	/**
	 * 使用Excel，批量导入昵称配置
	 * <p>
	 * Excel 共三列（英文昵称(ename)|中文昵称(cname)|性别(gender)），第一行为表头，第二行开始为数据
	 * </p>
	 * 
	 * @param file
	 *            Excel文件
	 * @param createBy
	 *            管理员
	 * @return
	 */
	@RequestMapping(value = "/v1/nickname-cfg/batch-add", method = RequestMethod.POST)
	ResponseParams<Map<String, String>> batchAddNickname(@RequestParam("contentsJson") String contentsJson,
			@RequestParam("createBy") String createBy);

	/**
	 * 增加一条昵称配置的一次使用记录
	 * 
	 * @param ename
	 *            英文昵称
	 * @return true 成功，false 失败
	 */
	@RequestMapping(value = "/v1/nickname-cfg/add-use-time", method = RequestMethod.POST)
	ResponseParams<Boolean> addUseTimes(AddNicknameCfgUseNumRequest request);

	/**
	 * 更新一条昵称配置
	 * 
	 * @param request
	 *            配置信息
	 * @return NicknameCfgDto 成功，Null 失败
	 */
	@RequestMapping(value = "/v1/nickname-cfg/update", method = RequestMethod.POST)
	ResponseParams<NicknameCfgDto> updateNicknameCfg(UpdateNicknameCfgRequest request);

	/**
	 * 昵称配置列表接口
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/nickname-cfg/list", method = RequestMethod.POST)
	ResponseParams<PageInfo<NicknameCfgDto>> listNicknameCfg(ListNicknameCfgRequest request);

}
