/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.wrapper;

import com.alibaba.fastjson.JSONObject;
import com.ella.resource.domain.CourseQuestionAnswer;
import com.ella.resource.domain.CourseQuestionOption;
import com.ella.resource.domain.UserCourseInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserCourseWrapper {
    private UserCourseInfo userCourseInfo;
    private List<CourseQuestionAnswer> courseQuestionAnswerList;
    private List<CourseQuestionOption> courseQuestionOptionList;
    private static UserCourseWrapper fluencyAndAccuracy;
    public static String NONE_RESLUT;
    public static String TIME_OUT;

    public static UserCourseWrapper parse(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        UserCourseWrapper result = new UserCourseWrapper();
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        result.setUserCourseInfo(UserCourseWrapper.getUserCourseInfoFromJson((JSONObject)jsonObject));
        result.setCourseQuestionAnswerList(UserCourseWrapper.getAnswerListFromJson((Object)jsonObject.get((Object)"detail")));
        result.setCourseQuestionOptionList(UserCourseWrapper.getOptionListFromJson((Object)jsonObject.get((Object)"answerset")));
        UserCourseWrapper.setFluencyAndAccuracy((UserCourseWrapper)result);
        return result;
    }

    private static List<CourseQuestionOption> getOptionListFromJson(Object answerset) {
        ArrayList<CourseQuestionOption> result = new ArrayList<CourseQuestionOption>();
        List jsonObjectList = (List)answerset;
        if (CollectionUtils.isEmpty((Collection)jsonObjectList)) {
            return result;
        }
        jsonObjectList.forEach(j -> result.add(CourseQuestionOption.builder().optionId(UserCourseWrapper.optionalInteger((Object)j.get((Object)"answereid"))).optionType(UserCourseWrapper.optionalString((Object)j.get((Object)"answertype"))).spriteTag(UserCourseWrapper.optionalString((Object)j.get((Object)"spritetag"))).oralType(UserCourseWrapper.optionalInteger((Object)j.get((Object)"oraltype"))).content(UserCourseWrapper.optionalString((Object)j.get((Object)"content"))).createTime(new Date()).build()));
        return result;
    }

    private static List<CourseQuestionAnswer> getAnswerListFromJson(Object detail) {
        ArrayList<CourseQuestionAnswer> result = new ArrayList<CourseQuestionAnswer>();
        List jsonObjectList = (List)detail;
        if (CollectionUtils.isEmpty((Collection)jsonObjectList)) {
            return result;
        }
        jsonObjectList.forEach(j -> result.add(CourseQuestionAnswer.builder().optionId(UserCourseWrapper.optionalInteger((Object)j.get((Object)"answereid"))).result(UserCourseWrapper.optionalString((Object)j.get((Object)"result"))).score(UserCourseWrapper.optionalInteger((Object)j.get((Object)"score"))).wrongTag(UserCourseWrapper.optionalString((Object)j.get((Object)"wrongtag"))).englishResult(UserCourseWrapper.optionalString((Object)j.get((Object)"englishresult"))).createTime(new Date()).build()));
        return result;
    }

    private static UserCourseInfo getUserCourseInfoFromJson(JSONObject jsonObject) {
        UserCourseInfo result = new UserCourseInfo();
        result.setPageId(UserCourseWrapper.optionalInteger((Object)jsonObject.get((Object)"pageid")));
        result.setGroupId(UserCourseWrapper.optionalInteger((Object)jsonObject.get((Object)"groupid")));
        result.setQuestionId(UserCourseWrapper.optionalInteger((Object)jsonObject.get((Object)"questionid")));
        result.setResult(jsonObject.get((Object)"result").toString().toLowerCase());
        result.setWrongNumber(UserCourseWrapper.optionalInteger((Object)jsonObject.get((Object)"wrongnumber")));
        result.setTimeoutNumber(UserCourseWrapper.optionalInteger((Object)jsonObject.get((Object)"timeoutnumber")));
        result.setQuantity(UserCourseWrapper.optionalInteger((Object)jsonObject.get((Object)"quantity")));
        return result;
    }

    private static void setFluencyAndAccuracy(UserCourseWrapper userCourseWrapper) {
        List optionIds = userCourseWrapper.getCourseQuestionOptionList().stream().filter(o -> "voice".equalsIgnoreCase(o.getOptionType())).map(CourseQuestionOption::getOptionId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(optionIds)) {
            return;
        }
        Stream<CourseQuestionAnswer> tmp = userCourseWrapper.getCourseQuestionAnswerList().stream().filter(a -> optionIds.contains(a.getOptionId()));
        DoubleSummaryStatistics fluencyStatistics = tmp.map(CourseQuestionAnswer::getScore).collect(Collectors.toList()).stream().mapToDouble(x -> x.intValue()).summaryStatistics();
        userCourseWrapper.getUserCourseInfo().setSpeechAccuracy(fluencyStatistics.getCount() < 1L ? null : Double.valueOf(fluencyStatistics.getMax()));
        Stream<CourseQuestionAnswer> tmp1 = userCourseWrapper.getCourseQuestionAnswerList().stream().filter(a -> optionIds.contains(a.getOptionId()));
        DoubleSummaryStatistics accuracyStatistics = tmp1.map(UserCourseWrapper::getFromJson).collect(Collectors.toList()).stream().mapToDouble(x -> x).summaryStatistics();
        userCourseWrapper.getUserCourseInfo().setSpeechFluency(accuracyStatistics.getCount() < 1L ? null : Double.valueOf(accuracyStatistics.getMax()));
    }

    private static Double getFromJson(CourseQuestionAnswer a) {
        JSONObject resultObject;
        JSONObject jsonObject = JSONObject.parseObject((String)a.getEnglishResult());
        if (Objects.isNull(jsonObject) || Objects.isNull(resultObject = (JSONObject)jsonObject.get((Object)"result"))) {
            return 0.0;
        }
        JSONObject fluencyObject = (JSONObject)resultObject.get((Object)"fluency");
        if (Objects.isNull(fluencyObject)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(fluencyObject.get((Object)"overall").toString());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private static String optionalString(Object o) {
        if (Objects.isNull(o)) {
            return "";
        }
        return o.toString();
    }

    private static Integer optionalInteger(Object o) {
        if (Objects.isNull(o)) {
            return 0;
        }
        try {
            return (int)Double.parseDouble(o.toString());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static void main(String[] args) {
        System.out.println("{\\\"result\\\":{\\\"systime\\\":4048,\\\"fluency\\\":{\\\"overall\\\":90,\\\"pause\\\":0,\\\"speed\\\":1},\\\"integrity\\\":100,\\\"pron\\\":64,\\\"version\\\":\\\"0.0.80.2018.6.11.16:33:21\\\",\\\"rhythm\\\":{\\\"overall\\\":75,\\\"stress\\\":0,\\\"tone\\\":100,\\\"sense\\\":100},\\\"wavetime\\\":3940,\\\"details\\\":[{\\\"start\\\":1330,\\\"fluency\\\":96,\\\"stressscore\\\":1,\\\"sensescore\\\":1,\\\"tonescore\\\":0,\\\"liaisonref\\\":0,\\\"char\\\":\\\"tim\\\",\\\"toneref\\\":0,\\\"stressref\\\":0,\\\"senseref\\\":1,\\\"end\\\":1760,\\\"score\\\":64,\\\"liaisonscore\\\":0,\\\"dur\\\":430}],\\\"forceout\\\":0,\\\"rank\\\":100,\\\"precision\\\":1,\\\"overall\\\":68,\\\"accuracy\\\":64,\\\"statics\\\":[{\\\"count\\\":1,\\\"score\\\":5,\\\"char\\\":\\\"t\\\"},{\\\"count\\\":1,\\\"score\\\":92,\\\"char\\\":\\\"ih\\\"},{\\\"count\\\":1,\\\"score\\\":95,\\\"char\\\":\\\"m\\\"}],\\\"pretime\\\":124,\\\"delaytime\\\":31,\\\"info\\\":{\\\"tipId\\\":0,\\\"volume\\\":90,\\\"clip\\\":0,\\\"snr\\\":14.694137},\\\"res\\\":\\\"eng.snt.offline.1.0\\\"},\\\"eof\\\":1,\\\"params\\\":{\\\"app\\\":{\\\"userId\\\":\\\"this-is-user-id\\\"},\\\"enableContonative\\\":0,\\\"request\\\":{\\\"typeThres\\\":2,\\\"syldet\\\":1,\\\"symbol\\\":1,\\\"request_id\\\":\\\"5cbd6414159eea0000066b80\\\",\\\"precision\\\":1,\\\"rank\\\":100,\\\"attachAudioUrl\\\":1,\\\"refText\\\":\\\"tim\\\",\\\"coreType\\\":\\\"en.sent.score\\\",\\\"tokenId\\\":\\\"5cbd6414159eea0000056b80\\\"},\\\"coreProvideType\\\":\\\"native\\\",\\\"soundIntensityEnable\\\":1,\\\"enableRetry\\\":1,\\\"audio\\\":{\\\"sampleBytes\\\":2,\\\"channel\\\":1,\\\"sampleRate\\\":16000,\\\"audioType\\\":\\\"wav\\\"}},\\\"tokenId\\\":\\\"5cbd6414159eea0000056b80\\\",\\\"version\\\":\\\"1.0.7\\\"}}".length());
    }

    public UserCourseInfo getUserCourseInfo() {
        return this.userCourseInfo;
    }

    public List<CourseQuestionAnswer> getCourseQuestionAnswerList() {
        return this.courseQuestionAnswerList;
    }

    public List<CourseQuestionOption> getCourseQuestionOptionList() {
        return this.courseQuestionOptionList;
    }

    public void setUserCourseInfo(UserCourseInfo userCourseInfo) {
        this.userCourseInfo = userCourseInfo;
    }

    public void setCourseQuestionAnswerList(List<CourseQuestionAnswer> courseQuestionAnswerList) {
        this.courseQuestionAnswerList = courseQuestionAnswerList;
    }

    public void setCourseQuestionOptionList(List<CourseQuestionOption> courseQuestionOptionList) {
        this.courseQuestionOptionList = courseQuestionOptionList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCourseWrapper)) {
            return false;
        }
        UserCourseWrapper other = (UserCourseWrapper)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UserCourseInfo this$userCourseInfo = this.getUserCourseInfo();
        UserCourseInfo other$userCourseInfo = other.getUserCourseInfo();
        if (this$userCourseInfo == null ? other$userCourseInfo != null : !this$userCourseInfo.equals(other$userCourseInfo)) {
            return false;
        }
        List this$courseQuestionAnswerList = this.getCourseQuestionAnswerList();
        List other$courseQuestionAnswerList = other.getCourseQuestionAnswerList();
        if (this$courseQuestionAnswerList == null ? other$courseQuestionAnswerList != null : !((Object)this$courseQuestionAnswerList).equals(other$courseQuestionAnswerList)) {
            return false;
        }
        List this$courseQuestionOptionList = this.getCourseQuestionOptionList();
        List other$courseQuestionOptionList = other.getCourseQuestionOptionList();
        return !(this$courseQuestionOptionList == null ? other$courseQuestionOptionList != null : !((Object)this$courseQuestionOptionList).equals(other$courseQuestionOptionList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserCourseWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserCourseInfo $userCourseInfo = this.getUserCourseInfo();
        result = result * 59 + ($userCourseInfo == null ? 43 : $userCourseInfo.hashCode());
        List $courseQuestionAnswerList = this.getCourseQuestionAnswerList();
        result = result * 59 + ($courseQuestionAnswerList == null ? 43 : ((Object)$courseQuestionAnswerList).hashCode());
        List $courseQuestionOptionList = this.getCourseQuestionOptionList();
        result = result * 59 + ($courseQuestionOptionList == null ? 43 : ((Object)$courseQuestionOptionList).hashCode());
        return result;
    }

    public String toString() {
        return "UserCourseWrapper(userCourseInfo=" + this.getUserCourseInfo() + ", courseQuestionAnswerList=" + this.getCourseQuestionAnswerList() + ", courseQuestionOptionList=" + this.getCourseQuestionOptionList() + ")";
    }

    static {
        NONE_RESLUT = "none";
        TIME_OUT = "timeout";
    }
}

