/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.utils;

import com.ella.resource.dto.WordCategoryDto;
import com.ella.resource.dto.WordListDto;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordListUtil {
    private static final Logger log = LoggerFactory.getLogger(WordListUtil.class);
    public static final String UTF8 = "utf-8";

    public static void encode(WordCategoryDto dto) {
        if (Objects.nonNull(dto)) {
            try {
                String word = dto.getCategoryName();
                String enWord = dto.getCategoryEnName();
                if (StringUtils.isNotBlank((CharSequence)word)) {
                    word = URLEncoder.encode(word, UTF8);
                    word = word.replaceAll("\\+", "%20");
                    dto.setCategoryName(word);
                }
                if (StringUtils.isNotBlank((CharSequence)enWord)) {
                    enWord = URLEncoder.encode(enWord, UTF8);
                    enWord = enWord.replaceAll("\\+", "%20");
                    dto.setCategoryEnName(enWord);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void decode(WordCategoryDto dto) {
        if (Objects.nonNull(dto)) {
            try {
                String word;
                if (StringUtils.isNotBlank((CharSequence)dto.getCategoryName())) {
                    word = URLDecoder.decode(dto.getCategoryName(), UTF8);
                    dto.setCategoryName(word);
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getCategoryEnName())) {
                    word = URLDecoder.decode(dto.getCategoryEnName(), UTF8);
                    dto.setCategoryEnName(word);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void decode(WordListDto dto) {
        if (Objects.nonNull(dto)) {
            try {
                if (StringUtils.isNotBlank((CharSequence)dto.getWord())) {
                    String word = URLDecoder.decode(dto.getWord(), UTF8);
                    dto.setWord(word);
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getExplains())) {
                    String explains = URLDecoder.decode(dto.getExplains(), UTF8);
                    dto.setExplains(explains);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void encode(WordListDto dto) {
        if (Objects.nonNull(dto)) {
            try {
                String explains = dto.getExplains();
                String word = dto.getWord();
                if (StringUtils.isNotBlank((CharSequence)word)) {
                    word = URLEncoder.encode(word, UTF8);
                    word = word.replaceAll("\\+", "%20");
                    dto.setWord(word);
                }
                if (StringUtils.isNotBlank((CharSequence)explains)) {
                    explains = URLEncoder.encode(explains, UTF8);
                    explains = explains.replaceAll("\\+", "%20");
                    dto.setExplains(explains);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void trim(WordListDto dto) {
        if (Objects.nonNull(dto)) {
            dto.setWord(StringUtils.trim((String)dto.getWord()));
            dto.setExplains(StringUtils.trim((String)dto.getExplains()));
        }
    }

    public static void trim(WordCategoryDto dto) {
        if (Objects.nonNull(dto)) {
            dto.setCategoryName(StringUtils.trim((String)dto.getCategoryName()));
            dto.setCategoryEnName(StringUtils.trim((String)dto.getCategoryEnName()));
        }
    }

    public static boolean checkCategoryIllegal(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return true;
        }
        String regex = "^[-a-zA-Z\\u4e00-\\u9fa5//_//://\uff1a//,//\uff0c//;//\uff1b//\u3002//.\\s]+$";
        return !str.matches(regex);
    }

    public static boolean checkWordIllegal(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return true;
        }
        String regex = "^[a-zA-Z\\s]+$";
        return !str.matches(regex);
    }

    public static boolean checkExplainIllegal(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return true;
        }
        String regex = "^[-0-9a-zA-Z\\u4e00-\\u9fa5//_//://\uff1a//,//\uff0c//;//\uff1b//\u3002//.\\s\u3010\u3011\uff08\uff09()\u2026\u3001\"\u201c\u201d\\[\\]]+$";
        return !str.matches(regex);
    }
}

