/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.api.GoodsService;
import com.ella.order.dto.goods.GetGoodsDetailByItemCodeAndTypeRequest;
import com.ella.order.dto.goods.SummaryGoodsPriceDto;
import com.ella.resource.config.HeadParamUtil;
import com.ella.resource.domain.CourseQuestionOption;
import com.ella.resource.domain.UserCourse;
import com.ella.resource.domain.UserWord;
import com.ella.resource.mapper.UserWordMapper;
import com.ella.resource.service.transactional.RpcService;
import com.ella.resource.wrapper.UserCourseWrapper;
import com.ella.user.api.UserInfoService;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.api.learn.UserWordFollowService;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.account.EventTypeEnum;
import com.ella.user.dto.account.ModifyUserStoneRequest;
import com.ella.user.dto.account.MoneyChangeTypeEnum;
import com.ella.user.dto.learn.SaveFollowRecordRequest;
import com.ella.user.dto.request.userinfo.FindUserByIdRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RpcServiceImpl
implements RpcService {
    private static final Logger log = LoggerFactory.getLogger(RpcServiceImpl.class);
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private UserWordFollowService userWordFollowService;
    @Autowired
    private UserWordMapper userWordMapper;

    public UserInfoDto getUserInfoById(String uid) {
        if (StringUtils.isBlank((CharSequence)uid)) {
            return null;
        }
        UserInfoDto userInfoDto = null;
        Integer isIos = StringUtils.equalsIgnoreCase((CharSequence)"ios", (CharSequence)HeadParamUtil.getClientType()) ? 1 : 0;
        ResponseParams userInfoResponse = this.userInfoService.getUserInfoById(new FindUserByIdRequest(uid, isIos));
        if (CommonRetCode.SUCCESS.getCode().equals(userInfoResponse.getCode())) {
            if (null == userInfoResponse.getData() || null == ((UserInfoDto)userInfoResponse.getData()).getId()) {
                return null;
            }
            userInfoDto = (UserInfoDto)userInfoResponse.getData();
        }
        return userInfoDto;
    }

    public UserInfoDto selectUserByUid(String uid) {
        if (StringUtils.isBlank((CharSequence)uid)) {
            return null;
        }
        UserInfoDto userInfoDto = null;
        ResponseParams userInfoResponse = this.userInfoService.selectUserByUid(uid);
        if (CommonRetCode.SUCCESS.getCode().equals(userInfoResponse.getCode())) {
            if (null == userInfoResponse.getData() || null == ((UserInfoDto)userInfoResponse.getData()).getId()) {
                return null;
            }
            userInfoDto = (UserInfoDto)userInfoResponse.getData();
        }
        return userInfoDto;
    }

    public Boolean addUserStoneNum(String uid, Long relationId, Integer stoneNum) {
        log.info("addUserStoneNum param {}--{}--{}:", new Object[]{uid, relationId, stoneNum});
        ModifyUserStoneRequest param = new ModifyUserStoneRequest();
        param.setUid(uid);
        param.setRelationId(relationId.toString());
        param.setTimex(Long.valueOf(System.currentTimeMillis()));
        param.setStoneNum(stoneNum);
        param.setDescription("add from mission " + relationId);
        param.setOpperType(MoneyChangeTypeEnum.ADD);
        param.setEventType(EventTypeEnum.PASS_MISSION);
        ResponseParams result = this.userAccountService.modifyUserStone(param);
        log.info("addUserStoneNum result {}--{}:", (Object)result.getCode(), (Object)result.getMessage());
        if (CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            return (Boolean)result.getData();
        }
        return Boolean.FALSE;
    }

    public Boolean minusUserStoneNum(String uid, Long relationId, Integer stoneNum) {
        log.info("minusUserStoneNum param {}--{}--{}:", new Object[]{uid, relationId, stoneNum});
        ModifyUserStoneRequest param = new ModifyUserStoneRequest();
        param.setUid(uid);
        param.setRelationId(relationId.toString());
        param.setTimex(Long.valueOf(System.currentTimeMillis()));
        param.setStoneNum(stoneNum);
        param.setDescription("change stone num " + relationId);
        param.setOpperType(MoneyChangeTypeEnum.MINUS);
        param.setEventType(EventTypeEnum.CHANGE);
        ResponseParams result = this.userAccountService.modifyUserStone(param);
        log.info("minusUserStoneNum result {}--{}:", (Object)result.getCode(), (Object)result.getMessage());
        if (CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            return (Boolean)result.getData();
        }
        return Boolean.FALSE;
    }

    public SummaryGoodsPriceDto getGoodsInfoByItemCodeAndType(String itemCode, String goodType) {
        SummaryGoodsPriceDto result = null;
        GetGoodsDetailByItemCodeAndTypeRequest param = new GetGoodsDetailByItemCodeAndTypeRequest();
        param.setGoodsType(goodType);
        param.setItemCode(itemCode);
        ResponseParams goodInfo = this.goodsService.getSummrayGoodsByItemCodeAndType(param);
        if (CommonRetCode.SUCCESS.getCode().equals(goodInfo.getCode())) {
            result = (SummaryGoodsPriceDto)goodInfo.getData();
        }
        return null == result ? new SummaryGoodsPriceDto() : result;
    }

    public Map<String, Integer> countUserFollowRecord(String uid, String mapCode, String missionCode, Integer learnTime) {
        return this.userWordFollowService.countUserFollowRecord(uid, mapCode, missionCode, learnTime);
    }

    public Boolean saveFollowRecordNew(SaveFollowRecordRequest request) {
        UserWord userWord;
        Integer isKnow = 3;
        if (request.getDetailScore().floatValue() < 80.0f) {
            isKnow = 0;
        }
        if ((userWord = this.userWordMapper.selectByUidAndWord(request.getUid(), request.getContent())) == null) {
            userWord = UserWord.builder().uid(request.getUid()).word(request.getContent()).isFollow(Integer.valueOf(1)).followTime(new Date()).isKnow(isKnow).voiceUrl(request.getVoiceUrl()).followScore(request.getDetailScore()).build();
            this.userWordMapper.insertSelective(userWord);
        } else {
            if (userWord.getIsKnow() != 1) {
                userWord.setIsKnow(isKnow);
            }
            userWord = UserWord.builder().id(userWord.getId()).isFollow(Integer.valueOf(1)).followTime(new Date()).voiceUrl(request.getVoiceUrl()).followScore(request.getDetailScore()).build();
            this.userWordMapper.updateByPrimaryKeySelective(userWord);
        }
        return this.userWordFollowService.saveFollowRecordNew(request);
    }

    @Async
    public void doFollowRecord(UserCourseWrapper userCourseWrapper, String uid, UserCourse userCourse) {
        SaveFollowRecordRequest request = new SaveFollowRecordRequest();
        request.setUid(uid);
        request.setMapCode(userCourse.getMapCode());
        request.setLevelCode(userCourse.getLevelCode());
        request.setMissionCode(userCourse.getMissionCode());
        request.setCourseCode(userCourse.getCourseCode());
        userCourseWrapper.getCourseQuestionAnswerList().forEach(a -> {
            List options = userCourseWrapper.getCourseQuestionOptionList().stream().filter(o -> o.getOptionId().equals(a.getOptionId()) && "voice".equalsIgnoreCase(o.getOptionType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(options)) {
                request.setContent(((CourseQuestionOption)options.get(0)).getContent());
                request.setContentType("1".equals(((CourseQuestionOption)options.get(0)).getOptionType()) ? "SENTENCE" : "WORD");
                request.setDetailScore(Float.valueOf(a.getScore().floatValue()));
                log.info("doFollowRecord uid-{}, missionCode--{}, content-{}", new Object[]{uid, userCourse.getMissionCode(), ((CourseQuestionOption)options.get(0)).getContent()});
                this.saveFollowRecordNew(request);
            }
        });
    }
}

