/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.domain.ResPeriodTest;
import com.ella.resource.domain.ResPeriodTestDetail;
import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.dto.ResPeriodTestDetailDto;
import com.ella.resource.dto.ResPeriodTestDto;
import com.ella.resource.dto.ResPeriodTestListDto;
import com.ella.resource.dto.ResQuestionDto;
import com.ella.resource.dto.request.periodtest.DeleteResPeriodTestRequest;
import com.ella.resource.dto.request.periodtest.EditResPeriodTestRequest;
import com.ella.resource.dto.request.periodtest.OrderQuestionRequest;
import com.ella.resource.dto.request.periodtest.PeriodTestDetailListRequest;
import com.ella.resource.dto.request.periodtest.QueryResPeriodTestQuestionRequest;
import com.ella.resource.dto.request.periodtest.QueryResPeriodTestRequest;
import com.ella.resource.dto.request.periodtest.RemoveQuestionRequest;
import com.ella.resource.dto.request.periodtest.SaveResPeriodTestRequest;
import com.ella.resource.dto.sendgoods.StatusEnum;
import com.ella.resource.mapper.ResPeriodTestDetailMapper;
import com.ella.resource.mapper.ResPeriodTestMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.service.transactional.ResPeriodTestTService;
import com.ella.resource.service.transactional.impl.ResQuestionTServiceImpl;
import com.github.pagehelper.PageHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResPeriodTestTServiceImpl
implements ResPeriodTestTService {
    private static final Logger log = LogManager.getLogger(ResPeriodTestTServiceImpl.class);
    @Autowired
    ResPeriodTestMapper mapper;
    @Autowired
    ResPeriodTestDetailMapper dMapper;
    @Autowired
    ResQuestionTServiceImpl questionService;
    @Autowired
    ResourceOccupantMapper occupantMapper;

    @Transactional(rollbackFor={Exception.class})
    public int savePeriodTest(SaveResPeriodTestRequest request) {
        ResPeriodTest test = new ResPeriodTest();
        BeanUtils.copyProperties((Object)request, (Object)test);
        try {
            SimpleDateFormat sdf;
            if (null == test.getCreateTime()) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                test.setCreateTime(sdf.parse(sdf.format(new Date())));
            }
            if (null == test.getUpdateTime()) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                test.setUpdateTime(sdf.parse(sdf.format(new Date())));
            }
            if (null == test.getStatus() || "".equals(test.getStatus())) {
                test.setStatus("NORMAL");
            }
            test.setQuestionNum(Short.valueOf((short)0));
            test.setUseStatus("N");
        }
        catch (Exception e) {
            log.error("savePeriodTest error {}", (Throwable)e);
        }
        return this.mapper.insert(test);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deletePeriodTest(DeleteResPeriodTestRequest request) {
        ResourceOccupant occupant = new ResourceOccupant();
        occupant.setStatus("EXCEPTION");
        ResourceOccupantExample exam = new ResourceOccupantExample();
        exam.createCriteria().andOccupantIdEqualTo(request.getId()).andOccupantTypeEqualTo("TEST").andStatusEqualTo(StatusEnum.NORMAL.getCode());
        this.occupantMapper.updateByExampleSelective(occupant, exam);
        int count = this.mapper.deleteByIds(Long.valueOf(request.getId()));
        return count;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ResPeriodTestListDto> getResPeriodTest(QueryResPeriodTestRequest request) {
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List list = this.mapper.getResPeriodTest(request);
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateResPeriodTest(EditResPeriodTestRequest request) {
        ResPeriodTest test = new ResPeriodTest();
        BeanUtils.copyProperties((Object)request, (Object)test);
        try {
            if (null == test.getUpdateTime()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                test.setUpdateTime(sdf.parse(sdf.format(new Date())));
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        int result = this.mapper.updateByPrimaryKeySelective(test);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public int addPeriodTestDetail(PeriodTestDetailListRequest request) {
        Long testId = request.getTestId();
        List list = request.getList();
        ArrayList detailList = new ArrayList();
        ArrayList occList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date now = sdf.parse(sdf.format(Calendar.getInstance().getTime()));
            list.forEach(detailRequest -> {
                ResPeriodTestDetail detail = new ResPeriodTestDetail();
                BeanUtils.copyProperties((Object)detailRequest, (Object)detail);
                detail.setTestId(testId);
                if (null == detail.getCreateTime()) {
                    detail.setCreateTime(now);
                }
                if (null == detail.getUpdateTime()) {
                    detail.setCreateTime(now);
                }
                if (null == detail.getStatus() || "".equals(detail.getStatus())) {
                    detail.setStatus("NORMAL");
                }
                detailList.add(detail);
                ResourceOccupant occupant = new ResourceOccupant();
                occupant.setResType("QUESTION");
                occupant.setResId(detailRequest.getQuestionId());
                occupant.setOccupantType("TEST");
                occupant.setOccupantId(testId);
                occupant.setStatus("NORMAL");
                occupant.setCreateTime(now);
                occupant.setUpdateTime(now);
                occList.add(occupant);
            });
            this.dMapper.batchInsert(detailList);
            ResPeriodTest test = this.mapper.selectByPrimaryKey(testId);
            Short num = test.getQuestionNum();
            num = null == num ? Short.valueOf((short)this.dMapper.selectDetailsById(testId).size()) : Short.valueOf((short)(num + list.size()));
            ResPeriodTest periodTest = new ResPeriodTest();
            periodTest.setUpdateTime(now);
            periodTest.setId(testId);
            periodTest.setQuestionNum(Short.valueOf(num));
            this.mapper.updateByPrimaryKeySelective(periodTest);
            this.occupantMapper.batchInsert(occList);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public int removeQuestionRequest(RemoveQuestionRequest request) {
        this.dMapper.deleteByIds(request);
        ResPeriodTest test = this.mapper.selectByPrimaryKey(request.getTestId());
        long num = test.getQuestionNum() - 1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date now = sdf.parse(sdf.format(Calendar.getInstance().getTime()));
            ResPeriodTest periodTest = new ResPeriodTest();
            periodTest.setUpdateTime(now);
            periodTest.setId(request.getTestId());
            periodTest.setQuestionNum(Short.valueOf((short)num));
            this.mapper.updateByPrimaryKeySelective(periodTest);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ResourceOccupant occupant = new ResourceOccupant();
        occupant.setOccupantType("TEST");
        occupant.setOccupantId(request.getTestId());
        occupant.setResType("QUESTION");
        occupant.setResId(request.getQuestionId());
        this.occupantMapper.deleteOccupant(occupant);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResPeriodTestDetailDto getResPeriodTestQuestion(QueryResPeriodTestQuestionRequest request) {
        ResPeriodTestDetail detail = this.dMapper.selectByTestId(request.getTestId(), request.getQuestionOrder());
        if (null == detail) {
            return null;
        }
        ResQuestionDto resQuestionDto = this.questionService.getQuestionById(detail.getQuestionId());
        ResPeriodTestDetailDto detailDto = new ResPeriodTestDetailDto();
        BeanUtils.copyProperties((Object)detail, (Object)detailDto);
        detailDto.setQuestionDto(resQuestionDto);
        return detailDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResPeriodTestDto getResPeriodTestAllQuestion(Long testId) {
        ResPeriodTest test = this.mapper.selectByPrimaryKey(testId);
        if (null == test) {
            return null;
        }
        List list = this.dMapper.selectDetailsById(testId);
        ResPeriodTestDto dto = new ResPeriodTestDto();
        BeanUtils.copyProperties((Object)test, (Object)dto);
        dto.setDetailDto(list);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateTestQuestionOrder(OrderQuestionRequest request) {
        Long id1 = request.getDetaiId1();
        Long id2 = request.getDetaiId2();
        int order1 = request.getOrder1();
        int order2 = request.getOrder2();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date now = sdf.parse(sdf.format(Calendar.getInstance().getTime()));
            ResPeriodTestDetail testDetail = this.dMapper.selectByPrimaryKey(id1);
            ResPeriodTest periodTest = new ResPeriodTest();
            periodTest.setUpdateTime(now);
            periodTest.setId(testDetail.getTestId());
            this.mapper.updateByPrimaryKeySelective(periodTest);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.dMapper.updateTestQuestion(id1, Long.valueOf(order2));
        this.dMapper.updateTestQuestion(id2, Long.valueOf(order1));
        return 1;
    }
}

