/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.QuestionRecord;
import com.ella.resource.domain.ResQuestion;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.appdto.AnalysisTestInfoDto;
import com.ella.resource.dto.appdto.TestRecordDto;
import com.ella.resource.dto.request.app.TestAnswerRequest;
import com.ella.resource.mapper.ResQuestionMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.AbstractEnTest;
import com.ella.resource.service.transactional.RpcService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProgressTestServiceImpl
extends AbstractEnTest {
    private static final Logger log = LogManager.getLogger(ProgressTestServiceImpl.class);
    @Autowired
    private ResQuestionMapper resQuestionMapper;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private UserMissionMapper userMissionMapper;

    protected AnalysisTestInfoDto doAnalysisTestAnswer(TestAnswerRequest request, BaseMission mission) {
        AnalysisTestInfoDto result = new AnalysisTestInfoDto();
        result.setIsPass(this.isPass(request, mission));
        return result;
    }

    protected void afterCompletion(TestAnswerRequest request, BaseMission mission, UserMission userMission) {
        log.info("ProgressTestServiceImpl.afterCompletion mission :{}", (Object)mission);
        Integer passNum = this.getPassNum(request);
        if (passNum > userMission.getCorrectNum()) {
            log.info("ProgressTestServiceImpl.afterCompletion addUserStoneNum param {},{},{} ", (Object)request.getUid(), (Object)mission.getId(), (Object)this.getPassNum(request));
            this.rpcService.addUserStoneNum(request.getUid(), mission.getId(), this.getPassNum(request));
            userMission.setCorrectNum(passNum);
        }
        Integer totalNum = request.getAnswerInfoList().size();
        userMission.setTestNum(totalNum);
        userMission.setStatus("PASS");
        log.info("ProgressTestServiceImpl.afterCompletion begin updateByPrimaryKeySelective");
        this.userMissionMapper.updateByPrimaryKeySelective(userMission);
    }

    protected List<ResQuestion> getResQuestion(Long resourceId) {
        return this.resQuestionMapper.selectPeriodQuestionByPeriodId(resourceId);
    }

    protected void doQuestionRecord(TestRecordDto result, List<QuestionRecord> questionRecords, BaseMission mission) {
    }
}

