/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.cache.impl;

import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.util.DateUtil;
import com.ella.resource.dto.request.PicBookStoreReq;
import com.ella.resource.service.cache.IServiceCacheHandler;
import com.ella.resource.utils.CacheEnum;
import com.ella.resource.utils.CacheUtilsNew;
import com.ella.user.api.auth.AccountService;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PicBookServiceCacheHandler
implements IServiceCacheHandler {
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private AccountService accountService;

    public Object getCache(String methodName, String[] resourceNames, Object[] args) {
        if (methodName == null || methodName.equals("")) {
            return null;
        }
        return this.getPicBookStoreCache(methodName, resourceNames, args);
    }

    public void cache(String methodName, Object[] args, Object data) {
        if (methodName == null || methodName.equals("")) {
            return;
        }
        this.picBookStore2Cache(methodName, data, args);
    }

    private boolean judgeFlush(String uid, String methodName, String[] resourceNames) {
        boolean isFlush = false;
        for (String resourceName : resourceNames) {
            Integer version;
            String key = "service_resource_" + methodName + ":" + resourceName + ":" + uid;
            Integer userVersion = this.redisCache.get(key) == null ? null : this.redisCache.getInt(key);
            String keyx = "service_resource_" + methodName + ":" + resourceName;
            Integer n = version = this.redisCache.get(keyx) == null ? null : this.redisCache.getInt(keyx);
            if (version == null || version.equals(userVersion)) continue;
            isFlush = true;
            this.redisCache.set(key, (Object)version);
        }
        return isFlush;
    }

    private void picBookStore2Cache(String methodName, Object data, Object[] args) {
        String key = this.picBookStoreKey(methodName, args);
        if (key == null) {
            return;
        }
        new CacheUtilsNew(this.redisCache, key, data, CacheEnum.SET_BYTES).run();
    }

    private String picBookStoreKey(String methodName, Object[] args) {
        PicBookStoreReq arg = (PicBookStoreReq)args[0];
        String uid = Optional.ofNullable(arg.getUid()).orElse("");
        String type = Optional.ofNullable(arg.getType()).orElse("");
        String levelCode = Optional.ofNullable(arg.getLevelCode()).orElse("");
        String fullScreen = arg.getFullScreen() == null ? "" : arg.getFullScreen().toString();
        String key = "service_resource_" + methodName + ":" + (uid.equals("") ? "" : uid + ":") + (levelCode.equals("") ? "" : levelCode + ":") + (fullScreen.equals("") ? "" : fullScreen + ":") + type;
        return key;
    }

    private Object getPicBookStoreCache(String methodName, String[] resourceNames, Object[] args) {
        String key;
        Integer userBookVersion;
        Integer goodsVersion;
        PicBookStoreReq arg = (PicBookStoreReq)args[0];
        String uid = Optional.ofNullable(arg.getUid()).orElse("uid");
        Date now = new Date();
        Date limitDate = DateUtil.stringToDate((String)"2020-07-01 00:00:00", (String)DateUtil.DEFAULT_FORMAT);
        if (now.getTime() < limitDate.getTime() && (goodsVersion = this.redisCache.getInt("free_goods_version")) != null && goodsVersion != 0 && !goodsVersion.equals(userBookVersion = this.redisCache.getInt("free_user_book_version_" + uid))) {
            this.accountService.verifyUserBook(uid);
        }
        if ((key = this.picBookStoreKey(methodName, args)) == null) {
            return null;
        }
        if (this.judgeFlush(uid, methodName, resourceNames)) {
            String batchKey = "service_resource_" + methodName + ":" + (uid.equals("") ? "" : uid + ":") + "*";
            this.redisCache.del(batchKey);
            return null;
        }
        return this.redisCache.getBytesObject(key);
    }
}

