/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.common.api.dictionary.YoudaoService;
import com.ella.common.dto.dictionary.AudioTypeEnum;
import com.ella.common.dto.dictionary.DictionaryDto;
import com.ella.common.dto.dictionary.GetEnToCnTranslateRequest;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.CombineBeansUtil;
import com.ella.frame.common.util.CoreUtil;
import com.ella.resource.api.WordListService;
import com.ella.resource.domain.CategoryLevelRelation;
import com.ella.resource.domain.CategoryLevelRelationExample;
import com.ella.resource.domain.WordBookCodeRelationExample;
import com.ella.resource.domain.WordCategory;
import com.ella.resource.domain.WordCategoryExample;
import com.ella.resource.domain.WordCategoryRelation;
import com.ella.resource.domain.WordCategoryRelationExample;
import com.ella.resource.domain.WordList;
import com.ella.resource.domain.WordListExample;
import com.ella.resource.dto.ResponsePageResult;
import com.ella.resource.dto.WordCategoryDto;
import com.ella.resource.dto.WordListDto;
import com.ella.resource.dto.request.WordCategoryReq;
import com.ella.resource.dto.request.WordListReq;
import com.ella.resource.mapper.BaseBookMapper;
import com.ella.resource.mapper.CategoryLevelRelationMapper;
import com.ella.resource.mapper.WordBookCodeRelationMapper;
import com.ella.resource.mapper.WordCategoryMapper;
import com.ella.resource.mapper.WordCategoryRelationMapper;
import com.ella.resource.mapper.WordListMapper;
import com.ella.resource.properties.WordListConfigProperties;
import com.ella.resource.utils.ResponsePageResultUtils;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.resource.utils.WordListUtil;
import com.ella.user.api.enums.DataStatusEnum;
import com.github.pagehelper.PageHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WordListServiceImpl
implements WordListService {
    private static final Logger log = LogManager.getLogger(WordListServiceImpl.class);
    @Autowired
    private WordCategoryMapper wordCategoryMapper;
    @Autowired
    private CategoryLevelRelationMapper categoryLevelRelationMapper;
    @Autowired
    private WordListConfigProperties wordListConfigProperties;
    @Autowired
    private WordCategoryRelationMapper wordCategoryRelationMapper;
    @Autowired
    private WordListMapper wordListMapper;
    @Autowired
    private WordBookCodeRelationMapper wordBookCodeRelationMapper;
    @Autowired
    private BaseBookMapper baseBookMapper;
    @Autowired
    private YoudaoService youdaoService;

    @RequestMapping(value={"ListCategoriesByLevel/v1"}, method={RequestMethod.POST})
    public ResponseParams<ResponsePageResult> listCategoriesByLevel(@RequestBody WordCategoryReq wordCategoryReq) {
        log.info("\u83b7\u53d6\u7b49\u7ea7\u4e0b\u7c7b\u522b\u5217\u8868---> {}", (Object)JSONObject.toJSONString((Object)wordCategoryReq));
        String levelCode = "";
        if (Objects.nonNull(wordCategoryReq)) {
            levelCode = wordCategoryReq.getLevelCode();
        }
        if (StringUtils.isBlank((CharSequence)levelCode)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"levelCode\u4e0d\u5f97\u4e3a\u7a7a");
        }
        int pageNum = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)wordCategoryReq.getPageNum(), (CharSequence)"1"));
        int pageSize = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)wordCategoryReq.getPageSize(), (CharSequence)"20"));
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List categoryList = this.categoryLevelRelationMapper.listCategoriesByLevel(levelCode);
        if (categoryList != null && categoryList.size() > 0) {
            categoryList.forEach(WordListUtil::encode);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((List)categoryList));
    }

    @RequestMapping(value={"ListSimpleCategoriesByLevel/v1"}, method={RequestMethod.POST})
    public ResponseParams<List<Map>> listSimpleCategoriesByLevel(@RequestBody WordCategoryReq wordCategoryReq) {
        log.info("\u83b7\u53d6\u7b49\u7ea7\u4e0b\u7c7b\u522b\u7b80\u5355\u5217\u8868---> {}", (Object)JSONObject.toJSONString((Object)wordCategoryReq));
        if (Objects.isNull(wordCategoryReq) || StringUtils.isBlank((CharSequence)wordCategoryReq.getLevelCode())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        List categoryList = this.categoryLevelRelationMapper.listSimpleCategoriesByLevel(wordCategoryReq.getLevelCode());
        if (CollectionUtils.isEmpty((Collection)categoryList)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        categoryList.forEach(WordListUtil::encode);
        ArrayList returnList = new ArrayList();
        categoryList.forEach(p -> {
            HashMap<String, String> objectHashMap = new HashMap<String, String>();
            objectHashMap.put("categoryCode", p.getCategoryCode());
            objectHashMap.put("categoryName", p.getCategoryName());
            objectHashMap.put("relationCode", p.getRelationCode());
            returnList.add(objectHashMap);
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, returnList);
    }

    @RequestMapping(value={"showCategoryByCode/v1"}, method={RequestMethod.POST})
    public ResponseParams<WordCategoryDto> showCategoryByCode(@RequestBody WordCategoryReq wordCategoryReq) {
        log.info("\u901a\u8fc7categoryCode\u67e5\u770b\u6b64\u7c7b\u522b\u4fe1\u606f---> {}", (Object)JSONObject.toJSONString((Object)wordCategoryReq));
        if (Objects.isNull(wordCategoryReq) || StringUtils.isBlank((CharSequence)wordCategoryReq.getCategoryCode())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        WordCategoryExample wordCategoryExample = new WordCategoryExample();
        wordCategoryExample.createCriteria().andCategoryCodeEqualTo(wordCategoryReq.getCategoryCode()).andStatusEqualTo(DataStatusEnum.NORMAL.getCode());
        List wordCategories = this.wordCategoryMapper.selectByExample(wordCategoryExample);
        if (CollectionUtils.isEmpty((Collection)wordCategories)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        WordCategoryDto wordCategoryDto = new WordCategoryDto();
        CombineBeansUtil.copyBeans(wordCategories.get(0), (Object)wordCategoryDto);
        WordListUtil.encode((WordCategoryDto)wordCategoryDto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)wordCategoryDto);
    }

    @RequestMapping(value={"updateCategory/v1"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<String> updateCategory(@RequestBody WordCategoryReq req) {
        int result;
        log.info("\u4fee\u6539\u7c7b\u522b\uff0c\u5220\u9664\u7c7b\u522b\u4e5f\u4f7f\u7528\u6b64\u63a5\u53e3---> {}", (Object)JSONObject.toJSONString((Object)req));
        if (Objects.isNull(req) || StringUtils.isBlank((CharSequence)req.getCategoryCode())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        WordListUtil.decode((WordCategoryDto)req);
        if (StringUtils.isNotBlank((CharSequence)req.getCategoryName()) && WordListUtil.checkCategoryIllegal((String)req.getCategoryName()) || StringUtils.isNotBlank((CharSequence)req.getCategoryEnName()) && WordListUtil.checkCategoryIllegal((String)req.getCategoryEnName())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u7c7b\u522b\u540d\u79f0\u4ec5\u652f\u6301\u4e2d\u6587\u3001\u82f1\u6587\u3001\u5b57\u6bcd\u53ca\u5e38\u7528\u7b26\u53f7");
        }
        if (StringUtils.isBlank((CharSequence)req.getUid()) || this.checkPermission(req.getUid())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.FORBIDDEN, null);
        }
        WordCategory wordCategory = WordCategory.builder().categoryCode(req.getCategoryCode()).categoryEnName(req.getCategoryEnName()).categoryImgUrl(req.getCategoryImgUrl()).categoryName(req.getCategoryName()).updateBy(req.getUid()).updateTime(new Date()).build();
        if (DataStatusEnum.EXCEPTION.getCode().equals(req.getStatus())) {
            if (StringUtils.isBlank((CharSequence)req.getLevelCode())) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
            }
            result = this.categoryLevelRelationMapper.delOne(req);
        } else {
            ResponseParams responseParams = this.checkCategoryPicIllegal(req.getCategoryImgUrl());
            if (Objects.nonNull(responseParams)) {
                return responseParams;
            }
            result = this.wordCategoryMapper.updateCategory(wordCategory);
        }
        if (1 == result) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u4fee\u6539\u6210\u529f");
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u4fee\u6539\u5931\u8d25");
    }

    private ResponseParams<String> checkCategoryPicIllegal(String categoryImgUrl) {
        if (StringUtils.isNotBlank((CharSequence)categoryImgUrl) && !this.checkPicUrlIllegal(categoryImgUrl)) {
            String urlFormatStr = this.wordListConfigProperties.getUrlFormat();
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u56fe\u7247\u4ec5\u652f\u6301" + urlFormatStr + "\u683c\u5f0f"));
        }
        return null;
    }

    @RequestMapping(value={"updateCategoryIdx/v1"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<String> updateCategoryIdx(@RequestBody WordCategoryReq wordCategoryReq) {
        log.info("\u8c03\u6574\u7c7b\u522b\u987a\u5e8f---> {}", (Object)JSONObject.toJSONString((Object)wordCategoryReq));
        if (Objects.isNull(wordCategoryReq) || StringUtils.isBlank((CharSequence)wordCategoryReq.getCategoryCode()) || StringUtils.isBlank((CharSequence)wordCategoryReq.getLevelCode()) || StringUtils.isBlank((CharSequence)wordCategoryReq.getSequence()) || !StringUtils.equalsIgnoreCase((CharSequence)wordCategoryReq.getSequence(), (CharSequence)"forward") && !StringUtils.equalsIgnoreCase((CharSequence)wordCategoryReq.getSequence(), (CharSequence)"back") && !StringUtils.equalsIgnoreCase((CharSequence)wordCategoryReq.getSequence(), (CharSequence)"top")) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        if (StringUtils.isBlank((CharSequence)wordCategoryReq.getUid()) || this.checkPermission(wordCategoryReq.getUid())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.FORBIDDEN, null);
        }
        CategoryLevelRelationExample example = new CategoryLevelRelationExample();
        example.createCriteria().andStatusEqualTo(DataStatusEnum.NORMAL.getCode()).andCategoryCodeEqualTo(wordCategoryReq.getCategoryCode()).andLevelCodeEqualTo(wordCategoryReq.getLevelCode());
        List relationList = this.categoryLevelRelationMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)relationList) || relationList.size() != 1) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int result = 0;
        if (StringUtils.equalsIgnoreCase((CharSequence)"top", (CharSequence)wordCategoryReq.getSequence())) {
            if (Objects.nonNull(((CategoryLevelRelation)relationList.get(0)).getIdx()) && 1 == ((CategoryLevelRelation)relationList.get(0)).getIdx()) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"to the top");
            }
            result = this.categoryLevelRelationMapper.updateCategoryIdxToTop((CategoryLevelRelation)relationList.get(0), wordCategoryReq.getUid());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"forward", (CharSequence)wordCategoryReq.getSequence())) {
            if (Objects.nonNull(((CategoryLevelRelation)relationList.get(0)).getIdx()) && 1 == ((CategoryLevelRelation)relationList.get(0)).getIdx()) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"to the top");
            }
            String targetIdx = this.categoryLevelRelationMapper.getTargetIdx((CategoryLevelRelation)relationList.get(0), "forward");
            result = this.categoryLevelRelationMapper.moveCategoryIdx((CategoryLevelRelation)relationList.get(0), targetIdx, wordCategoryReq.getUid());
        } else {
            String targetIdx = this.categoryLevelRelationMapper.getTargetIdx((CategoryLevelRelation)relationList.get(0), "back");
            if (StringUtils.isBlank((CharSequence)targetIdx)) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"to the bottom");
            }
            result = this.categoryLevelRelationMapper.moveCategoryIdx((CategoryLevelRelation)relationList.get(0), targetIdx, wordCategoryReq.getUid());
        }
        if (0 != result) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u4fee\u6539\u6210\u529f");
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u4fee\u6539\u5931\u8d25");
    }

    @RequestMapping(value={"insertCategory/v1"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<String> insertCategory(@RequestBody WordCategoryReq req) {
        log.info("\u65b0\u589e\u7c7b\u522b---> {}", (Object)JSONObject.toJSONString((Object)req));
        if (Objects.isNull(req) || StringUtils.isBlank((CharSequence)req.getLevelCode()) || StringUtils.isBlank((CharSequence)req.getCategoryName()) && StringUtils.isBlank((CharSequence)req.getCategoryEnName())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u7c7b\u522b\u4e2d\u82f1\u6587\u540d\u79f0\u4e0d\u5f97\u540c\u65f6\u4e3a\u7a7a");
        }
        WordListUtil.decode((WordCategoryDto)req);
        WordListUtil.trim((WordCategoryDto)req);
        if (StringUtils.isNotBlank((CharSequence)req.getCategoryName()) && WordListUtil.checkCategoryIllegal((String)req.getCategoryName()) || StringUtils.isNotBlank((CharSequence)req.getCategoryEnName()) && WordListUtil.checkCategoryIllegal((String)req.getCategoryEnName())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u7c7b\u522b\u540d\u79f0\u4ec5\u652f\u6301\u4e2d\u6587\u3001\u82f1\u6587\u3001\u5b57\u6bcd\u53ca\u5e38\u7528\u7b26\u53f7");
        }
        if (StringUtils.isBlank((CharSequence)req.getUid()) || this.checkPermission(req.getUid())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.FORBIDDEN, null);
        }
        if (StringUtils.isNotBlank((CharSequence)req.getCategoryName()) && req.getCategoryName().length() > this.wordListConfigProperties.getCategoryMaxSize()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u7c7b\u522b\u6700\u591a\u652f\u6301" + this.wordListConfigProperties.getCategoryMaxSize() + "\u4e2a\u5b57"));
        }
        if (req.getCategoryEnName().length() > this.wordListConfigProperties.getCategoryEnMaxSize()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u7c7b\u522b\u82f1\u6587\u540d\u79f0\u6700\u591a\u652f\u6301" + this.wordListConfigProperties.getCategoryEnMaxSize() + "\u4e2a\u5b57\u6bcd"));
        }
        ResponseParams responseParams = this.checkCategoryPicIllegal(req.getCategoryImgUrl());
        if (Objects.nonNull(responseParams)) {
            return responseParams;
        }
        WordCategory wordCategory = this.wordCategoryMapper.getOne(req.getCategoryName(), req.getCategoryEnName());
        if (Objects.isNull(wordCategory)) {
            return this.insertOneCategory(req);
        }
        return this.updateOneCategory(req, wordCategory);
    }

    private boolean checkPermission(String uid) {
        return false;
    }

    private ResponseParams<String> updateOneCategory(WordCategoryReq wordCategoryReq, WordCategory wordCategory) {
        if (StringUtils.isNotBlank((CharSequence)wordCategoryReq.getCategoryName())) {
            wordCategory.setCategoryName(wordCategoryReq.getCategoryName());
        }
        if (StringUtils.isNotBlank((CharSequence)wordCategoryReq.getCategoryEnName())) {
            wordCategory.setCategoryEnName(wordCategoryReq.getCategoryEnName());
        }
        wordCategory.setUpdateTime(new Date());
        wordCategory.setUpdateBy(wordCategoryReq.getUid());
        this.wordCategoryMapper.updateCategory(wordCategory);
        List wordCategoryDtos = this.categoryLevelRelationMapper.listCategoriesByLevel(wordCategoryReq.getLevelCode());
        if (CollectionUtils.isEmpty((Collection)wordCategoryDtos) || wordCategoryDtos.stream().filter(Objects::nonNull).map(WordCategoryDto::getCategoryName).noneMatch(e -> StringUtils.equals((CharSequence)wordCategoryReq.getCategoryName(), (CharSequence)e)) || wordCategoryDtos.stream().filter(Objects::nonNull).map(WordCategoryDto::getCategoryEnName).noneMatch(e -> StringUtils.equals((CharSequence)wordCategoryReq.getCategoryEnName(), (CharSequence)e))) {
            String relationCode = CoreUtil.createCommonsCore((String)"RC");
            CategoryLevelRelation relation = CategoryLevelRelation.builder().relationCode(relationCode).categoryCode(wordCategory.getCategoryCode()).levelCode(wordCategoryReq.getLevelCode()).createBy(wordCategoryReq.getUid()).createTime(new Date()).status(DataStatusEnum.NORMAL.getCode()).build();
            this.categoryLevelRelationMapper.insertOne(relation);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    private ResponseParams<String> insertOneCategory(WordCategoryReq wordCategoryReq) {
        if (StringUtils.isBlank((CharSequence)wordCategoryReq.getCategoryName()) || StringUtils.isBlank((CharSequence)wordCategoryReq.getCategoryEnName())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        String categoryCode = CoreUtil.createCommonsCore((String)"WC");
        WordCategory wordCategory = WordCategory.builder().categoryCode(categoryCode).categoryName(wordCategoryReq.getCategoryName()).categoryEnName(wordCategoryReq.getCategoryEnName()).categoryImgUrl(wordCategoryReq.getCategoryImgUrl()).createBy(wordCategoryReq.getUid()).createTime(new Date()).status(DataStatusEnum.NORMAL.getCode()).build();
        this.wordCategoryMapper.insertOne(wordCategory);
        String relationCode = CoreUtil.createCommonsCore((String)"RC");
        CategoryLevelRelation relation = CategoryLevelRelation.builder().relationCode(relationCode).categoryCode(categoryCode).levelCode(wordCategoryReq.getLevelCode()).createBy(wordCategoryReq.getUid()).createTime(new Date()).status(DataStatusEnum.NORMAL.getCode()).build();
        this.categoryLevelRelationMapper.insertOne(relation);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    @RequestMapping(value={"searchCategory/v1"}, method={RequestMethod.POST})
    public ResponseParams<ResponsePageResult> searchCategory(@RequestBody WordCategoryReq wordCategoryReq) {
        WordListUtil.decode((WordCategoryDto)wordCategoryReq);
        String word = wordCategoryReq.getCategoryName();
        if (StringUtils.isBlank((CharSequence)word)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        word = StringUtils.trim((String)word);
        int pageNum = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)wordCategoryReq.getPageNum(), (CharSequence)"1"));
        int pageSize = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)wordCategoryReq.getPageSize(), (CharSequence)"20"));
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<WordCategoryDto> categoryList = this.categoryLevelRelationMapper.listCategoriesByKeyWords(word, wordCategoryReq.getLevelCode());
        ResponsePageResult pageResult = ResponsePageResultUtils.build((List)categoryList);
        if (null != categoryList && categoryList.size() > 0) {
            categoryList = categoryList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getRelationCode())).collect(Collectors.toList());
            categoryList.forEach(WordListUtil::encode);
        }
        pageResult.setList((List)categoryList);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)pageResult);
    }

    @RequestMapping(value={"insertWord/v1"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<String> insertWord(@RequestBody WordListReq req) {
        log.info("\u65b0\u589e\u5355\u8bcd---> {}", (Object)JSONObject.toJSONString((Object)req));
        if (Objects.isNull(req) || StringUtils.isBlank((CharSequence)req.getWord())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u5355\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ResponseParams params = this.checkWordParam(req, true);
        if (Objects.nonNull(params)) {
            return params;
        }
        ResponseParams checkBookCodes = this.checkBookCodesExists(req.getBookCodes());
        if (Objects.nonNull(checkBookCodes)) {
            return checkBookCodes;
        }
        WordListExample example = new WordListExample();
        example.createCriteria().andWordEqualTo(req.getWord());
        List wordLists = this.wordListMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)wordLists)) {
            String relationCode = this.categoryLevelRelationMapper.getRelationCodeByLevelAndCategory(req.getLevelCode(), req.getCategoryCode());
            if (StringUtils.isBlank((CharSequence)relationCode)) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u8be5\u7b49\u7ea7\u4e0b\u4e0d\u5b58\u5728\u8be5\u7c7b\u522b");
            }
            return this.insertNewWord(req, relationCode);
        }
        WordList oldWord = (WordList)wordLists.get(0);
        return this.updateWord(req, oldWord);
    }

    private ResponseParams<String> updateWord(WordListReq req, WordList oldWord) {
        if (StringUtils.isNotBlank((CharSequence)req.getExplains())) {
            oldWord.setExplains(req.getExplains());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getPicUrl())) {
            oldWord.setPicUrl(req.getPicUrl());
        }
        oldWord.setUpdateBy(req.getUid());
        oldWord.setUpdateTime(new Date());
        oldWord.setStatus(DataStatusEnum.NORMAL.getCode());
        this.wordListMapper.updateByPrimaryKey(oldWord);
        String relationCode = this.categoryLevelRelationMapper.getRelationCodeByLevelAndCategory(req.getLevelCode(), req.getCategoryCode());
        if (StringUtils.isBlank((CharSequence)relationCode)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u8be5\u7b49\u7ea7\u4e0b\u6ca1\u6709\u8be5\u7c7b\u522b");
        }
        WordCategoryRelation wordCategoryRelation = this.wordCategoryRelationMapper.getOneByWordAndRelationCode(req.getWord(), relationCode);
        if (Objects.nonNull(wordCategoryRelation)) {
            wordCategoryRelation.setUpdateBy(req.getUid());
            wordCategoryRelation.setUpdateTime(new Date());
            wordCategoryRelation.setCategoryCode(req.getCategoryCode());
            wordCategoryRelation.setLevelCode(req.getLevelCode());
            wordCategoryRelation.setStatus(DataStatusEnum.NORMAL.getCode());
            this.wordCategoryRelationMapper.updateByPrimaryKey(wordCategoryRelation);
        } else {
            WordCategoryRelation categoryRelation = WordCategoryRelation.builder().word(req.getWord()).relationCode(relationCode).createBy(req.getUid()).categoryCode(req.getCategoryCode()).levelCode(req.getLevelCode()).createTime(new Date()).status(DataStatusEnum.NORMAL.getCode()).build();
            this.wordCategoryRelationMapper.insertOne(categoryRelation);
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getBookCodes())) {
            this.wordBookCodeRelationMapper.updateBatch(req.getWord(), req.getBookCodes());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    private boolean checkPicUrlIllegal(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String urlFormatStr = this.wordListConfigProperties.getUrlFormat();
            String[] suppliedFormats = urlFormatStr.split("\\|\\|");
            String urlFormat = url.substring(url.lastIndexOf(".") + 1);
            if (suppliedFormats.length > 0) {
                long count = Arrays.stream(suppliedFormats).filter(e -> e.equalsIgnoreCase(urlFormat)).count();
                return count > 0L;
            }
        }
        return false;
    }

    private ResponseParams<String> insertNewWord(WordListReq req, String relationCode) {
        GetEnToCnTranslateRequest getEnToCnTranslateRequest = new GetEnToCnTranslateRequest();
        getEnToCnTranslateRequest.setWordText(req.getWord());
        getEnToCnTranslateRequest.setAudioType(AudioTypeEnum.MP3);
        ResponseParams translate = this.youdaoService.getEnToCnTranslate(getEnToCnTranslateRequest);
        if (translate.getCode().equals(CommonRetCode.SUCCESS.getCode()) && StringUtils.isBlank((CharSequence)req.getExplains())) {
            String explains = ((DictionaryDto)translate.getData()).getExplains();
            if (StringUtils.isNotBlank((CharSequence)explains)) {
                try {
                    explains = URLDecoder.decode(explains, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            req.setExplains(explains);
        }
        WordList newWord = WordList.builder().word(req.getWord()).explains(req.getExplains()).picUrl(req.getPicUrl()).createBy(req.getUid()).status(DataStatusEnum.NORMAL.getCode()).createTime(new Date()).build();
        this.wordListMapper.insertOne(newWord);
        WordCategoryRelation wordCategoryRelation = WordCategoryRelation.builder().word(req.getWord()).relationCode(relationCode).categoryCode(req.getCategoryCode()).levelCode(req.getLevelCode()).createBy(req.getUid()).createTime(new Date()).status(DataStatusEnum.NORMAL.getCode()).build();
        this.wordCategoryRelationMapper.insertOne(wordCategoryRelation);
        if (CollectionUtils.isNotEmpty((Collection)req.getBookCodes())) {
            this.wordBookCodeRelationMapper.updateBatch(req.getWord(), req.getBookCodes());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    @RequestMapping(value={"checkWordExist/v1"}, method={RequestMethod.POST})
    public ResponseParams<String> checkWordExist(@RequestBody WordListReq req) {
        ResponseParams checkWordParam = this.checkWordParam(req, false);
        if (Objects.nonNull(checkWordParam)) {
            return checkWordParam;
        }
        if (StringUtils.isBlank((CharSequence)req.getCategoryCode()) || StringUtils.isBlank((CharSequence)req.getLevelCode())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u7c7b\u522b\u7b49\u7ea7code\u4e0d\u5f97\u4e3a\u7a7a");
        }
        CategoryLevelRelationExample example = new CategoryLevelRelationExample();
        example.createCriteria().andLevelCodeEqualTo(req.getLevelCode()).andCategoryCodeEqualTo(req.getCategoryCode()).andStatusEqualTo(DataStatusEnum.NORMAL.getCode());
        List relations = this.categoryLevelRelationMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)relations)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u6b64\u7b49\u7ea7\u4e0b\u65e0\u6b64\u5206\u7c7b");
        }
        String relationCode = ((CategoryLevelRelation)relations.get(0)).getRelationCode();
        int existStatus = this.wordCategoryRelationMapper.checkWordExist(req.getWord(), relationCode);
        if (0 != existStatus) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u8be5\u5355\u8bcd\u5df2\u5b58\u5728\u672c\u7b49\u7ea7\u7c7b\u522b\u4e2d");
        }
        existStatus = this.wordCategoryRelationMapper.checkWordExist(req.getWord(), null);
        if (0 != existStatus) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_EXISTED, null, (String)"\u8be5\u5355\u8bcd\u5df2\u5b58\u5728\u4e8e\u5176\u4ed6\u7b49\u7ea7\u7c7b\u522b\u4e2d\uff0c\u786e\u5b9a\u66ff\u6362\u4e4b\u524d\u7684\u5355\u8bcd\u8be6\u60c5\uff1f");
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    private ResponseParams<String> checkWordParam(WordListReq req, boolean checkAuthority) {
        WordListUtil.decode((WordListDto)req);
        WordListUtil.trim((WordListDto)req);
        if (checkAuthority && (StringUtils.isBlank((CharSequence)req.getUid()) || this.checkPermission(req.getUid()))) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.FORBIDDEN, null);
        }
        if (StringUtils.isNotBlank((CharSequence)req.getWord()) && WordListUtil.checkWordIllegal((String)req.getWord())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u5355\u8bcd\u4ec5\u652f\u6301\u82f1\u6587\u548c\u7a7a\u683c");
        }
        if (StringUtils.isNotBlank((CharSequence)req.getExplains()) && WordListUtil.checkExplainIllegal((String)req.getExplains())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u91ca\u4e49\u4ec5\u652f\u6301\u4e2d\u6587\u3001\u82f1\u6587\u3001\u5b57\u6bcd\u53ca\u5e38\u7528\u7b26\u53f7");
        }
        if (StringUtils.isNotBlank((CharSequence)req.getWord()) && req.getWord().length() > this.wordListConfigProperties.getWordMaxSize()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u5355\u8bcd\u6700\u591a\u652f\u6301" + this.wordListConfigProperties.getWordMaxSize() + "\u4e2a\u5b57"));
        }
        if (StringUtils.isNotBlank((CharSequence)req.getExplains()) && req.getExplains().length() > this.wordListConfigProperties.getExplainsMaxSize()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u91ca\u4e49\u6700\u591a\u652f\u6301" + this.wordListConfigProperties.getExplainsMaxSize() + "\u4e2a\u5b57"));
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getBookCodes()) && req.getBookCodes().size() > this.wordListConfigProperties.getWordMaxBookCodeNum()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u56fe\u4e66\u6765\u6e90\u6700\u591a\u652f\u6301" + this.wordListConfigProperties.getExplainsMaxSize() + "\u672c"));
        }
        if (StringUtils.isNotBlank((CharSequence)req.getPicUrl()) && !this.checkPicUrlIllegal(req.getPicUrl())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u56fe\u7247\u4ec5\u652f\u6301" + this.wordListConfigProperties.getUrlFormat() + "\u683c\u5f0f"));
        }
        return null;
    }

    @RequestMapping(value={"updateWord/v1"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<String> updateWord(@RequestBody WordListReq req) {
        log.info("\u4fee\u6539\u5355\u8bcd\u672c\u4e2d\u5355\u8bcd\uff0c\u5220\u9664\u5355\u8bcd\u4e5f\u4f7f\u7528\u6b64\u63a5\u53e3---> {}", (Object)JSONObject.toJSONString((Object)req));
        if (Objects.isNull(req) || StringUtils.isBlank((CharSequence)req.getWord())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        ResponseParams checkWordParam = this.checkWordParam(req, true);
        if (Objects.nonNull(checkWordParam)) {
            return checkWordParam;
        }
        if (StringUtils.isNotBlank((CharSequence)req.getStatus()) && req.getStatus().equals(DataStatusEnum.EXCEPTION.getCode()) && CollectionUtils.isNotEmpty((Collection)req.getRelationCodes()) && req.getRelationCodes().size() == 1) {
            this.wordCategoryRelationMapper.delOneByWordAndRelationCode(req.getUid(), req.getWord(), (String)req.getRelationCodes().get(0));
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u5220\u9664\u6210\u529f");
        }
        if (CollectionUtils.isEmpty((Collection)req.getRelationCodes())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u4e00\u4e2a\u5355\u8bcd\u81f3\u5c11\u6709\u4e00\u4e2a\u7b49\u7ea7\u7c7b\u522b");
        }
        List categoryNum = this.categoryLevelRelationMapper.countCategoryNumOfLevel(req.getRelationCodes());
        if (CollectionUtils.isNotEmpty((Collection)categoryNum) && categoryNum.stream().anyMatch(e -> e > this.wordListConfigProperties.getCategoryMaxNumOfLevelOneWord())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u4e00\u4e2a\u7b49\u7ea7\u5185\u6700\u591a" + this.wordListConfigProperties.getCategoryMaxNumOfLevelOneWord() + "\u4e2a\u7c7b\u522b"));
        }
        ResponseParams checkBookCodes = this.checkBookCodesExists(req.getBookCodes());
        if (Objects.nonNull(checkBookCodes)) {
            return checkBookCodes;
        }
        WordListExample example = new WordListExample();
        example.createCriteria().andWordEqualTo(req.getWord());
        List wordLists = this.wordListMapper.selectByExample(example);
        WordList wordList = (WordList)wordLists.get(0);
        if (StringUtils.isNotBlank((CharSequence)req.getExplains())) {
            wordList.setExplains(req.getExplains());
        }
        wordList.setPicUrl(req.getPicUrl());
        wordList.setUpdateTime(new Date());
        wordList.setUpdateBy(req.getUid());
        wordList.setStatus(DataStatusEnum.NORMAL.getCode());
        this.wordListMapper.updateByPrimaryKey(wordList);
        this.updateWordCategoryRelation(req);
        if (CollectionUtils.isNotEmpty((Collection)req.getBookCodes())) {
            this.wordBookCodeRelationMapper.updateBatch(req.getWord(), req.getBookCodes());
        } else {
            WordBookCodeRelationExample ex = new WordBookCodeRelationExample();
            ex.createCriteria().andWordEqualTo(req.getWord());
            this.wordBookCodeRelationMapper.deleteByExample(ex);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u4fee\u6539\u6210\u529f");
    }

    private void updateWordCategoryRelation(WordListReq req) {
        List relationCodesNew = req.getRelationCodes();
        WordCategoryRelationExample wordExample = new WordCategoryRelationExample();
        wordExample.createCriteria().andWordEqualTo(req.getWord());
        List wordCategoryRelations = this.wordCategoryRelationMapper.selectByExample(wordExample);
        if (CollectionUtils.isEmpty((Collection)wordCategoryRelations)) {
            this.wordCategoryRelationMapper.insertBatch(req, relationCodesNew);
            return;
        }
        Set relationCodesOld = wordCategoryRelations.stream().filter(Objects::nonNull).map(WordCategoryRelation::getRelationCode).collect(Collectors.toSet());
        List<Object> relationCodesUpdate = new ArrayList();
        if (CollectionUtils.isNotEmpty(relationCodesOld)) {
            relationCodesUpdate = relationCodesNew.stream().filter(relationCodesOld::contains).collect(Collectors.toList());
            this.wordCategoryRelationMapper.updateStatusBatch(req.getWord(), req.getUid(), DataStatusEnum.NORMAL.getCode());
        }
        relationCodesOld.removeAll(relationCodesNew);
        if (CollectionUtils.isNotEmpty(relationCodesOld)) {
            this.wordCategoryRelationMapper.updateRelationStatusBatch(req.getWord(), req.getUid(), DataStatusEnum.EXCEPTION.getCode(), relationCodesOld);
        }
        relationCodesNew.removeAll(relationCodesUpdate);
        if (CollectionUtils.isNotEmpty((Collection)relationCodesNew)) {
            this.wordCategoryRelationMapper.insertBatch(req, relationCodesNew);
        }
    }

    @RequestMapping(value={"searchWord/v1"}, method={RequestMethod.POST})
    public ResponseParams<List<String>> searchWord(@RequestBody WordListReq req) {
        this.checkWordParam(req, false);
        String word = req.getWord();
        if (StringUtils.isBlank((CharSequence)word)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u4ec0\u4e48\u4e5f\u6ca1\u6709\u641c\u5230");
        }
        List words = this.wordListMapper.listWordsByKeyWord(word, this.wordListConfigProperties.getWordMaxSearchNum());
        ArrayList<String> returnWords = new ArrayList<String>(words.size());
        if (CollectionUtils.isNotEmpty((Collection)words)) {
            for (String e : words) {
                try {
                    e = URLEncoder.encode(e, "utf-8");
                    e = e.replaceAll("\\+", "%20");
                    returnWords.add(e);
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            }
        }
        ResponseParams build = ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, returnWords);
        if (CollectionUtils.isEmpty(returnWords)) {
            build.setMessage("\u4ec0\u4e48\u4e5f\u6ca1\u6709\u641c\u5230");
        }
        return build;
    }

    @RequestMapping(value={"showOneWordMsg/v1"}, method={RequestMethod.POST})
    public ResponseParams<WordListDto> showOneWordMsg(@RequestBody WordListReq req) {
        this.checkWordParam(req, false);
        log.info("\u901a\u8fc7\u5173\u952e\u5b57\u67e5\u770b\u6b64\u5355\u8bcd\u4fe1\u606f---> {}", (Object)JSONObject.toJSONString((Object)req));
        if (Objects.isNull(req) || StringUtils.isBlank((CharSequence)req.getWord())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        WordListExample example = new WordListExample();
        example.createCriteria().andWordEqualTo(req.getWord()).andStatusEqualTo(DataStatusEnum.NORMAL.getCode());
        List wordLists = this.wordListMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)wordLists)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        WordList word = (WordList)wordLists.get(0);
        List categoriesAndLevels = this.wordCategoryRelationMapper.getCategoriesAndLevelsByWord(word.getWord());
        LinkedHashMap levelAndCategories = new LinkedHashMap(8);
        if (CollectionUtils.isNotEmpty((Collection)categoriesAndLevels)) {
            for (WordCategoryDto categoriesAndLevel : categoriesAndLevels) {
                WordListUtil.encode((WordCategoryDto)categoriesAndLevel);
                ArrayList maps = (ArrayList)levelAndCategories.get(categoriesAndLevel.getLevelCode());
                if (Objects.isNull(maps)) {
                    maps = new ArrayList();
                }
                HashMap<String, String> categoryRelations = new HashMap<String, String>();
                categoryRelations.put("categoryName", categoriesAndLevel.getCategoryName());
                categoryRelations.put("categoryCode", categoriesAndLevel.getCategoryCode());
                categoryRelations.put("relationCode", categoriesAndLevel.getRelationCode());
                maps.add(categoryRelations);
                levelAndCategories.put(categoriesAndLevel.getLevelCode(), maps);
            }
        }
        List bookCodes = this.wordBookCodeRelationMapper.getBookCodesByWord(word.getWord());
        WordListDto wordListDto = new WordListDto();
        BeanUtils.copyProperties((Object)word, (Object)wordListDto);
        wordListDto.setBookCodes(bookCodes);
        wordListDto.setLevelAndCategories(levelAndCategories);
        WordListUtil.encode((WordListDto)wordListDto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)wordListDto);
    }

    private ResponseParams<String> checkBookCodesExists(List<String> bookCodes) {
        List bookCodesExists;
        if (CollectionUtils.isNotEmpty(bookCodes) && (CollectionUtils.isEmpty((Collection)(bookCodesExists = this.baseBookMapper.countBookCodesExist(bookCodes))) || bookCodesExists.size() != bookCodes.size())) {
            if (CollectionUtils.isNotEmpty((Collection)bookCodesExists)) {
                bookCodes.removeAll(bookCodesExists);
            }
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)("\u5bfc\u5165\u5931\u8d25\uff0c\u5b58\u5728\u975e\u6cd5\u6765\u6e90" + bookCodes.toString()));
        }
        return null;
    }

    @RequestMapping(value={"listWordsByRelationCode/v1"}, method={RequestMethod.POST})
    public ResponseParams<ResponsePageResult> listWordsByRelationCode(@RequestBody WordListReq req) {
        if (CollectionUtils.isEmpty((Collection)req.getRelationCodes()) || StringUtils.isBlank((CharSequence)((CharSequence)req.getRelationCodes().get(0)))) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        int pageNum = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)req.getPageNum(), (CharSequence)"1"));
        int pageSize = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)req.getPageSize(), (CharSequence)"20"));
        String relationCode = (String)req.getRelationCodes().get(0);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<WordListDto> words = this.wordCategoryRelationMapper.listWordsByRelationCode(relationCode);
        ResponsePageResult pageResult = ResponsePageResultUtils.build((List)words);
        if (null != words && words.size() > 0) {
            words = words.stream().filter(Objects::nonNull).collect(Collectors.toList());
            words.forEach(e -> {
                WordListUtil.encode((WordListDto)e);
                e.setRelationCodes(req.getRelationCodes());
                List bookCodes = this.wordBookCodeRelationMapper.getBookCodesByWord(e.getWord());
                e.setBookCodes(bookCodes);
            });
        }
        pageResult.setList((List)words);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)pageResult);
    }

    @RequestMapping(value={"updateWordIdx/v1"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<String> updateWordIdx(@RequestBody WordListReq req) {
        log.info("\u8c03\u6574\u5355\u8bcd\u987a\u5e8f---> {}", (Object)JSONObject.toJSONString((Object)req));
        if (Objects.isNull(req) || CollectionUtils.isEmpty((Collection)req.getRelationCodes()) || StringUtils.isBlank((CharSequence)((CharSequence)req.getRelationCodes().get(0))) || StringUtils.isBlank((CharSequence)req.getWord()) || StringUtils.isBlank((CharSequence)req.getSequence()) || !StringUtils.equalsIgnoreCase((CharSequence)req.getSequence(), (CharSequence)"forward") && !StringUtils.equalsIgnoreCase((CharSequence)req.getSequence(), (CharSequence)"back") && !StringUtils.equalsIgnoreCase((CharSequence)req.getSequence(), (CharSequence)"top")) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        if (StringUtils.isBlank((CharSequence)req.getUid()) || this.checkPermission(req.getUid())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.FORBIDDEN, null);
        }
        WordListUtil.decode((WordListDto)req);
        WordCategoryRelation wordAndCategory = this.wordCategoryRelationMapper.getOneByWordAndRelationCode(req.getWord(), (String)req.getRelationCodes().get(0));
        if (Objects.isNull(wordAndCategory)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int result = 0;
        if (StringUtils.equalsIgnoreCase((CharSequence)"top", (CharSequence)req.getSequence())) {
            if (Objects.nonNull(wordAndCategory.getIdx()) && 1 == wordAndCategory.getIdx()) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"to the top");
            }
            result = this.wordCategoryRelationMapper.updateWordIdxToTop(wordAndCategory, req.getUid());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"forward", (CharSequence)req.getSequence())) {
            if (Objects.nonNull(wordAndCategory.getIdx()) && 1 == wordAndCategory.getIdx()) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"to the top");
            }
            String targetIdx = this.wordCategoryRelationMapper.getTargetIdx(wordAndCategory, "forward");
            result = this.wordCategoryRelationMapper.moveWordIdx(wordAndCategory, targetIdx, req.getUid());
        } else {
            String targetIdx = this.wordCategoryRelationMapper.getTargetIdx(wordAndCategory, "back");
            if (StringUtils.isBlank((CharSequence)targetIdx)) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"to the bottom");
            }
            result = this.wordCategoryRelationMapper.moveWordIdx(wordAndCategory, targetIdx, req.getUid());
        }
        if (0 != result) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u4fee\u6539\u6210\u529f");
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null, (String)"\u4fee\u6539\u5931\u8d25");
    }
}

