/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.api.WhiteUserService;
import com.ella.resource.dto.pass.SetLevelMissionRequest;
import com.ella.resource.service.transactional.MapAndMissionUtilService;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.api.UserInfoService;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.dto.UserInfoDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WhiteUserServiceImpl
implements WhiteUserService {
    private static final Logger log = LogManager.getLogger(WhiteUserServiceImpl.class);
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private MapAndMissionUtilService mapAndMissionUtilService;

    public ResponseParams<Boolean> snapAll(String uid, String mobile, String levelCode) {
        if (uid == null || uid.equals("")) {
            UserInfoDto user = this.userInfoService.getUserByMobile(mobile);
            if (user == null) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, (Object)false);
            }
            uid = user.getUid();
        }
        ResponseParams response = this.userMapAndMissionService.snapAll(uid, levelCode);
        return response;
    }

    public ResponseParams<Boolean> buyAppleVip(String mobile, Integer day) {
        UserInfoDto user = this.userInfoService.getUserByMobile(mobile);
        if (user == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, (Object)false);
        }
        String uid = user.getUid();
        boolean r = this.userAccountService.updateUserVipInfo(uid, day.intValue());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)r);
    }

    public ResponseParams setLevelMission(@RequestBody SetLevelMissionRequest request) {
        this.mapAndMissionUtilService.snapUserLevelResource(request.getUid(), request.getLevel());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }
}

