/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.common.api.dictionary.YoudaoService;
import com.ella.common.dto.dictionary.AudioTypeEnum;
import com.ella.common.dto.dictionary.DictionaryDto;
import com.ella.common.dto.dictionary.GetEnToCnTranslateRequest;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.LexileResTypeService;
import com.ella.resource.api.UserWordService;
import com.ella.resource.constants.DataConstants;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserWord;
import com.ella.resource.domain.UserWordCategory;
import com.ella.resource.domain.UserWordExample;
import com.ella.resource.domain.UserWordMissionRel;
import com.ella.resource.domain.WordCategory;
import com.ella.resource.domain.WordList;
import com.ella.resource.domain.WordSentence;
import com.ella.resource.dto.word.CategoryWordCount;
import com.ella.resource.dto.word.CollectUserWordRequest;
import com.ella.resource.dto.word.JudgeCollectRequest;
import com.ella.resource.dto.word.JudgeCollectResponse;
import com.ella.resource.dto.word.KnowUserWordRequest;
import com.ella.resource.dto.word.SaveUserWordFollowRequest;
import com.ella.resource.dto.word.SearchWordListRequest;
import com.ella.resource.dto.word.UserTouchNotifyRequest;
import com.ella.resource.dto.word.UserWordDetailRequest;
import com.ella.resource.dto.word.UserWordFollowRequest;
import com.ella.resource.dto.word.WordCategoriesRequest;
import com.ella.resource.dto.word.WordCategoriesResponse;
import com.ella.resource.dto.word.WordListRequest;
import com.ella.resource.dto.word.WordListResponse;
import com.ella.resource.mapper.CategoryLevelRelationMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.mapper.UserWordCategoryMapper;
import com.ella.resource.mapper.UserWordMapper;
import com.ella.resource.mapper.UserWordMissionRelMapper;
import com.ella.resource.mapper.WordBookCodeRelationMapper;
import com.ella.resource.mapper.WordCategoryMapper;
import com.ella.resource.mapper.WordCategoryRelationMapper;
import com.ella.resource.mapper.WordListMapper;
import com.ella.resource.mapper.WordSentenceMapper;
import com.ella.resource.utils.Putil;
import com.ella.resource.utils.ResponsePageResult;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.api.learn.UserWordFollowService;
import com.ella.user.constant.FollowTypeEnum;
import com.ella.user.dto.learn.UserFollowRecordRequest;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.autoconfigure.PageHelperProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserWordServiceImpl
implements UserWordService {
    private static final Logger log = LogManager.getLogger(UserWordServiceImpl.class);
    @Autowired
    private WordCategoryMapper wordCategoryMapper;
    @Autowired
    private CategoryLevelRelationMapper categoryLevelRelationMapper;
    @Autowired
    private UserWordCategoryMapper userWordCategoryMapper;
    @Autowired
    private WordCategoryRelationMapper wordCategoryRelationMapper;
    @Autowired
    private UserWordMapper userWordMapper;
    @Autowired
    private UserWordFollowService userWordFollowService;
    @Autowired
    private WordListMapper wordListMapper;
    @Autowired
    private WordSentenceMapper wordSentenceMapper;
    @Autowired
    private WordBookCodeRelationMapper wordBookCodeRelationMapper;
    @Autowired
    private LexileResTypeService lexileResTypeService;
    @Autowired
    PageHelperProperties pageHelperProperties;
    @Autowired
    YoudaoService youdaoService;
    @Autowired
    private UserWordMissionRelMapper userWordMissionRelMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;

    @PostConstruct
    public void initPageProperties() {
        this.pageHelperProperties.setReasonable("false");
    }

    public ResponseParams wordCategories(@RequestBody WordCategoriesRequest request) {
        String levelCode = request.getLevelCode() == null || request.getLevelCode().equals("") ? "1" : request.getLevelCode();
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List wordCategories = this.categoryLevelRelationMapper.selectListByLevelCode(levelCode, request.getUid());
        if (wordCategories == null || wordCategories.size() == 0) {
            ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        List codes = wordCategories.stream().map(WordCategory::getCategoryCode).collect(Collectors.toList());
        Map<String, Integer> map = null;
        if (codes != null && codes.size() > 0) {
            List dataMapList = this.wordCategoryRelationMapper.selectWordCountByCategory(codes);
            map = dataMapList.stream().collect(Collectors.toMap(CategoryWordCount::getCategoryCode, CategoryWordCount::getCounts));
        }
        ResponsePageResult responsePageResult = Putil.build((List)wordCategories);
        wordCategories = responsePageResult.getList();
        ArrayList<WordCategoriesResponse> responses = new ArrayList<WordCategoriesResponse>();
        for (WordCategory wordCategory : wordCategories) {
            WordCategoriesResponse item = new WordCategoriesResponse(wordCategory.getId(), wordCategory.getCategoryName(), wordCategory.getCategoryEnName(), wordCategory.getCategoryImgUrl());
            if (map != null) {
                item.setWordTotals(map.get(wordCategory.getCategoryCode()));
            }
            responses.add(item);
        }
        responsePageResult.setList(responses);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)responsePageResult);
    }

    public ResponseParams wordList(@RequestBody WordListRequest request) {
        ResponsePageResult response = null;
        if (DataEnum.WordSourceEnum.BASE.getCode().equals(request.getSourceType())) {
            response = this.getBaseWordList(request.getUid(), request.getCategoryId(), request.getPageNo(), Integer.valueOf(request.getPageSize()));
        } else if (DataEnum.WordSourceEnum.KNOW.getCode().equals(request.getSourceType())) {
            response = this.getKnowWordList(request.getUid(), request.getPageNo(), Integer.valueOf(request.getPageSize()));
        } else if (DataEnum.WordSourceEnum.COLLECT.getCode().equals(request.getSourceType())) {
            response = this.getCollectWordList(request.getUid(), request.getPageNo(), Integer.valueOf(request.getPageSize()));
        } else if (DataEnum.WordSourceEnum.FOLLOW.getCode().equals(request.getSourceType())) {
            response = this.getFollowWordList(request.getUid(), request.getPageNo(), Integer.valueOf(request.getPageSize()));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)response);
    }

    private ResponsePageResult<List<WordListResponse>> getBaseWordList(String uid, Long categoryId, Integer pageNo, Integer pageSize) {
        ResponsePageResult responsePageResult = null;
        WordCategory wordCategory = this.wordCategoryMapper.selectByPrimaryKey(Integer.valueOf(categoryId.intValue()));
        if (wordCategory == null) {
            ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List wordsMap = this.wordCategoryRelationMapper.selectWordListByCategory(wordCategory.getCategoryCode(), uid);
        ResponsePageResult responsePageResultx = Putil.build((List)wordsMap);
        responsePageResult = this.handleResultSet(responsePageResultx, DataEnum.WordSourceEnum.BASE.getCode());
        return responsePageResult;
    }

    private ResponsePageResult handleResultSet(ResponsePageResult responsePageResult, String sourceType) {
        if (responsePageResult == null) {
            return new ResponsePageResult();
        }
        if (DataEnum.WordSourceEnum.BASE.getCode().equals(sourceType)) {
            List list = responsePageResult.getList();
            if (list == null || list.size() == 0) {
                return responsePageResult;
            }
            ArrayList baseWordList = new ArrayList();
            list.forEach(map -> {
                WordListResponse wordListResponse = new WordListResponse();
                String word = Optional.ofNullable(map.get("word")).orElse("");
                String imgUrl = Optional.ofNullable(map.get("picUrl")).orElse("");
                wordListResponse.setWord(word);
                wordListResponse.setImgUrl(imgUrl);
                wordListResponse.setSourceType(DataEnum.WordSourceEnum.BASE.getCode());
                baseWordList.add(wordListResponse);
            });
            responsePageResult.setList(baseWordList);
        } else if (DataEnum.WordSourceEnum.KNOW.getCode().equals(sourceType) || DataEnum.WordSourceEnum.COLLECT.getCode().equals(sourceType) || DataEnum.WordSourceEnum.FOLLOW.getCode().equals(sourceType)) {
            List list = responsePageResult.getList();
            if (list == null || list.size() == 0) {
                return responsePageResult;
            }
            ArrayList knowWordList = new ArrayList();
            list.forEach(userWord -> {
                WordListResponse wordListResponse = new WordListResponse();
                String word = userWord.getWord();
                wordListResponse.setWord(word);
                WordList wordList = this.wordListMapper.selectByWord(word);
                if (wordList != null) {
                    wordListResponse.setImgUrl(wordList.getPicUrl());
                }
                wordListResponse.setSourceType(DataEnum.WordSourceEnum.KNOW.getCode());
                knowWordList.add(wordListResponse);
            });
            responsePageResult.setList(knowWordList);
        }
        return responsePageResult;
    }

    private ResponsePageResult<List<WordListResponse>> getKnowWordList(String uid, Integer pageNo, Integer pageSize) {
        ResponsePageResult responsePageResult = null;
        UserWordExample example = new UserWordExample();
        example.createCriteria().andUidEqualTo(uid).andIsFollowEqualTo(Integer.valueOf(1)).andIsKnowEqualTo(Integer.valueOf(0));
        UserWordExample.Criteria criteria = example.createCriteria().andUidEqualTo(uid).andIsSearchEqualTo(Integer.valueOf(1));
        example.or(criteria);
        UserWordExample.Criteria criteriax = example.createCriteria().andUidEqualTo(uid).andIsClickEqualTo(Integer.valueOf(1));
        example.or(criteriax);
        example.setOrderByClause(" touch_time asc,know_time desc");
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List userWords = this.userWordMapper.selectByExample(example);
        ResponsePageResult responsePageResultx = Putil.build((List)userWords);
        responsePageResult = this.handleResultSet(responsePageResultx, DataEnum.WordSourceEnum.KNOW.getCode());
        return responsePageResult;
    }

    private ResponsePageResult<List<WordListResponse>> getCollectWordList(String uid, Integer pageNo, Integer pageSize) {
        ResponsePageResult responsePageResult = null;
        UserWordExample example = new UserWordExample();
        example.createCriteria().andUidEqualTo(uid).andIsCollectedEqualTo(Integer.valueOf(1));
        example.setOrderByClause(" touch_time asc,collect_time desc");
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List userWords = this.userWordMapper.selectByExample(example);
        ResponsePageResult responsePageResultx = Putil.build((List)userWords);
        responsePageResult = this.handleResultSet(responsePageResultx, DataEnum.WordSourceEnum.KNOW.getCode());
        return responsePageResult;
    }

    private ResponsePageResult<List<WordListResponse>> getFollowWordList(String uid, Integer pageNo, Integer pageSize) {
        ResponsePageResult responsePageResult = null;
        UserWordExample example = new UserWordExample();
        example.createCriteria().andUidEqualTo(uid).andIsFollowEqualTo(Integer.valueOf(1));
        example.setOrderByClause(" follow_time desc");
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List userWords = this.userWordMapper.selectByExample(example);
        ResponsePageResult responsePageResultx = Putil.build((List)userWords);
        responsePageResult = this.handleResultSet(responsePageResultx, DataEnum.WordSourceEnum.KNOW.getCode());
        return responsePageResult;
    }

    public ResponseParams userTouchNotify(@RequestBody UserTouchNotifyRequest request) {
        if (request.getWord() != null && !request.getWord().equals("")) {
            UserWord userWord = this.userWordMapper.selectByUidAndWord(request.getUid(), request.getWord());
            if (userWord == null) {
                userWord = UserWord.builder().uid(request.getUid()).word(request.getWord()).touchTime(new Date()).build();
                this.userWordMapper.insertSelective(userWord);
            } else {
                userWord.setTouchTime(new Date());
                this.userWordMapper.updateByPrimaryKeySelective(userWord);
            }
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    public ResponseParams searchWordList(@RequestBody SearchWordListRequest request) {
        List data;
        block6: {
            block5: {
                data = this.wordListMapper.selectByKeyWord(request.getKeyword());
                if (data != null && data.size() != 0) break block5;
                data = this.userWordMapper.selectByUidAndLikeWord(request.getUid(), request.getKeyword());
                if (data == null || data.size() == 0) break block6;
                for (Map dataMap : data) {
                    dataMap.put("imgUrl", "");
                    String word = (String)dataMap.get("word");
                    UserWord userWord = this.userWordMapper.selectByUidAndWord(request.getUid(), word);
                    if (userWord == null) continue;
                    userWord.setIsSearch(Integer.valueOf(1));
                    if (userWord.getIsKnow() != 1) {
                        userWord.setIsKnow(Integer.valueOf(0));
                    }
                    this.userWordMapper.updateByPrimaryKeySelective(userWord);
                }
                break block6;
            }
            for (Map dataMap : data) {
                String word = (String)dataMap.get("word");
                UserWord userWord = this.userWordMapper.selectByUidAndWord(request.getUid(), word);
                if (userWord == null) {
                    userWord = UserWord.builder().uid(request.getUid()).word(word).isSearch(Integer.valueOf(1)).isKnow(Integer.valueOf(0)).build();
                    this.userWordMapper.insertSelective(userWord);
                    continue;
                }
                userWord.setIsSearch(Integer.valueOf(1));
                if (userWord.getIsKnow() != 1) {
                    userWord.setIsKnow(Integer.valueOf(0));
                }
                this.userWordMapper.updateByPrimaryKeySelective(userWord);
            }
        }
        return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)data);
    }

    public ResponseParams collectUserWord(@RequestBody CollectUserWordRequest request) {
        List collectUserWordRequestItemList = request.getList();
        if (collectUserWordRequestItemList != null && collectUserWordRequestItemList.size() > 0) {
            collectUserWordRequestItemList.forEach(item -> {
                String word = item.getWord();
                Integer isCollect = item.getIsCollect();
                UserWord userWord = this.userWordMapper.selectByUidAndWord(request.getUid(), word);
                if (userWord != null) {
                    userWord.setIsCollected(isCollect);
                    if (item.getMissionCode() != null && !item.getMissionCode().equals("")) {
                        userWord.setSourceType(Integer.valueOf(1));
                        this.replaceUserWordMission(request.getUid(), word, item.getMissionCode());
                    }
                    userWord.setTouchTime(new Date());
                    this.userWordMapper.updateByPrimaryKeySelective(userWord);
                } else {
                    userWord = UserWord.builder().uid(request.getUid()).word(item.getWord()).isCollected(item.getIsCollect()).touchTime(new Date()).build();
                    if (item.getMissionCode() != null && !item.getMissionCode().equals("")) {
                        userWord.setSourceType(Integer.valueOf(1));
                        this.replaceUserWordMission(request.getUid(), word, item.getMissionCode());
                    }
                    userWord.setExplains(this.getExplainsFromYouDao(word));
                }
                this.userWordMapper.insertSelective(userWord);
            });
        }
        return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private String getExplainsFromYouDao(String word) {
        GetEnToCnTranslateRequest translateRequest = new GetEnToCnTranslateRequest();
        translateRequest.setVoice(0);
        translateRequest.setWordText(word);
        translateRequest.setAudioType(AudioTypeEnum.MP3);
        ResponseParams result = this.youdaoService.getEnToCnTranslate(translateRequest);
        if (result != null && CommonRetCode.SUCCESS.getCode().equals(result.getCode()) && result.getData() != null) {
            return ((DictionaryDto)result.getData()).getExplains();
        }
        return "";
    }

    private void replaceUserWordMission(String uid, String word, String missionCode) {
        UserWordMissionRel userWordMissionRel = this.userWordMissionRelMapper.selectItem(uid, word, missionCode);
        if (userWordMissionRel == null) {
            userWordMissionRel = new UserWordMissionRel();
            userWordMissionRel.setUid(uid);
            userWordMissionRel.setMissionCode(missionCode);
            userWordMissionRel.setWord(word);
            this.userWordMissionRelMapper.insertSelective(userWordMissionRel);
        }
    }

    public ResponseParams knowUserWord(@RequestBody KnowUserWordRequest request) {
        List knowUserWordRequestItemList = request.getList();
        if (knowUserWordRequestItemList != null && knowUserWordRequestItemList.size() > 0) {
            knowUserWordRequestItemList.forEach(item -> {
                String word = item.getWord();
                Integer isKnow = item.getIsKnow();
                UserWord userWord = this.userWordMapper.selectByUidAndWord(request.getUid(), word);
                if (userWord != null) {
                    userWord.setIsKnow(isKnow);
                    userWord.setTouchTime(new Date());
                    this.userWordMapper.updateByPrimaryKeySelective(userWord);
                } else {
                    userWord = UserWord.builder().uid(request.getUid()).word(item.getWord()).isKnow(item.getIsKnow()).touchTime(new Date()).build();
                    this.userWordMapper.insertSelective(userWord);
                }
            });
        }
        return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    public ResponseParams userWordDetail(@RequestBody UserWordDetailRequest request) {
        HashMap<String, Object> params;
        List wordsList = null;
        if (DataEnum.WordSourceEnum.BASE.getCode().equals(request.getSourceType())) {
            WordCategory wordCategory = this.wordCategoryMapper.selectByPrimaryKey(Integer.valueOf(request.getCategoryId().intValue()));
            if (wordCategory == null) {
                ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
            }
            PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
            wordsList = this.wordCategoryRelationMapper.selectWordListByCategory(wordCategory.getCategoryCode(), request.getUid());
            UserWordCategory userWordCategory = this.userWordCategoryMapper.selectByCategoryId(request.getCategoryId());
            if (userWordCategory == null) {
                userWordCategory = UserWordCategory.builder().uid(request.getUid()).categoryId(request.getCategoryId()).touchTime(new Date()).build();
                this.userWordCategoryMapper.insertSelective(userWordCategory);
            } else {
                userWordCategory.setTouchTime(new Date());
                this.userWordCategoryMapper.updateByPrimaryKeySelective(userWordCategory);
            }
        } else if (DataEnum.WordSourceEnum.KNOW.getCode().equals(request.getSourceType())) {
            params = new HashMap<String, Object>(18);
            params.put("uid", request.getUid());
            params.put("sourceType", DataEnum.WordSourceEnum.KNOW.getCode());
            params.put("isKnow", 0);
            params.put("isSearch", 1);
            params.put("isClick", 1);
            params.put("isFollow", 1);
            params.put("word", request.getWord());
            PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
            wordsList = this.userWordMapper.selectByWordDetailList(params);
        } else if (DataEnum.WordSourceEnum.COLLECT.getCode().equals(request.getSourceType())) {
            params = new HashMap(18);
            params.put("uid", request.getUid());
            params.put("isCollect", 1);
            params.put("word", request.getWord());
            PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
            wordsList = this.userWordMapper.selectByWordDetailList(params);
        } else if (DataEnum.WordSourceEnum.FOLLOW.getCode().equals(request.getSourceType())) {
            params = new HashMap(18);
            params.put("uid", request.getUid());
            params.put("isFollow", 1);
            params.put("word", request.getWord());
            PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
            wordsList = this.userWordMapper.selectByWordDetailList(params);
        } else {
            PageHelper.startPage((int)1, (int)1);
            wordsList = this.wordListMapper.selectWordDetail(request.getWord(), request.getUid());
        }
        ResponsePageResult responsePageResultx = Putil.build((List)wordsList);
        List dataList = responsePageResultx.getList();
        if (dataList != null && dataList.size() > 0) {
            int index = 0;
            for (int i = 0; i < dataList.size(); ++i) {
                Object explains;
                Integer sourceType;
                Map wordMap = (Map)dataList.get(i);
                String word = (String)wordMap.get("word");
                List sentences = this.wordSentenceMapper.selectSentenceByWord(request.getUid(), word, Integer.valueOf(5));
                wordMap.put("exampleSentences", sentences);
                ArrayList wordSourceBookList = null;
                Integer n = sourceType = wordMap.get("sourceType") == null ? null : (Integer)wordMap.get("sourceType");
                if (sourceType == null || sourceType == 0) {
                    wordSourceBookList = this.wordBookCodeRelationMapper.selectSourceBookByWord(word, 5);
                    if (wordSourceBookList != null && wordSourceBookList.size() > 0) {
                        wordSourceBookList.forEach(wordSourceBook -> {
                            if (wordSourceBook.get("picBookCode") != null) {
                                String picBookCode = wordSourceBook.get("picBookCode").toString();
                                String lexileLevel = Optional.ofNullable(wordSourceBook.get("lexileLevel")).orElse("").toString();
                                String lexielLevelCode = this.lexileResTypeService.getLexileLevelCode(picBookCode, lexileLevel);
                                wordSourceBook.put("lexileResTypeCode", lexielLevelCode);
                            }
                        });
                    }
                } else if (sourceType == 1) {
                    wordSourceBookList = new ArrayList();
                    List sourceMissionCodeList = this.userWordMissionRelMapper.selectSourceList(request.getUid(), word);
                    if (sourceMissionCodeList != null && sourceMissionCodeList.size() > 0) {
                        for (String missionCode : sourceMissionCodeList) {
                            Long missionId = null;
                            UserMission userMission = this.userMissionMapper.selectByUidAndMissionCode(request.getUid(), missionCode);
                            if (userMission == null) {
                                Mission mission = this.missionMapper.selectByMissionCode(missionCode);
                                if (mission != null) {
                                    missionId = mission.getId();
                                }
                            } else {
                                missionId = userMission.getId();
                            }
                            HashMap<String, Long> map = new HashMap<String, Long>(1);
                            map.put("missionId", missionId);
                            wordSourceBookList.add(map);
                        }
                    }
                }
                wordMap.put("wordSourceBookList", wordSourceBookList);
                if (word.equals(request.getWord())) {
                    index = i;
                }
                if ((explains = wordMap.get("explains")) != null) continue;
                wordMap.put("explains", this.getExplainsFromYouDao(word));
            }
            if (!DataEnum.WordSourceEnum.BASE.getCode().equals(request.getSourceType())) {
                Map wordMap = (Map)dataList.get(index);
                Map firstMap = (Map)dataList.get(0);
                dataList.set(0, wordMap);
                dataList.set(index, firstMap);
            }
        }
        return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)responsePageResultx);
    }

    public ResponseParams getUserWordFollow(@RequestBody UserWordFollowRequest request) {
        UserFollowRecordRequest req = UserFollowRecordRequest.builder().content(request.getWord()).uid(request.getUid()).build();
        return this.userWordFollowService.getUserFollowRecord(req);
    }

    public ResponseParams saveUserWordFollow(@RequestBody SaveUserWordFollowRequest request) {
        UserWord userWord;
        Integer isKnow = 2;
        boolean isUpdateFollow = false;
        if (request.getFollowScore() < (float)DataConstants.LIMIT_SCORE.intValue()) {
            isUpdateFollow = true;
            isKnow = 0;
        }
        if ((userWord = this.userWordMapper.selectByUidAndWord(request.getUid(), request.getWord())) == null) {
            userWord = UserWord.builder().uid(request.getUid()).word(request.getWord()).categoryId(request.getCategoryId()).isFollow(Integer.valueOf(1)).followTime(new Date()).isKnow(isKnow).voiceUrl(request.getVoiceUrl()).followScore(Float.valueOf(request.getFollowScore())).build();
            if (request.getMissionCode() != null && !request.getMissionCode().equals("")) {
                userWord.setSourceType(Integer.valueOf(1));
                this.replaceUserWordMission(request.getUid(), request.getWord(), request.getMissionCode());
            }
            if (isUpdateFollow) {
                userWord.setKnowTime(new Date());
            }
            this.userWordMapper.insertSelective(userWord);
        } else {
            if (isKnow != 2) {
                userWord.setIsKnow(isKnow);
            }
            userWord = UserWord.builder().id(userWord.getId()).isFollow(Integer.valueOf(1)).voiceUrl(request.getVoiceUrl()).followScore(Float.valueOf(request.getFollowScore())).build();
            if (isUpdateFollow) {
                Date now = new Date();
                userWord.setFollowTime(now);
                userWord.setKnowTime(now);
            }
            if (request.getMissionCode() != null && !request.getMissionCode().equals("")) {
                userWord.setSourceType(Integer.valueOf(1));
                this.replaceUserWordMission(request.getUid(), request.getWord(), request.getMissionCode());
            }
            this.userWordMapper.updateByPrimaryKeySelective(userWord);
        }
        UserFollowRecordRequest req = UserFollowRecordRequest.builder().content(request.getWord()).detailScore(Float.valueOf(request.getFollowScore())).uid(request.getUid()).voiceUrl(request.getVoiceUrl()).contentType("WORD").followType(FollowTypeEnum.WORD.getCode()).build();
        ResponseParams responseParams = this.userWordFollowService.saveUserFollowRecord(req);
        if (responseParams != null && CommonRetCode.SUCCESS.getCode().equals(responseParams.getCode())) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(() -> {
                WordSentence wordSentence = WordSentence.builder().uid(request.getUid()).word(request.getWord()).sentence(request.getSentence()).status("NORMAL").createTime(new Date()).build();
                wordSentence.setExplains(this.getExplainsFromYouDao(request.getWord()));
                this.wordSentenceMapper.insertSelective(wordSentence);
            });
        }
        return responseParams;
    }

    public ResponseParams judgeCollect(@RequestBody JudgeCollectRequest request) {
        JudgeCollectResponse data = new JudgeCollectResponse();
        data.setIsCollect(Integer.valueOf(0));
        UserWordExample example = new UserWordExample();
        example.createCriteria().andUidEqualTo(request.getUid()).andWordEqualTo(request.getWord());
        List userWords = this.userWordMapper.selectByExample(example);
        if (userWords == null || userWords.size() == 0) {
            return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)data);
        }
        UserWord userWord = (UserWord)userWords.get(0);
        if (userWord.getIsCollected() == 0) {
            return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)data);
        }
        data.setIsCollect(Integer.valueOf(1));
        return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)data);
    }
}

