/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.dto.goods.GoodsStatusEnum;
import com.ella.resource.api.LexileResTypeService;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.api.UserMapAndMissionSnapshotService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.Attach;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.MissionAndResource;
import com.ella.resource.domain.UserCourseExample;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMapBo;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserMissionExample;
import com.ella.resource.dto.MapDto;
import com.ella.resource.dto.appdto.CourseMissionDto;
import com.ella.resource.dto.appdto.PicBookMissionDto;
import com.ella.resource.dto.appdto.UserMapListDto;
import com.ella.resource.dto.appdto.UserMissionDto;
import com.ella.resource.dto.appdto.UserMissionListDto;
import com.ella.resource.dto.missiondto.DynamicDto;
import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import com.ella.resource.dto.request.BaseRequest;
import com.ella.resource.dto.request.map.GetMapInfoRequest;
import com.ella.resource.dto.request.mission.GetMissionInfoRequest;
import com.ella.resource.mapper.IraReadReportMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.LevelTService;
import com.ella.resource.service.transactional.MapAndMissionUtilService;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.service.transactional.MissionTService;
import com.ella.resource.service.transactional.RpcService;
import com.ella.resource.service.transactional.UserCourseReportService;
import com.ella.resource.service.transactional.UserMissionTService;
import com.ella.resource.utils.MapUtils;
import com.ella.resource.utils.ModeTransformUtils;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.dto.UserInfoDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserMapAndMissionSnapshotServiceImpl
implements UserMapAndMissionSnapshotService {
    private static final Logger log = LogManager.getLogger(UserMapAndMissionSnapshotServiceImpl.class);
    private Integer missionNumOfFirstMap = 0;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private MapTService mapTService;
    @Autowired
    private MissionTService missionTService;
    @Autowired
    private LevelTService levelTService;
    @Autowired
    private UserMissionTService userMissionTService;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private MapAndMissionUtilService mapAndMissionUtilService;
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private LexileResTypeService lexileResTypeService;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;
    @Autowired
    private IraReadReportMapper iraReadReportMapper;
    @Autowired
    private UserCourseReportService userCourseReportService;

    public ResponseParams<List<UserMapListDto>> selectUserMap(@RequestBody BaseRequest request) {
        UserMapListDto userMapListDto;
        String uid = request.getUid();
        UserInfoDto userInfoDto = this.rpcService.selectUserByUid(uid);
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        ArrayList<UserMapListDto> result = new ArrayList<UserMapListDto>();
        try {
            this.mapAndMissionUtilService.needMapUpdate(request.getUid());
        }
        catch (Exception e) {
            log.error("check map update error", (Throwable)e);
        }
        List mapDtoList = this.getMapGreaterThanLevlCode(userInfoDto.getLevel());
        List userMaps = this.getUserMap(userInfoDto.getUid());
        if (userMaps.size() == 0) {
            this.userMapAndMissionService.updateUserMapForFree(userInfoDto.getUid(), "N");
            userMaps = this.getUserMap(userInfoDto.getUid());
        }
        java.util.Map mapAndPassMissionNum = ModeTransformUtils.getStringKStringVMap((List)this.userMissionMapper.countByUidGroupByMapCode(userInfoDto.getUid(), "PASS", userMaps.stream().map(MapDto::getMapCode).collect(Collectors.toList())), (String)"mapCode", (String)"num");
        HashSet<String> userMapCodeSet = new HashSet<String>();
        for (MapDto userMap : userMaps) {
            userMapListDto = this.fillByUserMap(userMap, mapAndPassMissionNum, userInfoDto.getLevel());
            String key = "SYS_RESOURCE_UPDATE:" + DataEnum.SYS_RESOURCE_UPDATE_TYPE.MAP_RESOURCE_INSERT + ":" + request.getUid() + ":" + userMap.getMapCode();
            String isNew = this.redisCache.get(key);
            if (isNew != null) {
                userMapListDto.setIsNew(Boolean.valueOf(true));
            }
            result.add(userMapListDto);
            userMapCodeSet.add(userMap.getMapCode());
        }
        for (MapDto dto : mapDtoList) {
            if (userMapCodeSet.contains(dto.getMapCode())) continue;
            userMapListDto = this.fillByMap(dto);
            result.add(userMapListDto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    @EnableValidate
    public ResponseParams<UserMissionListDto> selectUserMission(@RequestBody GetMapInfoRequest request) {
        UserMissionListDto result;
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        UserMap userMap = this.userMapMapper.selectByPrimaryKey(request.getId());
        Map baseMap = null;
        if (Objects.nonNull(userMap)) {
            String status;
            String reportCode;
            try {
                this.mapAndMissionUtilService.needMissionUpdate(userInfoDto.getUid(), userMap);
            }
            catch (Exception e) {
                log.error("check mission insert error", (Throwable)e);
            }
            result = UserMissionListDto.builder().backgroundUrl(userMap.getBackgroundUrl()).bottomUrl(userMap.getBottomUrl()).build();
            this.fillByUserMissions(result, userMap, userInfoDto);
            baseMap = this.mapMapper.selectByMapCode(userMap.getMapCode());
            if (StringUtils.isNotBlank((CharSequence)userMap.getMapCode()) && StringUtils.isNotBlank((CharSequence)request.getUid()) && StringUtils.isNotBlank((CharSequence)(reportCode = this.iraReadReportMapper.getReportCodeByUidAndMapCode(request.getUid(), userMap.getMapCode()))) && StringUtils.isBlank((CharSequence)(status = this.redisCache.get("BOE:EN:IRA:REPORT_CODE:" + reportCode)))) {
                result.setNewReport(Boolean.TRUE);
                this.redisCache.set("BOE:EN:IRA:REPORT_CODE:" + reportCode, (Object)"success");
            }
            result.setShowReport(Boolean.TRUE);
        } else {
            Map map = this.mapMapper.selectByPrimaryKey(request.getId());
            if (null == map) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_NOT_EXISTS);
            }
            result = UserMissionListDto.builder().backgroundUrl(map.getBackgroundUrl()).bottomUrl(map.getBottomUrl()).build();
            this.fillByMissions(result, map, userInfoDto);
            result.setShowReport(Boolean.FALSE);
            baseMap = map;
        }
        String key = "SYS_RESOURCE_UPDATE:" + DataEnum.SYS_RESOURCE_UPDATE_TYPE.MAP_RESOURCE_INSERT.getValue() + ":" + userInfoDto.getUid() + ":" + baseMap.getMapCode();
        String isNew = this.redisCache.get(key);
        if (isNew != null) {
            result.setIsNew(Boolean.valueOf(true));
        }
        this.setUserInfo(result, userInfoDto);
        result.setMapName(baseMap.getMapName());
        result.setLevelCode(baseMap.getLevelCode());
        Integer missionNum = this.mapAndMissionUtilService.getMissionNum(baseMap.getMapCode());
        result.setMissionNum(missionNum);
        result.setMapCode(baseMap.getMapCode());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<CourseMissionDto> userMissionInfo(@RequestBody GetMissionInfoRequest request) {
        Date unlockTime;
        String keyx;
        String isNewResource;
        CourseMissionDto result;
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        UserMission userMission = this.userMissionMapper.selectByPrimaryKey(request.getId());
        if (userMission != null) {
            UserMap userMap = this.userMapMapper.selectByUidAndMapCode(request.getUid(), userMission.getMapCode());
            try {
                this.mapAndMissionUtilService.needMissionUpdate(userInfoDto.getUid(), userMap);
            }
            catch (Exception e) {
                log.error("check mission del error", (Throwable)e);
            }
            try {
                this.mapAndMissionUtilService.needMissionResUpdate(userInfoDto.getUid(), userMission);
            }
            catch (Exception e) {
                log.error("check mission resource update error", (Throwable)e);
            }
        }
        if (Objects.isNull(result = this.userMissionMapper.selectCourseMissionInfo(request.getId()))) {
            result = this.missionMapper.selectCourseMissionInfo(request.getId());
            if (Objects.isNull(result)) {
                CourseMissionDto data = new CourseMissionDto();
                data.setBookCode(this.mapAndMissionUtilService.getBookCodeByMissionId(request.getId()));
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS, (Object)data);
            }
            result.setStatus("LOCKED");
            result.setIsClickable(Boolean.FALSE);
        } else {
            result.setPassNum(userMission.getPassNum());
            result.setStatus("NOTSTARTED".equalsIgnoreCase(result.getStatus()) ? "LOCKED" : "UNLOCKED");
            result.setIsClickable(Boolean.valueOf(this.mapAndMissionUtilService.missionClickable(request.getUid(), result.getMissionCode(), result.getStatus()) != false));
            if (result.getIsClickable().booleanValue() && !"DOING".equals(result.getStatus()) && !"PASS".equals(result.getStatus())) {
                result.setStatus("UNLOCKED");
            }
        }
        String key = "SYS_RESOURCE_UPDATE:" + DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue() + ":" + userInfoDto.getUid() + ":" + result.getMissionCode();
        String isNew = this.redisCache.get(key);
        if (isNew != null) {
            result.setIsNew(Boolean.valueOf(true));
        }
        if ((isNewResource = this.redisCache.get(keyx = "SYS_RESOURCE_UPDATE:" + DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_REPLACE.getValue() + ":" + userInfoDto.getUid() + ":" + result.getMissionCode())) != null) {
            result.setIsNewResource(Boolean.valueOf(true));
        }
        if (!result.getIsClickable().booleanValue() && result.getIsNewResource().booleanValue()) {
            this.redisCache.del(key);
            result.setIsNewResource(Boolean.valueOf(false));
        }
        Date date = unlockTime = userMission != null ? userMission.getUnlockTime() : null;
        if (unlockTime != null && result.getIsNewResource().booleanValue()) {
            String resUpdateTime = this.redisCache.get("mission_res_update_time_" + userMission.getMissionCode());
            String unlockTimeStr = String.valueOf(unlockTime.getTime());
            if (unlockTimeStr.compareTo(resUpdateTime) > 0) {
                this.redisCache.del(key);
                result.setIsNewResource(Boolean.valueOf(false));
            }
        }
        result.setBalance(userInfoDto.getBalance());
        Integer accountStoneNum = null == userInfoDto.getStoneNum() ? 0 : userInfoDto.getStoneNum();
        result.setStoneNum(accountStoneNum);
        this.setCourseInfoOfMission(result, request.getUid());
        result.setIsFinished(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)this.userCourseReportService.getUserCourseReportByUidAndMissionCode(request.getUid(), result.getMissionCode()))));
        result.setLexileLevelCode(this.lexileResTypeService.getLexileLevelCode(result.getCourseCode(), result.getLexileLevel()));
        if (DataEnum.SHELVESFLAG.SHELVES_OFF.getValue().equals(result.getShelvesFlag()) || "NO".equals(result.getEnglishStatus())) {
            result.setAvailable(Boolean.valueOf(false));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<PicBookMissionDto> userPicMissionInfo(GetMissionInfoRequest request) {
        return null;
    }

    public Boolean missionClickable(@RequestParam(value="uid") String uid, @RequestParam(value="currentMissionId") Long currentMissionId, @RequestParam(value="levelCode") String levelCode, @RequestParam(value="type") String type) {
        if (currentMissionId == -1L || currentMissionId == 0L) {
            return true;
        }
        UserMission prev = this.userMissionTService.getAdjacentMissionInfo(uid, currentMissionId, levelCode, StringUtils.isBlank((CharSequence)type) ? "up" : type);
        return Objects.isNull(prev) || "PASS".equalsIgnoreCase(prev.getStatus());
    }

    private UserMapListDto fillByMap(MapDto mapDto) {
        return UserMapListDto.builder().id(mapDto.getId()).mapName(mapDto.getMapName()).levelName(mapDto.getLevelName()).levelCode(mapDto.getLevelCode()).dynamicUrl(mapDto.getDynamicUrl()).missionNum(mapDto.getMissionNum()).mapIndex(mapDto.getLevelOrder()).icoUrl(mapDto.getIcoUrl()).status("LOCKED").processStatus("NOTSTARTED").isDoing(Boolean.FALSE).userMissionNum(Integer.valueOf(0)).mapCode(mapDto.getMapCode()).build();
    }

    private UserMapListDto fillByUserMap(MapDto userMap, java.util.Map<String, String> mapAndPassMissionNum, String userLevel) {
        UserMapListDto dto = UserMapListDto.builder().id(userMap.getId()).mapName(userMap.getMapName()).levelName(userMap.getLevelName()).levelCode(userMap.getLevelCode()).dynamicUrl(userMap.getDynamicUrl()).missionNum(userMap.getMissionNum()).mapIndex(userMap.getLevelOrder()).icoUrl(userMap.getIcoUrl()).status("UNLOCKED").processStatus(userMap.getStatus()).mapCode(userMap.getMapCode()).build();
        if (StringUtils.isBlank((CharSequence)userLevel) && this.missionNumOfFirstMap > 0 && !userMap.getMissionNum().equals(this.missionNumOfFirstMap) && userMap.getLevelCode() == LevelEnum.LV1.getCode() && userMap.getLevelOrder() == 1) {
            dto.setMissionNum(this.missionNumOfFirstMap);
        }
        dto.setUserMissionNum(Integer.valueOf(Objects.nonNull(mapAndPassMissionNum.get(userMap.getMapCode())) ? Integer.valueOf(mapAndPassMissionNum.get(userMap.getMapCode())) : 0));
        dto.setIsDoing(Boolean.valueOf("DOING".equalsIgnoreCase(userMap.getStatus())));
        return dto;
    }

    private List<UserMission> getUserMissionByMapCode(UserInfoDto userInfoDto, String mapCode) {
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(userInfoDto.getUid()).andMapCodeEqualTo(mapCode);
        example.setOrderByClause(" level_code,mission_index,mission_coords ");
        List userMissionList = this.userMissionMapper.selectByExample(example);
        userMissionList.forEach(userMission -> {
            try {
                this.mapAndMissionUtilService.needMissionResUpdate(userInfoDto.getUid(), userMission);
            }
            catch (Exception e) {
                log.error("check mission resource update error", (Throwable)e);
            }
        });
        if (StringUtils.isNotBlank((CharSequence)userInfoDto.getLevel()) || "Y".equalsIgnoreCase(userInfoDto.getIsVip())) {
            return userMissionList;
        }
        List userMissionCodes = this.mapAndMissionUtilService.getUserMissionCodes(userInfoDto.getUid(), null);
        Mission paramMission = new Mission();
        paramMission.setMapCode(mapCode);
        List missions = this.missionMapper.selectMissionList(paramMission);
        if (!CollectionUtils.isEmpty((Collection)missions)) {
            for (Mission mission : missions) {
                if (userMissionCodes.contains(mission.getMissionCode())) continue;
                userMissionList.add(MapUtils.missionToUserMission((Mission)mission, (String)userInfoDto.getUid(), null));
            }
        }
        return userMissionList;
    }

    private List<MapDto> getUserMap(String uid) {
        ArrayList<MapDto> result = new ArrayList<MapDto>();
        List userMapBos = this.userMapMapper.selectUserMaps(uid, null);
        if (userMapBos != null && userMapBos.size() > 0) {
            for (UserMapBo userMapBo : userMapBos) {
                MapDto tmp = new MapDto();
                BeanUtils.copyProperties((Object)userMapBo, (Object)tmp);
                result.add(tmp);
            }
        }
        return result;
    }

    private void addMapResSnap(UserInfoDto userInfoDto) {
        String uid = userInfoDto.getUid();
        String level = userInfoDto.getLevel();
        if (level == null || level.equals("")) {
            return;
        }
        String levelCode = this.userMapMapper.selectMaxLevelCode(uid);
        List userMapCodes = this.userMapMapper.selectUserMapCodes(uid);
        int levelx = Integer.parseInt(level);
        for (int levelCodex = Integer.parseInt(levelCode); levelCodex <= levelx; ++levelCodex) {
            this.snapUserMapAndMission(String.valueOf(levelCodex), uid, userMapCodes);
        }
    }

    private void snapUserMapAndMission(String levelCode, String uid, List<String> userMapCodes) {
        Map queryMap = new Map();
        queryMap.setLevelCode(String.valueOf(levelCode));
        queryMap.setStatus("SURE");
        List mapList = this.mapMapper.selectListByMap(queryMap);
        ArrayList<String> mapCodes = new ArrayList<String>();
        HashMap<String, String> mapCode2LeveCode = new HashMap<String, String>();
        for (Map map : mapList) {
            if (userMapCodes.contains(map.getMapCode())) continue;
            UserMap userMap = MapUtils.mapToUserMap((Map)map, (String)uid, (Boolean)false);
            this.userMapMapper.insertSelective(userMap);
            mapCodes.add(map.getMapCode());
            mapCode2LeveCode.put(map.getMapCode(), map.getLevelCode());
        }
        if (mapCodes.size() == 0) {
            return;
        }
        Set userMissionCodeSet = this.mapAndMissionUtilService.getUserMissionCodes(uid);
        List missions = this.missionMapper.selectMissionsByMapCodes(mapCodes);
        for (Mission mission : missions) {
            if (userMissionCodeSet.contains(mission.getMissionCode())) continue;
            String levelCodexx = (String)mapCode2LeveCode.get(mission.getMapCode());
            UserMission userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)levelCodexx);
            this.userMissionMapper.insertSelective(userMission);
        }
    }

    private List<MapDto> getMapGreaterThanLevlCode(String levelCode) {
        ArrayList<MapDto> result = new ArrayList<MapDto>();
        Map mapParam = new Map();
        mapParam.setStatus("SURE");
        List mapDtoList = this.mapMapper.selectMapList(mapParam);
        if (CollectionUtils.isEmpty((Collection)mapDtoList)) {
            return result;
        }
        mapDtoList.forEach(m -> {
            if (LevelEnum.LV1.getCode().equals(m.getLevelCode()) && 1 == m.getLevelOrder()) {
                this.missionNumOfFirstMap = m.getMissionNum();
            }
        });
        if (StringUtils.isBlank((CharSequence)levelCode)) {
            return mapDtoList;
        }
        return mapDtoList.stream().filter(m -> m.getLevelCode().compareTo(levelCode) > 0).collect(Collectors.toList());
    }

    private void fillByMissions(UserMissionListDto result, Map map, UserInfoDto userInfoDto) {
        result.setLevelPopupDto(this.levelTService.getLevelDtoByCode(map.getLevelCode()));
        MissionAndResource missionAndResource = this.mapTService.getMissionAndResource(map.getMapCode());
        java.util.Map statusTypeUrlMap = ModeTransformUtils.getUrlMap((List)missionAndResource.getPicGalleryList());
        java.util.Map missionGoodsStatusMap = ModeTransformUtils.getStringKStringVMap((List)this.missionTService.selectMissionGoods(missionAndResource.getMissionCodes()), (String)"itemCode", (String)"goodsState");
        ArrayList<UserMissionDto> userMissionDtoList = new ArrayList<UserMissionDto>();
        List wholeMissions = this.fillMissionForDynamic(missionAndResource.getMissionList());
        for (Mission m : wholeMissions) {
            UserMissionDto dto = UserMissionDto.builder().id(m.getId()).missionCode(m.getMissionCode()).missionName(m.getMissionName()).missionIndex(m.getMissionIndex()).missionType(m.getMissionType()).mapCode(m.getMapCode()).status("LOCKED").missionCoords(m.getMissionCoords()).build();
            dto.setIsDoing(Boolean.FALSE);
            if (missionGoodsStatusMap.containsKey(m.getMissionCode()) && GoodsStatusEnum.OVER_SALE.getCode().equals(missionGoodsStatusMap.get(m.getMissionCode()))) {
                dto.setStatus(DataEnum.PicGalleryStatusType.TYPE_SOLD_OUT.getType());
            }
            dto.setIoc((String)statusTypeUrlMap.get(this.fillK(dto.getMissionType(), dto.getStatus())));
            userMissionDtoList.add(dto);
        }
        result.setUserMissionDtoList(userMissionDtoList);
        result.setDynamicDtoList(this.fillD(missionAndResource.getDynamicList()));
    }

    private void fillByUserMissions(UserMissionListDto result, UserMap userMap, UserInfoDto userInfoDto) {
        List userMissions = this.getUserMissionByMapCode(userInfoDto, userMap.getMapCode());
        Set userMissionsStatusList = userMissions.stream().map(BaseMission::getStatus).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty((Collection)userMissions) || !userMissionsStatusList.contains("PASS")) {
            result.setLevelPopupDto(this.levelTService.getLevelDtoByCode(userMap.getLevelCode()));
        }
        MissionAndResource missionAndResource = this.mapTService.getMissionAndResource(userMap.getMapCode());
        java.util.Map statusTypeUrlMap = ModeTransformUtils.getUrlMap((List)missionAndResource.getPicGalleryList());
        java.util.Map missionGoodsStatusMap = ModeTransformUtils.getStringKStringVMap((List)this.missionTService.selectMissionGoods(userMissions.stream().map(BaseMission::getMissionCode).collect(Collectors.toList())), (String)"itemCode", (String)"goodsState");
        List wholeMissions = this.fillUserMissionForDynamic(userMissions);
        ArrayList<UserMissionDto> userMissionDtoList = new ArrayList<UserMissionDto>();
        for (UserMission u : wholeMissions) {
            String key;
            String isNew;
            boolean clickable;
            UserMissionDto dto = UserMissionDto.builder().id(u.getId()).missionCode(u.getMissionCode()).missionName(u.getMissionName()).missionIndex(u.getMissionIndex()).missionType(u.getMissionType()).mapCode(u.getMapCode()).missionCoords(u.getMissionCoords()).status(u.getStatus()).isDoing(Boolean.FALSE).build();
            if ("DOING".equals(u.getStatus())) {
                dto.setIsDoing(Boolean.TRUE);
                dto.setStatus("UNLOCKED");
            }
            if (missionGoodsStatusMap.containsKey(u.getMissionCode()) && GoodsStatusEnum.OVER_SALE.getCode().equals(missionGoodsStatusMap.get(u.getMissionCode()))) {
                dto.setStatus(DataEnum.PicGalleryStatusType.TYPE_SOLD_OUT.getType());
            }
            boolean bl = clickable = this.mapAndMissionUtilService.missionClickable(userInfoDto.getUid(), dto.getMissionCode(), dto.getStatus()) != false;
            if (clickable && !"DOING".equals(u.getStatus()) && !"PASS".equals(u.getStatus())) {
                dto.setStatus("UNLOCKED");
            }
            dto.setIoc((String)statusTypeUrlMap.get(this.fillK(dto.getMissionType(), clickable ? "UNLOCKED" : "LOCKED")));
            if (clickable) {
                dto.setStatus("UNLOCKED");
            }
            if ((isNew = this.redisCache.get(key = "SYS_RESOURCE_UPDATE:" + DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue() + ":" + userInfoDto.getUid() + ":" + dto.getMissionCode())) != null) {
                dto.setIsNew(Boolean.valueOf(true));
            }
            userMissionDtoList.add(dto);
        }
        result.setUserMissionDtoList(userMissionDtoList);
        result.setDynamicDtoList(this.fillD(missionAndResource.getDynamicList()));
    }

    public UserMission getBeforeMission(List<NextMissionInfoDto> missions, UserMission currentMission) {
        if (currentMission.getMissionType() == null || currentMission.getMissionType() == 0) {
            return null;
        }
        Long currentMissionId = currentMission.getId();
        int currentIndex = missions.stream().filter(m -> StringUtils.equalsIgnoreCase((CharSequence)m.getMissionId(), (CharSequence)currentMissionId.toString())).mapToInt(missions::indexOf).max().orElse(0);
        int beforeIndex = currentIndex - 1;
        if (beforeIndex < 0) {
            return null;
        }
        NextMissionInfoDto preMissionInfoDto = missions.get(beforeIndex);
        UserMission userMission = new UserMission();
        userMission.setStatus(preMissionInfoDto.getMissionStatus());
        return userMission;
    }

    private Boolean isDoing(UserMission userMission, UserMission prevUserMission, int index, String levelCode) {
        return "DOING".equals(userMission.getStatus());
    }

    private List<Mission> fillMissionForDynamic(List<Mission> missionList) {
        ArrayList<Mission> result = new ArrayList<Mission>();
        result.addAll(missionList);
        List missionCoords = missionList.stream().map(BaseMission::getMissionCoords).collect(Collectors.toList());
        String lastCoord = missionList.get(missionList.size() - 1).getMissionCoords().split(",")[0];
        MapUtils.coordCheckAndFill(missionCoords, (String)lastCoord, currentCoord -> {
            Mission emptyMission = new Mission();
            String tmp = currentCoord.split(",")[0];
            emptyMission.setMissionIndex(Integer.valueOf(Integer.valueOf(tmp) + 1));
            emptyMission.setMissionCoords(currentCoord);
            result.add(emptyMission);
        });
        result.sort((m1, m2) -> {
            if (m1.getMissionIndex().equals(m2.getMissionIndex())) {
                return m1.getMissionCoords().compareTo(m2.getMissionCoords());
            }
            return m1.getMissionIndex().compareTo(m2.getMissionIndex());
        });
        return result;
    }

    private List<UserMission> fillUserMissionForDynamic(List<UserMission> userMissions) {
        ArrayList<UserMission> result = new ArrayList<UserMission>();
        result.addAll(userMissions);
        List missionCoords = userMissions.stream().map(BaseMission::getMissionCoords).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userMissions)) {
            return result;
        }
        String lastCoord = userMissions.get(userMissions.size() - 1).getMissionCoords().split(",")[0];
        MapUtils.coordCheckAndFill(missionCoords, (String)lastCoord, currentCoord -> {
            UserMission emptyMission = new UserMission();
            String tmp1 = currentCoord.split(",")[0];
            emptyMission.setMissionIndex(Integer.valueOf(Integer.valueOf(tmp1) + 1));
            emptyMission.setMissionCoords(currentCoord);
            result.add(emptyMission);
        });
        this.sortUserMission(result);
        return result;
    }

    private void sortUserMission(List<UserMission> result) {
        result.sort((m1, m2) -> {
            if (m1.getMissionIndex().equals(m2.getMissionIndex())) {
                return m1.getMissionCoords().compareTo(m2.getMissionCoords());
            }
            return m1.getMissionIndex().compareTo(m2.getMissionIndex());
        });
    }

    private List<DynamicDto> fillD(List<Attach> dynamicList) {
        ArrayList<DynamicDto> result = new ArrayList<DynamicDto>();
        if (CollectionUtils.isEmpty(dynamicList)) {
            return result;
        }
        dynamicList.forEach(item -> {
            if (null != item.getFileOrder() && !item.getFileOrder().equals(0)) {
                result.add(new DynamicDto(item.getFileOrder(), item.getFilePath(), item.getId()));
            }
        });
        return result;
    }

    private String fillK(Integer missionType, String status) {
        if (null == missionType) {
            return "";
        }
        if (missionType > 0) {
            return missionType.toString() + DataEnum.PicGalleryStatusType.getTypeValueByType((String)status).toString();
        }
        return missionType.toString() + DataEnum.PicGalleryBookStatusType.getTypeValueByType((String)status).toString();
    }

    private void setUserInfo(UserMissionListDto result, UserInfoDto userInfoDto) {
        result.setStoneNum(Integer.valueOf(null == userInfoDto.getStoneNum() ? 0 : userInfoDto.getStoneNum()));
        result.setBalance(userInfoDto.getBalance());
        result.setNewMapUser(userInfoDto.getNewMapUser());
        result.setIsVisitor(userInfoDto.getIsVisitor());
        result.setIsVip(userInfoDto.getIsVip());
        result.setVipBegin(userInfoDto.getVipBegin());
        result.setVipEnd(userInfoDto.getVipEnd());
    }

    private void setCourseInfoOfMission(CourseMissionDto result, String uid) {
        UserCourseExample example = new UserCourseExample();
        UserCourseExample.Criteria criteria = example.createCriteria();
        criteria.andMissionCodeEqualTo(result.getMissionCode());
        result.setCourseTotalNum(Integer.valueOf(this.userCourseMapper.selectCountByExample(example)));
        criteria.andStatusEqualTo("PASS");
        result.setCoursePassNum(Integer.valueOf(this.userCourseMapper.selectCountByExample(example)));
    }
}

