/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.order.dto.goods.GoodsStatusEnum;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.Attach;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.MissionAndResource;
import com.ella.resource.domain.UserCourseExample;
import com.ella.resource.domain.UserCourseReportExample;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMapExample;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserMissionExample;
import com.ella.resource.dto.MapDto;
import com.ella.resource.dto.appdto.AfterLexilePassDto;
import com.ella.resource.dto.appdto.CourseMissionDto;
import com.ella.resource.dto.appdto.PicBookMissionDto;
import com.ella.resource.dto.appdto.UserMapListDto;
import com.ella.resource.dto.appdto.UserMissionDto;
import com.ella.resource.dto.appdto.UserMissionListDto;
import com.ella.resource.dto.missiondto.DynamicDto;
import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import com.ella.resource.dto.request.BaseRequest;
import com.ella.resource.dto.request.map.GetMapInfoRequest;
import com.ella.resource.dto.request.mission.GetMissionInfoRequest;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserCourseReportMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.LevelTService;
import com.ella.resource.service.transactional.MapAndMissionUtilService;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.service.transactional.MissionTService;
import com.ella.resource.service.transactional.RpcService;
import com.ella.resource.service.transactional.UserMissionTService;
import com.ella.resource.utils.MapUtils;
import com.ella.resource.utils.ModeTransformUtils;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.dto.UserInfoDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserMapAndMissionServiceImpl
implements UserMapAndMissionService {
    private static final Logger log = LogManager.getLogger(UserMapAndMissionServiceImpl.class);
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private UserMissionTService userMissionTService;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private MissionTService missionTService;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private MapTService mapTService;
    @Autowired
    private LevelTService levelTService;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private UserCourseReportMapper userCourseReportMapper;
    @Autowired
    private MapAndMissionUtilService mapAndMissionUtilService;

    public NextMissionInfoDto updateUserMapAfterTest(String levelCode, String uid, String mapCode, String missionCode) {
        if (levelCode == null || levelCode.equals("")) {
            Map nextMap = this.mapMapper.selectByMapCode(mapCode);
            log.info("updateUserMapAfterTest uid {} snap nextMap {}", (Object)uid, (Object)JSON.toJSONString((Object)nextMap));
            ArrayList<String> mapCodes = new ArrayList<String>();
            mapCodes.add(mapCode);
            List nextMissions = this.missionMapper.selectMissionsByMapCodes(mapCodes);
            log.info("updateUserMapAfterTest uid {} snap nextMission {}", (Object)uid, (Object)JSON.toJSONString((Object)nextMissions));
            UserMapExample userMapExample = new UserMapExample();
            userMapExample.createCriteria().andUidEqualTo(uid).andMapCodeEqualTo(mapCode);
            List userMaps = this.userMapMapper.selectByExample(userMapExample);
            if (userMaps == null || userMaps.size() == 0) {
                UserMap userMap = MapUtils.mapToUserMap((Map)nextMap, (String)uid, (Boolean)true);
                this.userMapMapper.insertSelective(userMap);
            }
            List userMissionCodes = this.mapAndMissionUtilService.getUserMissionCodes(uid, mapCode);
            nextMissions.stream().forEach(nextMission -> {
                if (!userMissionCodes.contains(nextMission.getMissionCode())) {
                    UserMission userMission = MapUtils.missionToUserMission((Mission)nextMission, (String)uid, (String)nextMap.getLevelCode());
                    this.userMissionMapper.insertSelective(userMission);
                }
            });
        } else {
            this.mapAndMissionUtilService.snapUserLevelResource(uid, Integer.valueOf(levelCode));
        }
        NextMissionInfoDto nextMissionInfoDto = this.missionMapper.selectNextMissionInfoDto(uid, missionCode);
        return nextMissionInfoDto;
    }

    public void updateUserMapAfterLexileTest(@RequestBody AfterLexilePassDto afterLexilePassDto) {
        log.info("method MapServiceImpl.updateUserMapAfterLexileTest param is {}", (Object)afterLexilePassDto);
        if (StringUtils.isBlank((CharSequence)afterLexilePassDto.getUid()) || StringUtils.isBlank((CharSequence)afterLexilePassDto.getLevelCode())) {
            return;
        }
        String uid = afterLexilePassDto.getUid();
        String levelCode = afterLexilePassDto.getLevelCode();
        String originalLevelCode = afterLexilePassDto.getOriginalLevelCode();
        this.redisCache.setIfAbsent("PIC_BOOK_POPUP:" + uid, (Object)uid);
        ArrayList<UserMap> userMaps = new ArrayList<UserMap>();
        ArrayList<UserMission> userMissions = new ArrayList<UserMission>();
        ArrayList<String> mapCodes = new ArrayList<String>();
        List maps = this.mapMapper.selectMapsByLevelCodes(this.getEffectiveLevelCodes(originalLevelCode, levelCode));
        boolean isPassOfFirstMap = this.checkFirstMap(originalLevelCode, uid);
        java.util.Map userMapStatus = this.mapAndMissionUtilService.getUserMapStatus(uid);
        java.util.Map userMissionStatus = this.mapAndMissionUtilService.getUserMissionStatus(uid);
        List userMapCodes = this.mapAndMissionUtilService.getUserMapCodes(uid);
        List userMissionCodes = this.mapAndMissionUtilService.getUserMissionCodes(uid, null);
        log.info("checkFirstMap result is {}", (Object)isPassOfFirstMap);
        String firstMapCode = null;
        if (!CollectionUtils.isEmpty((Collection)maps)) {
            for (Map m : maps) {
                mapCodes.add(m.getMapCode());
                if (LevelEnum.LV1.getCode().equalsIgnoreCase(m.getLevelCode()) && 1 == m.getLevelOrder()) {
                    firstMapCode = m.getMapCode();
                    continue;
                }
                if (userMapCodes.contains(m.getMapCode())) continue;
                userMaps.add(MapUtils.mapToUserMap((Map)m, (String)uid, (Boolean)this.isMapDoing(m, levelCode, Boolean.valueOf(isPassOfFirstMap))));
            }
        }
        List missions = this.missionMapper.selectMissionsByMapCodes(mapCodes);
        Mission firstMission = null;
        if (StringUtils.isNotBlank((CharSequence)originalLevelCode)) {
            if (!CollectionUtils.isEmpty((Collection)missions)) {
                for (Mission m : missions) {
                    if (userMissionCodes.contains(m.getMissionCode())) continue;
                    if (firstMission == null && m.getMissionType() != null && !m.getMissionType().equals(0) && levelCode.equals(m.getLevelCode())) {
                        firstMission = m;
                    }
                    UserMission userMission = MapUtils.missionToUserMission((Mission)m, (String)uid, (String)m.getLevelCode());
                    if (firstMission != null && userMission.getMissionCode().equals(firstMission.getMissionCode())) {
                        userMission.setUnlockTime(new Date());
                        userMission.setStatus("DOING");
                        this.mapAndMissionUtilService.setUserMissionNotStart(uid);
                        this.mapAndMissionUtilService.setUserMapNotStart(uid);
                    }
                    userMissions.add(userMission);
                }
            }
            this.updateUserMissionAndMap(uid, afterLexilePassDto.getMissionId());
        } else {
            for (int i = 0; i < missions.size(); ++i) {
                Mission mission = (Mission)missions.get(i);
                if (userMissionCodes.contains(mission.getMissionCode())) continue;
                if (firstMission == null && mission.getMissionType() != null && !mission.getMissionType().equals(0) && levelCode.equals(mission.getLevelCode())) {
                    firstMission = mission;
                }
                UserMission userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)mission.getLevelCode());
                if (firstMission != null && userMission.getMissionCode().equals(firstMission.getMissionCode()) && levelCode.compareTo(LevelEnum.LV1.getCode()) > 0) {
                    userMission.setUnlockTime(new Date());
                    userMission.setStatus("DOING");
                }
                userMissions.add(userMission);
            }
            if (levelCode.compareTo(LevelEnum.LV1.getCode()) > 0) {
                UserMapExample example = new UserMapExample();
                UserMap item = new UserMap();
                UserMissionExample examplex = new UserMissionExample();
                UserMission itemx = new UserMission();
                String firstMapCodex = firstMapCode;
                userMapStatus.keySet().forEach(mapCode -> {
                    String status = (String)userMapStatus.get(mapCode);
                    if ("DOING".equals(status)) {
                        if (levelCode.equals(LevelEnum.LV1.getCode()) && mapCode.equals(firstMapCodex)) {
                            return;
                        }
                        example.createCriteria().andUidEqualTo(uid).andMapCodeEqualTo(mapCode);
                        item.setStatus("NOTSTARTED");
                        this.userMapMapper.updateByExampleSelective(item, example);
                    }
                });
                userMissionStatus.keySet().forEach(missionCode -> {
                    String status = (String)userMissionStatus.get(missionCode);
                    if ("DOING".equals(status)) {
                        Mission mission = this.missionMapper.selectByMissionCode(missionCode);
                        if (levelCode.equals(LevelEnum.LV1.getCode()) && mission.getMapCode().equalsIgnoreCase(firstMapCodex) && 1 == mission.getMissionIndex()) {
                            return;
                        }
                        examplex.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(missionCode);
                        itemx.setStatus("NOTSTARTED");
                        this.userMissionMapper.updateByExampleSelective(itemx, examplex);
                    }
                });
            }
            if (afterLexilePassDto.isPromotion()) {
                this.updateUserMissionAndMap(uid, afterLexilePassDto.getMissionId());
            }
        }
        if (!CollectionUtils.isEmpty(userMaps)) {
            this.userMapMapper.insertBatch(userMaps);
        }
        if (!CollectionUtils.isEmpty(userMissions)) {
            this.userMissionMapper.batchInsert(userMissions);
        }
    }

    private boolean checkFirstMap(String originalLevelCode, String uid) {
        if (StringUtils.isNotBlank((CharSequence)originalLevelCode)) {
            return true;
        }
        UserMapExample example = new UserMapExample();
        example.createCriteria().andUidEqualTo(uid).andLevelCodeEqualTo(LevelEnum.LV1.getCode()).andLevelOrderEqualTo(Integer.valueOf(1));
        List userMaps = this.userMapMapper.selectByExample(example);
        return "PASS".equalsIgnoreCase(((UserMap)userMaps.get(0)).getStatus());
    }

    private Boolean isMapDoing(Map m, String levelCode, Boolean isPassOfFirstMap) {
        log.info("isMapDoing m.getLevelCode():{},user levelCode:{},m.getLevelOrder:{}", (Object)m.getLevelCode(), (Object)levelCode, (Object)m.getLevelOrder());
        if (!levelCode.equalsIgnoreCase(m.getLevelCode())) {
            return false;
        }
        if (LevelEnum.LV1.getCode().equalsIgnoreCase(levelCode)) {
            return isPassOfFirstMap != false && 2 == m.getLevelOrder();
        }
        return 1 == m.getLevelOrder();
    }

    private Set<String> getEffectiveLevelCodes(String originalLevelCode, String levelCode) {
        String maxLevelCode = this.mapMapper.selectMaxLevelCode();
        if (levelCode.compareTo(maxLevelCode) > 0) {
            levelCode = maxLevelCode;
        }
        HashSet<String> result = new HashSet<String>();
        try {
            int minCode = StringUtils.isNotBlank((CharSequence)originalLevelCode) ? Integer.valueOf(originalLevelCode) : 0;
            int maxCode = Integer.valueOf(levelCode);
            for (int i = minCode + 1; i <= maxCode; ++i) {
                result.add(String.valueOf(i));
            }
        }
        catch (NumberFormatException e) {
            log.info("updateUserMapAfterLexileTest getEffectiveLevelCodes error:{}", (Throwable)e);
        }
        log.info("updateUserMapAfterLexileTest getEffectiveLevelCodes result:{}", result.toArray());
        return result;
    }

    public void updateUserMapForFree(@RequestParam(value="uid") String uid, @RequestParam(value="vipFlag") String vipFlag) {
        log.info("updateUserMapForFree param uid:{},vipFlag:{}", (Object)uid, (Object)vipFlag);
        if (StringUtils.isBlank((CharSequence)uid)) {
            return;
        }
        Map paramMap = new Map();
        paramMap.setStatus("SURE");
        paramMap.setLevelCode(LevelEnum.LV1.getCode());
        List mapList = this.mapMapper.selectListByMap(paramMap);
        if (CollectionUtils.isEmpty((Collection)mapList)) {
            return;
        }
        String mapCode = ((Map)mapList.get(0)).getMapCode();
        log.info("updateUserMapForFree insert into usermap {},mapCode:{}", (Object)uid, (Object)mapCode);
        List userMapCodes = this.mapAndMissionUtilService.getUserMapCodes(uid);
        if (userMapCodes == null || !userMapCodes.contains(((Map)mapList.get(0)).getMapCode())) {
            this.userMapMapper.insertSelective(MapUtils.mapToUserMap((Map)((Map)mapList.get(0)), (String)uid, (Boolean)Boolean.TRUE));
        }
        Mission paramMission = new Mission();
        paramMission.setMapCode(mapCode);
        List missions = this.missionMapper.selectMissionList(paramMission);
        if (CollectionUtils.isEmpty((Collection)missions)) {
            return;
        }
        List userMissionCodes = this.mapAndMissionUtilService.getUserMissionCodes(uid, mapCode);
        ArrayList<UserMission> userMissionList = new ArrayList<UserMission>();
        int i = 1;
        for (Mission mission : missions) {
            if (userMissionCodes.contains(mission.getMissionCode())) continue;
            if (i < 4 || "Y".equalsIgnoreCase(vipFlag)) {
                UserMission userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)LevelEnum.LV1.getCode());
                if (LevelEnum.LV1.getCode().equalsIgnoreCase(userMission.getLevelCode()) && mission.getMissionIndex() == 1) {
                    userMission.setUnlockTime(new Date());
                    userMission.setStatus("DOING");
                }
                userMissionList.add(userMission);
            }
            if (!Objects.nonNull(mission.getMissionType()) || mission.getMissionType() <= 0) continue;
            ++i;
        }
        if (!CollectionUtils.isEmpty(userMissionList)) {
            log.info("updateUserMapForFree insert into user mission {},mapCode:{},size;{}", (Object)uid, (Object)mapCode, (Object)userMissionList.size());
            this.userMissionMapper.batchInsert(userMissionList);
        }
    }

    public ResponseParams<Boolean> snapAll(String uid, String levelCode) {
        Map paramMap = new Map();
        paramMap.setStatus("SURE");
        paramMap.setLevelCode(levelCode);
        List mapList = this.mapMapper.selectListByMap(paramMap);
        if (CollectionUtils.isEmpty((Collection)mapList)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        List userMapCodes = this.mapAndMissionUtilService.getUserMapCodes(uid);
        ArrayList userMapCodesInserted = new ArrayList();
        ArrayList userMapCodesUpdated = new ArrayList();
        ArrayList userMissionCodesUpdated = new ArrayList();
        UserMap updateMapItem = new UserMap();
        UserMission updateMissionItem = new UserMission();
        mapList.stream().forEach(map -> {
            String mapCode = map.getMapCode();
            if (userMapCodes.contains(mapCode)) {
                map.setStatus("PASS");
                UserMapExample userMapExample = new UserMapExample();
                userMapExample.createCriteria().andMapCodeEqualTo(mapCode).andUidEqualTo(uid);
                updateMapItem.setStatus("PASS");
                this.userMapMapper.updateByExampleSelective(updateMapItem, userMapExample);
                userMapCodesUpdated.add(mapCode);
                HashSet<String> existUserMissionCodeSet = new HashSet<String>();
                UserMissionExample userMissionExample = new UserMissionExample();
                userMissionExample.createCriteria().andMapCodeEqualTo(mapCode).andUidEqualTo(uid);
                List userMissions = this.userMissionMapper.selectByExample(userMissionExample);
                for (UserMission record : userMissions) {
                    existUserMissionCodeSet.add(record.getMissionCode());
                    if (record.getStatus().equals("PASS")) continue;
                    record.setStatus("PASS");
                    this.userMissionMapper.updateByPrimaryKey(record);
                    userMissionCodesUpdated.add(record.getMissionCode());
                }
                Mission paramMission = new Mission();
                paramMission.setMapCode(mapCode);
                List missions = this.missionMapper.selectMissionList(paramMission);
                for (Mission mission : missions) {
                    if (existUserMissionCodeSet.contains(mission.getMissionCode())) continue;
                    UserMission userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)map.getLevelCode());
                    userMission.setStatus("PASS");
                    this.userMissionMapper.insertSelective(userMission);
                }
                return;
            }
            UserMap userMap = MapUtils.mapToUserMap((Map)map, (String)uid, (Boolean)Boolean.TRUE);
            userMap.setStatus("PASS");
            this.userMapMapper.insertSelective(userMap);
            userMapCodes.add(mapCode);
            userMapCodesInserted.add(mapCode);
            Mission paramMission = new Mission();
            paramMission.setMapCode(mapCode);
            List missions = this.missionMapper.selectMissionList(paramMission);
            if (CollectionUtils.isEmpty((Collection)missions)) {
                return;
            }
            List userMissionCodes = this.mapAndMissionUtilService.getUserMissionCodes(uid, mapCode);
            ArrayList<UserMission> userMissionList = new ArrayList<UserMission>();
            for (Mission mission : missions) {
                if (userMissionCodes.contains(mission.getMissionCode())) {
                    mission.setStatus("PASS");
                    UserMissionExample userMissionExample = new UserMissionExample();
                    userMissionExample.createCriteria().andMissionCodeEqualTo(mission.getMissionCode()).andUidEqualTo(uid);
                    updateMissionItem.setStatus("PASS");
                    this.userMissionMapper.updateByExampleSelective(updateMissionItem, userMissionExample);
                    userMissionCodesUpdated.add(mission.getMissionCode());
                    continue;
                }
                UserMission userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)map.getLevelCode());
                userMission.setStatus("PASS");
                userMissionList.add(userMission);
                userMissionCodes.add(userMission.getMissionCode());
            }
            if (!CollectionUtils.isEmpty(userMissionList)) {
                log.info("snapAll insert into user mission {},mapCode:{},size:{},missionCodes contains:{}", (Object)uid, (Object)mapCode, (Object)userMissionList.size(), (Object)userMissionCodes);
                this.userMissionMapper.batchInsert(userMissionList);
            }
        });
        log.info("snapAll insert into user map {},mapCodes contains:{}", (Object)uid, userMapCodesInserted);
        log.info("snapAll update status user map {},mapCodes contains:{}", (Object)uid, userMapCodesUpdated);
        log.info("snapAll update status user mission {},missionCodes contains:{}", (Object)uid, userMissionCodesUpdated);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private UserMap buildUserMap(String uid, Map m, String levelCode) {
        UserMap map = new UserMap();
        map.setId(Long.valueOf(IdWrokerUtils.nextId()));
        map.setUid(uid);
        map.setMapCode(m.getMapCode());
        map.setStatus("NOTSTARTED");
        if (levelCode.equalsIgnoreCase(m.getLevelCode()) && m.getLevelOrder() == 1) {
            map.setStatus("DOING");
        }
        map.setCreateTime(new Date());
        map.setMissionNum(m.getMissionNum());
        map.setStoneNum(Integer.valueOf(0));
        map.setMapIndex(m.getLevelOrder());
        map.setLevelCode(m.getLevelCode());
        return map;
    }

    private void doUpdateMap(String uid, String mapCode) {
        UserMapExample example = new UserMapExample();
        UserMapExample.Criteria criteria = example.createCriteria();
        criteria.andUidEqualTo(uid).andStatusNotEqualTo("PASS");
        if (StringUtils.isNotBlank((CharSequence)mapCode)) {
            criteria.andMapCodeEqualTo(mapCode);
        }
        example.setOrderByClause(" level_code desc,map_index desc");
        List userMapList = this.userMapMapper.selectByExample(example);
        if (!CollectionUtils.isEmpty((Collection)userMapList)) {
            UserMap currentUserMap = (UserMap)userMapList.get(0);
            currentUserMap.setStatus("PASS");
            log.info("method MapServiceImpl.updateUserMapAfterLexileTest update user map: {}", (Object)((UserMap)userMapList.get(0)).getId());
            this.userMapMapper.updateByPrimaryKeySelective(currentUserMap);
        }
    }

    private void updateUserMissionAndMap(String uid, Long missionId) {
        if (missionId == null) {
            return;
        }
        UserMissionExample example1 = new UserMissionExample();
        example1.createCriteria().andUidEqualTo(uid).andIdEqualTo(missionId);
        List userMissionList = this.userMissionMapper.selectByExample(example1);
        if (!CollectionUtils.isEmpty((Collection)userMissionList)) {
            UserMission currentUserMission = (UserMission)userMissionList.get(0);
            log.info("method MapServiceImpl.updateUserMapAfterLexileTest currentUserMission:{}", (Object)JSONObject.toJSONString((Object)currentUserMission));
            if (!"PASS".equalsIgnoreCase(currentUserMission.getStatus())) {
                currentUserMission.setStatus("PASS");
                log.info("method MapServiceImpl.updateUserMapAfterLexileTest update user mission: {}", (Object)((UserMission)userMissionList.get(0)).getId());
                this.userMissionMapper.updateByPrimaryKeySelective(currentUserMission);
                this.doUpdateMap(uid, currentUserMission.getMapCode());
            }
        }
    }

    @Deprecated
    public ResponseParams<List<UserMapListDto>> selectUserMap(@RequestBody BaseRequest request) {
        UserInfoDto userInfoDto = this.rpcService.selectUserByUid(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        ArrayList result = new ArrayList();
        this.jointResult(result, userInfoDto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    @Deprecated
    @EnableValidate
    public ResponseParams<UserMissionListDto> selectUserMission(@RequestBody GetMapInfoRequest request) {
        Map map = this.mapMapper.selectByPrimaryKey(request.getId());
        if (null == map) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_NOT_EXISTS);
        }
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        UserMissionListDto result = new UserMissionListDto();
        MissionAndResource missionAndResource = this.mapTService.getMissionAndResource(map.getMapCode());
        if (null == missionAndResource || CollectionUtils.isEmpty((Collection)missionAndResource.getMissionList())) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        this.setUserInfo(result, userInfoDto);
        result.setBackgroundUrl(map.getBackgroundUrl());
        result.setBottomUrl(map.getBottomUrl());
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(userInfoDto.getUid()).andMapCodeEqualTo(map.getMapCode());
        example.setOrderByClause(" mission_index ");
        List userMissionList = this.userMissionMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)userMissionList) || !"PASS".equals(((UserMission)userMissionList.get(0)).getStatus())) {
            result.setLevelPopupDto(this.levelTService.getLevelDtoByCode(map.getLevelCode()));
        }
        java.util.Map userMissions = ModeTransformUtils.getCodeAndTMap((List)userMissionList, (String)"missionCode");
        this.jointUserMissionResult(result, missionAndResource, userMissions, map, userInfoDto.getLevel());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<CourseMissionDto> userMissionInfo(@RequestBody GetMissionInfoRequest request) {
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        CourseMissionDto result = this.userMissionTService.getCourseMission(request.getId());
        if (null == result) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        result.setVideoPerviewPicUrl("");
        result.setBalance(userInfoDto.getBalance());
        result.setStoneNum(Integer.valueOf(null == userInfoDto.getAccountDto() ? 0 : userInfoDto.getAccountDto().getStoneNum()));
        this.setCourseInfoOfMission(result, request.getUid());
        UserCourseReportExample urExample = new UserCourseReportExample();
        urExample.setOrderByClause(" version desc");
        urExample.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(result.getMissionCode());
        List userCourseReports = this.userCourseReportMapper.selectByExample(urExample);
        result.setIsFinished(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)userCourseReports)));
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(result.getMissionCode());
        List userMissions = this.userMissionMapper.selectByExample(example);
        result.setStatus("LOCKED");
        if (!CollectionUtils.isEmpty((Collection)userMissions)) {
            result.setStatus("UNLOCKED");
        }
        result.setIsClickable(this.missionTService.isMissionClickable(userInfoDto, result.getMissionCode(), result.getMapCode(), result.getMissionIndex(), result.getMissionType()));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<PicBookMissionDto> userPicMissionInfo(@RequestBody GetMissionInfoRequest request) {
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        PicBookMissionDto result = this.missionMapper.selectPicBookMissionInfo(request.getId());
        if (null == result) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        result.setBalance(userInfoDto.getBalance());
        result.setStoneNum(Integer.valueOf(null == userInfoDto.getAccountDto() ? 0 : userInfoDto.getAccountDto().getStoneNum()));
        result.setLockedNum(Integer.valueOf(this.userMissionMapper.countByMission(result.getMissionCode())));
        if (LevelEnum.LV0.getCode().equalsIgnoreCase(result.getLevelCode())) {
            result.setStatus("UNLOCKED");
            result.setIsClickable(Boolean.valueOf(true));
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
        }
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(result.getMissionCode());
        List userMissions = this.userMissionMapper.selectByExample(example);
        result.setStatus(CollectionUtils.isEmpty((Collection)userMissions) ? "LOCKED" : "UNLOCKED");
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    private void jointUserMissionResult(UserMissionListDto result, MissionAndResource missionAndResource, java.util.Map<String, Object> userMissions, Map map, String userLevelCode) {
        java.util.Map statusTypeUrlMap = ModeTransformUtils.getUrlMap((List)missionAndResource.getPicGalleryList());
        java.util.Map missionGoodsStatusMap = ModeTransformUtils.getStringKStringVMap((List)this.missionTService.selectMissionGoods(missionAndResource.getMissionCodes()), (String)"itemCode", (String)"goodsState");
        ArrayList<UserMissionDto> userMissionDtoList = new ArrayList<UserMissionDto>();
        List wholeMissions = this.fillMissionForDynamic(missionAndResource.getMissionList());
        UserMission prevUserMission = null;
        for (Mission v : wholeMissions) {
            UserMissionDto dto = new UserMissionDto(Integer.valueOf(v.getId().intValue()), v.getMissionCode(), v.getMissionName(), v.getMissionIndex(), v.getMissionCoords(), v.getMissionType());
            dto.setMapCode(v.getMapCode());
            UserMission userMission = (UserMission)userMissions.get(v.getMissionCode());
            dto.setStatus(null == userMission ? "LOCKED" : userMission.getStatus());
            dto.setIsDoing(this.isDoing(userMission, prevUserMission, wholeMissions.indexOf(v), v.getMissionType(), map, userLevelCode));
            if (dto.getIsDoing().booleanValue()) {
                dto.setStatus("UNLOCKED");
            }
            if (v.getMissionType() > 0) {
                prevUserMission = userMission;
            }
            if (LevelEnum.LV1.getCode().equalsIgnoreCase(map.getLevelCode()) && map.getLevelOrder() == 1 && ("N".equals(result.getIsVip()) || Objects.equals("Y", result.getIsVisitor())) && wholeMissions.indexOf(v) > 3) {
                dto.setStatus("LOCKED");
            }
            if (missionGoodsStatusMap.containsKey(v.getMissionCode()) && GoodsStatusEnum.OVER_SALE.getCode().equals(missionGoodsStatusMap.get(v.getMissionCode()))) {
                dto.setStatus(DataEnum.PicGalleryStatusType.TYPE_SOLD_OUT.getType());
            }
            dto.setIoc((String)statusTypeUrlMap.get(this.fillK(v.getMissionType(), dto.getStatus())));
            userMissionDtoList.add(dto);
        }
        result.setUserMissionDtoList(userMissionDtoList);
        result.setDynamicDtoList(this.fillD(missionAndResource.getDynamicList()));
    }

    private Boolean isDoing(UserMission userMission, UserMission prevUserMission, int index, Integer missionType, Map map, String userLevelCode) {
        boolean firstFreeMapOrUserLevelMap;
        if (missionType == 0) {
            return Boolean.FALSE;
        }
        boolean bl = firstFreeMapOrUserLevelMap = 1 == map.getLevelOrder() && (LevelEnum.LV1.getCode().equalsIgnoreCase(map.getLevelCode()) || userLevelCode.equalsIgnoreCase(map.getLevelCode()));
        if (null == userMission) {
            if (null == prevUserMission && index == 0 && firstFreeMapOrUserLevelMap) {
                return Boolean.TRUE;
            }
            if (null != prevUserMission && StringUtils.equalsIgnoreCase((CharSequence)prevUserMission.getStatus(), (CharSequence)"PASS")) {
                return Boolean.TRUE;
            }
        } else {
            if (index == 0 && !StringUtils.equalsIgnoreCase((CharSequence)userMission.getStatus(), (CharSequence)"PASS")) {
                return Boolean.TRUE;
            }
            if (null != prevUserMission && StringUtils.equalsIgnoreCase((CharSequence)prevUserMission.getStatus(), (CharSequence)"PASS") && !StringUtils.equalsIgnoreCase((CharSequence)userMission.getStatus(), (CharSequence)"PASS")) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private List<Mission> fillMissionForDynamic(List<Mission> missionList) {
        ArrayList<Mission> result = new ArrayList<Mission>();
        result.addAll(missionList);
        List missionCoords = missionList.stream().map(BaseMission::getMissionCoords).collect(Collectors.toList());
        String lastCoord = missionList.get(missionList.size() - 1).getMissionCoords().split(",")[0];
        MapUtils.coordCheckAndFill(missionCoords, (String)lastCoord, currentCoord -> {
            Mission emptyMission = new Mission();
            String index = currentCoord.split(",")[0];
            emptyMission.setMissionIndex(Integer.valueOf(Integer.valueOf(index) + 1));
            emptyMission.setMissionCoords(currentCoord);
            result.add(emptyMission);
        });
        return result.stream().sorted(Comparator.comparing(BaseMission::getMissionCoords)).collect(Collectors.toList());
    }

    private static int getCoordNum(int firstNumOfCurrentCoord) {
        int result = 0;
        for (int i = 0; i <= firstNumOfCurrentCoord; ++i) {
            result += i % 2 == 0 ? 1 : 2;
        }
        return result;
    }

    private List<DynamicDto> fillD(List<Attach> dynamicList) {
        ArrayList<DynamicDto> result = new ArrayList<DynamicDto>();
        if (CollectionUtils.isEmpty(dynamicList)) {
            return result;
        }
        dynamicList.forEach(item -> {
            if (null != item.getFileOrder() && !item.getFileOrder().equals(0)) {
                result.add(new DynamicDto(item.getFileOrder(), item.getFilePath(), item.getId()));
            }
        });
        return result;
    }

    private String fillK(Integer missionType, String status) {
        if (null == missionType) {
            return "";
        }
        if (missionType > 0) {
            return missionType.toString() + DataEnum.PicGalleryStatusType.getTypeValueByType((String)status).toString();
        }
        return missionType.toString() + DataEnum.PicGalleryBookStatusType.getTypeValueByType((String)status).toString();
    }

    private void jointResult(List<UserMapListDto> result, UserInfoDto userInfoDto) {
        Map mapParam = new Map();
        mapParam.setStatus("SURE");
        List mapDtoList = this.mapMapper.selectMapList(mapParam);
        UserMapExample example = new UserMapExample();
        example.createCriteria().andUidEqualTo(userInfoDto.getUid());
        java.util.Map userMaps = ModeTransformUtils.getCodeAndTMap((List)this.userMapMapper.selectByExample(example), (String)"mapCode");
        UserMap prevUserMap = null;
        for (MapDto v : mapDtoList) {
            UserMapListDto dto = new UserMapListDto(v.getId(), v.getMapName(), v.getLevelName(), v.getLevelCode(), v.getDynamicUrl(), v.getMissionNum());
            UserMap userMap = null == userMaps ? null : (UserMap)userMaps.get(v.getMapCode());
            dto.setMapIndex(v.getLevelOrder());
            dto.setIcoUrl(v.getIcoUrl());
            if (v.getLevelOrder() == 1 && LevelEnum.LV1.getCode().equals(v.getLevelCode())) {
                dto.setStatus("UNLOCKED");
            } else {
                dto.setStatus("LOCKED");
            }
            dto.setProcessStatus("NOTSTARTED");
            if (null != userMap) {
                dto.setUserMissionNum(Integer.valueOf(null == userMap.getMissionNum() ? 0 : userMap.getMissionNum()));
                dto.setStatus("UNLOCKED");
                dto.setProcessStatus(userMap.getStatus());
                dto.setIsDoing(MapUtils.isDoingMap((UserMap)userMap, prevUserMap, (String)userInfoDto.getLevel()));
                prevUserMap = userMap;
            }
            result.add(dto);
        }
    }

    private void setCourseInfoOfMission(CourseMissionDto result, String uid) {
        UserCourseExample example = new UserCourseExample();
        UserCourseExample.Criteria criteria = example.createCriteria();
        criteria.andMissionCodeEqualTo(result.getMissionCode());
        result.setCourseTotalNum(Integer.valueOf(this.userCourseMapper.selectCountByExample(example)));
        criteria.andStatusEqualTo("PASS");
        result.setCoursePassNum(Integer.valueOf(this.userCourseMapper.selectCountByExample(example)));
    }

    private void setUserInfo(UserMissionListDto result, UserInfoDto userInfoDto) {
        result.setStoneNum(Integer.valueOf(null == userInfoDto.getAccountDto() ? 0 : userInfoDto.getAccountDto().getStoneNum()));
        result.setBalance(userInfoDto.getBalance());
        result.setIsVip(userInfoDto.getIsVip());
        result.setNewMapUser(userInfoDto.getNewMapUser());
        result.setVipBegin(userInfoDto.getVipBegin());
        result.setVipEnd(userInfoDto.getVipEnd());
        result.setIsVisitor(userInfoDto.getIsVisitor());
    }
}

