/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.ResQuestionService;
import com.ella.resource.dto.ResQuestionDto;
import com.ella.resource.dto.request.question.DeleteResQuestionRequest;
import com.ella.resource.dto.request.question.EditResQuestionRequest;
import com.ella.resource.dto.request.question.QueryResQuestionRequest;
import com.ella.resource.dto.request.question.QuestionsByOccupantTypeReq;
import com.ella.resource.dto.request.question.SaveResQuestionRequest;
import com.ella.resource.service.transactional.ResQuestionTService;
import com.ella.resource.utils.ResponsePageResultUtils;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.resource.utils.ValidationUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ResQuestionServiceImpl
implements ResQuestionService {
    private static final Logger log = LogManager.getLogger(ResQuestionServiceImpl.class);
    @Autowired
    ResQuestionTService resQuestionTService;

    public ResponseParams<Boolean> insertResQuestion(@RequestBody SaveResQuestionRequest resQuestion) {
        log.info("\u6dfb\u52a0\u9898\u76ee\uff1a{}", (Object)JSONObject.toJSONString((Object)resQuestion));
        String checkResult = ValidationUtils.validateEntity((Object)resQuestion, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("insertResQuestion param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int result = this.resQuestionTService.insertResQuestion(resQuestion);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<Boolean> updateResQuestion(@RequestBody EditResQuestionRequest request) {
        log.info("\u66f4\u65b0\u9898\u76ee\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("updateResQuestion param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)false);
        }
        int result = this.resQuestionTService.updateResQuestion(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<?> getAllResQuestionInfo(@RequestBody QueryResQuestionRequest request) {
        log.info("\u83b7\u53d6\u9898\u76ee\u5217\u8868,{}", (Object)JSONObject.toJSONString((Object)request));
        List resQuestion = this.resQuestionTService.getAllResQuestion(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((List)resQuestion));
    }

    public ResponseParams<Boolean> deleteResQuestion(@RequestBody DeleteResQuestionRequest request) {
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("deleteResQuestion param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int id = request.getId();
        log.info("\u5220\u9664\u6307\u5b9aid\u7684\u9898\u76ee:{}", (Object)id);
        try {
            this.resQuestionTService.deleteResQuestionByIds(id);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        catch (Exception e) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, (Object)false);
        }
    }

    public ResponseParams<ResQuestionDto> getQuestionById(@RequestBody DeleteResQuestionRequest request) {
        log.info("\u6839\u636eID\u67e5\u8be2\u9898\u76ee:{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getQuestionByQueryCondition param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        ResQuestionDto result = this.resQuestionTService.getQuestionById(Long.valueOf(request.getId().toString()));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<?> getResQuestionByOccupant(@RequestBody QuestionsByOccupantTypeReq request) {
        log.info("\u83b7\u53d6\u8fc7\u6ee4\u6389\u5360\u7528\u8005\u7684\u9898\u76ee\u5217\u8868,{}", (Object)JSONObject.toJSONString((Object)request));
        List allResQuestion = this.resQuestionTService.getAllResQuestion(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((List)allResQuestion));
    }
}

