/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.resource.api.ResOccupantService;
import com.ella.resource.domain.CoinConfig;
import com.ella.resource.domain.CoinConfigExample;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.PictureBook;
import com.ella.resource.domain.PictureBookExample;
import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.dto.SaveResOccupantRequest;
import com.ella.resource.dto.request.DeleteResOccupantRequest;
import com.ella.resource.dto.request.ModifyResOccupantRequest;
import com.ella.resource.dto.sendgoods.StatusEnum;
import com.ella.resource.mapper.CoinConfigMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.PictureBookMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.service.ResOccupantServiceImpl;
import com.ella.resource.utils.ResponseParamUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ResOccupantServiceImpl
implements ResOccupantService {
    private static final Logger log = LogManager.getLogger(ResOccupantServiceImpl.class);
    @Autowired
    private ResourceOccupantMapper occupantMapper;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private PictureBookMapper picBookMapper;
    @Autowired
    private CoinConfigMapper coinConfigMapper;

    @EnableValidate
    public ResponseParams<Boolean> saveResOccupant(@RequestBody SaveResOccupantRequest request) {
        log.info("saveResOccupant -- req :{}", (Object)request);
        List list = this.buildRec(request);
        if (list == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        this.occupantMapper.batchInsert(list);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private List<ResourceOccupant> buildRec(SaveResOccupantRequest req) {
        if (req.getResIds().isEmpty()) {
            return null;
        }
        ArrayList<ResourceOccupant> list = new ArrayList<ResourceOccupant>();
        Date now = Calendar.getInstance().getTime();
        java.util.Map map = new HashMap();
        switch (1.$SwitchMap$com$ella$resource$dto$sendgoods$ResTypeEnum[req.getResType().ordinal()]) {
            case 1: {
                map = this.getMapId(req.getResIds().keySet());
                break;
            }
            case 2: {
                map = this.getMissionId(req.getResIds().keySet());
                break;
            }
            case 3: {
                map = this.getBookId(req.getResIds().keySet());
                break;
            }
            case 4: {
                map = this.getCoinsId(req.getResIds().keySet());
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
        }
        for (String key : req.getResIds().keySet()) {
            ResourceOccupant occu = new ResourceOccupant();
            occu.setId(Long.valueOf(IdWrokerUtils.nextId()));
            occu.setCreateTime(now);
            occu.setUpdateTime(now);
            if (map != null) {
                occu.setResId((Long)map.get(key));
            }
            occu.setResCode(key);
            occu.setOccupantId((Long)req.getResIds().get(key));
            occu.setResType(req.getResType().getCode());
            occu.setOccupantType(req.getOccuType());
            occu.setStatus(StatusEnum.NORMAL.getCode());
            list.add(occu);
        }
        return list;
    }

    private java.util.Map<String, Long> getMapId(Set<String> keySet) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        List list = this.mapMapper.selectMapsByMapCodes(keySet);
        if (list == null) {
            return null;
        }
        for (Map mapDto : list) {
            map.put(mapDto.getMapCode(), (long)mapDto.getId());
        }
        return map;
    }

    private java.util.Map<String, Long> getMissionId(Set<String> keySet) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        List list = this.missionMapper.selectMissionIdsBycodes(keySet);
        if (list == null) {
            return null;
        }
        for (Mission mission : list) {
            map.put(mission.getMissionCode(), (long)mission.getId());
        }
        return map;
    }

    private java.util.Map<String, Long> getBookId(Set<String> keySet) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        PictureBookExample exam = new PictureBookExample();
        exam.createCriteria().andPicBookCodeIn(new ArrayList<String>(keySet));
        List list = this.picBookMapper.selectByExample(exam);
        if (list == null) {
            return null;
        }
        for (PictureBook book : list) {
            map.put(book.getPicBookCode(), book.getId().longValue());
        }
        return map;
    }

    private java.util.Map<String, Long> getCoinsId(Set<String> keySet) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        CoinConfigExample exam = new CoinConfigExample();
        exam.createCriteria().andCoinCodeIn(new ArrayList<String>(keySet));
        List list = this.coinConfigMapper.selectByExample(exam);
        if (list == null) {
            return null;
        }
        for (CoinConfig coin : list) {
            map.put(coin.getCoinCode(), (long)coin.getId());
        }
        return map;
    }

    @EnableValidate
    public ResponseParams<Boolean> deleteResOccupant(@RequestBody DeleteResOccupantRequest request) {
        log.info("deleteResOccupant -- req :{}", (Object)request);
        ResourceOccupantExample example = new ResourceOccupantExample();
        example.createCriteria().andOccupantIdEqualTo(request.getOccupantId()).andOccupantTypeEqualTo(request.getOccupantType());
        Date now = Calendar.getInstance().getTime();
        ResourceOccupant occu = new ResourceOccupant();
        occu.setUpdateTime(now);
        occu.setStatus(StatusEnum.DELETE.getCode());
        this.occupantMapper.updateByExample(occu, example);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    @EnableValidate
    public ResponseParams<Boolean> modifyResOccupant(@RequestBody ModifyResOccupantRequest request) {
        log.info("modifyResOccupant -- req :{}", (Object)request);
        ResourceOccupantExample example = new ResourceOccupantExample();
        example.createCriteria().andOccupantIdEqualTo(request.getOccupantId()).andOccupantTypeEqualTo(request.getOccupantType());
        Date now = Calendar.getInstance().getTime();
        ResourceOccupant occu = new ResourceOccupant();
        occu.setUpdateTime(now);
        occu.setResCode(request.getResCode());
        this.occupantMapper.updateByExampleSelective(occu, example);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    public static void main(String[] args) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("M002", 999999999L);
        map.put("M001", 999999999L);
        map.put("M001", 999999999L);
        System.out.println(JSONObject.toJSONString(map));
    }
}

