/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.LexileResTypeService;
import com.ella.resource.api.PictureBookLevelRelService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.OperateEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.PictureBook;
import com.ella.resource.domain.PictureBookExample;
import com.ella.resource.domain.PictureBookLevelRel;
import com.ella.resource.domain.PictureBookLevelRelExample;
import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.dto.PictureBookLevelRelDto;
import com.ella.resource.dto.PictureBookListDto;
import com.ella.resource.dto.request.picturebooklevel.AddPictureBookToLevelRequest;
import com.ella.resource.dto.request.picturebooklevel.SavePictureBookLevelRelRequest;
import com.ella.resource.dto.request.picturebooklevel.SortPictureBookRequest;
import com.ella.resource.mapper.PictureBookLevelRelMapper;
import com.ella.resource.mapper.PictureBookMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.service.PictureBookLevelRelServiceImpl;
import com.ella.resource.utils.ResponseParamUtils;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PictureBookLevelRelServiceImpl
implements PictureBookLevelRelService {
    private static final Logger log = LogManager.getLogger(PictureBookLevelRelServiceImpl.class);
    @Autowired
    private PictureBookLevelRelMapper pictureBookLevelRelMapper;
    @Autowired
    private ResourceOccupantMapper resourceOccupantMapper;
    @Autowired
    private PictureBookMapper pictureBookMapper;
    @Autowired
    private LexileResTypeService lexileResTypeService;
    @Autowired
    private DistributedCache redisCache;

    public ResponseParams<List<PictureBookLevelRelDto>> getPictureBookLevelRelList() {
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.pictureBookLevelRelMapper.selectLevelRelList());
    }

    @EnableValidate
    public ResponseParams<List<PictureBookListDto>> getPictureBookList(@RequestBody SavePictureBookLevelRelRequest request) {
        List list = this.pictureBookLevelRelMapper.selectPictureBookList(request.getLevelCode());
        list.forEach(item -> item.setLexileLevel(this.lexileResTypeService.getLexileLevelCode(item.getPicBookCode(), item.getLexileLevel())));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)list);
    }

    @EnableValidate
    public ResponseParams<Integer> savePictureBookLevelRel(@RequestBody SavePictureBookLevelRelRequest request) {
        List pictureBookLevelRelList = this.getListByLevelCode(request.getLevelCode());
        if (!CollectionUtils.isEmpty((Collection)pictureBookLevelRelList)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.BOOK_LEVEL_ALREADY_EXISTS);
        }
        PictureBookLevelRel pictureBookLevelRel = new PictureBookLevelRel();
        pictureBookLevelRel.setCreateTime(new Date());
        pictureBookLevelRel.setLevelCode(request.getLevelCode());
        pictureBookLevelRel.setStatus("NORMAL");
        int result = this.pictureBookLevelRelMapper.insertSelective(pictureBookLevelRel);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? pictureBookLevelRel.getId() : 0));
    }

    @EnableValidate
    public ResponseParams<Boolean> addPictureBookToLevel(@RequestBody AddPictureBookToLevelRequest request) {
        PictureBookLevelRel pictureBookLevelRel2;
        if (CollectionUtils.isEmpty((Collection)request.getPicBookCode())) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.INCOMPLETE_PARAMETERS_ERROR);
        }
        List pictureBookLevelRelList = this.getListByLevelCode(request.getLevelCode());
        if (CollectionUtils.isEmpty((Collection)pictureBookLevelRelList)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.LEVEL_NOT_EXISTS);
        }
        Set pictureBookCodes = pictureBookLevelRelList.stream().map(pictureBookLevelRel -> pictureBookLevelRel.getPicBookCode()).collect(Collectors.toSet());
        HashSet picBookCodesSet = new HashSet(request.getPicBookCode());
        Sets.SetView intersection = Sets.intersection(picBookCodesSet, pictureBookCodes);
        Sets.SetView difference = Sets.difference(picBookCodesSet, pictureBookCodes);
        int result = 0;
        for (String pic : intersection) {
            pictureBookLevelRel2 = (PictureBookLevelRel)pictureBookLevelRelList.stream().filter(p -> pic.equals(p.getPicBookCode())).collect(Collectors.toList()).get(0);
            pictureBookLevelRel2.setPicBookCode(pic);
            pictureBookLevelRel2.setIdx(Integer.valueOf(1));
            this.pictureBookLevelRelMapper.updateByPrimaryKeySelective(pictureBookLevelRel2);
            this.updateResourceOccupant(OperateEnum.INSERT, pic, pictureBookLevelRel2.getId());
            ++result;
        }
        for (String diff : difference) {
            pictureBookLevelRel2 = (PictureBookLevelRel)pictureBookLevelRelList.get(pictureBookLevelRelList.size() - 1);
            pictureBookLevelRel2.setId(null);
            pictureBookLevelRel2.setIdx(Integer.valueOf(pictureBookLevelRel2.getIdx() + 1));
            pictureBookLevelRel2.setPicBookCode(diff);
            pictureBookLevelRel2.setCreateTime(new Date());
            pictureBookLevelRel2.setUpdateTime(null);
            this.pictureBookLevelRelMapper.insertSelective(pictureBookLevelRel2);
            this.updateResourceOccupant(OperateEnum.INSERT, diff, pictureBookLevelRel2.getId());
            ++result;
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @EnableValidate
    public ResponseParams<Boolean> deletePictureBookLevelRel(@RequestBody SavePictureBookLevelRelRequest request) {
        PictureBookLevelRelExample example = new PictureBookLevelRelExample();
        example.createCriteria().andLevelCodeEqualTo(request.getLevelCode()).andStatusEqualTo("NORMAL");
        this.updateResourceOccupant(OperateEnum.DELETE_BATCH, request.getLevelCode(), null);
        int result = this.pictureBookLevelRelMapper.deleteByExample(example);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<Boolean> deletePictureBookFromLevel(@RequestParam(value="id") Integer id) {
        PictureBookLevelRel pictureBookLevelRel = this.pictureBookLevelRelMapper.selectByPrimaryKey(id);
        if (null == pictureBookLevelRel) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.LEVEL_NOT_EXISTS);
        }
        int result = 0;
        List pictureBookLevelRelList = this.getListByLevelCode(pictureBookLevelRel.getLevelCode());
        result = pictureBookLevelRelList.size() == 1 ? this.pictureBookLevelRelMapper.updatePictureBookToNull(id) : this.pictureBookLevelRelMapper.deleteByPrimaryKey(id);
        this.updateResourceOccupant(OperateEnum.DELETE, pictureBookLevelRel.getPicBookCode(), id);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<Boolean> sortPictureBook(@RequestBody SortPictureBookRequest request) {
        PictureBookLevelRel pictureBookLevelRel = this.pictureBookLevelRelMapper.selectByPrimaryKey(request.getId());
        if (null == pictureBookLevelRel) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.LEVEL_NOT_EXISTS);
        }
        int result = 0;
        PictureBookLevelRel changePictureBook = this.getChangePictureBook(pictureBookLevelRel.getLevelCode(), request);
        if (null == changePictureBook) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
        }
        Integer currentIdx = pictureBookLevelRel.getIdx();
        pictureBookLevelRel.setIdx(changePictureBook.getIdx());
        changePictureBook.setIdx(currentIdx);
        result = this.pictureBookLevelRelMapper.updateByPrimaryKeySelective(pictureBookLevelRel);
        if (result > 0) {
            result = this.pictureBookLevelRelMapper.updateByPrimaryKeySelective(changePictureBook);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    private PictureBookLevelRel getChangePictureBook(String levelCode, SortPictureBookRequest request) {
        List pictureBookLevelRelList = this.getListByLevelCode(levelCode);
        int currentPosition = 0;
        for (PictureBookLevelRel rel : pictureBookLevelRelList) {
            if (request.getId().equals(rel.getId())) break;
            ++currentPosition;
        }
        if ("up".equalsIgnoreCase(request.getOperateType()) && currentPosition != 0) {
            return (PictureBookLevelRel)pictureBookLevelRelList.get(currentPosition - 1);
        }
        if ("down".equalsIgnoreCase(request.getOperateType()) && currentPosition != pictureBookLevelRelList.size() - 1) {
            return (PictureBookLevelRel)pictureBookLevelRelList.get(currentPosition + 1);
        }
        return null;
    }

    private List<PictureBookLevelRel> getListByLevelCode(String levelCode) {
        PictureBookLevelRelExample example = new PictureBookLevelRelExample();
        example.createCriteria().andLevelCodeEqualTo(levelCode).andStatusEqualTo("NORMAL");
        example.setOrderByClause(" idx ");
        return this.pictureBookLevelRelMapper.selectByExample(example);
    }

    private void updateResourceOccupant(OperateEnum operateEnum, String resCode, Integer occupantId) {
        log.info("method PictureBookLevelRelServiceImpl.updateResourceOccupant param:{},{},{}", (Object)operateEnum, (Object)resCode, (Object)occupantId);
        PictureBookExample bookExample = new PictureBookExample();
        bookExample.createCriteria().andPicBookCodeEqualTo(resCode).andStatusEqualTo("NORMAL");
        List pictureBookList = this.pictureBookMapper.selectByExample(bookExample);
        switch (1.$SwitchMap$com$ella$resource$constants$OperateEnum[operateEnum.ordinal()]) {
            case 1: {
                ResourceOccupantExample example = new ResourceOccupantExample();
                example.createCriteria().andResIdEqualTo(Long.valueOf(((PictureBook)pictureBookList.get(0)).getId().longValue())).andResTypeEqualTo(DataEnum.RO_ResType.Res_PICTURE_BOOK.getType()).andOccupantIdEqualTo(Long.valueOf(occupantId.longValue())).andOccupantTypeEqualTo(DataEnum.RO_OccupantType.Occupant_PICTURE_BOOK.getType());
                this.resourceOccupantMapper.deleteByExample(example);
                break;
            }
            case 2: {
                ResourceOccupant occupant = new ResourceOccupant();
                occupant.setOccupantId(Long.valueOf(occupantId.longValue()));
                occupant.setOccupantType(DataEnum.RO_OccupantType.Occupant_PICTURE_BOOK.getType());
                occupant.setResId(Long.valueOf(((PictureBook)pictureBookList.get(0)).getId().longValue()));
                occupant.setResType(DataEnum.RO_ResType.Res_PICTURE_BOOK.getType());
                occupant.setCreateTime(new Date());
                occupant.setStatus("NORMAL");
                this.resourceOccupantMapper.insertSelective(occupant);
                break;
            }
            case 3: {
                List pictureBookLevelRelList = this.getListByLevelCode(resCode);
                List idList = pictureBookLevelRelList.stream().map(p -> p.getId().longValue()).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(idList)) {
                    return;
                }
                ResourceOccupantExample occupantExample = new ResourceOccupantExample();
                occupantExample.createCriteria().andResTypeEqualTo(DataEnum.RO_ResType.Res_PICTURE_BOOK.getType()).andOccupantTypeEqualTo(DataEnum.RO_OccupantType.Occupant_PICTURE_BOOK.getType()).andOccupantIdIn(idList);
                this.resourceOccupantMapper.deleteByExample(occupantExample);
                break;
            }
        }
    }
}

