/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.DateUtil;
import com.ella.frame.common.util.OrderUtil;
import com.ella.resource.api.LexileResTypeService;
import com.ella.resource.api.PicBookService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.LexileResTypeEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.BaseBook;
import com.ella.resource.domain.BaseBookExample;
import com.ella.resource.domain.Constant;
import com.ella.resource.domain.CourseBookExample;
import com.ella.resource.domain.Goods;
import com.ella.resource.domain.GoodsExample;
import com.ella.resource.domain.Level;
import com.ella.resource.domain.LexileResTypeRel;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.PictureBook;
import com.ella.resource.domain.PictureBookExample;
import com.ella.resource.domain.PictureBookLevelRel;
import com.ella.resource.domain.PictureBookLevelRelExample;
import com.ella.resource.domain.ReadHistory;
import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.domain.UserBook;
import com.ella.resource.domain.UserBookExample;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.GetPicBookInfoDto;
import com.ella.resource.dto.PicBookStoreDto;
import com.ella.resource.dto.PictureBookDto;
import com.ella.resource.dto.getBookShelvesFlagDto;
import com.ella.resource.dto.request.AddPicBookReq;
import com.ella.resource.dto.request.AddReadCountReq;
import com.ella.resource.dto.request.GetPicBookInfoReq;
import com.ella.resource.dto.request.PicBookListReq;
import com.ella.resource.dto.request.PicBookStoreReq;
import com.ella.resource.dto.request.ReadRecordReq;
import com.ella.resource.dto.request.picturebook.GetPicBooksByCodeRequest;
import com.ella.resource.dto.sendgoods.FetchTypeEnum;
import com.ella.resource.mapper.BaseBookMapper;
import com.ella.resource.mapper.ConstantMapper;
import com.ella.resource.mapper.CourseBookMapper;
import com.ella.resource.mapper.GoodsMapper;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.LexileResTypeMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.PictureBookLevelRelMapper;
import com.ella.resource.mapper.PictureBookMapper;
import com.ella.resource.mapper.ReadHistoryMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.mapper.UserBookMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.utils.MapUtils;
import com.ella.resource.utils.ModeTransformUtils;
import com.ella.resource.utils.ParseTypeUtils;
import com.ella.resource.utils.Putil;
import com.ella.resource.utils.ResponsePageResultUtils;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.resource.utils.ValidationUtils;
import com.ella.user.api.UserInfoService;
import com.github.pagehelper.PageHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PicBookServiceImpl
implements PicBookService {
    private static final Logger log = LogManager.getLogger(PicBookServiceImpl.class);
    @Autowired
    private PictureBookMapper pictureBookMapper;
    @Autowired
    private TransactionTemplate txTemplate;
    @Autowired
    private ResourceOccupantMapper resourceOccupantMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private PictureBookLevelRelMapper pictureBookLevelRelMapper;
    @Autowired
    private BaseBookMapper baseBookMapper;
    @Autowired
    private UserBookMapper userBookMapper;
    @Autowired
    private ConstantMapper constantMapper;
    @Autowired
    private LevelMapper levelMapper;
    @Autowired
    private ReadHistoryMapper historyMapper;
    @Autowired
    private CourseBookMapper courseBookMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private LexileResTypeMapper lexileResTypeMapper;
    @Autowired
    private LexileResTypeService lexileResTypeService;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private MissionMapper missionMapper;

    public ResponseParams levelAddPicBook(@RequestBody PicBookListReq req) {
        Level lev = this.levelMapper.selectReadRange(req.getLevelCode());
        PageHelper.startPage((int)req.getPageNo(), (int)req.getPageSize());
        List levelAddPicBook = this.pictureBookMapper.getLevelAddPicBook(lev.getReadStartIndex(), lev.getReadEndIndex(), req.getLevelCode());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((List)levelAddPicBook));
    }

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams readRecord(@RequestBody ReadRecordReq req) {
        if (StringUtils.isEmpty((String)req.getUid())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)false);
        }
        Integer integer = this.readHistory(req);
        if (integer == 0) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.READ_INSERT_ERROR);
        }
        float percent = (float)req.getPageNum().intValue() / (float)req.getTotalPage().intValue();
        String format = new DecimalFormat("0.00").format(percent);
        Integer lastReadStatus = 0;
        if (req.getTotalPage() > req.getPageNum()) {
            lastReadStatus = 1;
        } else if (Objects.equals(req.getTotalPage(), req.getPageNum())) {
            lastReadStatus = 2;
        }
        int i = this.userBookMapper.updateBookPercent(format, req.getUid(), req.getBookCode(), lastReadStatus);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private Integer readHistory(@RequestBody ReadRecordReq req) {
        ReadHistory history = new ReadHistory();
        if (Objects.equals(req.getTotalPage(), req.getPageNum())) {
            history.setIsFinish(Boolean.valueOf(true));
        } else {
            history.setIsFinish(Boolean.valueOf(false));
        }
        history.setUid(req.getUid());
        history.setCreateTime(new Date());
        history.setEndTime(req.getEndTime());
        history.setReadStart(req.getReadStart());
        history.setPageNum(req.getPageNum());
        history.setReadModel(req.getReadModel());
        history.setTotalPage(req.getTotalPage());
        history.setReadIp(req.getReadIp());
        history.setPicBookCode(req.getBookCode());
        return this.historyMapper.insertSelective(history);
    }

    @EnableValidate
    public ResponseParams addReadCount(@RequestBody AddReadCountReq req) {
        List pictureBooks = this.getPictureBooks(req.getPicBookCode());
        if (CollectionUtils.isEmpty((Collection)pictureBooks)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, (Object)false);
        }
        BaseBook baseBookInfo = this.getBaseBookInfo(((PictureBook)pictureBooks.get(0)).getBookCode());
        baseBookInfo.setReadeCount(Integer.valueOf(baseBookInfo.getReadeCount() + 1));
        this.baseBookMapper.updateByPrimaryKey(baseBookInfo);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    @EnableValidate
    @PostMapping(value={"getPicBookInfo/v1"})
    public ResponseParams getPicBookInfo(@RequestBody GetPicBookInfoReq req) {
        GetPicBookInfoDto dto = new GetPicBookInfoDto();
        List pictureBooks = this.getPictureBooks(req.getPicBookCode());
        if (CollectionUtils.isEmpty((Collection)pictureBooks)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, (Object)false);
        }
        PictureBook pictureBook = (PictureBook)pictureBooks.get(0);
        BaseBook baseBookInfo = this.getBaseBookInfo(pictureBook.getBookCode());
        BeanUtils.copyProperties((Object)baseBookInfo, (Object)dto);
        dto.setVersion(String.valueOf(baseBookInfo.getEnVersion()));
        if (req.getFullScreen().booleanValue()) {
            dto.setResourceUrl(baseBookInfo.getIphoneUrl());
        } else {
            dto.setResourceUrl(baseBookInfo.getNormalUrl());
        }
        BeanUtils.copyProperties((Object)pictureBook, (Object)dto);
        dto.setBookCode(pictureBook.getBookCode());
        dto.setPicBookCode(pictureBook.getPicBookCode());
        dto.setBookIntroduction(baseBookInfo.getBookIntroduction());
        if (dto.getDescription() == null || dto.getDescription().equals("")) {
            dto.setDescription(baseBookInfo.getBookIntroduction());
        }
        dto.setCoverUrl(baseBookInfo.getCoverUrl());
        dto.setPublishName(baseBookInfo.getBookPressName());
        GoodsExample goodsExample = new GoodsExample();
        goodsExample.createCriteria().andStatusEqualTo("NORMAL").andItemCodeEqualTo(req.getPicBookCode());
        List goods = this.goodsMapper.selectByExample(goodsExample);
        if (!CollectionUtils.isEmpty((Collection)goods)) {
            BeanUtils.copyProperties(goods.get(0), (Object)dto);
            this.checkPromotPrice(dto, (Goods)goods.get(0));
        }
        UserBookExample userBookExample = new UserBookExample();
        userBookExample.createCriteria().andStatusEqualTo("NORMAL").andBookCodeEqualTo(req.getPicBookCode()).andUidEqualTo(req.getUid());
        List userBooks = this.userBookMapper.selectByExample(userBookExample);
        if (!CollectionUtils.isEmpty((Collection)userBooks)) {
            dto.setIsBuy(Boolean.valueOf(true));
            if ("NO".equals(baseBookInfo.getEnglishStatus())) {
                dto.setAvailable(Boolean.valueOf(false));
            }
        } else {
            dto.setIsBuy(Boolean.valueOf(false));
            if (DataEnum.SHELVESFLAG.SHELVES_OFF.getValue().equals(baseBookInfo.getShelvesFlag()) || "NO".equals(baseBookInfo.getEnglishStatus())) {
                dto.setAvailable(Boolean.valueOf(false));
            }
        }
        this.getStrings(dto, pictureBooks);
        Level level = this.levelMapper.getLevelByAbility(ParseTypeUtils.parseInteger((String)dto.getLexileLevel()));
        if (Objects.nonNull(level)) {
            dto.setLevelCode(level.getLevelCode());
            dto.setLevelRecommend(this.getPicBookStoreDtos(req, dto));
        }
        dto.setIsReadFinish(this.reviewPermissions(req.getUid(), dto.getPicBookCode()));
        dto.setLexileLevelCode(this.lexileResTypeService.getLexileLevelCode(pictureBook.getPicBookCode(), pictureBook.getLexileLevel()));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    private Boolean reviewPermissions(String uid, String picBookCode) {
        List histories = this.historyMapper.getReviewPermissions(uid, picBookCode);
        return histories.size() != 0;
    }

    private void getStrings(GetPicBookInfoDto dto, List<PictureBook> pictureBooks) {
        List constants = this.constantMapper.selectConcatNameGroupTypeByCode(pictureBooks.get(0).getBookCode());
        ArrayList objects = new ArrayList();
        for (Constant item : constants) {
            if ("AUTHOR_REVIEW".equals(item.getItemType())) {
                dto.setReviewerMan(item.getItemName());
            }
            if ("AUTHOR_AUDIO".equals(item.getItemType())) {
                dto.setRadioMan(item.getItemName());
            }
            if ("AUTHOR_DESIGN".equals(item.getItemType())) {
                dto.setInteractionEffect(item.getItemName());
            }
            if ("AUTHOR_ART".equals(item.getItemType())) {
                dto.setPicHandle(item.getItemName());
            }
            if ("AUTHOR_TEXT".equals(item.getItemType())) {
                dto.setAuthorText(item.getItemName());
            }
            if ("PREVIEW_IMG".equals(item.getItemType())) {
                dto.setPreImage(Arrays.asList(item.getItemName().split(",")));
            }
            if ("PREVIEW_VIDEO".equals(item.getItemType())) {
                dto.setVideoUrl(item.getItemName());
            }
            if ("AUTHOR_PAINTING".equals(item.getItemType())) {
                dto.setPainting(item.getItemName());
            }
            if (!"PICBOOKSRCPRICE".equals(item.getItemType())) continue;
            dto.setPaperBookPrice(item.getItemName());
        }
    }

    private List<PicBookStoreDto> getPicBookStoreDtos(GetPicBookInfoReq req, GetPicBookInfoDto dto) {
        if (StringUtils.isBlank((String)dto.getLevelCode())) {
            dto.setLevelCode(LevelEnum.LV1.getCode());
        }
        List data = this.getUserPicBookStore(dto.getLevelCode(), Boolean.valueOf(false), req.getUid(), "");
        data.removeIf(next -> next.getPicBookCode().equals(req.getPicBookCode()));
        if (data.size() > 3) {
            data = data.subList(0, 4);
        }
        return data;
    }

    @RequestMapping(value={"picBookStore/v1"}, method={RequestMethod.POST})
    public ResponseParams picBookStore(@RequestBody PicBookStoreReq req) {
        log.info("APP\u6211\u7684\u7ed8\u672c---> {}", (Object)JSONObject.toJSONString((Object)req));
        if (FetchTypeEnum.BUY.getCode().equals(req.getType())) {
            List picBookStoreDtos = this.picBookStoreBuy(req.getUid(), req.getFullScreen().booleanValue());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)picBookStoreDtos);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.getUserPicBookStore(req.getLevelCode(), req.getFullScreen(), req.getUid(), req.getType()));
    }

    private ArrayList<PicBookStoreDto> getUserPicBookStore(String levelCode, Boolean fullScreen, String uid, String type) {
        ArrayList<PicBookStoreDto> arrayList = new ArrayList<PicBookStoreDto>();
        List goods = this.selectOnSellPicBook();
        if (CollectionUtils.isEmpty((Collection)goods)) {
            return arrayList;
        }
        List userBooks = this.getUserBooks(uid);
        List picBookCode = goods.stream().map(Goods::getItemCode).collect(Collectors.toList());
        PictureBookLevelRelExample pictureBookLevelRelExample = new PictureBookLevelRelExample();
        PictureBookLevelRelExample.Criteria criteria = pictureBookLevelRelExample.createCriteria();
        if ("COMMAND".equalsIgnoreCase(type)) {
            if (StringUtils.isBlank((String)levelCode)) {
                return arrayList;
            }
            criteria.andLevelCodeLessThanOrEqualTo(levelCode);
        } else if (StringUtils.isNotBlank((String)levelCode)) {
            criteria.andLevelCodeEqualTo(levelCode);
        }
        criteria.andPicBookCodeIn(picBookCode).andStatusEqualTo("NORMAL");
        List pictureBookLevelRels = this.pictureBookLevelRelMapper.selectByExample(pictureBookLevelRelExample);
        Map pictureBookLevelRelMap = ModeTransformUtils.getCodeAndDomainMap((List)pictureBookLevelRels, (String)"picBookCode");
        goods.forEach(g -> {
            PicBookStoreDto picBookStoreDto = new PicBookStoreDto();
            if (pictureBookLevelRelMap.containsKey(g.getItemCode())) {
                List pictureBooks = this.getPictureBooks(g.getItemCode());
                String bookName = null;
                if (!CollectionUtils.isEmpty((Collection)pictureBooks)) {
                    picBookStoreDto.setLexileLevelCode(this.lexileResTypeService.getLexileLevelCode(g.getItemCode(), ((PictureBook)pictureBooks.get(0)).getLexileLevel()));
                    picBookStoreDto.setLexileLevel(((PictureBook)pictureBooks.get(0)).getLexileLevel());
                    BaseBook baseBookInfo = this.getBaseBookInfo(((PictureBook)pictureBooks.get(0)).getBookCode());
                    if (DataEnum.SHELVESFLAG.SHELVES_OFF.getValue().equals(baseBookInfo.getShelvesFlag()) || "NO".equals(baseBookInfo.getEnglishStatus())) {
                        return;
                    }
                    picBookStoreDto.setBookCode(baseBookInfo.getBookCode());
                    picBookStoreDto.setCoverUrl(baseBookInfo.getCoverUrl());
                    if (fullScreen.booleanValue()) {
                        picBookStoreDto.setResourceUrl(baseBookInfo.getIphoneUrl());
                    } else {
                        picBookStoreDto.setResourceUrl(baseBookInfo.getNormalUrl());
                    }
                    picBookStoreDto.setBookIntroduction(baseBookInfo.getBookIntroduction());
                    picBookStoreDto.setBookScore(baseBookInfo.getBookScore());
                    picBookStoreDto.setTags(baseBookInfo.getTags());
                    picBookStoreDto.setVersion(String.valueOf(baseBookInfo.getEnVersion()));
                    bookName = baseBookInfo.getBookName();
                }
                picBookStoreDto.setGoodsCode(g.getGoodsCode());
                picBookStoreDto.setGoodsPrice(g.getGoodsPrice());
                picBookStoreDto.setGoodsPriceStone(g.getGoodsPriceStone());
                picBookStoreDto.setGoodsName(bookName == null ? g.getGoodsName() : bookName);
                picBookStoreDto.setLevelCode(((PictureBookLevelRel)pictureBookLevelRelMap.get(g.getItemCode())).getLevelCode());
                picBookStoreDto.setPicBookCode(g.getItemCode());
                picBookStoreDto.setBought(userBooks.contains(g.getItemCode()));
                arrayList.add(picBookStoreDto);
            }
        });
        this.sortByType(arrayList, uid, type);
        return arrayList;
    }

    private List<String> getUserBooks(String uid) {
        List<String> result = new ArrayList<String>();
        UserBookExample userBookExample = new UserBookExample();
        userBookExample.createCriteria().andUidEqualTo(uid).andStatusEqualTo("NORMAL");
        List userBooks = this.userBookMapper.selectByExample(userBookExample);
        if (CollectionUtils.isEmpty((Collection)userBooks)) {
            return result;
        }
        result = userBooks.stream().map(UserBook::getBookCode).collect(Collectors.toList());
        return result;
    }

    private void sortByType(ArrayList<PicBookStoreDto> arrayList, String uid, String type) {
        if ("COMMAND".equalsIgnoreCase(type)) {
            arrayList.sort((o1, o2) -> {
                if (o1.getLevelCode().equals(o2.getLevelCode())) {
                    return ParseTypeUtils.parseInteger((String)o1.getLexileLevel()).compareTo(ParseTypeUtils.parseInteger((String)o2.getLexileLevel()));
                }
                return o1.getLevelCode().compareTo(o2.getLevelCode());
            });
        } else {
            arrayList.sort(Comparator.comparing(o -> ParseTypeUtils.parseInteger((String)o.getLexileLevel())));
        }
    }

    private ArrayList<PicBookStoreDto> sort(ArrayList<PicBookStoreDto> arrayList, String uid) {
        List picBookCodes = arrayList.stream().map(PicBookStoreDto::getPicBookCode).collect(Collectors.toList());
        UserBookExample userBookExample = new UserBookExample();
        userBookExample.createCriteria().andUidEqualTo(uid).andStatusEqualTo("NORMAL").andBookCodeIn(picBookCodes);
        List userBookList = this.userBookMapper.selectByExample(userBookExample);
        if (CollectionUtils.isEmpty((Collection)userBookList)) {
            return arrayList;
        }
        Map userBookMap = ModeTransformUtils.getCodeAndDomainMap((List)userBookList, (String)"bookCode");
        arrayList.sort((o1, o2) -> {
            if (o1.getLevelCode().equals(o2.getLevelCode())) {
                UserBook book1 = (UserBook)userBookMap.get(o1.getPicBookCode());
                UserBook book2 = (UserBook)userBookMap.get(o2.getPicBookCode());
                if (Objects.isNull(book1) && Objects.isNull(book2)) {
                    return 0;
                }
                if (Objects.isNull(book1) && Objects.nonNull(book2)) {
                    return 1;
                }
                if (Objects.nonNull(book1) && Objects.isNull(book2)) {
                    return -1;
                }
                if (book1.getCreateTime() == book2.getCreateTime()) {
                    return book1.getUpdateTime().compareTo(book2.getUpdateTime());
                }
                return book1.getCreateTime().compareTo(book2.getCreateTime());
            }
            return o1.getLevelCode().compareTo(o2.getLevelCode());
        });
        return arrayList;
    }

    private List<PicBookStoreDto> picBookStoreBuy(String uid, boolean fullScreen) {
        ArrayList<PicBookStoreDto> arrayList = new ArrayList<PicBookStoreDto>();
        UserBookExample userBookExample = new UserBookExample();
        userBookExample.createCriteria().andUidEqualTo(uid).andStatusEqualTo("NORMAL");
        userBookExample.setOrderByClause("last_read_status ,last_read_time DESC ,create_time DESC");
        List userBooks = this.userBookMapper.selectByExample(userBookExample);
        userBooks.forEach(picbook -> {
            List pictureBooks;
            PicBookStoreDto picBookStoreDto = new PicBookStoreDto();
            PictureBookLevelRelExample pictureBookLevelRelExample = new PictureBookLevelRelExample();
            pictureBookLevelRelExample.createCriteria().andPicBookCodeEqualTo(picbook.getBookCode()).andStatusEqualTo("NORMAL");
            List pictureBookLevelRels = this.pictureBookLevelRelMapper.selectByExample(pictureBookLevelRelExample);
            if (pictureBookLevelRels != null && pictureBookLevelRels.size() > 0) {
                picBookStoreDto.setLevelCode(((PictureBookLevelRel)pictureBookLevelRels.get(0)).getLevelCode());
            }
            if ((pictureBooks = this.getPictureBooks(picbook.getBookCode())) == null || pictureBooks.size() == 0) {
                return;
            }
            picBookStoreDto.setLexileLevelCode(this.lexileResTypeService.getLexileLevelCode(((PictureBook)pictureBooks.get(0)).getPicBookCode(), ((PictureBook)pictureBooks.get(0)).getLexileLevel()));
            picBookStoreDto.setLexileLevel(((PictureBook)pictureBooks.get(0)).getLexileLevel());
            picBookStoreDto.setPicBookCode(((PictureBook)pictureBooks.get(0)).getPicBookCode());
            BaseBook baseBookInfo = this.getBaseBookInfo(((PictureBook)pictureBooks.get(0)).getBookCode());
            picBookStoreDto.setCoverUrl(baseBookInfo.getCoverUrl());
            picBookStoreDto.setBookCode(baseBookInfo.getBookCode());
            picBookStoreDto.setVersion(String.valueOf(baseBookInfo.getEnVersion()));
            picBookStoreDto.setGoodsName(baseBookInfo.getBookName());
            if (fullScreen) {
                picBookStoreDto.setResourceUrl(baseBookInfo.getIphoneUrl());
            } else {
                picBookStoreDto.setResourceUrl(baseBookInfo.getNormalUrl());
            }
            if ("NO".equals(baseBookInfo.getEnglishStatus())) {
                picBookStoreDto.setAvailable(Boolean.valueOf(false));
            }
            arrayList.add(picBookStoreDto);
        });
        return arrayList;
    }

    private void userBookSort(List<UserBook> userBooks) {
        userBooks.sort((o1, o2) -> {
            if (Objects.equals(o1.getLastReadStatus(), o2.getLastReadStatus())) {
                return -o1.getLastReadTime().compareTo(o2.getLastReadTime());
            }
            return o1.getLastReadStatus().compareTo(o2.getLastReadStatus());
        });
    }

    private BaseBook getBaseBookInfo(String bookCode) {
        BaseBook result = new BaseBook();
        if (StringUtils.isBlank((String)bookCode)) {
            return result;
        }
        BaseBookExample baseBookExample = new BaseBookExample();
        baseBookExample.createCriteria().andStatusEqualTo("NORMAL").andBookCodeEqualTo(bookCode);
        List baseBooks = this.baseBookMapper.selectByExample(baseBookExample);
        if (!CollectionUtils.isEmpty((Collection)baseBooks)) {
            return (BaseBook)baseBooks.get(0);
        }
        return result;
    }

    private List<PictureBook> getPictureBooks(String picBookCode) {
        PictureBookExample pictureBookExample = new PictureBookExample();
        pictureBookExample.createCriteria().andStatusEqualTo("NORMAL").andPicBookCodeEqualTo(picBookCode);
        return this.pictureBookMapper.selectByExample(pictureBookExample);
    }

    public List<Goods> selectOnSellPicBook() {
        GoodsExample goodsExample = new GoodsExample();
        goodsExample.createCriteria().andStatusEqualTo("NORMAL").andGoodsStateEqualTo("SALING").andGoodsTypeEqualTo("BOOK");
        return this.goodsMapper.selectByExample(goodsExample);
    }

    @RequestMapping(value={"picBookList/v1"}, method={RequestMethod.POST})
    public ResponseParams picBookList(@RequestBody PicBookListReq req) {
        log.info("\u7ed8\u672c\u5217\u8868\u5206\u9875-----> {}", (Object)JSONObject.toJSONString((Object)req));
        PictureBookExample pictureBookExample = new PictureBookExample();
        PictureBookExample.Criteria normal = pictureBookExample.createCriteria().andStatusEqualTo("NORMAL");
        pictureBookExample.setOrderByClause("update_time desc");
        if (StringUtils.isNotEmpty((String)req.getName())) {
            normal.andBookNameLike(req.getName());
            pictureBookExample.or().andSeriesNameLike(req.getName()).andStatusEqualTo("NORMAL");
        }
        if (StringUtils.isNotEmpty((String)req.getLevelCode())) {
            Level level = this.levelMapper.selectReadRange(req.getLevelCode());
            normal.andLexileLevelBetween(level.getReadStartIndex().intValue(), level.getReadEndIndex().intValue());
        }
        PageHelper.startPage((int)req.getPageNo(), (int)req.getPageSize());
        List pictureBooks = null;
        if (StringUtils.isNotEmpty((String)req.getApplyType())) {
            Map map = MapUtils.java2Map((Object)req);
            pictureBooks = this.pictureBookMapper.selectUnusedPictureBook(map);
        } else {
            pictureBooks = this.pictureBookMapper.selectByExample(pictureBookExample);
            Iterator iterator = pictureBooks.iterator();
            this.fore(iterator, req.getClientType());
        }
        pictureBooks.forEach(pictureBook -> {
            BaseBook baseBookInfo = this.getBaseBookInfo(pictureBook.getBookCode());
            pictureBook.setCoverUrl(baseBookInfo.getCoverUrl());
            pictureBook.setGoodsName(pictureBook.getBookName());
            pictureBook.setBookIntroduction(baseBookInfo.getBookIntroduction());
            pictureBook.setBookScore(baseBookInfo.getBookScore());
            pictureBook.setLexileLevel(this.lexileResTypeService.getLexileLevelCode(pictureBook.getPicBookCode(), pictureBook.getLexileLevel()));
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Putil.build((List)pictureBooks));
    }

    private void fore(Iterator<PictureBook> iterator, String client) {
        while (iterator.hasNext()) {
            PictureBook item = iterator.next();
            if (!"OTS".equals(client)) {
                GoodsExample goodsExample = new GoodsExample();
                goodsExample.createCriteria().andStatusEqualTo("NORMAL").andGoodsTypeEqualTo("BOOK").andItemCodeEqualTo(item.getPicBookCode()).andGoodsStateEqualTo("SALING");
                List goods = this.goodsMapper.selectByExample(goodsExample);
                if (goods.size() == 0) {
                    iterator.remove();
                    continue;
                }
            }
            ResourceOccupantExample example = new ResourceOccupantExample();
            example.createCriteria().andResIdEqualTo(Long.valueOf(item.getId().intValue())).andStatusEqualTo("NORMAL").andResTypeEqualTo("PICTUREBOOK");
            List resourceOccupants = this.resourceOccupantMapper.selectByExample(example);
            if (!CollectionUtils.isEmpty((Collection)resourceOccupants)) {
                item.setUseStatus("Y");
                continue;
            }
            item.setUseStatus("N");
        }
    }

    @RequestMapping(value={"getInfoById/v1"}, method={RequestMethod.GET})
    public ResponseParams getInfoById(@RequestParam(value="id") Integer id) {
        log.info("\u7ed8\u672c\u901a\u8fc7id\u67e5\u8be2-----> {}", (Object)id);
        if (id == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        PictureBook pictureBook = this.pictureBookMapper.selectByPrimaryKey(id);
        LexileResTypeRel lexileResTypeRel = this.lexileResTypeMapper.selectByResCode(pictureBook.getPicBookCode());
        if (lexileResTypeRel != null) {
            pictureBook.setLexileResTypeCode(lexileResTypeRel.getLexileResTypeCode());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)pictureBook);
    }

    @RequestMapping(value={"updatePicBook/v1"}, method={RequestMethod.POST})
    public ResponseParams updatePicBook(@RequestBody AddPicBookReq res) {
        log.info("\u7ed8\u672c\u65b0\u589e/\u5220\u9664/\u4fee\u6539-----> {}", (Object)JSONObject.toJSONString((Object)res));
        PictureBook pictureBook = new PictureBook();
        BeanUtils.copyProperties((Object)res, (Object)pictureBook);
        return (ResponseParams)this.txTemplate.execute(tx -> {
            PictureBook record;
            if ("EXCEPTION".equals(res.getStatus()) && res.getId() != null) {
                ResourceOccupantExample example = new ResourceOccupantExample();
                example.createCriteria().andResTypeEqualTo("PICTUREBOOK").andResIdEqualTo(Long.valueOf(res.getId().intValue())).andStatusEqualTo("NORMAL");
                List resourceOccupants = this.resourceOccupantMapper.selectByExample(example);
                if (CollectionUtils.isEmpty((Collection)resourceOccupants)) {
                    this.pictureBookMapper.updateByPrimaryKeySelective(pictureBook);
                    ResourceOccupantExample occupantExample = new ResourceOccupantExample();
                    occupantExample.createCriteria().andOccupantIdEqualTo(Long.valueOf(pictureBook.getId().intValue())).andOccupantTypeEqualTo("PICTUREBOOK");
                    this.resourceOccupantMapper.deleteByExample(occupantExample);
                    PictureBook record2 = this.pictureBookMapper.selectByPrimaryKey(res.getId());
                    if (record2 != null) {
                        LexileResTypeRel lexileResTypeRel = LexileResTypeRel.builder().resType("PICTURE").resCode(record2.getPicBookCode()).build();
                        this.lexileResTypeMapper.deleteByResCodeAndType(lexileResTypeRel);
                    }
                    return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
                }
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.DELETE_FILL);
            }
            String entity = ValidationUtils.validateEntity((Object)res, (Class[])new Class[0]);
            if (StringUtils.isNotEmpty((String)entity)) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
            }
            if (res.getId() == null) {
                CourseBookExample example = new CourseBookExample();
                example.createCriteria().andBookCodeEqualTo(res.getBookCode()).andStatusEqualTo("NORMAL");
                List courseBookList = this.courseBookMapper.selectByExample(example);
                if (!CollectionUtils.isEmpty((Collection)courseBookList)) {
                    return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.EXISTS_IN_COURSE_BOOK);
                }
                pictureBook.setCreateTime(new Date());
                pictureBook.setForAge(String.valueOf(res.getForAge().get(0)) + "," + String.valueOf(res.getForAge().get(1)));
                pictureBook.setPicBookCode(OrderUtil.createNo((String)"PB", (Integer)1));
                pictureBook.setStatus("NORMAL");
                int i = this.pictureBookMapper.insertSelective(pictureBook);
                if (i == 1) {
                    ResourceOccupant occupant = new ResourceOccupant();
                    occupant.setResCode(pictureBook.getBookCode());
                    occupant.setResType("BOOK");
                    occupant.setOccupantType("PICTUREBOOK");
                    occupant.setOccupantId(Long.valueOf(pictureBook.getId().intValue()));
                    occupant.setCreateTime(new Date());
                    occupant.setStatus("NORMAL");
                    this.resourceOccupantMapper.insertSelective(occupant);
                    if (res.getLexileResTypeCode() != null && !res.getLexileResTypeCode().equals("")) {
                        LexileResTypeRel record3 = LexileResTypeRel.builder().lexileResTypeCode(res.getLexileResTypeCode()).resType("PICTURE").resCode(pictureBook.getPicBookCode()).build();
                        this.lexileResTypeMapper.insertSelective(record3);
                    }
                    return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
                }
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.INSERT_FILL);
            }
            List forAge = res.getForAge();
            pictureBook.setForAge(forAge.get(0) + "," + forAge.get(1));
            this.pictureBookMapper.updateByPrimaryKeySelective(pictureBook);
            if (LexileResTypeEnum.NP.getCode().equals(res.getLexileResTypeCode())) {
                PictureBook item = new PictureBook();
                item.setLexileLevel("");
                item.setId(res.getId());
                this.pictureBookMapper.updateByPrimaryKeySelective(item);
            }
            if ((record = this.pictureBookMapper.selectByPrimaryKey(res.getId())) != null) {
                LexileResTypeRel lexileResTypeRel = LexileResTypeRel.builder().lexileResTypeCode(res.getLexileResTypeCode()).resType("PICTURE").resCode(record.getPicBookCode()).build();
                this.lexileResTypeMapper.udpateByResCodeAndType(lexileResTypeRel);
            }
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        });
    }

    @EnableValidate
    public ResponseParams<List<PictureBookDto>> getPicBooksByCode(@RequestBody GetPicBooksByCodeRequest req) {
        List list;
        log.info("getPicBooks --- req :{}", (Object)req);
        if (req.getPicBookCode() == null && req.getPicBookCodes() == null && req.getPicBookCodes().isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        PictureBookExample exam = new PictureBookExample();
        PictureBookExample.Criteria crit = exam.createCriteria();
        if (StringUtils.isNotEmpty((String)req.getPicBookCode())) {
            crit.andPicBookCodeEqualTo(req.getPicBookCode());
        }
        if (req.getPicBookCodes() != null) {
            crit.andPicBookCodeIn(req.getPicBookCodes());
        }
        if ((list = this.pictureBookMapper.selectByExample(exam)) == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        ArrayList<PictureBookDto> result = new ArrayList<PictureBookDto>();
        for (PictureBook book : list) {
            PictureBookDto dto = new PictureBookDto();
            BeanUtils.copyProperties((Object)book, (Object)dto);
            result.add(dto);
        }
        list = null;
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    public ResponseParams<Boolean> getBookShelvesFlag(@RequestBody getBookShelvesFlagDto request) {
        Boolean available = true;
        String missionId = request.getMissionId();
        if (missionId == null || missionId.equals("")) {
            BaseBook baseBook = this.baseBookMapper.selectByBookCode(request.getBookCode());
            if (baseBook == null) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
            }
            UserBookExample userBookExample = new UserBookExample();
            userBookExample.createCriteria().andUidEqualTo(request.getUid()).andStatusEqualTo("NORMAL");
            userBookExample.setOrderByClause("last_read_status ,last_read_time DESC ,create_time DESC");
            List userBooks = this.userBookMapper.selectByExample(userBookExample);
            if (userBooks != null && userBooks.size() > 0) {
                if ("NO".equals(baseBook.getEnglishStatus())) {
                    available = false;
                }
            } else {
                Goods goods = this.goodsMapper.selectByBookCode(request.getBookCode());
                if (goods == null) {
                    return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
                }
                if (DataEnum.SHELVESFLAG.SHELVES_OFF.getValue().equals(baseBook.getShelvesFlag()) || "NO".equals(baseBook.getEnglishStatus()) || goods.getGoodsState().equals("OVER_SALE")) {
                    available = false;
                }
            }
        } else {
            BaseBook baseBook;
            Integer resourceId = null;
            UserMission userMission = this.userMissionMapper.selectByPrimaryKey(Long.valueOf(missionId));
            if (userMission == null || userMission.getIsDel().equals(1)) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
            }
            if (userMission != null) {
                Mission mission = this.missionMapper.selectByMissionCode(userMission.getMissionCode());
                if (mission == null || "DELETE".equals(mission.getStatus())) {
                    return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
                }
                resourceId = mission.getResourceId();
            }
            if ((baseBook = this.baseBookMapper.selectBookByResourceId(resourceId)) == null) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
            }
            if (DataEnum.SHELVESFLAG.SHELVES_OFF.getValue().equals(baseBook.getShelvesFlag()) || "NO".equals(baseBook.getEnglishStatus())) {
                available = false;
            }
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)available);
    }

    private void checkPromotPrice(GetPicBookInfoDto dto, Goods goods) {
        if (Objects.isNull(goods) || Objects.isNull(dto)) {
            return;
        }
        if (Objects.isNull(goods.getGoodsPromotPrice())) {
            return;
        }
        if (Objects.isNull(goods.getGoodsPromotTimeStart()) || Objects.isNull(goods.getGoodsPromotTimeEnd())) {
            return;
        }
        if (!DateUtil.isEffectiveDate((Date)new Date(), (Date)goods.getGoodsPromotTimeStart(), (Date)goods.getGoodsPromotTimeEnd())) {
            return;
        }
        dto.setGoodsPrice(goods.getGoodsPromotPrice());
    }
}

