/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.OpSystemService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.domain.Advert;
import com.ella.resource.domain.Attach;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.GetAdUrlRequest;
import com.ella.resource.dto.GetAdUrlResponse;
import com.ella.resource.dto.SystemResourceNotify;
import com.ella.resource.mapper.AdvertMapper;
import com.ella.resource.mapper.AttachMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.SysResourceOperateService;
import com.ella.resource.utils.FillModeUtils;
import com.ella.resource.utils.ResponseParamUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OpSystemServiceImpl
implements OpSystemService {
    private static final Logger log = LogManager.getLogger(OpSystemServiceImpl.class);
    @Autowired
    private AttachMapper attachMapper;
    @Autowired
    private SysResourceOperateService sysResourceOperateService;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private AdvertMapper advertMapper;

    public ResponseParams getVideo() {
        int lastOrder = this.attachMapper.selectLastOrderByType("OP_VIDEO");
        Attach attach = this.attachMapper.selectByTypeAndOrder("OP_VIDEO", Integer.valueOf(lastOrder));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)attach.getFilePath());
    }

    public ResponseParams addVideo(@RequestParam(value="filePath") String filePath) {
        int lastOrder = this.attachMapper.selectLastOrderByType("OP_VIDEO");
        int result = this.attachMapper.insertSelective(FillModeUtils.fillOpVideoAttach((String)filePath, (Integer)(lastOrder + 1)));
        log.info("\u63d2\u5165\u5f00\u673a\u89c6\u9891\u7c7b\u578b\u9644\u4ef6 result: " + result);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    public ResponseParams resGotNotify(@RequestBody SystemResourceNotify systemResourceNotify) {
        String resCode;
        if (DataEnum.SYS_RESOURCE_UPDATE_TYPE.MAP_RESOURCE_INSERT.getValue().equals(systemResourceNotify.getType())) {
            UserMap userMap = this.userMapMapper.selectByPrimaryKey(systemResourceNotify.getResId());
            resCode = userMap.getMapCode();
        } else {
            UserMission userMission = this.userMissionMapper.selectByPrimaryKey(systemResourceNotify.getResId());
            resCode = userMission.getMissionCode();
        }
        boolean r = this.sysResourceOperateService.delSysResourceNotify(systemResourceNotify.getUid(), resCode, systemResourceNotify.getType());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)r);
    }

    public ResponseParams getAdUrl(@RequestBody GetAdUrlRequest request) {
        Advert advert = this.advertMapper.selectAll();
        GetAdUrlResponse responseData = new GetAdUrlResponse();
        responseData.setAdUrl(advert.getAdUrl());
        responseData.setJumpUrl(advert.getJumpUrl());
        responseData.setIsShow(Boolean.valueOf(true));
        if (advert.getIsShow() == 0 && request.getOs().equals("ios")) {
            responseData.setIsShow(Boolean.valueOf(false));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)responseData);
    }
}

