/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.aop.annotion.EvictDataCache;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.MissionService;
import com.ella.resource.api.UserMapAndMissionSnapshotService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.Attach;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.LexileLevelHistory;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.MapResourceRel;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.MissionAndResource;
import com.ella.resource.domain.PicGallery;
import com.ella.resource.domain.QuestionRecord;
import com.ella.resource.domain.ResExam;
import com.ella.resource.domain.ResPeriodTest;
import com.ella.resource.domain.UserCourse;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.ResponsePageResult;
import com.ella.resource.dto.UpdateStoneNumDto;
import com.ella.resource.dto.appdto.MapMissionDto;
import com.ella.resource.dto.missiondto.MissionDetailPageDto;
import com.ella.resource.dto.missiondto.MissionDto;
import com.ella.resource.dto.missiondto.MissionFullDto;
import com.ella.resource.dto.missiondto.MissionSetDto;
import com.ella.resource.dto.request.map.MapResourceDeleteRequest;
import com.ella.resource.dto.request.map.MapResourceSaveRequest;
import com.ella.resource.dto.request.mission.GetMissionDetailPageRequest;
import com.ella.resource.dto.request.mission.GetMissionInfoRequest;
import com.ella.resource.dto.request.mission.GetMissionLevelListRequest;
import com.ella.resource.dto.request.mission.GetMissionListRequest;
import com.ella.resource.dto.request.mission.MoveMissionRequest;
import com.ella.resource.dto.request.mission.SaveMissionRequest;
import com.ella.resource.dto.request.mission.UpdateMissionRequest;
import com.ella.resource.mapper.AttachMapper;
import com.ella.resource.mapper.CourseBookMapper;
import com.ella.resource.mapper.LexileLevelHistoryMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MapResourceRelMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.PicGalleryMapper;
import com.ella.resource.mapper.QuestionRecordMapper;
import com.ella.resource.mapper.ResExamMapper;
import com.ella.resource.mapper.ResPeriodTestMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.MapAndMissionUtilService;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.service.transactional.MissionTService;
import com.ella.resource.utils.CacheEnum;
import com.ella.resource.utils.CacheUtilsNew;
import com.ella.resource.utils.FillModeUtils;
import com.ella.resource.utils.MapUtils;
import com.ella.resource.utils.ModeTransformUtils;
import com.ella.resource.utils.ResponsePageResultUtils;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.api.UserInfoService;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.request.userinfo.FindUserByIdRequest;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MissionServiceImpl
implements MissionService {
    private static final Logger log = LogManager.getLogger(MissionServiceImpl.class);
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private MapTService mapTService;
    @Autowired
    private AttachMapper attachMapper;
    @Autowired
    private PicGalleryMapper picGalleryMapper;
    @Autowired
    private MissionTService missionTService;
    @Autowired
    private MapResourceRelMapper mapResourceRelMapper;
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private ResPeriodTestMapper testMapper;
    @Autowired
    private ResExamMapper examMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private UserMapAndMissionSnapshotService userMapAndMissionSnapshotService;
    @Autowired
    private CourseBookMapper courseBookMapper;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private LexileLevelHistoryMapper lexileLevelHistoryMapper;
    @Autowired
    private QuestionRecordMapper questionRecordMapper;
    @Autowired
    private MapAndMissionUtilService mapAndMissionUtilService;

    @EnableValidate
    public ResponseParams<MissionSetDto> getMissionList(@RequestBody GetMissionListRequest request) {
        Map map = this.mapMapper.selectByPrimaryKey(request.getId());
        if (null == map) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_NOT_EXISTS);
        }
        MissionAndResource missionAndResource = this.mapTService.getMissionAndResource(map.getMapCode());
        MissionSetDto result = new MissionSetDto();
        ModeTransformUtils.jointMissionListResult((MissionSetDto)result, (Map)map, (List)missionAndResource.getMissionList(), (List)missionAndResource.getDynamicList(), (List)missionAndResource.getPicGalleryList());
        result.setMapId(request.getId());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<MissionDto> getMissionInfo(@RequestBody GetMissionInfoRequest request) {
        Mission mission = this.missionMapper.selectByPrimaryKey(request.getId());
        if (null == mission) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        MissionDto result = new MissionDto();
        BeanUtils.copyProperties((Object)mission, (Object)result);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<Integer> saveMission(@RequestBody SaveMissionRequest request) {
        if (request.getMissionIndex() != null && request.getMissionIndex() <= 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Map map = this.mapMapper.selectByPrimaryKey(request.getMapId());
        if (null == map) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_NOT_EXISTS);
        }
        if (request.getMissionIndex() == null) {
            request.setMissionIndex(Integer.valueOf(this.getNextIndex(request.getMissionType(), request.getMissionCoords(), map.getMapCode())));
        } else {
            int maxIndex = this.missionMapper.selectMaxIndexByMapCode(map.getMapCode());
            int abs = request.getMissionIndex() - maxIndex;
            if (abs > 1) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_INDEX_ERROR, null);
            }
            this.missionTService.moveInsertMissionIndex(map.getMapCode(), request.getMissionIndex());
        }
        Mission mission = new Mission();
        BeanUtils.copyProperties((Object)request, (Object)mission);
        mission.setMapCode(map.getMapCode());
        mission.setCreateBy(request.getUid());
        int result = this.missionTService.saveMission(mission);
        new CacheUtilsNew(this.redisCache, "MAP_RESOURCE:" + map.getMapCode(), null, CacheEnum.DEL).run();
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    private int getNextIndex(Integer missionType, String missionCoords, String mapCode) {
        if (missionType > 0) {
            int index = this.missionMapper.selectMaxIndexByMapCode(mapCode);
            return index + 1;
        }
        String index = missionCoords.split(",")[0];
        return Integer.valueOf(index) + 1;
    }

    @EnableValidate
    public ResponseParams<Boolean> updateMission(@RequestBody UpdateMissionRequest request) {
        Mission mission = new Mission();
        BeanUtils.copyProperties((Object)request, (Object)mission);
        mission.setUpdateBy(request.getUid());
        Map map = this.mapMapper.selectByPrimaryKey(request.getMapId());
        List missionList = this.missionMapper.getMissionList(map.getMapCode());
        List missions = missionList.stream().filter(m -> m.getResourceName().equals(request.getResourceName())).filter(m -> !m.getId().equals(request.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(missions)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_RESOURCE_EXISTS);
        }
        int result = this.missionTService.updateMission(mission);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @EvictDataCache(resourceName={"MissionMapper:selectByMissionCode"}, operation="UPDATE", evictAll=true)
    @EnableValidate
    public ResponseParams<Boolean> moveMission(@RequestBody MoveMissionRequest request) {
        Mission mission = this.missionMapper.selectByPrimaryKey(Long.valueOf(request.getId()));
        Map map = this.mapMapper.selectByMapCode(mission.getMapCode());
        if (map != null && map.getStatus().equals("SURE")) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.REF_MAP_RESOURCE_SURE);
        }
        if (null == mission) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        if (!Objects.isNull(request.getTopOrBottom())) {
            return this.moveToTopOrBottom(mission, request);
        }
        if (!Objects.isNull(request.getUpOrDown())) {
            return this.moveToSite(mission, request);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.UPDATE_FILL);
    }

    private ResponseParams<Boolean> moveToTopOrBottom(Mission mission, MoveMissionRequest request) {
        List preUpdateMssionList = this.missionMapper.listIndexGreaterOrLessParame(mission.getMapCode(), Boolean.valueOf(request.getTopOrBottom() == false), mission.getMissionIndex());
        if (CollectionUtils.isNotEmpty((Collection)preUpdateMssionList) && Objects.equals(((Mission)preUpdateMssionList.get(0)).getMissionIndex(), mission.getMissionIndex())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        ArrayList<Mission> updateMissionList = new ArrayList<Mission>(preUpdateMssionList.size());
        Mission tempMission = new Mission();
        BeanUtils.copyProperties(preUpdateMssionList.get(0), (Object)tempMission);
        for (int i = 0; i < preUpdateMssionList.size() - 1; ++i) {
            Mission currentMission = (Mission)preUpdateMssionList.get(i);
            Mission nextMission = (Mission)preUpdateMssionList.get(i + 1);
            currentMission.setMissionIndex(nextMission.getMissionIndex());
            currentMission.setMissionCoords(nextMission.getMissionCoords());
            currentMission.setUpdateBy(request.getUid());
            updateMissionList.add(currentMission);
        }
        mission.setMissionIndex(tempMission.getMissionIndex());
        mission.setMissionCoords(tempMission.getMissionCoords());
        mission.setUpdateBy(request.getUid());
        updateMissionList.add(mission);
        int result = this.updateMission(updateMissionList);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    private ResponseParams<Boolean> moveToSite(Mission mission, MoveMissionRequest request) {
        Mission changeMission = this.missionMapper.selectMinAbsMission(mission.getMapCode(), mission.getMissionIndex(), request.getUpOrDown() != false ? Integer.valueOf(1) : null);
        if (null == changeMission) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        int tempMissionIndex = changeMission.getMissionIndex();
        String tempMissionCoords = changeMission.getMissionCoords();
        changeMission.setUpdateBy(request.getUid());
        changeMission.setMissionIndex(mission.getMissionIndex());
        changeMission.setMissionCoords(mission.getMissionCoords());
        mission.setMissionIndex(Integer.valueOf(tempMissionIndex));
        mission.setMissionCoords(tempMissionCoords);
        mission.setUpdateBy(request.getUid());
        ArrayList<Mission> updateMissionList = new ArrayList<Mission>(2);
        updateMissionList.add(mission);
        updateMissionList.add(changeMission);
        int result = this.updateMission(updateMissionList);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateMission(List<Mission> missionList) {
        missionList.forEach(m -> this.missionMapper.updateByPrimaryKeySelective(m));
        new CacheUtilsNew("MAP_RESOURCE:" + missionList.get(0).getMapCode(), null, CacheEnum.DEL).run();
        return missionList.size();
    }

    @EnableValidate
    public ResponseParams<Boolean> deleteMission(@RequestBody GetMissionInfoRequest request) {
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(this.missionTService.deleteMission(Integer.valueOf(request.getId().intValue()), request.getUid()) > 0 ? 1 : 0));
    }

    @EnableValidate
    public ResponseParams<Boolean> saveMapResource(@RequestBody MapResourceSaveRequest request) {
        Map map = this.mapMapper.selectByPrimaryKey(request.getMapId());
        if (null == map) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_NOT_EXISTS);
        }
        int result = 0;
        switch (request.getResourceType()) {
            case "background": {
                map.setBackgroundUrl(request.getUrl());
                map.setUpdateBy(request.getUid());
                result = this.mapTService.updateMap(map);
                break;
            }
            case "ico": {
                PicGallery picGallery = FillModeUtils.fillPicGallery((Integer)request.getIcoType(), (String)request.getUrl(), (String)map.getMapCode(), (Integer)request.getIcoStatus());
                List picGalleryList = this.picGalleryMapper.selectPicGalleryList(picGallery);
                if (CollectionUtils.isEmpty((Collection)picGalleryList)) {
                    result = this.picGalleryMapper.insertSelective(picGallery);
                    break;
                }
                ((PicGallery)picGalleryList.get(0)).setOssUrl(request.getUrl());
                result = this.picGalleryMapper.updateByPrimaryKeySelective((PicGallery)picGalleryList.get(0));
                break;
            }
            case "dynamic": {
                Attach attach = this.attachMapper.selectByRelCodeAndOrder(map.getMapCode(), request.getFileOrder());
                if (null == attach) {
                    result = this.attachMapper.insertSelective(FillModeUtils.fillAttach((String)request.getUrl(), (String)map.getMapCode(), (Integer)request.getFileOrder()));
                    break;
                }
                attach.setFilePath(request.getUrl());
                result = this.attachMapper.updateByPrimaryKeySelective(attach);
                break;
            }
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @EnableValidate
    public ResponseParams<Boolean> deleteMapResource(@RequestBody MapResourceDeleteRequest request) {
        Map map = this.mapMapper.selectByPrimaryKey(request.getMapId());
        if (null == map) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_NOT_EXISTS);
        }
        int result = 0;
        switch (request.getResourceType()) {
            case "background": {
                map.setBackgroundUrl("");
                map.setUpdateBy(request.getUid());
                result = this.mapTService.updateMap(map);
                break;
            }
            case "ico": {
                result = this.picGalleryMapper.deleteByPrimaryKey(request.getResourceId());
                break;
            }
            case "dynamic": {
                result = this.attachMapper.deleteByPrimaryKey(request.getResourceId());
                break;
            }
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<List<MissionDto>> getMissionListByMapCode(@RequestParam(value="mapCode") String mapCode) {
        if (StringUtils.isBlank((CharSequence)mapCode)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Mission paramMission = new Mission();
        paramMission.setMapCode(mapCode);
        List missionList = this.missionMapper.selectMissionList(paramMission);
        if (CollectionUtils.isEmpty((Collection)missionList)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        ArrayList result = new ArrayList(missionList.size());
        missionList.forEach(item -> {
            MissionDto dto = new MissionDto();
            BeanUtils.copyProperties((Object)item, (Object)dto);
            result.add(dto);
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    @EnableValidate
    public ResponseParams<Boolean> updateMapResource(@RequestBody MissionSetDto dto) {
        Map map = this.mapMapper.selectByPrimaryKey(dto.getMapId());
        if (null == map) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_NOT_EXISTS);
        }
        MapResourceRel resourceRel = this.mapResourceRelMapper.selectByMapCode(map.getMapCode());
        map.setBackgroundUrl(dto.getBackgroundUrl());
        this.mapTService.updateMap(map);
        List attachList = ModeTransformUtils.transformToAttach((List)dto.getDynamicDtoList(), (String)resourceRel.getResourcePackageCode());
        List picGalleryList = ModeTransformUtils.transformToPicGallery((java.util.Map)dto.getIcoGroupMap(), (String)resourceRel.getResourcePackageCode());
        if (!CollectionUtils.isEmpty((Collection)attachList)) {
            this.attachMapper.deleteByRelCode(resourceRel.getResourcePackageCode());
            this.attachMapper.insertBatch(attachList);
        }
        if (!CollectionUtils.isEmpty((Collection)picGalleryList)) {
            this.picGalleryMapper.deleteByMapCode(resourceRel.getResourcePackageCode());
            this.picGalleryMapper.insertBatch(picGalleryList);
        }
        new CacheUtilsNew(this.redisCache, "MAP_RESOURCE:" + map.getMapCode(), null, CacheEnum.DEL).run();
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private boolean checkHideData(Mission mission) {
        if (!DataEnum.MissionType.TYPE_HIDE.getTypeValue().equals(mission.getMissionType())) {
            return true;
        }
        Mission missionParam = new Mission();
        missionParam.setMapCode(mission.getMapCode());
        missionParam.setMissionIndex(Integer.valueOf(mission.getParentCode()));
        List missions = this.missionMapper.selectMissionList(missionParam);
        if (CollectionUtils.isEmpty((Collection)missions)) {
            return false;
        }
        for (Mission v : missions) {
            if (DataEnum.MissionType.TYPE_HIDE.getTypeValue().equals(v.getMissionType())) continue;
            return true;
        }
        return false;
    }

    @EnableValidate
    public ResponseParams<ResponsePageResult<List<MissionFullDto>>> getMissionAndLevelList(@RequestBody GetMissionLevelListRequest request) {
        log.info("getMissionAndLevelList -- req:{}", (Object)request);
        PageHelper.startPage((int)(request.getPageNo() == null ? 1 : request.getPageNo()), (int)request.getPageSize());
        java.util.Map mission = MapUtils.java2Map((Object)request);
        List list = null;
        list = StringUtils.isNotEmpty((CharSequence)request.getApplyType()) ? this.missionMapper.selectUnusedMissionFullInfList(mission) : this.missionMapper.selectMissionFullInfList(mission);
        if (list == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build(null));
        }
        List result = this.fillMissionFullDtos(list);
        log.debug("getMissionAndLevelList - resposne :{}", (Object)result);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((List)list, (List)result));
    }

    public ResponseParams<List<MissionFullDto>> getMissionAndLevelListNoPage(@RequestBody GetMissionLevelListRequest request) {
        log.info("getMissionAndLevelList -- req:{}", (Object)request);
        java.util.Map mission = MapUtils.java2Map((Object)request);
        List list = this.missionMapper.selectMissionFullInfList(mission);
        if (list == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        List result = this.fillMissionFullDtos(list);
        log.debug("getMissionAndLevelList - resposne :{}", (Object)result);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    private List<MissionFullDto> fillMissionFullDtos(List<Mission> list) {
        ArrayList<MissionFullDto> result = new ArrayList<MissionFullDto>();
        for (Mission miss : list) {
            MissionFullDto dto = new MissionFullDto();
            BeanUtils.copyProperties((Object)miss, (Object)dto);
            if (miss.getMap() != null) {
                dto.setMapName(miss.getMap().getMapName());
                dto.setLevelOrder(miss.getMap().getLevelOrder());
            }
            if (miss.getLevel() != null) {
                dto.setLevelName(miss.getLevel().getLevelName());
                dto.setLevelCode(miss.getLevel().getLevelCode());
            }
            result.add(dto);
        }
        return result;
    }

    public ResponseParams<MissionDetailPageDto> missionDetailPageInfo(@RequestBody GetMissionDetailPageRequest request) {
        ResExam exam;
        log.info("missionDetailPageInfo -- req:{}", (Object)request);
        MissionDetailPageDto dto = new MissionDetailPageDto();
        FindUserByIdRequest fr = new FindUserByIdRequest();
        fr.setUid(request.getUid());
        fr.setIsIos(request.getIsIos());
        ResponseParams user = this.userInfoService.getUserInfoById(fr);
        UserInfoDto userInfo = (UserInfoDto)user.getData();
        if (null == userInfo) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR, null);
        }
        UserMission mission = this.userMissionMapper.selectByPrimaryKey(request.getMissionId());
        if (Objects.isNull(mission)) {
            mission = this.missionMapper.selectByPrimaryKey(request.getMissionId());
            if (Objects.isNull(mission)) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR, null);
            }
            dto.setRecordFlag(Boolean.FALSE);
        } else {
            dto.setRecordFlag(Boolean.valueOf(this.getRecordFlag(request.getUid(), (BaseMission)mission)));
        }
        Map map = this.mapMapper.selectByMapCode(mission.getMapCode());
        Integer resId = mission.getResourceId();
        if (null == resId) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_RESOURCE_IS_NULL);
        }
        Integer missionType = mission.getMissionType();
        Integer stoneNum = this.missionMapper.selectStoneNum(mission.getMissionType(), mission.getResourceId());
        short questionNum = 0;
        if (null == missionType) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR, null);
        }
        if (missionType == 2) {
            ResPeriodTest test = this.testMapper.selectByPrimaryKey(Long.valueOf(resId.toString()));
            if (null != test) {
                questionNum = test.getQuestionNum();
            }
        } else if (missionType == 3 && null != (exam = this.examMapper.selectByPrimaryKey(Long.valueOf(resId.toString())))) {
            questionNum = exam.getQuestionNum();
        }
        dto.setAwardStoneNum(stoneNum.intValue());
        dto.setBalance(userInfo.getBalance());
        dto.setQuestionNums((int)questionNum);
        dto.setStoneNums(userInfo.getStoneNum().intValue());
        dto.setUsedTime(1 * questionNum);
        dto.setMissionIndex(mission.getMissionIndex());
        dto.setClickAble(this.mapAndMissionUtilService.missionClickable(request.getUid(), mission.getMissionCode(), mission.getStatus()).booleanValue());
        dto.setLevelCode(map.getLevelCode());
        dto.setLevelOrder(map.getLevelOrder());
        String key = "SYS_RESOURCE_UPDATE:" + DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue() + ":" + userInfo.getUid() + ":" + mission.getMissionCode();
        String isNew = this.redisCache.get(key);
        if (isNew != null) {
            dto.setIsNew(Boolean.valueOf(true));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    private boolean getRecordFlag(String uid, BaseMission mission) {
        Integer missionType = mission.getMissionType();
        boolean recordFlag = false;
        switch (missionType) {
            case 1: {
                UserCourse userCourse = this.userCourseMapper.selectByUidAndMissionCode(uid, mission.getMissionCode());
                recordFlag = userCourse != null;
                break;
            }
            case 3: {
                String missionCode = mission.getMissionCode();
                QuestionRecord questionRecord = this.questionRecordMapper.selectByUidAndMissionId(uid, missionCode);
                recordFlag = questionRecord != null;
                break;
            }
            case 4: {
                Integer resourceId = mission.getResourceId();
                LexileLevelHistory lexileLevelHistory = this.lexileLevelHistoryMapper.findByUidAndEvaluationId(uid, resourceId);
                recordFlag = lexileLevelHistory != null;
                break;
            }
        }
        return recordFlag;
    }

    public ResponseParams<MapMissionDto> getLevelCodeById(@RequestParam(value="id", required=true) Long id) {
        UserMission mission = this.userMissionMapper.selectByPrimaryKey(id);
        if (Objects.isNull(mission)) {
            mission = this.missionMapper.selectByPrimaryKey(id);
        }
        Map map = this.mapMapper.selectByMapCode(mission.getMapCode());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)MapMissionDto.builder().missionIndex(mission.getMissionIndex()).levelCode(map.getLevelCode()).levelOrder(map.getLevelOrder()).mapCode(map.getMapCode()).build());
    }

    public ResponseParams<Boolean> updateStoneNum(@RequestBody UpdateStoneNumDto updateStoneNumDto) {
        String bookCode = updateStoneNumDto.getBookCode();
        Integer stoneNum = updateStoneNumDto.getStoneNum();
        this.courseBookMapper.updateStoneNumByBookCode(bookCode, stoneNum);
        List resourceIds = this.courseBookMapper.selectResourceIdsByBookCode(bookCode);
        if (resourceIds == null || resourceIds.size() == 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        this.missionMapper.updateStoneNumByBookCode(resourceIds, stoneNum);
        this.userMissionMapper.updateStoneNumByBookCode(resourceIds, stoneNum, updateStoneNumDto.getUid());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }
}

