/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.resource.api.EnTest;
import com.ella.resource.api.LexileResTypeService;
import com.ella.resource.api.MissionCourseService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.CourseBook;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.UserCourse;
import com.ella.resource.domain.UserCourseExample;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserMissionGiveStoneFlow;
import com.ella.resource.dto.SendMissionStoneDto;
import com.ella.resource.dto.appdto.AnalysisTestDto;
import com.ella.resource.dto.appdto.AnalysisTestInfoDto;
import com.ella.resource.dto.appdto.CourseAnswerInfoDto;
import com.ella.resource.dto.appdto.CourseMissionDto;
import com.ella.resource.dto.appdto.CourseTestInfoDto;
import com.ella.resource.dto.appdto.EnTestDto;
import com.ella.resource.dto.appdto.PutCourseAnswerDto;
import com.ella.resource.dto.appdto.SharePassResultDto;
import com.ella.resource.dto.appdto.TestRecordDto;
import com.ella.resource.dto.request.app.AnalysisCourseAnswerRequest;
import com.ella.resource.dto.request.app.CourseAnswerPutRequest;
import com.ella.resource.dto.request.app.GetAnalysisTestRequest;
import com.ella.resource.dto.request.app.GetEnTestListRequest;
import com.ella.resource.dto.request.app.TestAnswerRequest;
import com.ella.resource.dto.request.mission.GetMissionInfoRequest;
import com.ella.resource.mapper.CourseBookMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionGiveStoneFlowMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.MapAndMissionUtilService;
import com.ella.resource.service.transactional.RpcService;
import com.ella.resource.service.transactional.SysResourceOperateService;
import com.ella.resource.service.transactional.UserCourseReportService;
import com.ella.resource.service.transactional.UserMapTService;
import com.ella.resource.service.transactional.UserMissionTService;
import com.ella.resource.utils.ApplicationContextHelper;
import com.ella.resource.utils.EnTestTypeEnum;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.dto.UserInfoDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MissionCourseServiceImpl
implements MissionCourseService {
    private static final Logger log = LogManager.getLogger(MissionCourseServiceImpl.class);
    @Autowired
    private CourseBookMapper courseBookMapper;
    @Autowired
    private UserMissionGiveStoneFlowMapper userMissionGiveStoneFlowMapper;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private UserMapTService userMapTService;
    @Autowired
    private UserMissionTService userMissionTService;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private UserCourseReportService userCourseReportService;
    @Autowired
    private LexileResTypeService lexileResTypeService;
    @Autowired
    private MapAndMissionUtilService mapAndMissionUtilService;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private SysResourceOperateService sysResourceOperateService;
    @Autowired
    private UserMapMapper userMapMapper;

    @Transactional(rollbackFor={Exception.class})
    @EnableValidate
    public ResponseParams<CourseTestInfoDto> courseTestInfo(@RequestBody GetMissionInfoRequest request) {
        log.info("courseTestInfo param is {}", (Object)JSONObject.toJSONString((Object)request));
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission || 1 != mission.getMissionType()) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        UserCourseExample example = new UserCourseExample();
        example.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(mission.getMissionCode());
        List userCourses = this.userCourseMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)userCourses) || !((UserCourse)userCourses.get(0)).getProcess().equalsIgnoreCase(DataEnum.CourseProcess.TEST.getType())) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.COURSE_TEST_ORDER_ERROR);
        }
        CourseBook courseBook = this.courseBookMapper.selectByPrimaryKey(mission.getResourceId());
        if (null == courseBook) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.COURSE_NOT_EXISTS);
        }
        CourseTestInfoDto result = new CourseTestInfoDto();
        this.jointCourseTestInfo(result, courseBook, mission);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    @EnableValidate
    public ResponseParams<Boolean> finishCourseDownload(@RequestBody GetMissionInfoRequest request) {
        log.info("finishCourseDownload param is {}", (Object)JSONObject.toJSONString((Object)request));
        int result = 0;
        CourseMissionDto courseMissionDto = this.userMissionTService.getCourseMission(request.getId());
        if (null == courseMissionDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        this.insertUserMissionIfNotExist(request.getUid(), courseMissionDto.getMissionCode(), courseMissionDto.getMissionIndex(), courseMissionDto.getMapCode());
        this.userMapTService.updateUserMapAndMissionToDoing(request.getUid(), courseMissionDto.getMapCode(), courseMissionDto.getMissionCode());
        UserCourseExample example = new UserCourseExample();
        example.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(courseMissionDto.getMissionCode()).andBookCodeEqualTo(courseMissionDto.getBookCode());
        List userCourses = this.userCourseMapper.selectByExample(example);
        UserCourse userCourse = null;
        if (CollectionUtils.isEmpty((Collection)userCourses)) {
            userCourse = new UserCourse();
            userCourse.setId(Long.valueOf(IdWrokerUtils.nextId()));
            userCourse.setUid(request.getUid());
            userCourse.setBookCode(courseMissionDto.getBookCode());
            userCourse.setCourseCode(courseMissionDto.getCourseCode());
            userCourse.setCreateTime(new Date());
            userCourse.setLevelCode(courseMissionDto.getLexileLevel());
            userCourse.setMapCode(courseMissionDto.getMapCode());
            userCourse.setMissionCode(courseMissionDto.getMissionCode());
            userCourse.setProcess(DataEnum.CourseProcess.CLASSROOM.getType());
            userCourse.setStatus("NOTSTARTED");
            result = this.userCourseMapper.insertSelective(userCourse);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    @Transactional(rollbackFor={Exception.class})
    @EnableValidate
    public ResponseParams<Boolean> finishCourseMode(@RequestBody GetMissionInfoRequest request) {
        log.info("finishCourseMode param is {}", (Object)JSONObject.toJSONString((Object)request));
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission || 1 != mission.getMissionType()) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        if (!this.updateUserCourse(request.getUid(), mission.getMissionCode(), DataEnum.CourseProcess.SELF_STUDY.getType(), request.getLearnTime()).booleanValue()) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_COURSE_DATA_ERROR);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
    }

    @Transactional(rollbackFor={Exception.class})
    @EnableValidate
    public ResponseParams<Boolean> finishSelfStudyMode(@RequestBody GetMissionInfoRequest request) {
        log.info("finishSelfStudyMode param is {}", (Object)JSONObject.toJSONString((Object)request));
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission || 1 != mission.getMissionType()) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        if (!this.updateUserCourse(request.getUid(), mission.getMissionCode(), DataEnum.CourseProcess.TEST.getType(), request.getLearnTime()).booleanValue()) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_COURSE_DATA_ERROR);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
    }

    @EnableValidate
    public ResponseParams<List<EnTestDto>> testListPreview(@RequestBody GetEnTestListRequest request) {
        log.info("testListPreview param is {}", (Object)JSONObject.toJSONString((Object)request));
        Class clazz = EnTestTypeEnum.getTypeClass((String)request.getTestType());
        if (null == clazz) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        EnTest enTest = (EnTest)ApplicationContextHelper.getBean((Class)clazz);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)enTest.testListPreview(request));
    }

    @EnableValidate
    public ResponseParams<List<EnTestDto>> getEnTestList(@RequestBody GetEnTestListRequest request) {
        log.info("getEnTestList param is {}", (Object)JSONObject.toJSONString((Object)request));
        Class clazz = EnTestTypeEnum.getTypeClass((String)request.getTestType());
        if (null == clazz) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        EnTest enTest = (EnTest)ApplicationContextHelper.getBean((Class)clazz);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)enTest.getTestList(request));
    }

    @EnableValidate
    public ResponseParams<AnalysisTestDto> analysisTest(@RequestBody TestAnswerRequest request) {
        log.info("analysisTest param is {}", (Object)JSONObject.toJSONString((Object)request));
        Class clazz = EnTestTypeEnum.getTypeClass((String)request.getTestType());
        if (null == clazz) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        try {
            UserMission userMission = this.userMissionMapper.selectByPrimaryKey(request.getId());
            if (userMission != null) {
                UserMap userMap = this.userMapMapper.selectByUidAndMapCode(request.getUid(), userMission.getMapCode());
                this.mapAndMissionUtilService.needMissionUpdate(request.getUid(), userMap);
            }
        }
        catch (Exception e) {
            log.error("check mission insert error", (Throwable)e);
        }
        EnTest enTest = (EnTest)ApplicationContextHelper.getBean((Class)clazz);
        AnalysisTestInfoDto dto = enTest.analysisTestAnswer(request);
        AnalysisTestDto result = new AnalysisTestDto();
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        result.setStoneNum(Integer.valueOf(null == userInfoDto.getAccountDto() ? 0 : userInfoDto.getAccountDto().getStoneNum()));
        result.setEnName(StringUtils.isBlank((CharSequence)userInfoDto.getEnName()) ? userInfoDto.getMobile() : userInfoDto.getEnName());
        result.setBalance(userInfoDto.getBalance());
        result.setAnalysisTestInfo(dto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<TestRecordDto> getLastTimeQuestionRecord(@RequestBody GetEnTestListRequest request) {
        log.info("getLastTimeQuestionRecord param is {}", (Object)JSONObject.toJSONString((Object)request));
        Class clazz = EnTestTypeEnum.getTypeClass((String)request.getTestType());
        if (null == clazz) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        EnTest enTest = (EnTest)ApplicationContextHelper.getBean((Class)clazz);
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        TestRecordDto result = enTest.getLastTimeQuestionRecord(request);
        result.setStoneNum(Integer.valueOf(null == userInfoDto.getAccountDto() ? 0 : userInfoDto.getAccountDto().getStoneNum()));
        result.setEnName(StringUtils.isBlank((CharSequence)userInfoDto.getEnName()) ? userInfoDto.getMobile() : userInfoDto.getEnName());
        result.setBalance(userInfoDto.getBalance());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<Boolean> finishMissionPicDownload(@RequestBody GetMissionInfoRequest request) {
        log.info("finishMissionPicDownload param is {}", (Object)JSONObject.toJSONString((Object)request));
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission || 1 != mission.getMissionType()) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        this.insertUserMissionIfNotExist(request.getUid(), mission.getMissionCode(), mission.getMissionIndex(), mission.getMapCode());
        int result = this.userMapTService.updateUserMapAndMissionToDoing(request.getUid(), mission.getMapCode(), mission.getMissionCode());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @EnableValidate
    public ResponseParams<PutCourseAnswerDto> putCourseAnswerInfo(@RequestBody CourseAnswerPutRequest request) {
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission || "EXCEPTION".equals(mission.getStatus()) || "DELETE".equals(mission.getStatus())) {
            PutCourseAnswerDto data = new PutCourseAnswerDto();
            data.setBookCode(this.mapAndMissionUtilService.getBookCodeByMissionId(request.getId()));
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS, (Object)data);
        }
        UserCourse userCourse = this.userCourseMapper.selectByUidAndMissionCode(request.getUid(), mission.getMissionCode());
        if (Objects.isNull(userCourse)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.COURSE_NOT_EXISTS);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.userMissionTService.putCourseAnswerInfo(request, userCourse, mission.getId()));
    }

    @EnableValidate
    public ResponseParams<List<CourseAnswerInfoDto>> getCourseAnswerInfo(@RequestBody GetMissionInfoRequest request) {
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission) {
            CourseAnswerInfoDto data = new CourseAnswerInfoDto();
            data.setBookCode(this.mapAndMissionUtilService.getBookCodeByMissionId(request.getId()));
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        List result = this.userMissionTService.getCourseAnswerInfo(request.getUid(), mission.getMissionCode());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<AnalysisTestDto> analysisCourseAnswer(@RequestBody AnalysisCourseAnswerRequest request) {
        AnalysisTestDto result = new AnalysisTestDto();
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        CourseMissionDto courseMissionDto = this.userMissionTService.getCourseMission(request.getId());
        if (null == courseMissionDto) {
            AnalysisTestDto data = new AnalysisTestDto();
            data.setBookCode(this.mapAndMissionUtilService.getBookCodeByMissionId(request.getId()));
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS, (Object)data);
        }
        result.setMissionType(courseMissionDto.getMissionType());
        result.setStoneNum(userInfoDto.getStoneNum());
        result.setEnName(StringUtils.isBlank((CharSequence)userInfoDto.getEnName()) ? userInfoDto.getMobile() : userInfoDto.getEnName());
        result.setBalance(userInfoDto.getBalance());
        result.setPublisher(courseMissionDto.getPublisher());
        result.setLexileLevel(courseMissionDto.getLexileLevel());
        result.setAnalysisTestInfo(this.userMissionTService.analysisCourseAnswer(request, courseMissionDto));
        result.setLexileLevelCode(this.lexileResTypeService.getLexileLevelCode(courseMissionDto.getCourseCode(), result.getLexileLevel()));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<SharePassResultDto> sharePassResult(@RequestBody GetAnalysisTestRequest request) {
        UserInfoDto userInfoDto = this.rpcService.getUserInfoById(request.getUid());
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        SharePassResultDto result = new SharePassResultDto();
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission || 1 != mission.getMissionType()) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MISSION_NOT_EXISTS);
        }
        List userCourseReportList = this.userCourseReportService.getUserCourseReportByUidAndMissionCode(request.getUid(), mission.getMissionCode());
        if (CollectionUtils.isEmpty((Collection)userCourseReportList)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.COURSE_REPORT_NOT_EXISTS);
        }
        userCourseReportList.sort((c1, c2) -> c2.getVersion() - c1.getVersion());
        BeanUtils.copyProperties(userCourseReportList.get(0), (Object)result);
        result.setAvatar(userInfoDto.getAvatar());
        result.setName(StringUtils.isBlank((CharSequence)userInfoDto.getEnName()) ? userInfoDto.getMobile() : userInfoDto.getEnName());
        result.setAge(Integer.valueOf(null == userInfoDto.getAge() ? 0 : userInfoDto.getAge()));
        result.setStoneNum(Integer.valueOf(null == userInfoDto.getAccountDto() ? 0 : userInfoDto.getAccountDto().getStoneNum()));
        UserCourseExample userCourseExample = new UserCourseExample();
        userCourseExample.createCriteria().andUidEqualTo(request.getUid()).andStatusEqualTo("PASS");
        List userCourseList = this.userCourseMapper.selectByExample(userCourseExample);
        result.setReadBookNum(Integer.valueOf(userCourseList.size()));
        int totalLearnTime = this.userCourseReportService.countLearnTimeByUid(request.getUid());
        result.setLearnTimeToal(Integer.valueOf(totalLearnTime));
        return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<Boolean> missionSendPower(@RequestBody SendMissionStoneDto request) {
        Long missionId = request.getMissionId();
        UserMission userMission = this.userMissionMapper.selectByPrimaryKey(missionId);
        if (userMission == null) {
            return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        List userMissionGiveStoneFlows = this.userMissionGiveStoneFlowMapper.selectByUidAndMissionCode(request.getUid(), userMission.getMissionCode(), Integer.valueOf(0));
        if (userMissionGiveStoneFlows == null || userMissionGiveStoneFlows.size() == 0) {
            return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        Integer giveStoneNum = 0;
        for (UserMissionGiveStoneFlow userMissionGiveStoneFlow2 : userMissionGiveStoneFlows) {
            if (!DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_REPLACE.getValue().equals(userMissionGiveStoneFlow2.getType())) continue;
            giveStoneNum = giveStoneNum + userMissionGiveStoneFlow2.getGiveNum();
        }
        if (giveStoneNum == 0) {
            return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        this.rpcService.addUserStoneNum(request.getUid(), request.getMissionId(), giveStoneNum);
        userMissionGiveStoneFlows.forEach(userMissionGiveStoneFlow -> {
            userMissionGiveStoneFlow.setIsGive(Integer.valueOf(1));
            this.userMissionGiveStoneFlowMapper.updateByPrimaryKeySelective(userMissionGiveStoneFlow);
        });
        this.sysResourceOperateService.updateUserMissionSendStoneNum(request.getUid(), userMission.getMapCode(), userMission.getMissionCode(), giveStoneNum);
        return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private void insertUserMissionIfNotExist(String uid, String missionCode, Integer missionIndex, String mapCode) {
        if (StringUtils.isBlank((CharSequence)uid) || StringUtils.isBlank((CharSequence)missionCode) || StringUtils.isBlank((CharSequence)mapCode)) {
            return;
        }
        Map map = this.mapMapper.selectByMapCode(mapCode);
        this.userMissionTService.insertUserMissionIfNotExist(uid, missionCode, missionIndex, mapCode, map.getLevelCode());
    }

    private Boolean updateUserCourse(String uid, String missionCode, String process, Integer learnTime) {
        UserCourseExample example = new UserCourseExample();
        example.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(missionCode);
        List userCourses = this.userCourseMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)userCourses)) {
            return Boolean.FALSE;
        }
        UserCourse userCourse = (UserCourse)userCourses.get(0);
        userCourse.setLearnTime(Integer.valueOf(userCourse.getLearnTime() + learnTime));
        userCourse.setProcess(process);
        if (!"PASS".equalsIgnoreCase(userCourse.getStatus())) {
            userCourse.setStatus("DOING");
        }
        this.userCourseMapper.updateByPrimaryKeySelective(userCourse);
        return Boolean.TRUE;
    }

    private void jointCourseTestInfo(CourseTestInfoDto result, CourseBook courseBook, BaseMission mission) {
        result.setId(mission.getId());
        result.setMissionName(mission.getMissionName());
        result.setMissionStoneNum(courseBook.getTestNum());
        result.setNum(courseBook.getTestNum());
        result.setGrammarNum(courseBook.getGrammarNum());
        result.setPhonicNum(courseBook.getPhonicNum());
        result.setVocabularyNum(courseBook.getVocabularyNum());
    }
}

