/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.LevelService;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.Attach;
import com.ella.resource.domain.Level;
import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.LevelListDto;
import com.ella.resource.dto.request.GetLevelInfoRequest;
import com.ella.resource.dto.request.UpdateLevelRequest;
import com.ella.resource.mapper.AttachMapper;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.LexileResTypeMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.service.transactional.LevelTService;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.resource.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Service(value="levelServiceInner")
public class LevelServiceImpl
implements LevelService {
    private static final Logger log = LogManager.getLogger(LevelServiceImpl.class);
    @Autowired
    private LevelMapper levelMapper;
    @Autowired
    private LevelTService levelTService;
    @Autowired
    private MapTService mapTService;
    @Autowired
    private AttachMapper attachMapper;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private LexileResTypeMapper lexileResTypeMapper;

    public ResponseParams<List<LevelListDto>> getLevelList() {
        ArrayList result = new ArrayList();
        List levelList = this.levelMapper.selectAll();
        if (CollectionUtils.isEmpty((Collection)levelList)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
        }
        levelList.forEach(item -> {
            LevelListDto dto = new LevelListDto();
            BeanUtils.copyProperties((Object)item, (Object)dto);
            int mapNums = this.mapMapper.selectMapNums(dto.getLevelCode());
            dto.setMapNum(Integer.valueOf(mapNums));
            result.add(dto);
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    public ResponseParams<LevelDto> getLevelInfo(@RequestBody GetLevelInfoRequest request) {
        log.info("getLevelInfo request :{}", (Object)request);
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLevelInfo param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        LevelDto result = new LevelDto();
        Level level = this.levelMapper.selectByPrimaryKey(request.getId());
        if (null == level) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
        }
        BeanUtils.copyProperties((Object)level, (Object)result);
        result.setReadStartIndex(String.valueOf(level.getReadStartIndex()));
        result.setReadEndIndex(String.valueOf(level.getReadEndIndex()));
        Attach attach = this.attachMapper.selectByCode(level.getAttachCode());
        result.setAttachCode(null == attach ? "" : attach.getFilePath());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<Boolean> updateLevel(@RequestBody UpdateLevelRequest request) {
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("updateLevel param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)Boolean.FALSE);
        }
        Level level = new Level();
        BeanUtils.copyProperties((Object)request, (Object)level);
        level.setUpdateBy(request.getUid());
        int result = this.levelTService.updateLevel(level);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @EnableValidate
    public ResponseParams<Boolean> doSureLevel(@RequestBody GetLevelInfoRequest request) {
        Level tmp = this.levelMapper.selectByPrimaryKey(request.getId());
        if (null == tmp) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.LEVEL_NOT_EXISTS);
        }
        Level level = new Level();
        level.setId(request.getId());
        level.setUpdateBy(request.getUid());
        level.setUseStatus(Integer.valueOf(2));
        int result = this.levelTService.updateLevel(level);
        if (result > 0) {
            this.mapTService.doSureByLevelCode(tmp.getLevelCode(), request.getUid());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<List<LevelDto>> allEnableLevels() {
        ArrayList result = new ArrayList();
        List levels = this.levelMapper.listAllEnableLevels();
        if (!CollectionUtils.isEmpty((Collection)levels)) {
            levels.forEach(l -> {
                LevelDto ld = new LevelDto();
                BeanUtils.copyProperties((Object)l, (Object)ld);
                int mapNum = this.mapMapper.selectMapNums(l.getLevelCode());
                ld.setMapNum(Integer.valueOf(mapNum));
                int missionNum = this.mapMapper.selectMissionNums(l.getLevelCode());
                ld.setMissionNum(Integer.valueOf(missionNum));
                if (l.getReadStartIndex() != null && l.getReadStartIndex() < 0) {
                    ld.setReadStartIndex("BR" + l.getReadStartIndex() * -1 + "L");
                } else {
                    ld.setReadStartIndex(String.valueOf(l.getReadStartIndex()) + "L");
                }
                if (l.getReadEndIndex() != null && l.getReadEndIndex() < 0) {
                    ld.setReadEndIndex("BR" + l.getReadEndIndex() * -1 + "L");
                } else {
                    ld.setReadEndIndex(String.valueOf(l.getReadEndIndex()) + "L");
                }
                ld.setLevelDesc(LevelEnum.getDesc((String)ld.getLevelCode()));
                result.add(ld);
            });
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    public ResponseParams<LevelDto> defaultLevel() {
        LevelDto ld = null;
        Level level = this.levelMapper.defaultLevel();
        if (level != null) {
            ld = new LevelDto();
            BeanUtils.copyProperties((Object)level, (Object)ld);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ld);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, ld);
    }

    public ResponseParams<LevelDto> getLevelByCode(@RequestParam(value="code", required=true) String code) {
        LevelDto ld = null;
        Level level = this.levelMapper.selectByCode(code);
        if (level != null) {
            ld = new LevelDto();
            BeanUtils.copyProperties((Object)level, (Object)ld);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ld);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, ld);
    }

    public ResponseParams<LevelDto> getLevelByIndex(@RequestParam(value="levelIndex", required=true) Integer levelIndex) {
        LevelDto ld = null;
        Level level = this.levelMapper.getLevelByIndex(levelIndex);
        if (level != null) {
            ld = new LevelDto();
            BeanUtils.copyProperties((Object)level, (Object)ld);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ld);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, ld);
    }

    public ResponseParams<LevelDto> getLevelByCode(@RequestBody GetLevelInfoRequest request) {
        if (Objects.isNull(request) || StringUtils.isBlank((CharSequence)request.getLevelCode())) {
            log.info("getLevelByCode param error,{}", (Object)request);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Level level = this.levelMapper.selectByCode(request.getLevelCode());
        if (null == level) {
            return null;
        }
        LevelDto dto = new LevelDto();
        BeanUtils.copyProperties((Object)level, (Object)dto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    public ResponseParams<LevelDto> getLevelByAbility(@RequestParam(value="ability", required=true) Integer ability) {
        LevelDto ld = null;
        Level level = this.levelMapper.getLevelByAbility(ability);
        if (level != null) {
            ld = new LevelDto();
            BeanUtils.copyProperties((Object)level, (Object)ld);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ld);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, ld);
    }

    public ResponseParams<List<String>> getLexileResTypeCodeList() {
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.lexileResTypeMapper.selectResTypeCodeList());
    }

    public String transferLexileLevel(String lexileLevel) {
        if (lexileLevel == null || lexileLevel.equals("")) {
            return "";
        }
        if ((lexileLevel = lexileLevel.replace("L", "")).contains("BR")) {
            lexileLevel = lexileLevel.replace("BR", "-");
        }
        String levelCode = "";
        ResponseParams levelResp = this.getLevelByAbility(Integer.valueOf(lexileLevel));
        if (CommonRetCode.isSuccess((String)levelResp.getCode())) {
            LevelDto level = (LevelDto)levelResp.getData();
            levelCode = level.getLevelCode();
        }
        return levelCode;
    }
}

