/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.IraReportService;
import com.ella.resource.domain.IraReadReport;
import com.ella.resource.domain.IraReadReportExample;
import com.ella.resource.domain.UserChildrenInfo;
import com.ella.resource.dto.IraFirstAbilityReportDto;
import com.ella.resource.dto.IraMapDto;
import com.ella.resource.dto.IraReadRecordDto;
import com.ella.resource.dto.IraReadRecordStartAndEndTime;
import com.ella.resource.dto.IraReportDto;
import com.ella.resource.dto.request.ira.GetIraReportRequest;
import com.ella.resource.dto.request.ira.ReadRecordIraRequest;
import com.ella.resource.mapper.IraReadRecordMapper;
import com.ella.resource.mapper.IraReadReportMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.UserMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.IraReportTService;
import com.ella.resource.utils.ResponseParamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IraReportServiceImpl
implements IraReportService {
    private static final Logger log = LogManager.getLogger(IraReportServiceImpl.class);
    @Autowired
    IraReportTService iraReportTService;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private IraReadRecordMapper iraReadRecordMapper;
    @Autowired
    private DistributedCache redis;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private IraReadReportMapper iraReadReportMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;

    public ResponseParams<IraReportDto> getIraReport(@RequestBody GetIraReportRequest request) {
        String status;
        IraReportDto result;
        log.info("\u83b7\u53d6IRA\u62a5\u544a:{}", (Object)JSONObject.toJSONString((Object)request));
        if (StringUtils.isBlank((CharSequence)request.getUid()) || StringUtils.isBlank((CharSequence)request.getMapCode())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        String reportData = this.redis.get("BOE:EN:IRA:REPORT:DATA:" + request.getUid() + ":" + request.getMapCode());
        if (StringUtils.isBlank((CharSequence)reportData)) {
            result = this.iraReportTService.getIraReport(request);
            if (result != null) {
                List firstAbilityList;
                int passCount;
                String reportCode = result.getReportCode();
                StringBuilder builder = new StringBuilder();
                if (result.getReadCountIncrease() != null && result.getReadCountIncrease() > 0) {
                    builder.append("\u9605\u8bfb\u91cf");
                }
                Date reportTime = result.getReportTime();
                Date lastReportTime = result.getLastReportTime();
                if (reportTime != null && lastReportTime != null && (passCount = this.iraReportTService.getPassCount(request.getUid(), request.getMapCode(), reportTime, lastReportTime)) > 0) {
                    result.setNewPass(true);
                }
                HashSet<Integer> firstTypeSet = new HashSet<Integer>();
                if (StringUtils.isNotBlank((CharSequence)reportCode) && CollectionUtils.isNotEmpty((Collection)(firstAbilityList = this.iraReportTService.getIraFirstAbility(reportCode)))) {
                    for (IraFirstAbilityReportDto firstAbility : firstAbilityList) {
                        String firstCode;
                        if (firstAbility == null || !StringUtils.isNotBlank((CharSequence)(firstCode = firstAbility.getFirstCode()))) continue;
                        int iraNumChange = firstAbility.getIraNumChange();
                        if (iraNumChange > 0) {
                            firstTypeSet.add(firstAbility.getFirstType());
                        }
                        List secondAbilityList = this.iraReportTService.listIraSecondAbility(firstCode);
                        firstAbility.setSecondAbilitys(secondAbilityList);
                    }
                    result.setFirstAbilitys(firstAbilityList);
                }
                if ((builder = this.getFirstAbilityUpText(builder, firstTypeSet)).length() > 0) {
                    result.setFirstAbilityUpText("\u4f60\u7684" + builder.toString() + "\u53c8\u6709\u4e86\u63d0\u5347");
                }
            } else {
                UserChildrenInfo userInfo = this.userMapper.getChildrenByUid(request.getUid());
                result = new IraReportDto();
                result.setAvatar(userInfo.getAvatar());
                result.setUserName(userInfo.getName());
            }
            this.redis.set("BOE:EN:IRA:REPORT:DATA:" + request.getUid() + ":" + request.getMapCode(), (Object)JSONObject.toJSONString((Object)result), 3600);
        } else {
            result = (IraReportDto)JSONObject.parseObject((String)reportData, IraReportDto.class);
        }
        if (result != null && StringUtils.isNotBlank((CharSequence)result.getReportCode()) && StringUtils.isBlank((CharSequence)(status = this.redis.get("BOE:EN:IRA:REPORT_CODE:" + result.getReportCode())))) {
            result.setFirstShow(true);
            this.redis.set("BOE:EN:IRA:REPORT_CODE:" + result.getReportCode(), (Object)"success");
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    private StringBuilder getFirstAbilityUpText(StringBuilder builder, Set<Integer> firstTypeSet) {
        if (CollectionUtils.isNotEmpty(firstTypeSet)) {
            if (firstTypeSet.contains(2)) {
                if (builder.length() > 0) {
                    builder.append("\u3001");
                }
                builder.append("\u8bc6\u5b57\u80fd\u529b");
            }
            if (firstTypeSet.contains(1)) {
                if (builder.length() > 0) {
                    builder.append("\u3001");
                }
                builder.append("\u9605\u8bfb\u7406\u89e3");
            }
            if (firstTypeSet.contains(3)) {
                if (builder.length() > 0) {
                    builder.append("\u3001");
                }
                builder.append("\u53e3\u8bed\u80fd\u529b");
            }
            if (firstTypeSet.contains(4)) {
                if (builder.length() > 0) {
                    builder.append("\u3001");
                }
                builder.append("\u542c\u529b\u7406\u89e3");
            }
        }
        return builder;
    }

    public ResponseParams<Boolean> insertReadRecordIra(@RequestBody ReadRecordIraRequest request) {
        IraReadRecordDto readRecord;
        int result;
        String missionCode;
        String missionId = request.getMissionId();
        if (StringUtils.isBlank((CharSequence)missionId)) {
            log.error("\u7528\u6237IRA\u9605\u8bfb\u65f6\u957f\u7edf\u8ba1missionId\u4e3a\u7a7a:{}", (Object)JSONObject.toJSONString((Object)request));
        }
        if (StringUtils.isBlank((CharSequence)(missionCode = this.userMissionMapper.getMissionCodeByMissionId(missionId)))) {
            log.error("\u7528\u6237IRA\u9605\u8bfb\u65f6\u957f\u7edf\u8ba1 missionCode\u4e0d\u5b58\u5728:{}", (Object)JSONObject.toJSONString((Object)request));
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)true);
        }
        String mapCode = this.redis.get("BOE:EN:MISSIONCODE:MAPCODE:" + missionCode);
        if (StringUtils.isBlank((CharSequence)mapCode)) {
            mapCode = this.missionMapper.getMapCodeByMissionCode(missionCode);
            this.redis.set("BOE:EN:MISSIONCODE:MAPCODE:" + missionCode, (Object)mapCode, 180);
        }
        String readStartEnds = request.getReadStartEnds();
        List list = (List)JSONObject.parseObject((String)readStartEnds, List.class);
        long secondNum = 0L;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (JSONObject jsonObject : list) {
                IraReadRecordStartAndEndTime time = (IraReadRecordStartAndEndTime)JSONObject.toJavaObject((JSON)jsonObject, IraReadRecordStartAndEndTime.class);
                secondNum += this.getMinuteTime(time);
            }
        }
        if ((result = this.iraReadRecordMapper.insertIraReadRecord(readRecord = IraReadRecordDto.builder().mapCode(mapCode).missionCode(missionCode).uid(request.getUid()).commitTime(new Date()).readTime(Integer.valueOf((int)Math.ceil((double)secondNum / 60.0))).build())) != 1) {
            log.error("\u7528\u6237IRA\u9605\u8bfb\u65f6\u957f\u7edf\u8ba1\u672a\u8ba1\u5165\u6570\u636e\u5e93:{}", (Object)JSONObject.toJSONString((Object)readRecord));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private long getMinuteTime(IraReadRecordStartAndEndTime time) {
        if (Objects.isNull(time.getStart()) || Objects.isNull(time.getEnd())) {
            return 0L;
        }
        return time.getEnd().getTime() - time.getStart().getTime();
    }

    public ResponseParams<List<IraMapDto>> getIraReportUpdateStatus(@RequestParam(value="cid") String cid) {
        if (StringUtils.isNotBlank((CharSequence)cid)) {
            List allMaps = this.getAllMapInfo();
            IraReadReportExample iraReadReportExample = new IraReadReportExample();
            iraReadReportExample.createCriteria().andUidEqualTo(cid);
            List iraReadReportList = this.iraReadReportMapper.selectByExample(iraReadReportExample);
            if (CollectionUtils.isEmpty((Collection)iraReadReportList)) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
            }
            List mapCodeList = iraReadReportList.stream().map(IraReadReport::getMapCode).collect(Collectors.toList());
            Map<String, String> mapCodeReportCodeMap = iraReadReportList.stream().collect(Collectors.toMap(IraReadReport::getMapCode, IraReadReport::getReportCode));
            allMaps = allMaps.stream().filter(e -> mapCodeList.contains(e.getMapCode())).collect(Collectors.toList());
            for (IraMapDto iraMapDto : allMaps) {
                String mapCode = iraMapDto.getMapCode();
                String reportCode = mapCodeReportCodeMap.get(mapCode);
                if (!StringUtils.isNotBlank((CharSequence)reportCode)) continue;
                String status = this.redis.get("BOE:EN:IRA:REPORT_CODE:" + reportCode);
                if (StringUtils.isBlank((CharSequence)status)) {
                    iraMapDto.setNewReport(Boolean.TRUE);
                    continue;
                }
                iraMapDto.setNewReport(Boolean.FALSE);
            }
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, allMaps);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    private List<IraMapDto> getAllMapInfo() {
        String mapInfoStr = this.redis.get("EN_MAP_INFO:");
        ArrayList<IraMapDto> allMaps = new ArrayList();
        if (StringUtils.isBlank((CharSequence)mapInfoStr)) {
            allMaps = this.mapMapper.getAllMapsOrdered();
            mapInfoStr = JSONObject.toJSONString(allMaps);
            this.redis.set("EN_MAP_INFO:", (Object)mapInfoStr);
            this.redis.expire("EN_MAP_INFO:", 900);
        } else {
            List list = (List)JSONObject.parseObject((String)mapInfoStr, List.class);
            for (Object mapObj : list) {
                IraMapDto map = (IraMapDto)JSONObject.parseObject((String)mapObj.toString(), IraMapDto.class);
                allMaps.add(map);
            }
        }
        return allMaps;
    }
}

