/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.common.api.EllabookUserClient;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.HomePageService;
import com.ella.resource.api.LevelService;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMapExample;
import com.ella.resource.dto.MapDto;
import com.ella.resource.dto.appdto.HomePageDto;
import com.ella.resource.dto.appdto.LevelPopupDto;
import com.ella.resource.dto.appdto.PicBookPopupDto;
import com.ella.resource.dto.appdto.UserMapDto;
import com.ella.resource.dto.request.BaseRequest;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.PictureBookLevelRelMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionGiveStoneMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.LevelTService;
import com.ella.resource.utils.MapUtils;
import com.ella.resource.utils.ModeTransformUtils;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.api.UserInfoService;
import com.ella.user.dto.UserInfoDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class HomePageServiceImpl
implements HomePageService {
    private static final Logger log = LogManager.getLogger(HomePageServiceImpl.class);
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private LevelTService levelTService;
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private PictureBookLevelRelMapper pictureBookLevelRelMapper;
    @Autowired
    private UserMissionGiveStoneMapper userMissionGiveStoneMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private LevelService levelService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    EllabookUserClient ellabookUserClient;

    public ResponseParams<LevelPopupDto> levelPopup(@RequestParam(value="uid") String uid, @RequestParam(value="levelCode") String levelCode) {
        if (StringUtils.isBlank((CharSequence)levelCode)) {
            levelCode = LevelEnum.LV1.getCode();
        }
        if (StringUtils.isBlank((CharSequence)uid)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.getLevelPopup(uid, levelCode));
        }
        String tmpKey = this.redisCache.get("EXPERIENCE_POPUP:" + uid);
        if (StringUtils.isBlank((CharSequence)tmpKey)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        LevelPopupDto result = this.getLevelPopup(uid, levelCode);
        if (null == result) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.LEVEL_NOT_EXISTS);
        }
        this.redisCache.del("EXPERIENCE_POPUP:" + uid);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<HomePageDto> userHomePage(@RequestBody BaseRequest request) {
        UserInfoDto userInfoDto = null;
        ResponseParams userInfoResponse = this.userInfoService.selectUserByUid(request.getUid());
        if (CommonRetCode.SUCCESS.getCode().equals(userInfoResponse.getCode())) {
            userInfoDto = (UserInfoDto)userInfoResponse.getData();
        }
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        HomePageDto result = new HomePageDto();
        result.setUid(request.getUid());
        result.setEnName(StringUtils.isBlank((CharSequence)userInfoDto.getEnName()) ? userInfoDto.getMobile() : userInfoDto.getEnName());
        if (StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)userInfoDto.getIsVisitor())) {
            result.setUserMapDtoList(this.getUserMap(result, userInfoDto));
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
        }
        result.setLevel(this.levelService.transferLexileLevel(userInfoDto.getLexileLevel()));
        result.setLexileLevel(userInfoDto.getLexileLevel());
        result.setAvatar(userInfoDto.getAvatar());
        result.setUserMapDtoList(this.getUserMap(result, userInfoDto));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<PicBookPopupDto> picBookPopup(@RequestParam(value="uid") String uid) {
        PicBookPopupDto result = new PicBookPopupDto();
        if (StringUtils.isBlank((CharSequence)uid)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
        }
        UserInfoDto userInfoDto = null;
        ResponseParams userInfoResponse = this.userInfoService.selectUserByUid(uid);
        if (CommonRetCode.SUCCESS.getCode().equals(userInfoResponse.getCode())) {
            userInfoDto = (UserInfoDto)userInfoResponse.getData();
        }
        if (null == userInfoDto) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_EXISTS);
        }
        result.setNeedPopup(Boolean.TRUE);
        if (StringUtils.isBlank((CharSequence)userInfoDto.getEnName())) {
            result.setName(userInfoDto.getEnName());
        } else {
            String mobile = this.getMobileFromEllaBook(uid);
            result.setName(mobile);
        }
        result.setPicBookNum(this.pictureBookLevelRelMapper.countByLevelCode(userInfoDto.getLevel()));
        this.redisCache.del("PIC_BOOK_POPUP:" + uid);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    private String getMobileFromEllaBook(String uid) {
        JSONObject date = new JSONObject();
        date.put("uid", (Object)uid);
        String mobile = this.ellabookUserClient.getMobile(date);
        System.out.println(mobile);
        return mobile;
    }

    private List<UserMapDto> getUserMap(HomePageDto result, UserInfoDto userInfoDto) {
        String level = "";
        UserMap doingUserMap = this.userMapMapper.selectDoingUserMap(userInfoDto.getUid());
        if (doingUserMap != null) {
            level = doingUserMap.getLevelCode();
        }
        ArrayList<UserMapDto> userMapDtoList = new ArrayList<UserMapDto>();
        List tmpBos = this.userMapMapper.selectUserMaps(userInfoDto.getUid(), StringUtils.isBlank((CharSequence)level) ? LevelEnum.LV1.getCode() : level);
        result.setDoingLevel(StringUtils.isBlank((CharSequence)level) ? LevelEnum.LV1.getCode() : level);
        ArrayList tmpMapCodes = new ArrayList();
        ArrayList userMaps = new ArrayList();
        tmpBos.forEach(t -> {
            MapDto tmp = new MapDto();
            BeanUtils.copyProperties((Object)t, (Object)tmp);
            userMaps.add(tmp);
            tmpMapCodes.add(tmp.getMapCode());
        });
        java.util.Map mapAndPassMissionNum = new HashMap();
        if (!CollectionUtils.isEmpty(tmpMapCodes)) {
            mapAndPassMissionNum = ModeTransformUtils.getStringKStringVMap((List)this.userMissionMapper.countByUidGroupByMapCode(userInfoDto.getUid(), "PASS", tmpMapCodes), (String)"mapCode", (String)"num");
        }
        for (MapDto mapDto : userMaps) {
            UserMapDto userMapDto = this.fillUserMapDto(mapDto, mapAndPassMissionNum, userInfoDto);
            if ("DOING".equalsIgnoreCase(mapDto.getStatus())) {
                result.setMapIndex(userMapDto.getMapIndex());
                userMapDto.setProcessStatus("DOING");
            }
            userMapDtoList.add(userMapDto);
            Integer giveStoneNum = this.userMissionGiveStoneMapper.selectSumSendStoneNumByMap(userInfoDto.getUid(), mapDto.getMapCode());
            userMapDto.setGotStoneNum(Integer.valueOf(userMapDto.getGotStoneNum() + giveStoneNum));
        }
        result.setTotalMissionNum(this.missionMapper.selectTotalMissionNums(StringUtils.isBlank((CharSequence)level) ? LevelEnum.LV1.getCode() : level));
        result.setUserTotalMissionNum(Integer.valueOf(this.userMissionMapper.countByUidAndLevelCode(userInfoDto.getUid(), level)));
        return userMapDtoList;
    }

    private UserMapDto fillUserMapDto(MapDto mapDto, java.util.Map<String, String> mapAndPassMissionNum, UserInfoDto userInfoDto) {
        UserMapDto tmp = UserMapDto.builder().id(mapDto.getId()).icoUrl(mapDto.getIcoUrl()).mapName(mapDto.getLevelName() + mapDto.getMapName()).missionNum(mapDto.getMissionNum()).mapIndex(mapDto.getLevelOrder()).dynamicUrl(mapDto.getDynamicUrl()).gotStoneNum(Integer.valueOf(Objects.nonNull(mapDto.getStoneNum()) ? mapDto.getStoneNum() : 0)).build();
        if (Objects.nonNull(mapDto.getUserMapFlag()) && mapDto.getUserMapFlag().booleanValue()) {
            tmp.setProcessStatus("NOTSTARTED");
            tmp.setStatus("LOCKED");
            tmp.setSurplusStoneNum(Integer.valueOf(this.mapMapper.countTotalStoneNum(mapDto.getMapCode())));
            tmp.setUserMissionNum(Integer.valueOf(0));
        } else {
            Map map;
            tmp.setProcessStatus(mapDto.getStatus());
            tmp.setStatus("UNLOCKED");
            tmp.setUserMissionNum(Integer.valueOf(Objects.nonNull(mapAndPassMissionNum.get(mapDto.getMapCode())) ? Integer.valueOf(mapAndPassMissionNum.get(mapDto.getMapCode())) : 0));
            if (StringUtils.isBlank((CharSequence)userInfoDto.getLevel()) && !"Y".equalsIgnoreCase(userInfoDto.getIsVip()) && (map = this.mapMapper.selectByMapCode(mapDto.getMapCode())) != null) {
                tmp.setMissionNum(map.getMissionNum());
            }
            tmp.setSurplusStoneNum(Integer.valueOf(this.mapMapper.countTotalStoneNum(mapDto.getMapCode())));
        }
        return tmp;
    }

    private List<UserMapDto> getUserMapBak(HomePageDto result) {
        String levelCode = StringUtils.isBlank((CharSequence)result.getLevel()) ? LevelEnum.LV1.getCode() : result.getLevel();
        ArrayList<UserMapDto> userMapDtoList = new ArrayList<UserMapDto>();
        Map mapParam = new Map();
        mapParam.setStatus("SURE");
        mapParam.setLevelCode(levelCode);
        List mapDtoList = this.mapMapper.selectMapList(mapParam);
        if (CollectionUtils.isEmpty((Collection)mapDtoList)) {
            return userMapDtoList;
        }
        UserMapExample example = new UserMapExample();
        example.createCriteria().andUidEqualTo(result.getUid());
        java.util.Map userMaps = ModeTransformUtils.getCodeAndTMap((List)this.userMapMapper.selectByExample(example), (String)"mapCode");
        HashMap stoneMap = new HashMap();
        this.mapMapper.countMapStoneNumByLevelCode(levelCode).forEach(v -> stoneMap.put(v.get("mapCode").toString(), Integer.parseInt(v.get("num").toString())));
        UserMap prevUserMap = null;
        for (MapDto dto : mapDtoList) {
            UserMapDto tmp = new UserMapDto();
            tmp.setId(dto.getId());
            tmp.setIcoUrl(dto.getIcoUrl());
            tmp.setMapName(dto.getLevelName() + dto.getMapName());
            tmp.setMissionNum(dto.getMissionNum());
            tmp.setMapIndex(dto.getLevelOrder());
            tmp.setDynamicUrl(dto.getDynamicUrl());
            if (!CollectionUtils.isEmpty((java.util.Map)userMaps) && userMaps.containsKey(dto.getMapCode())) {
                UserMap v2 = (UserMap)userMaps.get(dto.getMapCode());
                tmp.setProcessStatus(v2.getStatus());
                if (MapUtils.isDoingMap((UserMap)v2, prevUserMap, (String)levelCode).booleanValue()) {
                    result.setMapIndex(v2.getMapIndex());
                    tmp.setProcessStatus("DOING");
                }
                tmp.setStatus("UNLOCKED");
                tmp.setUserMissionNum(v2.getMissionNum());
                tmp.setGotStoneNum(v2.getStoneNum());
                tmp.setSurplusStoneNum(Integer.valueOf((Integer)stoneMap.get(dto.getMapCode()) - (null == v2.getStoneNum() ? 0 : v2.getStoneNum())));
                prevUserMap = v2;
            } else {
                tmp.setStatus(null == prevUserMap ? "UNLOCKED" : "LOCKED");
                tmp.setProcessStatus("NOTSTARTED");
                tmp.setSurplusStoneNum((Integer)stoneMap.get(dto.getMapCode()));
            }
            userMapDtoList.add(tmp);
            result.setTotalMissionNum(Integer.valueOf(result.getTotalMissionNum() + (null == tmp.getMissionNum() ? 0 : tmp.getMissionNum())));
            result.setUserTotalMissionNum(Integer.valueOf(result.getUserTotalMissionNum() + (null == tmp.getUserMissionNum() ? 0 : tmp.getUserMissionNum())));
        }
        return userMapDtoList;
    }

    private LevelPopupDto getLevelPopup(String uid, String levelCode) {
        LevelPopupDto result = this.levelTService.getLevelDtoByCode(levelCode);
        if (null == result) {
            return null;
        }
        Map param = new Map();
        param.setLevelCode(levelCode);
        param.setStatus("SURE");
        if (uid != null && !uid.equals("")) {
            result.setMapId(this.mapMapper.selectFirstMapIdByLevelCode(uid, levelCode));
        } else {
            List mapDtoList = this.mapMapper.selectMapList(param);
            if (!CollectionUtils.isEmpty((Collection)mapDtoList)) {
                result.setMapId(((MapDto)mapDtoList.get(0)).getId());
            }
        }
        return result;
    }
}

