/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.mapper.cache.handler;

import com.ella.frame.cache.DistributedCache;
import com.ella.resource.domain.Mission;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.cache.handler.ICacheHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MissionMapperCacheHandler
implements ICacheHandler {
    @Autowired
    MissionMapper missionMapper;
    @Autowired
    private DistributedCache redisCache;

    public void evictCache(String resourceName, Object[] args) {
        if (args == null || args.length == 0) {
            this.redisCache.batchDelLike(resourceName + "*");
            return;
        }
        Mission mission = (Mission)args[0];
        Long id = mission.getId();
        Mission data = this.missionMapper.selectByPrimaryKey(id);
        if (data == null) {
            return;
        }
        String missionCode = data.getMissionCode();
        String key = "db_resource_" + resourceName + missionCode;
        this.redisCache.del(key);
    }
}

