/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.configure;

import com.ella.resource.domain.Map;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMission;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.UserLevelResourceVersionMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionMapper;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FillMapAndMissionFiledAspect {
    private static final Logger log = LogManager.getLogger(FillMapAndMissionFiledAspect.class);
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private UserLevelResourceVersionMapper userLevelResourceVersionMapper;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;

    @Pointcut(value="execution(* com.ella.resource.mapper.UserMapMapper.*(..))")
    public void fillMap() {
    }

    @Pointcut(value="execution(* com.ella.resource.mapper.UserMissionMapper.*(..))")
    public void fillMission() {
    }

    @Around(value="fillMap()")
    public Object fillMap(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Object resultObj = joinPoint.proceed(args);
        if (resultObj == null) {
            return resultObj;
        }
        Signature signature = joinPoint.getSignature();
        Class returnType = ((MethodSignature)signature).getReturnType();
        if (returnType.equals(UserMap.class)) {
            UserMap userMap = (UserMap)resultObj;
            this.fillUserMap(userMap);
        } else if (returnType.equals(List.class)) {
            List resultObjx = (List)resultObj;
            if (resultObjx == null || resultObjx.size() == 0) {
                return resultObj;
            }
            Object item = resultObjx.get(0);
            if (item.getClass().equals(UserMap.class) || item instanceof UserMap) {
                for (Object o : resultObjx) {
                    UserMap userMap = (UserMap)o;
                    this.fillUserMap(userMap);
                }
            }
        }
        return resultObj;
    }

    private void fillUserMap(UserMap userMap) {
        String mapCode = userMap.getMapCode();
        Map map = this.mapMapper.selectByMapCode(mapCode);
        if (map == null) {
            return;
        }
        userMap.setMapName(map.getMapName());
        userMap.setLevelCode(map.getLevelCode());
        userMap.setLevelOrder(map.getLevelOrder());
        if (map.getLevelOrder() != null && !map.getLevelOrder().equals(userMap.getLevelOrder())) {
            userMap.setLevelOrder(map.getLevelOrder());
            this.userMapMapper.updateByPrimaryKeySelective(userMap);
        }
        if (map.getLevelOrder() != null && !map.getLevelOrder().equals(userMap.getMapIndex())) {
            userMap.setMapIndex(map.getLevelOrder());
            this.userMapMapper.updateByPrimaryKeySelective(userMap);
        }
        userMap.setMissionNum(map.getMissionNum());
        userMap.setIcoUrl(map.getIcoUrl());
        userMap.setBackgroundUrl(map.getBackgroundUrl());
        userMap.setBottomUrl(map.getBottomUrl());
    }

    @Around(value="fillMission()")
    public Object fillMission(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Object resultObj = joinPoint.proceed(args);
        if (resultObj == null) {
            return resultObj;
        }
        Signature signature = joinPoint.getSignature();
        Class returnType = ((MethodSignature)signature).getReturnType();
        if (returnType.equals(UserMission.class)) {
            UserMission userMission = (UserMission)resultObj;
            this.fillUserMission(userMission);
        } else if (returnType.equals(List.class)) {
            List resultObjx = (List)resultObj;
            if (resultObjx == null || resultObjx.size() == 0) {
                return resultObj;
            }
            Object item = resultObjx.get(0);
            if (item.getClass().equals(UserMission.class)) {
                for (Object o : resultObjx) {
                    UserMission userMission = (UserMission)o;
                    this.fillUserMission(userMission);
                }
                return resultObjx;
            }
        }
        return resultObj;
    }

    private void fillUserMission(UserMission userMission) {
        String missionCode = userMission.getMissionCode();
        Mission mission = this.missionMapper.selectByMissionCode(missionCode);
        if (mission == null) {
            return;
        }
        userMission.setMissionName(mission.getMissionName());
        userMission.setMissionType(mission.getMissionType());
        if (mission.getMissionIndex() != null && !mission.getMissionIndex().equals(userMission.getMissionIndex())) {
            userMission.setMissionIndex(mission.getMissionIndex());
            this.userMissionMapper.updateByPrimaryKeySelective(userMission);
        }
        if (mission.getPassNum() != null && !mission.getPassNum().equals(userMission.getPassNum())) {
            userMission.setPassNum(mission.getPassNum());
            this.userMissionMapper.updateByPrimaryKeySelective(userMission);
        }
        userMission.setMissionStoneNum(mission.getMissionStoneNum());
        userMission.setMapCode(mission.getMapCode());
        userMission.setPassNum(mission.getPassNum());
    }
}

