/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.frame.cache.DistributedCache;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.frame.lock.DistributedLocker;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.constants.CourseResultEnum;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.UserCourse;
import com.ella.resource.domain.UserCourseInfo;
import com.ella.resource.domain.UserCourseInfoExample;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserMissionExample;
import com.ella.resource.domain.UserMissionGiveStone;
import com.ella.resource.domain.UserMissionGiveStoneFlow;
import com.ella.resource.domain.WordSentenceExample;
import com.ella.resource.dto.appdto.AnalysisTestInfoDto;
import com.ella.resource.dto.appdto.CourseAnswerInfoDto;
import com.ella.resource.dto.appdto.CourseMissionDto;
import com.ella.resource.dto.appdto.PutCourseAnswerDto;
import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import com.ella.resource.dto.request.app.AnalysisCourseAnswerRequest;
import com.ella.resource.dto.request.app.CourseAnswerPutRequest;
import com.ella.resource.mapper.CourseQuestionAnswerMapper;
import com.ella.resource.mapper.CourseQuestionOptionMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.UserCourseInfoMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionGiveStoneFlowMapper;
import com.ella.resource.mapper.UserMissionGiveStoneMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.mapper.WordSentenceMapper;
import com.ella.resource.service.transactional.MapAndMissionUtilService;
import com.ella.resource.service.transactional.MissionTService;
import com.ella.resource.service.transactional.RpcService;
import com.ella.resource.service.transactional.SysResourceOperateService;
import com.ella.resource.service.transactional.UserCourseReportService;
import com.ella.resource.service.transactional.UserMapTService;
import com.ella.resource.service.transactional.UserMissionTService;
import com.ella.resource.utils.RedisAssistUtils;
import com.ella.resource.wrapper.CourseCheckWrapper;
import com.ella.resource.wrapper.UserCourseReportDto;
import com.ella.resource.wrapper.UserCourseWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserMissionTServiceImpl
implements UserMissionTService {
    private static final Logger log = LogManager.getLogger(UserMissionTServiceImpl.class);
    @Autowired
    private DistributedLocker distributedLocker;
    @Autowired
    private DistributedCache redis;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private UserCourseInfoMapper userCourseInfoMapper;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private UserMapTService userMapTService;
    @Autowired
    private WordSentenceMapper wordSentenceMapper;
    @Autowired
    private CourseQuestionAnswerMapper courseQuestionAnswerMapper;
    @Autowired
    private CourseQuestionOptionMapper courseQuestionOptionMapper;
    @Autowired
    private MissionTService missionTService;
    @Autowired
    private UserCourseReportService userCourseReportService;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;
    @Autowired
    private MapAndMissionUtilService mapAndMissionUtilService;
    @Autowired
    private UserMissionGiveStoneFlowMapper userMissionGiveStoneFlowMapper;
    @Autowired
    private SysResourceOperateService sysResourceOperateService;
    @Autowired
    private UserMissionGiveStoneMapper userMissionGiveStoneMapper;
    @Autowired
    private UserMapMapper userMapMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void insertUserMissionIfNotExist(String uid, String missionCode, Integer missionIndex, String mapCode, String levelCode) {
        if (StringUtils.isBlank((CharSequence)uid) || StringUtils.isBlank((CharSequence)missionCode) || StringUtils.isBlank((CharSequence)mapCode)) {
            return;
        }
        try {
            this.distributedLocker.lock("ELLA_USER_MISSION_INSERT:" + uid + missionCode, 2);
            UserMissionExample example = new UserMissionExample();
            example.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(missionCode);
            List userMissionList = this.userMissionMapper.selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)userMissionList)) {
                UserMission userMission = new UserMission();
                userMission.setId(Long.valueOf(IdWrokerUtils.nextId()));
                userMission.setCreateTime(new Date());
                userMission.setStatus("NOTSTARTED");
                userMission.setUid(uid);
                userMission.setMissionCode(missionCode);
                userMission.setMissionIndex(missionIndex);
                userMission.setMapCode(mapCode);
                userMission.setLevelCode(levelCode);
                this.userMissionMapper.insertSelective(userMission);
            }
        }
        finally {
            this.distributedLocker.unlock("ELLA_USER_MISSION_INSERT:" + uid + missionCode);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PutCourseAnswerDto putCourseAnswerInfo(CourseAnswerPutRequest request, UserCourse userCourse, Long id) {
        UserCourseWrapper userCourseWrapper = UserCourseWrapper.parse((String)request.getJsonContent());
        CourseCheckWrapper courseCheckWrapper = this.checkAndUpdateUserCourse(request, userCourse, id, userCourseWrapper);
        this.updateUserCourseAndMissionStatus(userCourse, courseCheckWrapper.isHandle() ? courseCheckWrapper.getHandleAddStone() : courseCheckWrapper.getAddStone());
        this.checkAndUpdateUserCourseDetail(userCourseWrapper, courseCheckWrapper);
        if (!UserCourseWrapper.NONE_RESLUT.equalsIgnoreCase(userCourseWrapper.getUserCourseInfo().getResult()) && !UserCourseWrapper.TIME_OUT.equalsIgnoreCase(userCourseWrapper.getUserCourseInfo().getResult())) {
            this.rpcService.doFollowRecord(userCourseWrapper, request.getUid(), userCourse);
        }
        return new PutCourseAnswerDto(courseCheckWrapper.getAddStone(), userCourseWrapper.getUserCourseInfo().getResult(), userCourse.getBookCode());
    }

    private void updateUserCourseAndMissionStatus(UserCourse userCourse, Integer addStone) {
        if (Objects.isNull(userCourse)) {
            return;
        }
        if ("NOTSTARTED".equalsIgnoreCase(userCourse.getStatus())) {
            UserCourse param = new UserCourse();
            param.setId(userCourse.getId());
            param.setStatus("DOING");
            this.userCourseMapper.updateByPrimaryKeySelective(param);
        }
        this.updateUserMissionStatusToDoing(this.userMissionMapper.selectByUidAndMissionCode(userCourse.getUid(), userCourse.getMissionCode()), addStone);
    }

    public void updateUserMissionStatusToDoing(UserMission userMission, Integer addStone) {
        Boolean r;
        boolean doUpdate = false;
        if (Objects.isNull(userMission)) {
            return;
        }
        UserMission param = new UserMission();
        param.setId(userMission.getId());
        if ("NOTSTARTED".equalsIgnoreCase(userMission.getStatus())) {
            param.setStatus("DOING");
            doUpdate = true;
        }
        if ((r = this.mapAndMissionUtilService.judgeAddStoneNum(userMission.getUid(), userMission.getMissionCode(), addStone)) != null && r.equals(false)) {
            addStone = 0;
        }
        if (Objects.nonNull(addStone) && addStone > 0) {
            param.setCorrectNum(Integer.valueOf(userMission.getCorrectNum() + addStone));
            log.info("updateUserMissionStatusToDoing {}-{}: map num+{}", (Object)userMission.getMapCode(), (Object)userMission.getUid(), (Object)addStone);
            this.userMapTService.updateUserMapWhenMissionFinish(userMission.getMapCode(), userMission.getUid(), null, addStone, null);
        }
        if (doUpdate) {
            if (userMission.getMissionType() != null && !userMission.getMissionType().equals(0)) {
                this.mapAndMissionUtilService.setUserMissionNotStart(userMission.getUid());
            }
            if (userMission.getMissionType() != null && userMission.getMissionType().equals(0)) {
                param.setStatus(null);
            }
            if (param.getCorrectNum() != null) {
                this.userMissionMapper.updateByPrimaryKeySelective(param);
            }
        }
    }

    public List<CourseAnswerInfoDto> getCourseAnswerInfo(String uid, String missionCode) {
        ArrayList<CourseAnswerInfoDto> result = new ArrayList<CourseAnswerInfoDto>();
        if (StringUtils.isBlank((CharSequence)uid) || StringUtils.isBlank((CharSequence)missionCode)) {
            return result;
        }
        UserCourseInfoExample example = new UserCourseInfoExample();
        example.setOrderByClause(" page_id ");
        Mission mission = this.missionMapper.selectByMissionCode(missionCode);
        example.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(missionCode).andCourseIdEqualTo(mission.getResourceId());
        List userCourseInfos = this.userCourseInfoMapper.groupCountByExample(example);
        if (CollectionUtils.isEmpty((Collection)userCourseInfos)) {
            return result;
        }
        userCourseInfos.forEach(u -> {
            CourseAnswerInfoDto tmp = new CourseAnswerInfoDto();
            BeanUtils.copyProperties((Object)u, (Object)tmp);
            tmp.setPageNumber(u.getPageId());
            result.add(tmp);
        });
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public AnalysisTestInfoDto analysisCourseAnswer(AnalysisCourseAnswerRequest request, CourseMissionDto courseMissionDto) {
        NextMissionInfoDto nextMissionInfoDto;
        AnalysisTestInfoDto result = new AnalysisTestInfoDto();
        UserCourseReportDto userCourseReport = new UserCourseReportDto();
        UserCourseInfoExample example = new UserCourseInfoExample();
        Mission mission = this.missionMapper.selectByMissionCode(courseMissionDto.getMissionCode());
        example.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(courseMissionDto.getMissionCode()).andCourseIdEqualTo(mission.getResourceId());
        UserCourseInfo userCourseInfo = this.userCourseInfoMapper.sumAndAvgByExample(example);
        if (Objects.isNull(userCourseInfo)) {
            return result;
        }
        UserCourse userCourse = this.userCourseMapper.selectByUidAndMissionCode(request.getUid(), courseMissionDto.getMissionCode());
        userCourse.setSpeechFluency(userCourseInfo.getSpeechFluency());
        userCourse.setSpeechAccuracy(userCourseInfo.getSpeechAccuracy());
        if (Objects.nonNull(request.getLearnTime())) {
            userCourse.setLearnTime(Integer.valueOf(Optional.ofNullable(userCourse.getLearnTime()).orElse(0) + request.getLearnTime()));
        }
        userCourseReport.setSurplusNum(Integer.valueOf(courseMissionDto.getPassNum() - userCourseInfo.getStoneNum()));
        result.setIsPass(Boolean.FALSE);
        UserMission userMission = this.userMissionMapper.selectByPrimaryKey(request.getId());
        if (userCourseInfo.getStoneNum() >= courseMissionDto.getPassNum()) {
            NextMissionInfoDto nextMissionInfoDtox;
            log.info("analysisCourseAnswer {}-{}: IsPass:true", (Object)courseMissionDto.getMapCode(), (Object)request.getUid());
            userCourseReport.setSurplusNum(Integer.valueOf(0));
            result.setIsPass(Boolean.TRUE);
            userCourse.setStatus("PASS");
            this.userMapTService.updateUserMapWhenMissionFinish(courseMissionDto.getMapCode(), request.getUid(), userMission.getMissionCode(), null, userMission.getStatus());
            userMission.setStatus("PASS");
            log.info("analysisCourseAnswer begin updateByPrimaryKeySelective");
            this.userMissionMapper.updateByPrimaryKeySelective(userMission);
            nextMissionInfoDto = this.missionTService.getJumpMissionInfo(courseMissionDto.getId(), request.getUid());
            result.setNextMissionInfo(nextMissionInfoDto);
            if (nextMissionInfoDto != null && nextMissionInfoDto.isSnapLastUserMission() && (nextMissionInfoDtox = this.userMapAndMissionService.updateUserMapAfterTest(null, request.getUid(), nextMissionInfoDto.getMapCode(), nextMissionInfoDto.getMissionCode())) != null) {
                result.setNextMissionInfo(nextMissionInfoDtox);
            }
            if (result.getNextMissionInfo() != null && userMission.getMissionType() != null && !userMission.getMissionType().equals(0)) {
                this.userMapTService.updateUserMapAndMissionToDoing(request.getUid(), nextMissionInfoDto.getMapCode(), nextMissionInfoDto.getMissionCode());
            }
        }
        if (result.getNextMissionInfo() == null && "PASS".equals(userMission.getStatus()) && userMission.getMissionType() != null && !userMission.getMissionType().equals(0)) {
            result.setIsPass(Boolean.valueOf(true));
            nextMissionInfoDto = this.missionTService.getJumpMissionInfo(courseMissionDto.getId(), request.getUid());
            result.setNextMissionInfo(nextMissionInfoDto);
        }
        if (userMission.getMissionType() != null && userMission.getMissionType().equals(0)) {
            nextMissionInfoDto = this.userMissionMapper.selectByMapCodeAndIndex(request.getUid(), userMission.getMapCode(), userMission.getMissionIndex());
            result.setNextMissionInfo(nextMissionInfoDto);
        }
        this.userCourseMapper.updateByPrimaryKeySelective(userCourse);
        log.info("analysisCourseAnswer {}-{}: createUserCourseReport", (Object)courseMissionDto.getMapCode(), (Object)request.getUid());
        List userMissionGiveStoneFlows = this.userMissionGiveStoneFlowMapper.selectByUidAndMissionCode(request.getUid(), courseMissionDto.getMissionCode(), Integer.valueOf(0));
        if (userMissionGiveStoneFlows != null && userMissionGiveStoneFlows.size() > 0 && userCourseInfo.getStoneNum() < courseMissionDto.getPassNum()) {
            int giveStoneNum = courseMissionDto.getPassNum() - userCourseInfo.getStoneNum();
            result.setGiveStoneNum(Integer.valueOf(giveStoneNum));
        }
        if (userCourseInfo.getStoneNum() >= courseMissionDto.getPassNum()) {
            result.setGotStoneNum(userCourseInfo.getStoneNum());
        } else if ("PASS".equals(userMission.getStatus())) {
            result.setGotStoneNum(courseMissionDto.getPassNum());
        } else {
            result.setGotStoneNum(userCourseInfo.getStoneNum());
        }
        userCourseReport.setUid(request.getUid());
        userCourseReport.setStoneNum(userCourseInfo.getStoneNum());
        userCourseReport.setMissionCode(courseMissionDto.getMissionCode());
        userCourseReport.setLearnTime(userCourse.getLearnTime());
        userCourseReport.setSpeechFluency(userCourse.getSpeechFluency());
        userCourseReport.setSpeechAccuracy(userCourse.getSpeechAccuracy());
        Map follow = this.rpcService.countUserFollowRecord(request.getUid(), courseMissionDto.getMapCode(), courseMissionDto.getMissionCode(), request.getLearnTime());
        userCourseReport.setFollowWordNum(Optional.ofNullable(follow.get("WORD")).orElse(0));
        userCourseReport.setFollowSentenceNum(Optional.ofNullable(follow.get("SENTENCE")).orElse(0));
        userCourseReport.setCollectedWordNum(Integer.valueOf(this.wordSentenceMapper.countByExample(this.getCountWordExample(request.getUid(), courseMissionDto.getMissionCode()))));
        result.setAnalysisResult((Object)userCourseReport);
        this.userCourseReportService.createUserCourseReport(userCourseReport, userCourseInfo.getVersion());
        boolean isShowGive = false;
        if (userMissionGiveStoneFlows != null && userMissionGiveStoneFlows.size() > 0 && result.getGiveStoneNum() != null) {
            this.rpcService.addUserStoneNum(request.getUid(), request.getId(), result.getGiveStoneNum());
            this.userMapMapper.updateAfterMissionPass(request.getUid(), userMission.getMapCode(), null, result.getGiveStoneNum());
            for (UserMissionGiveStoneFlow userMissionGiveStoneFlow : userMissionGiveStoneFlows) {
                userMissionGiveStoneFlow.setIsGive(Integer.valueOf(1));
                this.userMissionGiveStoneFlowMapper.updateByPrimaryKeySelective(userMissionGiveStoneFlow);
                if (!DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue().equals(userMissionGiveStoneFlow.getType())) continue;
                isShowGive = true;
            }
            this.sysResourceOperateService.updateUserMissionSendStoneNum(request.getUid(), userMission.getMapCode(), userMission.getMissionCode(), result.getGiveStoneNum());
        }
        if (!isShowGive) {
            result.setGiveStoneNum(null);
        }
        return result;
    }

    public UserMission getAdjacentMissionInfo(String uid, Long currentMissionId, String levelCode, String type) {
        List userMissionList = this.userMissionMapper.selectByUidAndLevelCode(uid, levelCode);
        if (CollectionUtils.isEmpty((Collection)userMissionList)) {
            return new UserMission();
        }
        userMissionList.removeIf(tmp -> new Integer(0).equals(tmp.getMissionType()));
        UserMission prevUserMission = null;
        for (UserMission userMission : userMissionList) {
            if (currentMissionId.equals(userMission.getId())) {
                return prevUserMission;
            }
            prevUserMission = userMission;
        }
        return null;
    }

    public BaseMission getMissionById(Long id) {
        UserMission mission = this.userMissionMapper.selectByPrimaryKey(id);
        if (null == mission) {
            return this.missionMapper.selectByPrimaryKey(id);
        }
        Mission baseMission = this.missionMapper.selectByMissionCode(mission.getMissionCode());
        if ("DELETE".equals(baseMission.getStatus())) {
            return null;
        }
        return mission;
    }

    public CourseMissionDto getCourseMission(Long id) {
        CourseMissionDto result = this.userMissionMapper.selectCourseMissionInfo(id);
        if (Objects.isNull(result)) {
            return this.missionMapper.selectCourseMissionInfo(id);
        }
        return result;
    }

    private WordSentenceExample getCountWordExample(String uid, String missionCode) {
        WordSentenceExample wordSentenceExample = new WordSentenceExample();
        wordSentenceExample.createCriteria().andUidEqualTo(uid).andStatusEqualTo("NORMAL").andMissionCodeEqualTo(missionCode);
        return wordSentenceExample;
    }

    private void checkAndUpdateUserCourseDetail(UserCourseWrapper userCourseWrapper, CourseCheckWrapper courseCheckWrapper) {
        ArrayList courseQuestionOptions = new ArrayList();
        courseQuestionOptions.addAll(userCourseWrapper.getCourseQuestionOptionList());
        courseQuestionOptions.forEach(c -> c.setCourseInfoId(courseCheckWrapper.getUserCourseId()));
        log.info("method putCourseAnswerInfo courseQuestionOptionMapper.insertBatch size:{}", (Object)courseQuestionOptions.size());
        if (!CollectionUtils.isEmpty(courseQuestionOptions)) {
            this.courseQuestionOptionMapper.insertBatch(courseQuestionOptions);
        }
        if (CollectionUtils.isEmpty((Collection)userCourseWrapper.getCourseQuestionAnswerList())) {
            log.info("method putCourseAnswerInfo courseQuestionOptionMapper.insertBatch size:0");
            return;
        }
        ArrayList courseQuestionAnswers = new ArrayList();
        courseQuestionAnswers.addAll(userCourseWrapper.getCourseQuestionAnswerList());
        courseQuestionAnswers.forEach(c -> c.setCourseInfoId(courseCheckWrapper.getUserCourseId()));
        log.info("method putCourseAnswerInfo courseQuestionOptionMapper.insertBatch size:{}", (Object)courseQuestionAnswers.size());
        this.courseQuestionAnswerMapper.insertBatch(courseQuestionAnswers);
    }

    private CourseCheckWrapper checkAndUpdateUserCourse(CourseAnswerPutRequest request, UserCourse userCourse, Long id, UserCourseWrapper userCourseWrapper) {
        CourseCheckWrapper result = new CourseCheckWrapper();
        UserCourseInfoExample example = new UserCourseInfoExample();
        Mission mission = this.missionMapper.selectByMissionCode(userCourse.getMissionCode());
        example.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(userCourse.getMissionCode()).andCourseIdEqualTo(mission.getResourceId()).andPageIdEqualTo(userCourseWrapper.getUserCourseInfo().getPageId()).andGroupIdEqualTo(userCourseWrapper.getUserCourseInfo().getGroupId()).andQuestionIdEqualTo(userCourseWrapper.getUserCourseInfo().getQuestionId());
        List userCourseInfos = this.userCourseInfoMapper.selectByExample(example);
        Integer cardinal = Optional.ofNullable(new RedisAssistUtils(this.redis).getIntByKey("COURSE_STONE_CARDINAL")).orElse(3);
        Integer currentAnswerWithStone = CourseResultEnum.ofCode((String)userCourseWrapper.getUserCourseInfo().getResult()).getId();
        UserCourseInfo userCourseInfo = userCourseWrapper.getUserCourseInfo();
        userCourseInfo.setUid(request.getUid());
        userCourseInfo.setCreateTime(new Date());
        userCourseInfo.setMissionCode(userCourse.getMissionCode());
        userCourseInfo.setStoneNum(currentAnswerWithStone);
        userCourseInfo.setMaxStoneNum(Integer.valueOf(request.getTotalNum() * cardinal));
        userCourseInfo.setAcquireAll(userCourseInfo.getMaxStoneNum().equals(userCourseInfo.getStoneNum()) ? "Y" : "N");
        userCourseInfo.setCourseId(Long.valueOf(mission.getResourceId().longValue()));
        this.userCourseInfoMapper.insertSelective(userCourseInfo);
        CourseCheckWrapper courseCheckWrapper = null;
        boolean isChange = false;
        if (CollectionUtils.isEmpty((Collection)userCourseInfos)) {
            Boolean flag = this.mapAndMissionUtilService.judgeAddStoneNum(request.getUid(), userCourse.getMissionCode(), userCourseInfo.getStoneNum());
            if (flag != null && flag.equals(true)) {
                this.rpcService.addUserStoneNum(request.getUid(), id, userCourseInfo.getStoneNum());
            } else if (flag == null) {
                isChange = true;
            }
            courseCheckWrapper = result.fill(Boolean.TRUE, currentAnswerWithStone, userCourseInfo.getId());
        } else {
            String resultTmp = "";
            Integer oldStone = 0;
            Integer addStone = 0;
            for (UserCourseInfo tmp : userCourseInfos) {
                resultTmp = resultTmp.compareTo(tmp.getResult()) > 0 ? resultTmp : tmp.getResult();
                oldStone = oldStone.compareTo(tmp.getStoneNum()) > 0 ? oldStone : tmp.getStoneNum();
            }
            if (CourseResultEnum.ofCode((String)resultTmp).compareTo((Enum)CourseResultEnum.ofCode((String)userCourseWrapper.getUserCourseInfo().getResult())) < 0) {
                addStone = currentAnswerWithStone.compareTo(oldStone) > 0 ? currentAnswerWithStone - oldStone : 0;
                Boolean flag = this.mapAndMissionUtilService.judgeAddStoneNum(request.getUid(), userCourse.getMissionCode(), addStone);
                if (addStone > 0 && flag != null && flag.equals(true)) {
                    this.rpcService.addUserStoneNum(request.getUid(), id, addStone);
                } else if (flag == null) {
                    isChange = true;
                }
            }
            courseCheckWrapper = result.fill(Boolean.TRUE, addStone, userCourseInfo.getId());
        }
        if (isChange) {
            UserMissionGiveStone userMissionGiveStone = this.userMissionGiveStoneMapper.selectByUidAndMissionCode(request.getUid(), userCourse.getMissionCode());
            UserCourseInfoExample examplex = new UserCourseInfoExample();
            examplex.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(userCourse.getMissionCode()).andCourseIdEqualTo(mission.getResourceId());
            UserCourseInfo userCourseInfox = this.userCourseInfoMapper.sumAndAvgByExample(examplex);
            int abs = userCourseInfox.getStoneNum() - userMissionGiveStone.getHandleNum();
            this.rpcService.addUserStoneNum(request.getUid(), request.getId(), Integer.valueOf(abs));
            userMissionGiveStone.setIsHandle(Integer.valueOf(1));
            this.userMissionGiveStoneMapper.updateByPrimaryKeySelective(userMissionGiveStone);
            courseCheckWrapper.setHandle(true);
            courseCheckWrapper.setHandleAddStone(Integer.valueOf(abs));
        }
        return courseCheckWrapper;
    }
}

