/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.constants.OperateEnum;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.CourseBook;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.UserCourse;
import com.ella.resource.domain.UserCourseExample;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMapExample;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserMissionExample;
import com.ella.resource.mapper.CourseBookMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.MapAndMissionUtilService;
import com.ella.resource.service.transactional.UserMapTService;
import com.ella.resource.service.transactional.impl.UserMapTServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserMapTServiceImpl
implements UserMapTService {
    private static final Logger log = LogManager.getLogger(UserMapTServiceImpl.class);
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private CourseBookMapper courseBookMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private MapAndMissionUtilService mapAndMissionUtilService;

    @Async
    @Transactional(rollbackFor={Exception.class})
    public Integer updateUserMapWhenMissionFinish(String mapCode, String uid, String missionCode, Integer stoneNum, String missionStatus) {
        String status;
        log.info("UserMapTServiceImpl.updateUserMapWhenMissionFinish param:{},{}", (Object)mapCode, (Object)uid);
        String string = status = StringUtils.isBlank((CharSequence)missionStatus) ? null : "PASS";
        if (StringUtils.isNotBlank((CharSequence)missionCode)) {
            Mission param = new Mission();
            param.setMapCode(mapCode);
            List missions = this.missionMapper.selectMissionList(param);
            if (!CollectionUtils.isEmpty((Collection)missions)) {
                List missionCodes = missions.stream().filter(m -> m.getMissionType() > 0).map(BaseMission::getMissionCode).collect(Collectors.toList());
                log.info("UserMapTServiceImpl.updateUserMapWhenMissionFinish is last mission:{},{}", (Object)missionCode, missionCodes.get(missionCodes.size() - 1));
                if (!missionCode.equalsIgnoreCase((String)missionCodes.get(missionCodes.size() - 1))) {
                    status = null;
                }
            }
        }
        if (Objects.isNull(status) && Objects.isNull(stoneNum)) {
            return 0;
        }
        return this.userMapMapper.updateAfterMissionPass(uid, mapCode, status, stoneNum);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateUserMapWhenMissionBegin(String mapCode, String uid) {
        if (StringUtils.isBlank((CharSequence)mapCode) || StringUtils.isBlank((CharSequence)uid)) {
            return 0;
        }
        UserMapExample example = new UserMapExample();
        example.createCriteria().andUidEqualTo(uid).andMapCodeEqualTo(mapCode);
        List userMaps = this.userMapMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)userMaps)) {
            return 0;
        }
        UserMap prevUserMap = (UserMap)userMaps.get(0);
        if (StringUtils.isBlank((CharSequence)prevUserMap.getStatus()) || StringUtils.equalsIgnoreCase((CharSequence)prevUserMap.getStatus(), (CharSequence)"NOTSTARTED")) {
            prevUserMap.setStatus("DOING");
            this.mapAndMissionUtilService.setUserMapNotStart(uid);
            return this.userMapMapper.updateByPrimaryKeySelective(prevUserMap);
        }
        return 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateUserAfterMissionChange(Mission beforeMission, Integer afterResourceId, OperateEnum operateEnum) {
        switch (1.$SwitchMap$com$ella$resource$constants$OperateEnum[operateEnum.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                CourseBook beforeCourseBook = this.courseBookMapper.selectByPrimaryKey(beforeMission.getResourceId());
                CourseBook afterCourseBook = this.courseBookMapper.selectByPrimaryKey(afterResourceId);
                UserCourseExample example = new UserCourseExample();
                example.createCriteria().andMissionCodeEqualTo(beforeMission.getMissionCode()).andCourseCodeEqualTo(beforeCourseBook.getCourseCode());
                UserCourse param = new UserCourse();
                param.setCourseCode(afterCourseBook.getCourseCode());
                this.userCourseMapper.updateByExampleSelective(param, example);
                break;
            }
            case 3: {
                break;
            }
        }
        return false;
    }

    public int updateUserMapAndMissionToDoing(String uid, String mapCode, String missionCode) {
        UserMap record = this.userMapMapper.selectByUidAndMapCode(uid, mapCode);
        if (record == null || record.getStatus().equals("PASS")) {
            return 1;
        }
        UserMission recordx = this.userMissionMapper.selectByUidAndMissionCode(uid, missionCode);
        if (recordx == null || recordx.getStatus().equals("PASS")) {
            return 1;
        }
        if (recordx.getMissionType() != null && recordx.getMissionType().equals(0)) {
            return 1;
        }
        this.updateUserMapWhenMissionBegin(mapCode, uid);
        this.updateUserMissionWhenMissionBegin(missionCode, uid);
        return 1;
    }

    public int updateUserMissionWhenMissionBegin(String missionCode, String uid) {
        if (StringUtils.isBlank((CharSequence)missionCode) || StringUtils.isBlank((CharSequence)uid)) {
            return 0;
        }
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(missionCode);
        List userMissions = this.userMissionMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)userMissions)) {
            return 0;
        }
        UserMission prevUserMission = (UserMission)userMissions.get(0);
        if (StringUtils.isBlank((CharSequence)prevUserMission.getStatus()) || StringUtils.equalsIgnoreCase((CharSequence)prevUserMission.getStatus(), (CharSequence)"NOTSTARTED")) {
            if (prevUserMission.getUnlockTime() == null) {
                prevUserMission.setUnlockTime(new Date());
            }
            prevUserMission.setStatus("DOING");
            this.mapAndMissionUtilService.setUserMissionNotStart(uid);
            return this.userMissionMapper.updateByPrimaryKeySelective(prevUserMission);
        }
        return 0;
    }
}

