/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.frame.lock.DistributedLocker;
import com.ella.resource.domain.UserCourseReport;
import com.ella.resource.domain.UserCourseReportExample;
import com.ella.resource.mapper.UserCourseInfoMapper;
import com.ella.resource.mapper.UserCourseReportMapper;
import com.ella.resource.service.transactional.UserCourseReportService;
import com.ella.resource.wrapper.UserCourseReportDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserCourseReportServiceImpl
implements UserCourseReportService {
    private static final Logger log = LogManager.getLogger(UserCourseReportServiceImpl.class);
    @Autowired
    private UserCourseReportMapper userCourseReportMapper;
    @Autowired
    private UserCourseInfoMapper userCourseInfoMapper;
    @Autowired
    private DistributedLocker distributedLocker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Boolean createUserCourseReport(UserCourseReportDto userCourseReportDto, Integer version) {
        String key = "ACCOUNT:COURSE_REPORT_LOCK_KEY:" + userCourseReportDto.getUid() + userCourseReportDto.getMissionCode();
        try {
            Integer reportVersion;
            this.distributedLocker.lock(key, 1);
            UserCourseReport report = new UserCourseReport();
            BeanUtils.copyProperties((Object)userCourseReportDto, (Object)report);
            UserCourseReportExample example = new UserCourseReportExample();
            example.setOrderByClause(" version desc");
            example.createCriteria().andUidEqualTo(userCourseReportDto.getUid()).andMissionCodeEqualTo(userCourseReportDto.getMissionCode());
            List userCourseReports = this.userCourseReportMapper.selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)userCourseReports)) {
                reportVersion = 1;
            } else {
                reportVersion = userCourseReports.stream().map(UserCourseReport::getVersion).max(Integer::compareTo).get() + 1;
                report.setFollowSentenceNum(Integer.valueOf(report.getFollowSentenceNum() + Optional.ofNullable(((UserCourseReport)userCourseReports.get(0)).getFollowSentenceNum()).orElse(0)));
                report.setFollowWordNum(Integer.valueOf(report.getFollowWordNum() + Optional.ofNullable(((UserCourseReport)userCourseReports.get(0)).getFollowWordNum()).orElse(0)));
            }
            report.setVersion(reportVersion);
            report.setCreateTime(new Date());
            int i = this.userCourseInfoMapper.updateVersionForNull(userCourseReportDto.getUid(), userCourseReportDto.getMissionCode(), Optional.ofNullable(version).orElse(0) + 1);
            log.info("userCourseInfoMapper.updateVersionForNull result-{}", (Object)i);
            Boolean bl = this.userCourseReportMapper.insertSelective(report) > 0;
            return bl;
        }
        finally {
            this.distributedLocker.unlock(key);
        }
    }

    public List<UserCourseReport> getUserCourseReportByUidAndMissionCode(String uid, String missionCode) {
        UserCourseReportExample example = new UserCourseReportExample();
        example.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(missionCode);
        List userCourseReportList = this.userCourseReportMapper.selectByExample(example);
        return userCourseReportList;
    }

    public int countLearnTimeByUid(String uid) {
        Integer totalLearnTime = this.userCourseReportMapper.countLearnTimeByUid(uid);
        return null == totalLearnTime ? 0 : totalLearnTime;
    }
}

