/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.frame.cache.DistributedCache;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.SysResourceUpdateLog;
import com.ella.resource.domain.SysResourceUpdateLogExample;
import com.ella.resource.domain.UserMissionGiveStone;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.SysResourceUpdateLogMapper;
import com.ella.resource.mapper.UserMissionGiveStoneMapper;
import com.ella.resource.service.transactional.SysResourceOperateService;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysResourceOperateServiceImpl
implements SysResourceOperateService {
    private static final Logger log = LogManager.getLogger(SysResourceOperateServiceImpl.class);
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private SysResourceUpdateLogMapper sysResourceUpdateLogMapper;
    @Autowired
    private UserMissionGiveStoneMapper userMissionGiveStoneMapper;
    @Autowired
    private MissionMapper missionMapper;

    public void insertSysResourceNotify(String uid, String resCode, String type) {
        if (uid == null || resCode == null) {
            return;
        }
        String key = "SYS_RESOURCE_UPDATE:" + type + ":" + uid + ":" + resCode;
        log.info("insertSysResourceNotify->key:" + key);
        this.redisCache.set(key, (Object)"1");
    }

    public boolean delSysResourceNotify(String uid, String resCode, String type) {
        if (uid == null || resCode == null) {
            return false;
        }
        String key = "SYS_RESOURCE_UPDATE:" + type + ":" + uid + ":" + resCode;
        log.info("delSysResourceNotify->key:" + key);
        this.redisCache.del(key);
        return true;
    }

    public void addSysResourceOperateLog(String resType, String opType, String resCode, String opCode, String opUid, Integer lastVersion, Integer version) {
        SysResourceUpdateLog sysResourceUpdateLog = new SysResourceUpdateLog();
        sysResourceUpdateLog.setResType(resType);
        sysResourceUpdateLog.setResCode(resCode);
        sysResourceUpdateLog.setOpType(opType);
        sysResourceUpdateLog.setOpCode(opCode);
        sysResourceUpdateLog.setLastVersion(lastVersion);
        sysResourceUpdateLog.setVersion(version);
        sysResourceUpdateLog.setCreateBy(opUid);
        sysResourceUpdateLog.setUpdateBy(opUid);
        sysResourceUpdateLog.setCreateTime(new Date());
        sysResourceUpdateLog.setUpdateTime(new Date());
        this.sysResourceUpdateLogMapper.insertSelective(sysResourceUpdateLog);
    }

    public List<SysResourceUpdateLog> getNeedUpdateResource(String resType, String resCode, String opType, Integer lastVersion) {
        SysResourceUpdateLogExample example = new SysResourceUpdateLogExample();
        example.createCriteria().andResTypeEqualTo(resType).andResCodeEqualTo(resCode).andVersionGreaterThan(lastVersion);
        if (opType != null) {
            example.createCriteria().andOpTypeEqualTo(opType);
        }
        List sysResourceUpdateLogList = this.sysResourceUpdateLogMapper.selectByExample(example);
        return sysResourceUpdateLogList;
    }

    public int updateUserMissionSendStoneNum(String uid, String mapCode, String missionCode, Integer giveNum) {
        UserMissionGiveStone userMissionGiveStone = this.userMissionGiveStoneMapper.selectByUidAndMissionCode(uid, missionCode);
        if (userMissionGiveStone == null) {
            userMissionGiveStone = new UserMissionGiveStone();
            userMissionGiveStone.setMapCode(mapCode);
            userMissionGiveStone.setMissionCode(missionCode);
            userMissionGiveStone.setUid(uid);
            userMissionGiveStone.setGiveNum(giveNum);
            Mission mission = this.missionMapper.selectByMissionCode(missionCode);
            userMissionGiveStone.setHandleNum(mission.getPassNum());
            this.userMissionGiveStoneMapper.insertSelective(userMissionGiveStone);
        } else {
            Mission mission = this.missionMapper.selectByMissionCode(missionCode);
            userMissionGiveStone.setGiveNum(Integer.valueOf(userMissionGiveStone.getGiveNum() + giveNum));
            userMissionGiveStone.setHandleNum(mission.getPassNum());
            this.userMissionGiveStoneMapper.updateByPrimaryKeySelective(userMissionGiveStone);
        }
        return 1;
    }
}

