/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.domain.ResQuestion;
import com.ella.resource.domain.ResQuestionItem;
import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.dto.ResQuestionDto;
import com.ella.resource.dto.ResQuestionItemDto;
import com.ella.resource.dto.ResQuestionListDto;
import com.ella.resource.dto.request.question.EditResQuestionRequest;
import com.ella.resource.dto.request.question.QueryResQuestionRequest;
import com.ella.resource.dto.request.question.QuestionsByOccupantTypeReq;
import com.ella.resource.dto.request.question.SaveResQuestionRequest;
import com.ella.resource.mapper.ResQuestionItemMapper;
import com.ella.resource.mapper.ResQuestionMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.service.transactional.ResQuestionTService;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ResQuestionTServiceImpl
implements ResQuestionTService {
    private static final Logger log = LogManager.getLogger(ResQuestionTServiceImpl.class);
    @Autowired
    private ResQuestionMapper mapper;
    @Autowired
    private ResQuestionItemMapper iMapper;
    @Autowired
    private ResourceOccupantMapper occMapper;

    @Transactional(rollbackFor={Exception.class})
    public int insertResQuestion(SaveResQuestionRequest res) {
        ResQuestion question = new ResQuestion();
        BeanUtils.copyProperties((Object)res, (Object)question);
        try {
            SimpleDateFormat sdf;
            if (null == question.getCreateTime()) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                question.setCreateTime(sdf.parse(sdf.format(new Date())));
            }
            if (null == question.getUpdateTime()) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                question.setUpdateTime(sdf.parse(sdf.format(new Date())));
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        if (null == question.getStatus() || "".equals(question.getStatus())) {
            question.setStatus("NORMAL");
        }
        if (null == question.getUseStatus() || "".equals(question.getUseStatus())) {
            question.setUseStatus("N");
        }
        this.mapper.insert(question);
        List itemList = res.getItemList();
        ArrayList daoList = new ArrayList();
        if (null != itemList && !itemList.isEmpty()) {
            itemList.forEach(item -> {
                ResQuestionItem ri = new ResQuestionItem();
                BeanUtils.copyProperties((Object)item, (Object)ri);
                ri.setQuestionId(question.getId());
                ri.setCreateBy(question.getCreateBy());
                ri.setCreateTime(question.getCreateTime());
                ri.setUpdateBy(question.getUpdateBy());
                ri.setUpdateTime(question.getUpdateTime());
                ri.setStatus(question.getStatus());
                daoList.add(ri);
            });
        }
        this.iMapper.batchInsert(daoList);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateResQuestion(EditResQuestionRequest request) {
        ResQuestion question = new ResQuestion();
        BeanUtils.copyProperties((Object)request, (Object)question);
        try {
            if (null == question.getUpdateTime()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                question.setUpdateTime(sdf.parse(sdf.format(new Date())));
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        this.mapper.updateByPrimaryKeySelective(question);
        List itemList = request.getItemList();
        if (null != itemList && !itemList.isEmpty()) {
            itemList.forEach(item -> {
                ResQuestionItem ri = new ResQuestionItem();
                BeanUtils.copyProperties((Object)item, (Object)ri);
                ri.setQuestionId(question.getId());
                ri.setCreateBy(request.getCreateBy());
                ri.setCreateTime(request.getCreateTime());
                ri.setUpdateBy(request.getUpdateBy());
                ri.setUpdateTime(request.getUpdateTime());
                ri.setStatus(request.getStatus());
                this.iMapper.updateByPrimaryKeySelective(ri);
            });
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ResQuestionListDto> getAllResQuestion(QueryResQuestionRequest page) {
        PageHelper.startPage((int)page.getPageNo(), (int)page.getPageSize());
        List list = this.mapper.selectAll(page);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        ResourceOccupantExample example = new ResourceOccupantExample();
        example.createCriteria().andResTypeEqualTo("QUESTION").andStatusEqualTo("NORMAL");
        List resourceOccupants = this.occMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)resourceOccupants)) {
            return list;
        }
        List resIds = resourceOccupants.stream().map(ResourceOccupant::getResId).collect(Collectors.toList());
        list.forEach(r -> r.setUseStatus(resIds.contains(r.getId()) ? "Y" : "N"));
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteResQuestionByIds(int id) {
        this.mapper.deleteByIds(Long.valueOf(id));
    }

    @Transactional(rollbackFor={Exception.class})
    public ResQuestionDto getQuestionById(Long questionId) {
        ResQuestion result = this.mapper.selectByPrimaryKey(questionId);
        if (null == result) {
            return null;
        }
        List itemList = this.iMapper.selectByQuestionId(questionId);
        ArrayList itemDtoList = new ArrayList();
        if (null != itemList && !itemList.isEmpty()) {
            itemList.forEach(item -> {
                ResQuestionItemDto itemDto = new ResQuestionItemDto();
                BeanUtils.copyProperties((Object)item, (Object)itemDto);
                itemDtoList.add(itemDto);
            });
        }
        ResQuestionDto questionDto = new ResQuestionDto();
        BeanUtils.copyProperties((Object)result, (Object)questionDto);
        questionDto.setItemList(itemDtoList);
        return questionDto;
    }

    public List<ResQuestionListDto> getAllResQuestion(QuestionsByOccupantTypeReq req) {
        String occType = req.getOccupantType();
        List idList = "COURSE".equals(occType) ? this.occMapper.selectResId("QUESTION", occType) : this.occMapper.selectResId("QUESTION", occType);
        PageHelper.startPage((int)req.getPageNo(), (int)req.getPageSize());
        return this.mapper.selectQuestions(idList, req);
    }
}

