/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.frame.aop.annotion.EvictDataCache;
import com.ella.frame.cache.DistributedCache;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.domain.BaseMap;
import com.ella.resource.domain.Level;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.MapResourceRel;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.MissionAndResource;
import com.ella.resource.domain.PicGallery;
import com.ella.resource.domain.SysResourceUpdateLog;
import com.ella.resource.domain.UserLevelResourceVersion;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.UpdateLevelNumDto;
import com.ella.resource.mapper.AttachMapper;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MapResourceRelMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.PicGalleryMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.service.transactional.SysResourceOperateService;
import com.ella.resource.utils.CacheEnum;
import com.ella.resource.utils.CacheUtilsNew;
import com.ella.resource.utils.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MapTServiceImpl
implements MapTService {
    private static final Logger log = LogManager.getLogger(MapTServiceImpl.class);
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private LevelMapper levelMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private MapResourceRelMapper mapResourceRelMapper;
    @Autowired
    private AttachMapper attachMapper;
    @Autowired
    private PicGalleryMapper picGalleryMapper;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private SysResourceOperateService sysResourceOperateService;
    @Autowired
    private UserMapper userMapper;

    @Transactional(rollbackFor={Exception.class})
    public int doSureByLevelCode(String levelCode, String uid) {
        return this.mapMapper.doSureByLevelCode(levelCode, uid);
    }

    @EvictDataCache(resourceName={"MapMapper:selectByMapCode"}, operation="UPDATE")
    @Transactional(rollbackFor={Exception.class})
    public int updateMap(Map map) {
        return this.mapMapper.updateByPrimaryKeySelective(map);
    }

    @EvictDataCache(resourceName={"MapMapper:selectByMapCode"}, operation="UPDATE", evictAll=true)
    @Transactional(rollbackFor={Exception.class})
    public int deleteMap(Map map) {
        map.setStatus("DELETE");
        int result = this.mapMapper.updateByPrimaryKeySelective(map);
        if (result > 0) {
            UpdateLevelNumDto dto = new UpdateLevelNumDto(map.getLevelCode());
            dto.setMinusStoneNum(Integer.valueOf(this.mapMapper.sumMapStoneNum(map.getMapCode())));
            dto.setMinusMapNum(Integer.valueOf(1));
            dto.setMinusMissionNum(Integer.valueOf(null == map.getMissionNum() ? 0 : map.getMissionNum()));
            this.levelMapper.updateNumByCode(dto);
            this.missionMapper.deleteByMapCode(map.getMapCode());
        }
        return result;
    }

    @EvictDataCache(resourceName={"MapMapper:selectByMapCode"}, operation="UPDATE", evictAll=true)
    @Transactional(rollbackFor={Exception.class})
    public int saveMap(Map map) {
        int result = this.mapMapper.insertSelective(map);
        if (result > 0) {
            this.levelMapper.mapNumPlusOne(map.getLevelCode());
            return result;
        }
        return result;
    }

    public MissionAndResource getMissionAndResource(String mapCode) {
        if (StringUtils.isBlank((CharSequence)mapCode)) {
            return new MissionAndResource();
        }
        MissionAndResource resource = null;
        try {
            resource = (MissionAndResource)this.redisCache.getBytesObject("MAP_RESOURCE:" + mapCode);
        }
        catch (Exception e) {
            this.redisCache.del("MAP_RESOURCE:" + mapCode);
        }
        if (null != resource) {
            return resource;
        }
        resource = new MissionAndResource();
        MapResourceRel resourceRel = this.mapResourceRelMapper.selectByMapCode(mapCode);
        if (null != resourceRel) {
            List dynamicList = this.attachMapper.selectByRelCode(resourceRel.getResourcePackageCode());
            PicGallery paramPicGallery = new PicGallery();
            paramPicGallery.setMapCode(resourceRel.getResourcePackageCode());
            List picGalleryList = this.picGalleryMapper.selectPicGalleryList(paramPicGallery);
            resource.setDynamicList(dynamicList);
            resource.setPicGalleryList(picGalleryList);
        }
        Mission paramMission = new Mission();
        paramMission.setMapCode(mapCode);
        paramMission.setStatus("NORMAL");
        ArrayList missionCodes = new ArrayList();
        List missionList = this.missionMapper.selectMissionList(paramMission);
        if (CollectionUtils.isEmpty((Collection)missionList)) {
            new CacheUtilsNew(this.redisCache, "MAP_RESOURCE:" + mapCode, (Object)resource, CacheEnum.SET_BYTES).run();
            return resource;
        }
        missionList.forEach(v -> missionCodes.add(v.getMissionCode()));
        resource.setMissionList(missionList);
        resource.setMissionCodes(missionCodes);
        new CacheUtilsNew(this.redisCache, "MAP_RESOURCE:" + mapCode, (Object)resource, CacheEnum.SET_BYTES).run();
        return resource;
    }

    public Long getFirstMapidByLevelCode(String levelCode) {
        return this.mapMapper.selectFirstMapidByLevelCode(levelCode);
    }

    public Long getFirstMapIdByLevelCode(String uid, String levelCode) {
        return this.mapMapper.selectFirstMapIdByLevelCode(uid, levelCode);
    }

    public void moveInsertMapIndex(String levelCode, Integer levelOrder) {
        Map map = this.mapMapper.selectByLevelAndOrder(levelCode, levelOrder);
        if (map != null) {
            List maps = this.mapMapper.selectByLevelCodeAndGreaterThanOrder(levelCode, levelOrder);
            maps.forEach(item -> {
                item.setLevelOrder(Integer.valueOf(item.getLevelOrder() + 1));
                this.mapMapper.updateByPrimaryKeySelective(item);
            });
        }
    }

    public boolean moveAndInsertUserMap(String uid, Level level, UserLevelResourceVersion userLevelResourceVersion) {
        log.info("moveAndInsertUserMap->" + uid + ":" + level.getLevelCode());
        String levelCode = level.getLevelCode();
        List userMapList = this.userMapMapper.selectByLevelCode(uid, levelCode);
        Set userMapCodeSet = null;
        if (userMapList != null) {
            userMapCodeSet = userMapList.stream().map(BaseMap::getMapCode).collect(Collectors.toSet());
        }
        Integer lastVersion = userLevelResourceVersion == null ? 1 : userLevelResourceVersion.getVersion();
        List sysResourceUpdateLogList = this.sysResourceOperateService.getNeedUpdateResource(DataEnum.SYS_RESOURCE_TYPE.LEVEL.getValue(), level.getLevelCode(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MAP_RESOURCE_INSERT.getValue(), lastVersion);
        if (sysResourceUpdateLogList == null || sysResourceUpdateLogList.size() == 0) {
            return false;
        }
        ArrayList<Map> insertMapList = new ArrayList<Map>();
        for (SysResourceUpdateLog sysResourceUpdateLog : sysResourceUpdateLogList) {
            Map map2;
            if (userMapCodeSet != null && userMapCodeSet.contains(sysResourceUpdateLog.getOpCode()) || !(map2 = this.mapMapper.selectByMapCode(sysResourceUpdateLog.getOpCode())).getStatus().equals("SURE")) continue;
            insertMapList.add(map2);
        }
        if (insertMapList.size() == 0) {
            return false;
        }
        UserMap doingMap = this.userMapMapper.selectDoingUserMap(uid);
        insertMapList.forEach(map -> this.handleInsertUserMap(uid, map, doingMap));
        return true;
    }

    private boolean judgeInsertUserMap(String uid, String levelCode, Integer levelOrder) {
        boolean result = false;
        String maxLevelCode = this.userMapMapper.selectMaxLevelCode(uid);
        if (Integer.valueOf(maxLevelCode) >= Integer.valueOf(levelCode)) {
            result = true;
        }
        boolean isPassAccount = false;
        String level = this.userMapper.selectUserLevelCode(uid);
        if (level != null && !level.equals("")) {
            int levelx = Integer.parseInt(level);
            int levelCodex = Integer.parseInt(levelCode);
            if (levelCodex <= levelx) {
                result = true;
            }
        } else {
            UserMap lastMap = this.userMapMapper.selectLastMap(uid, levelCode);
            if (lastMap != null && lastMap.getLevelOrder() < levelOrder && !isPassAccount) {
                result = false;
            }
        }
        return result;
    }

    private void handleInsertUserMap(String uid, Map map, UserMap doingMap) {
        UserMap lastUserMap;
        Integer levelOrder;
        log.info("handleInsertUserMap->" + uid + ":" + map.getMapCode());
        if (map == null) {
            return;
        }
        if (!map.getStatus().equals("SURE")) {
            return;
        }
        String mapCode = map.getMapCode();
        String levelCode = map.getLevelCode();
        boolean isInsert = this.judgeInsertUserMap(uid, levelCode, levelOrder = map.getLevelOrder());
        if (!isInsert) {
            return;
        }
        Map oldMap = this.mapMapper.selectMinAbsMap(levelCode, levelOrder, null);
        UserMission userMissionLexile = null;
        String status = "NOTSTARTED";
        if (oldMap == null && (lastUserMap = this.userMapMapper.selectLastMap(uid, levelCode)) != null) {
            userMissionLexile = this.userMissionMapper.selectLastMission(uid, lastUserMap.getMapCode());
        }
        UserMap record = MapUtils.mapToUserMap((Map)map, (String)uid, (Boolean)false);
        record.setStatus(status);
        this.userMapMapper.insertSelective(record);
        Mission queryParam = new Mission();
        queryParam.setMapCode(mapCode);
        List missions = this.missionMapper.selectMissionList(queryParam);
        for (Mission mission : missions) {
            if (userMissionLexile != null && userMissionLexile.getMissionCode().equals(mission.getMissionCode())) {
                userMissionLexile.setMapCode(mission.getMapCode());
                userMissionLexile.setStatus(status);
                userMissionLexile.setMissionIndex(mission.getMissionIndex());
                userMissionLexile.setMissionCoords(mission.getMissionCoords());
                this.userMissionMapper.updateByPrimaryKeySelective(userMissionLexile);
                continue;
            }
            UserMission userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)levelCode);
            userMission.setStatus(status);
            this.userMissionMapper.insertSelective(userMission);
        }
        if (doingMap != null && doingMap.getLevelOrder().compareTo(record.getLevelOrder()) >= 0) {
            log.info("handleInsertUserMap insertSysResourceNotify" + uid + ":" + map.getMapCode());
            this.sysResourceOperateService.insertSysResourceNotify(uid, mapCode, DataEnum.SYS_RESOURCE_UPDATE_TYPE.MAP_RESOURCE_INSERT.getValue());
        }
    }

    public void moveLexileMission(String mapCode) {
        Map map = this.mapMapper.selectByMapCode(mapCode);
        if (map.getStatus().equals("SURE")) {
            return;
        }
        String levelCode = map.getLevelCode();
        Map lastMap = this.mapMapper.selectLastByLevelCode(levelCode);
        if (lastMap == null) {
            return;
        }
        if (lastMap.getLevelOrder() >= map.getLevelOrder()) {
            return;
        }
        if (lastMap.getMapCode().equals(mapCode)) {
            Mission lexileMission = this.missionMapper.selectLexileMission(mapCode, 4);
            if (lexileMission != null) {
                return;
            }
            Map preMap = this.getPreMap(mapCode);
            lexileMission = this.missionMapper.selectLexileMission(preMap.getMapCode(), 4);
            if (lexileMission == null) {
                // empty if block
            }
            lexileMission.setMapCode(mapCode);
            Mission currMission = this.missionMapper.selectLastByMapCode(mapCode);
            String coords = MapUtils.getNextCoord((String)currMission.getMissionCoords());
            lexileMission.setMissionCoords(coords);
            lexileMission.setMissionIndex(Integer.valueOf(currMission.getMissionIndex() + 1));
            this.missionMapper.updateByPrimaryKeySelective(lexileMission);
        }
    }

    public void incrSysVersion(Level level) {
        level.setVersion(Integer.valueOf(level.getVersion() + 1));
        this.levelMapper.updateByPrimaryKeySelective(level);
    }

    public void moveDelMapIndex(String levelCode, Integer levelOrder) {
        Map map = this.mapMapper.selectByLevelAndOrder(levelCode, levelOrder);
        if (map != null) {
            List maps = this.mapMapper.selectByLevelCodeAndGreaterThanOrder(levelCode, levelOrder);
            maps = maps.stream().filter(item -> !item.getLevelOrder().equals(levelOrder)).collect(Collectors.toList());
            maps.sort(Comparator.comparing(BaseMap::getLevelOrder));
            Integer preLevelOrder = levelOrder;
            for (Map item2 : maps) {
                int currLevelOrder = item2.getLevelOrder();
                item2.setLevelOrder(preLevelOrder);
                this.mapMapper.updateByPrimaryKeySelective(item2);
                preLevelOrder = currLevelOrder;
            }
        }
    }

    private UserMap getPreUserMap(String uid, String levelCode, Integer levelOrder) {
        if (LevelEnum.LV1.getCode().equals(levelCode) && levelOrder == 1) {
            return null;
        }
        List userMaps = this.userMapMapper.selectListByOrder(uid);
        UserMap pre = null;
        for (UserMap userMap : userMaps) {
            if (userMap.getLevelCode().equals(levelCode) && userMap.getLevelOrder().equals(levelOrder)) {
                return pre;
            }
            pre = userMap;
        }
        return pre;
    }

    private Map getPreMap(String mapCode) {
        List maps = this.mapMapper.selectListByOrder();
        Map pre = null;
        for (Map map : maps) {
            if (map.getMapCode().equals(mapCode)) {
                return pre;
            }
            pre = map;
        }
        return null;
    }
}

