/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.DateUtil;
import com.ella.frame.common.util.LexileUtil;
import com.ella.resource.api.LevelService;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.LexileEvaluationStatusEnum;
import com.ella.resource.constants.LexileTestTypeEnum;
import com.ella.resource.domain.LexileLevelHistory;
import com.ella.resource.domain.QuestionLexileRecord;
import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.LexileEvaluationDto;
import com.ella.resource.dto.LexileEvaluationQuestionDto;
import com.ella.resource.dto.LexileEvaluationQuestionItemDto;
import com.ella.resource.dto.LexileLevelHistoryDto;
import com.ella.resource.dto.appdto.AfterLexilePassDto;
import com.ella.resource.dto.lexile.LexileR2bScoreRequest;
import com.ella.resource.dto.lexile.LexileR2bScoreResponse;
import com.ella.resource.dto.request.lexile.LexileEvalutionHandOverRequest;
import com.ella.resource.dto.request.question.LexileAnswerResponse;
import com.ella.resource.mapper.LexileLevelHistoryMapper;
import com.ella.resource.mapper.QuestionLexileRecordMapper;
import com.ella.resource.service.transactional.LexileEvaluationTService;
import com.ella.resource.service.transactional.LexileLevelHistoryTService;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.utils.LexileR2bScoreUtil;
import com.ella.user.api.UserInfoService;
import com.ella.user.dto.AccountDto;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.request.userinfo.UpdateUserLevelRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LexileLevelHistoryTServiceImpl
implements LexileLevelHistoryTService {
    private static final Logger log = LogManager.getLogger(LexileLevelHistoryTServiceImpl.class);
    @Autowired
    LexileR2bScoreUtil lexileScoreUtil;
    @Autowired
    LexileLevelHistoryMapper mapper;
    @Autowired
    QuestionLexileRecordMapper questionLexileRecordMapper;
    @Autowired
    LexileEvaluationTService lexileService;
    @Autowired
    LevelService levelService;
    @Autowired
    UserInfoService userInfoService;
    @Autowired
    MapTService mapTService;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;
    @Value(value="${lexile.promotion.local:1}")
    private Integer promotion;

    @Async
    public void updateUserLexileLevelHistoryStatus(String uid, Integer exceptId, String originStatusCode, String statusCode) {
        int affectRows = this.mapper.updateUserHistoryStatus(uid, exceptId, originStatusCode, statusCode);
        log.info("\u66f4\u65b0\u7528\u6237[{}]\u84dd\u601d\u8bc4\u6d4b\u72b6\u6001[{}]-\u6570\u91cf[{}]", (Object)uid, (Object)statusCode, (Object)affectRows);
    }

    private int judgeAnswer(List<QuestionLexileRecord> answers) {
        int score = 0;
        for (QuestionLexileRecord record : answers) {
            if (!record.getOptionKey().equalsIgnoreCase(record.getOptionKeyCorrect())) continue;
            ++score;
        }
        return score;
    }

    private String findQuestionCorrectOptionKey(LexileEvaluationQuestionDto question) {
        String key = null;
        if (question != null && !CollectionUtils.isEmpty((Collection)question.getQuestionItemDtoList())) {
            for (LexileEvaluationQuestionItemDto it : question.getQuestionItemDtoList()) {
                if (!it.getIsTrueAnswer().booleanValue()) continue;
                key = it.getOptionKey();
                break;
            }
        }
        return key;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public LexileAnswerResponse handover(LexileEvalutionHandOverRequest request) {
        int updateResult;
        ResponseParams responseParams;
        LexileEvaluationDto eva;
        String originLevelCode;
        log.info("Receive Lexile Evaluation hand over request - [{}]", (Object)request);
        if (CollectionUtils.isEmpty((Collection)request.getAnswers())) {
            throw new EllaEnglishException(CommonRetCode.PARAM_ERROR.getCode(), CommonRetCode.PARAM_ERROR.getMsg(), "\u7b54\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LexileAnswerResponse result = new LexileAnswerResponse();
        Date now = new Date();
        LexileLevelHistory history = this.mapper.selectByPrimaryKey(Integer.valueOf(request.getHistoryId().intValue()));
        this.checkEvaluationHistroy(history);
        String realLevelCode = originLevelCode = history.getLevelCode();
        boolean isPrepare10 = false;
        boolean isPrepare8 = false;
        if (LevelEnum.LV0.equealTo(originLevelCode)) {
            if (request.getAnswers().size() == 10) {
                isPrepare10 = true;
            }
            if (request.getAnswers().size() == 8) {
                isPrepare8 = true;
            }
            if (StringUtils.isNotBlank((CharSequence)history.getRemark())) {
                realLevelCode = history.getRemark();
            }
        }
        if ((eva = this.lexileService.selectDetailByLevelCode(realLevelCode)) == null || CollectionUtils.isEmpty((Collection)eva.getQuestionDtoList())) {
            throw new EllaEnglishException(CommonRetCode.DATA_NOT_EXISTED.getCode(), CommonRetCode.DATA_NOT_EXISTED.getMsg(), "\u8bc4\u6d4b\u9898\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        ArrayList currentAnswers = new ArrayList();
        Map<Long, LexileEvaluationQuestionDto> questionMap = eva.getQuestionDtoList().stream().collect(Collectors.toMap(LexileEvaluationQuestionDto::getId, q -> q));
        request.getAnswers().forEach(ua -> {
            LexileEvaluationQuestionDto q = (LexileEvaluationQuestionDto)questionMap.get(ua.getQuestionId());
            if (q != null) {
                QuestionLexileRecord record = new QuestionLexileRecord();
                record.setLevelCode(originLevelCode);
                record.setLexileHistoryId(Long.valueOf(history.getId().longValue()));
                record.setQuestionId(q.getId());
                record.setQuestionOrder(q.getIdx());
                record.setOptionKey(ua.getAnswerKey());
                record.setOptionKeyCorrect(this.findQuestionCorrectOptionKey(q));
                record.setUid(request.getUid());
                record.setCreateTime(now);
                currentAnswers.add(record);
            }
        });
        Collections.sort(currentAnswers);
        int score = this.judgeAnswer(currentAnswers);
        if (isPrepare10) {
            LexileLevelHistory upHis = new LexileLevelHistory();
            if (score < 3) {
                this.questionLexileRecordMapper.batchInsert(currentAnswers);
                result.setNewQuestions(true);
                result.setEvaluation(this.lexileService.selectDetailByLevelCode(LevelEnum.LV1.getCode()));
                upHis.setRemark(LevelEnum.LV1.getCode());
                upHis.setId(history.getId());
                this.mapper.updateByPrimaryKeySelective(upHis);
            }
            return result;
        }
        if (isPrepare8 && score >= 3) {
            this.questionLexileRecordMapper.batchInsert(currentAnswers);
            result.setNewQuestions(true);
            result.setEvaluation(this.lexileService.selectDetailByLevelCode(realLevelCode));
            return result;
        }
        LexileEvaluationQuestionDto formQuestion = (LexileEvaluationQuestionDto)eva.getQuestionDtoList().get(eva.getQuestionDtoList().size() - 1);
        LexileR2bScoreRequest r2bRequest = new LexileR2bScoreRequest();
        LexileLevelHistory lastlexileHistory = this.mapper.findLatestHistoryForDisplay(request.getUid());
        if (lastlexileHistory == null) {
            r2bRequest.setMethod(LexileTestTypeEnum.RANK.getMethod());
            r2bRequest.setParams(Arrays.asList(String.format("L%s", formQuestion.getFormId()), score));
        } else {
            r2bRequest.setMethod(LexileTestTypeEnum.PROMITION.getMethod());
            Integer bPrior = lastlexileHistory.getLexileScore();
            Integer sigmaPrior = lastlexileHistory.getLexileSem();
            long numDays = DateUtil.differentDays((Date)lastlexileHistory.getCreateTime(), (Date)now);
            r2bRequest.setParams(Arrays.asList(bPrior == null ? 0 : bPrior, sigmaPrior, numDays, String.format("L%s", formQuestion.getFormId()), score, String.valueOf(history.getAge())));
        }
        LexileR2bScoreResponse.Result r2bResult = null;
        if (this.promotion == 1 && request.isPromotion()) {
            r2bResult = this.lexileScoreUtil.scoreLocal(originLevelCode, Integer.valueOf(score));
        } else {
            r2bResult = this.lexileScoreUtil.score(r2bRequest);
            if (r2bResult == null) {
                throw new EllaEnglishException(CommonRetCode.SERVER_ERROR.getCode(), "Lexile service exception\uff01", "\u84dd\u601d\u63a5\u53e3\u5f02\u5e38\uff0c\u670d\u52a1\u8d85\u65f6\u6216\u63a5\u53e3\u4e0d\u53ef\u7528\uff01");
            }
            log.info("Lexile Api R2b.score result [{}] for evaluation history[{}]", (Object)r2bResult, (Object)history);
        }
        Integer ability = r2bResult.getB_new();
        if (ability != null) {
            int abilityx = ability / 10;
            int lastNum = Math.abs(ability % 10);
            if (lastNum <= 2) {
                lastNum = 0;
            } else if (2 < lastNum && lastNum < 7) {
                lastNum = 5;
            } else {
                lastNum = 0;
                abilityx = abilityx > 0 ? ++abilityx : --abilityx;
            }
            ability = Integer.valueOf(String.valueOf(abilityx) + lastNum);
        }
        history.setLexileScore(ability);
        history.setLexileSem(Integer.valueOf(r2bResult.getSigma_new()));
        history.setStatus(LexileEvaluationStatusEnum.COMPLETED.getCode());
        int enAbility = LexileUtil.rawAbility2EnAbility((int)ability);
        String lexileLevel = LexileUtil.formatAbility((int)enAbility);
        history.setLexileLevel(lexileLevel);
        history.setCorrectNum(Integer.valueOf(score));
        history.setEndTime(now);
        ResponseParams levelResp = this.levelService.getLevelByAbility(Integer.valueOf(enAbility));
        if (!CommonRetCode.isSuccess((String)levelResp.getCode())) {
            log.error("Lexile Ability [{}]'s level not existed.", (Object)ability);
            throw new EllaEnglishException(CommonRetCode.DATA_NOT_EXISTED.getCode(), CommonRetCode.DATA_NOT_EXISTED.getMsg(), "\u7f3a\u5c11\u7b49\u7ea7\u4fe1\u606f\uff01");
        }
        LevelDto level = (LevelDto)levelResp.getData();
        boolean promotion = LexileUtil.higherLevel((String)level.getLevelCode(), (String)originLevelCode);
        result.setLevelInfo(level);
        history.setLevelCode(level.getLevelCode());
        history.setPromotion(Boolean.valueOf(promotion));
        this.mapper.updateByPrimaryKeySelective(history);
        this.setOriginalLevelCode(result, request.getUid());
        this.userInfoService.updateUserLevelInfo(UpdateUserLevelRequest.builder().uid(request.getUid()).lexileLevel(lexileLevel).levelCode(level.getLevelCode()).build());
        LexileLevelHistoryDto hisDto = new LexileLevelHistoryDto();
        BeanUtils.copyProperties((Object)history, (Object)hisDto);
        result.setResult(hisDto);
        result.setPromotion(Boolean.valueOf(promotion));
        if (!promotion) {
            result.setMissionInfo(this.mapper.selectWrongAnswerMissionInfoByHistoryId(history.getId()));
        }
        Long mapId = this.mapTService.getFirstMapIdByLevelCode(request.getUid(), history.getLevelCode());
        result.setMapId(mapId);
        if (result.getPromotion().booleanValue()) {
            this.userMapAndMissionService.updateUserMapAfterLexileTest(AfterLexilePassDto.builder().levelCode(level.getLevelCode()).originalLevelCode(result.getOriginalLevelCode()).uid(request.getUid()).promotion(request.isPromotion()).missionId(request.getMissionId()).build());
        }
        if ((responseParams = this.userInfoService.getUserAccountInfo(request.getUid())) != null && CommonRetCode.isSuccess((String)responseParams.getCode())) {
            result.setStoneNum(((AccountDto)responseParams.getData()).getStoneNum());
        }
        if (LexileEvaluationStatusEnum.COMPLETED.equals((Object)history.getStatus()) && (updateResult = this.mapper.UpdateEvaluationTime(history.getUid())) <= 0) {
            throw new EllaEnglishException("\u66f4\u65b0\u7528\u6237\u84dd\u601d\u8bc4\u6d4b\u6b21\u6570\u51fa\u9519------uid : " + history.getUid());
        }
        return result;
    }

    private void setOriginalLevelCode(LexileAnswerResponse result, String uid) {
        ResponseParams userInfoDtoResponseParams = this.userInfoService.selectUserByUid(uid);
        UserInfoDto userInfoDto = (UserInfoDto)userInfoDtoResponseParams.getData();
        if (Objects.nonNull(userInfoDto)) {
            result.setOriginalLevelCode(userInfoDto.getLevel());
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void JiaDe(String uid, String levelCode, int evaluationId, int age, int ability, int sem) {
        Date now = new Date();
        LexileEvaluationDto evaluation = this.lexileService.selectDetailById(Long.valueOf(evaluationId));
        ResponseParams levelResp = this.levelService.getLevelByAbility(Integer.valueOf(ability));
        if (!CommonRetCode.isSuccess((String)levelResp.getCode())) {
            log.error("Lexile Ability [{}]'s level not existed.");
            return;
        }
        LevelDto level = (LevelDto)levelResp.getData();
        String code = level.getLevelCode();
        LexileLevelHistory history = LexileLevelHistory.builder().uid(uid).evaluationId(Integer.valueOf(evaluationId)).age(Integer.valueOf(age)).levelCode(code).originLevelCode(code).testNum(Integer.valueOf(evaluation.getQuestionDtoList().size())).correctNum(Integer.valueOf(0)).status(LexileEvaluationStatusEnum.UNDERWAY.getCode()).lexileLevel("").promotion(Boolean.FALSE).startTime(now).createTime(now).remark(code).build();
        history.setLexileScore(Integer.valueOf(ability));
        history.setLexileSem(Integer.valueOf(sem));
        history.setStatus(LexileEvaluationStatusEnum.COMPLETED.getCode());
        int enAbility = LexileUtil.rawAbility2EnAbility((int)ability);
        String lexileLevel = LexileUtil.formatAbility((int)enAbility);
        history.setLexileLevel(lexileLevel);
        history.setCorrectNum(Integer.valueOf(10));
        history.setEndTime(now);
        history.setPromotion(Boolean.valueOf(true));
        log.info("update user history");
        this.mapper.insertSelective(history);
        log.info("update user info");
        this.userInfoService.updateUserLevelInfo(UpdateUserLevelRequest.builder().uid(uid).lexileLevel(lexileLevel).levelCode(code).build());
        log.info("update user map");
        this.userMapAndMissionService.updateUserMapAfterLexileTest(AfterLexilePassDto.builder().levelCode(code).originalLevelCode(levelCode).uid(uid).build());
    }

    private void checkEvaluationHistroy(LexileLevelHistory history) {
        if (history == null) {
            throw new EllaEnglishException(CommonRetCode.DATA_NOT_EXISTED.getCode(), "\u8bc4\u6d4b\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01", "\u8bc4\u6d4b\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (!LexileEvaluationStatusEnum.UNDERWAY.equalTo(history.getStatus())) {
            throw new EllaEnglishException(CommonRetCode.STATUS_ERROR.getCode(), "\u65e0\u6cd5\u5f97\u5230\u8bc4\u6d4b\u7ed3\u679c\uff0c\u53ef\u80fd\u662f\u8d85\u65f6\u6216\u5176\u4ed6\u539f\u56e0\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\uff01", "\u8bc4\u6d4b\u72b6\u6001\u9519\u8bef,\u8bc4\u6d4b\u5df2\u5173\u95ed\u6216\u5df2\u5b8c\u6210\uff01");
        }
    }
}

