/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.common.dto.dictionary.AbilitySecondTypeEnum;
import com.ella.common.dto.dictionary.AbilityTypeEnum;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.util.CoreUtil;
import com.ella.resource.domain.BaseMap;
import com.ella.resource.domain.IraReadReportExample;
import com.ella.resource.domain.UserCourse;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMapExample;
import com.ella.resource.dto.IraFirstAbilityReportDto;
import com.ella.resource.dto.IraQuestionAbilityTypeDto;
import com.ella.resource.dto.IraQuestionScoreDto;
import com.ella.resource.dto.IraReadRecordStartAndEndTime;
import com.ella.resource.dto.IraReportDto;
import com.ella.resource.dto.IraSecondAbilityReportDto;
import com.ella.resource.dto.IraSecondAbilityTotalDto;
import com.ella.resource.mapper.IraFirstAbilityReportMapper;
import com.ella.resource.mapper.IraReadRecordMapper;
import com.ella.resource.mapper.IraReadReportMapper;
import com.ella.resource.mapper.IraReportMapper;
import com.ella.resource.mapper.IraSecondAbilityReportMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.IraReadReportTService;
import com.ella.resource.service.transactional.impl.IraReadReportServiceImpl;
import com.ella.resource.utils.ShowStatusEnum;
import com.ella.user.api.enums.DataStatusEnum;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IraReadReportServiceImpl
implements IraReadReportTService {
    private static final Logger log = LogManager.getLogger(IraReadReportServiceImpl.class);
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private IraReadRecordMapper iraReadRecordMapper;
    @Autowired
    private IraReadReportMapper iraReadReportMapper;
    @Autowired
    private DistributedCache redis;
    @Autowired
    private IraFirstAbilityReportMapper iraFirstAbilityReportMapper;
    @Autowired
    private IraSecondAbilityReportMapper iraSecondAbilityReportMapper;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private IraReportMapper iraReportMapper;
    private static final Map<Integer, Integer> abilityTypeMap = new HashMap();

    public List<IraReportDto> generateReadVolumeReport(String uid) {
        ArrayList<IraReportDto> iraReadReportList = new ArrayList<IraReportDto>();
        UserMapExample userMapExample = new UserMapExample();
        userMapExample.createCriteria().andUidEqualTo(uid).andStatusNotEqualTo("NOTSTARTED");
        List userMapList = this.userMapMapper.selectByExample(userMapExample);
        if (CollectionUtils.isEmpty((Collection)userMapList)) {
            return iraReadReportList;
        }
        List<String> mapCodes = userMapList.stream().map(BaseMap::getMapCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(mapCodes)) {
            return iraReadReportList;
        }
        ArrayList mapCodesUpdated = new ArrayList();
        mapCodes.forEach(mapCode -> {
            String status = this.redis.get("BOE:EN:IRA:REPORT:" + uid + ":" + mapCode);
            if (!StringUtils.isNotBlank((CharSequence)status) || !"1".equals(status)) {
                mapCodesUpdated.add(mapCode);
            }
        });
        for (UserMap userMap : userMapList) {
            if (StringUtils.isBlank((CharSequence)userMap.getMapCode()) || !mapCodesUpdated.contains(userMap.getMapCode())) continue;
            IraReportDto iraReadReportTemp = this.getChildrenLastReadReport(uid, userMap.getMapCode());
            Map missionAndCourseNum = this.getMapMissionAndCourseNum(userMap.getMapCode(), uid);
            if (Objects.isNull(iraReadReportTemp)) {
                iraReadReportTemp = this.iraReadRecordMapper.getUserMapReadTimeAndReadNum(userMap.getMapCode(), uid);
                iraReadReportTemp.setReportCode(CoreUtil.createCommonsCore((String)"R", (int)4));
                this.buildData(iraReadReportTemp, missionAndCourseNum, iraReadReportList, userMap);
                continue;
            }
            IraReadRecordStartAndEndTime startAndEndTime = this.getStartAndEndDateToSelect(iraReadReportTemp);
            IraReportDto readRecordBetweenTwoDays = this.iraReadRecordMapper.getIraReadRecordBetweenTwoDays(startAndEndTime.getStart(), startAndEndTime.getEnd(), userMap.getMapCode(), uid);
            Integer completedCourseNumBetweenTwoDays = this.getCompletedCourseNumBetweenTwoDays(userMap.getMapCode(), uid, startAndEndTime.getStart(), startAndEndTime.getEnd());
            iraReadReportTemp.setReadCountIncrease((Integer)ObjectUtils.defaultIfNull((Object)readRecordBetweenTwoDays.getReadCount(), (Object)0));
            iraReadReportTemp.setReadCount(Integer.valueOf((Integer)ObjectUtils.defaultIfNull((Object)iraReadReportTemp.getReadCount(), (Object)0) + (Integer)ObjectUtils.defaultIfNull((Object)iraReadReportTemp.getReadCountIncrease(), (Object)0)));
            iraReadReportTemp.setReadTimeIncrease(readRecordBetweenTwoDays.getReadTimeIncrease());
            iraReadReportTemp.setReadTime(Integer.valueOf((Integer)ObjectUtils.defaultIfNull((Object)iraReadReportTemp.getReadTime(), (Object)0) + (Integer)ObjectUtils.defaultIfNull((Object)iraReadReportTemp.getReadTimeIncrease(), (Object)0)));
            iraReadReportTemp.setCompletedCourseIncrease((Integer)ObjectUtils.defaultIfNull((Object)completedCourseNumBetweenTwoDays, (Object)0));
            this.buildData(iraReadReportTemp, missionAndCourseNum, iraReadReportList, userMap);
        }
        return iraReadReportList;
    }

    private IraReportDto getChildrenLastReadReport(String uid, String mapCode) {
        IraReadReportExample iraReadReportExample = new IraReadReportExample();
        iraReadReportExample.createCriteria().andUidEqualTo(uid).andMapCodeEqualTo(mapCode);
        List iraReadReports = this.iraReadReportMapper.selectByExample(iraReadReportExample);
        if (CollectionUtils.isEmpty((Collection)iraReadReports)) {
            return null;
        }
        IraReportDto temp = new IraReportDto();
        BeanUtils.copyProperties(iraReadReports.get(0), (Object)temp);
        return temp;
    }

    private Map<String, Integer> getMapMissionAndCourseNum(String mapCode, String uid) {
        String totalMissionStr = this.redis.get("BOE:EN:IRA:MAP_MISSION_NUM:" + mapCode);
        if (StringUtils.isBlank((CharSequence)totalMissionStr)) {
            Integer totalMission = this.mapMapper.getMissionNumByMapCode(mapCode);
            totalMissionStr = totalMission.toString();
            this.redis.set("BOE:EN:IRA:MAP_MISSION_NUM:" + mapCode, (Object)totalMissionStr, 300);
        }
        Map missionAndCourseNum = this.getChildrenCompletedMissionAndCourseNum(mapCode, uid);
        missionAndCourseNum.put("totalMission", Integer.valueOf(totalMissionStr));
        return missionAndCourseNum;
    }

    private Map<String, Integer> getChildrenCompletedMissionAndCourseNum(String mapCode, String uid) {
        Map missionAndCourseNum = this.userMissionMapper.getChildrenCompletedMissionAndCourseNum(mapCode, uid);
        HashMap<String, Integer> map = new HashMap<String, Integer>(3);
        map.put("courseNum", Integer.valueOf(ObjectUtils.defaultIfNull(missionAndCourseNum.get("courseNum"), (Object)0).toString()));
        map.put("missionNum", Integer.valueOf(ObjectUtils.defaultIfNull(missionAndCourseNum.get("missionNum"), (Object)0).toString()));
        return map;
    }

    private Integer getCompletedCourseNumBetweenTwoDays(String mapCode, String uid, Date start, Date end) {
        return this.userMissionMapper.getCompletedCourseNumBetweenTwoDays(mapCode, uid, start, end);
    }

    private IraReadRecordStartAndEndTime getStartAndEndDateToSelect(IraReportDto iraReadReportTemp) {
        IraReadRecordStartAndEndTime startAndEndTime = new IraReadRecordStartAndEndTime();
        Date reportTime = iraReadReportTemp.getReportTime();
        Date reportStartTime = this.getFirstTimeOfDate(reportTime);
        Date reportEndTime = this.getFirstTimeOfDate(new Date());
        startAndEndTime.setStart(reportStartTime);
        startAndEndTime.setEnd(reportEndTime);
        return startAndEndTime;
    }

    private Date getFirstTimeOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private void buildData(IraReportDto iraReadReportTemp, Map<String, Integer> missionAndCourseNum, List<IraReportDto> iraReadReportList, UserMap userMap) {
        iraReadReportTemp.setMapCode(userMap.getMapCode());
        iraReadReportTemp.setUid(userMap.getUid());
        iraReadReportTemp.setTotalMission(missionAndCourseNum.get("totalMission"));
        iraReadReportTemp.setCompletedMissionNum(missionAndCourseNum.get("missionNum"));
        iraReadReportTemp.setCompletedCourse(missionAndCourseNum.get("courseNum"));
        if (iraReadReportTemp.getTotalMission().equals(iraReadReportTemp.getCompletedMissionNum())) {
            iraReadReportTemp.setFirstSuccessTime(userMap.getUpdateTime());
        }
        iraReadReportTemp.setReportTime(new Date());
        iraReadReportList.add(iraReadReportTemp);
    }

    public void saveReport(List<IraReportDto> iraReadReportList) {
        if (CollectionUtils.isEmpty(iraReadReportList)) {
            return;
        }
        iraReadReportList = iraReadReportList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.iraReadReportMapper.insertBatch(iraReadReportList);
        List<Object> firstAbilityReportDtoList = new ArrayList();
        List<Object> secondAbilityReportDtoList = new ArrayList();
        for (IraReportDto iraReportDto : iraReadReportList) {
            if (!CollectionUtils.isNotEmpty((Collection)iraReportDto.getFirstAbilitys())) continue;
            firstAbilityReportDtoList.addAll(iraReportDto.getFirstAbilitys());
        }
        if (CollectionUtils.isNotEmpty(firstAbilityReportDtoList)) {
            firstAbilityReportDtoList = firstAbilityReportDtoList.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.iraFirstAbilityReportMapper.insertBatch(firstAbilityReportDtoList);
        }
        for (IraFirstAbilityReportDto iraFirstAbilityReportDto : firstAbilityReportDtoList) {
            if (!CollectionUtils.isNotEmpty((Collection)iraFirstAbilityReportDto.getSecondAbilitys())) continue;
            secondAbilityReportDtoList.addAll(iraFirstAbilityReportDto.getSecondAbilitys());
        }
        if (CollectionUtils.isNotEmpty(secondAbilityReportDtoList)) {
            secondAbilityReportDtoList = secondAbilityReportDtoList.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.iraSecondAbilityReportMapper.insertBatch(secondAbilityReportDtoList);
        }
    }

    public void updateReport(List<IraReportDto> iraReadReportUpdateList) {
        if (CollectionUtils.isEmpty(iraReadReportUpdateList)) {
            return;
        }
        this.iraReadReportMapper.updateBatch(iraReadReportUpdateList);
        ArrayList firstAbilityReportDtoList = new ArrayList();
        iraReadReportUpdateList.stream().filter(Objects::nonNull).forEach(e -> {
            if (CollectionUtils.isNotEmpty((Collection)e.getFirstAbilitys())) {
                firstAbilityReportDtoList.addAll(e.getFirstAbilitys());
            }
        });
        if (CollectionUtils.isNotEmpty(firstAbilityReportDtoList)) {
            List<IraFirstAbilityReportDto> firstAbilityReportDtoListInsert;
            Map<Integer, List<IraFirstAbilityReportDto>> firstAbilityMap = firstAbilityReportDtoList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(IraFirstAbilityReportDto::getSaveStatus));
            List<IraFirstAbilityReportDto> firstAbilityReportDtoListUpdate = firstAbilityMap.get(0);
            if (CollectionUtils.isNotEmpty(firstAbilityReportDtoListUpdate)) {
                this.iraFirstAbilityReportMapper.updateBatch(firstAbilityReportDtoListUpdate);
                ArrayList secondAbilityReportDtoListUpdate = new ArrayList();
                firstAbilityReportDtoListUpdate.forEach(e -> {
                    if (CollectionUtils.isNotEmpty((Collection)e.getSecondAbilitys())) {
                        secondAbilityReportDtoListUpdate.addAll(e.getSecondAbilitys());
                    }
                });
                if (CollectionUtils.isNotEmpty(secondAbilityReportDtoListUpdate)) {
                    this.iraSecondAbilityReportMapper.updateBatch(secondAbilityReportDtoListUpdate);
                }
            }
            if (CollectionUtils.isNotEmpty(firstAbilityReportDtoListInsert = firstAbilityMap.get(1))) {
                this.iraFirstAbilityReportMapper.insertBatch(firstAbilityReportDtoListInsert);
                ArrayList secondAbilityReportDtoListInsert = new ArrayList();
                firstAbilityReportDtoListInsert.forEach(e -> {
                    if (CollectionUtils.isNotEmpty((Collection)e.getSecondAbilitys())) {
                        secondAbilityReportDtoListInsert.addAll(e.getSecondAbilitys());
                    }
                });
                if (CollectionUtils.isNotEmpty(secondAbilityReportDtoListInsert)) {
                    this.iraSecondAbilityReportMapper.insertBatch(secondAbilityReportDtoListInsert);
                }
            }
        }
    }

    public List<String> listMapCode() {
        List mapCodeList = this.mapMapper.getAllMapCodes();
        return mapCodeList;
    }

    public List<IraSecondAbilityTotalDto> listSecondAbilityTotal(String mapCode) {
        List list = this.mapMapper.listSecondAbilityTotal(mapCode);
        if (list != null && list.size() > 0) {
            return list.stream().filter(e -> !Objects.isNull(e.getFirstAbilityType()) && !Objects.isNull(e.getSecondAbilityType())).collect(Collectors.toList());
        }
        return list;
    }

    public List<IraQuestionAbilityTypeDto> listQuestionAbilityType(@Param(value="mapCode") String mapCode) {
        List list = this.mapMapper.listQuestionAbilityType(mapCode);
        if (list != null && list.size() > 0) {
            return list.stream().filter(e -> !Objects.isNull(e.getFirstAbilityType()) && !Objects.isNull(e.getSecondAbilityType())).collect(Collectors.toList());
        }
        return list;
    }

    public List<IraQuestionScoreDto> listQuestionScore(@Param(value="uid") String uid, @Param(value="mapCode") String mapCode) {
        return this.mapMapper.listQuestionScore(uid, mapCode);
    }

    private Map<Integer, IraFirstAbilityReportDto> getFirstReportMap(String reportCode) {
        HashMap<Integer, IraFirstAbilityReportDto> map = new HashMap<Integer, IraFirstAbilityReportDto>();
        List list = this.iraReportMapper.getIraFirstAbility(reportCode);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (IraFirstAbilityReportDto firstReport : list) {
                Integer firstType;
                if (firstReport == null || (firstType = firstReport.getFirstType()) == null) continue;
                map.put(firstType, firstReport);
            }
        }
        return map;
    }

    public void generateFirstAbilities(List<IraReportDto> iraReadReportList, Map<String, List<IraSecondAbilityTotalDto>> secondAbilityTotalMap) {
        for (IraReportDto iraReportDto : iraReadReportList) {
            List<Object> secondAbilityTotalList = new ArrayList();
            String mapCode = iraReportDto.getMapCode();
            if (StringUtils.isNotBlank((CharSequence)mapCode)) {
                secondAbilityTotalList = secondAbilityTotalMap.get(mapCode);
            }
            if (!CollectionUtils.isNotEmpty(secondAbilityTotalList)) continue;
            List firstAbilityList = this.createFirstAbilities(iraReportDto, secondAbilityTotalList);
            iraReportDto.setFirstAbilitys(firstAbilityList);
            this.redis.del("BOE:EN:IRA:REPORT_CODE:" + iraReportDto.getReportCode());
            this.redis.set("BOE:EN:IRA:REPORT:" + iraReportDto.getUid() + ":" + iraReportDto.getMapCode(), (Object)"1");
        }
    }

    private Map<String, Integer> typeMapTran(List<IraQuestionAbilityTypeDto> questionTypeList) {
        HashMap<String, Integer> typeMap = new HashMap<String, Integer>();
        if (CollectionUtils.isNotEmpty(questionTypeList)) {
            for (IraQuestionAbilityTypeDto temp : questionTypeList) {
                if (temp == null) continue;
                String missionCode = temp.getMissionCode();
                String pageId = temp.getPageId();
                String groupId = temp.getGroupId();
                String questionId = temp.getQuestionId();
                String key = missionCode + pageId + groupId + questionId;
                typeMap.put(key, temp.getSecondAbilityType());
            }
            return typeMap;
        }
        return null;
    }

    private Map<Integer, Integer> secondTotalNumMapTran(List<IraSecondAbilityTotalDto> secondAbilityTotalList) {
        HashMap<Integer, Integer> secondTotalNumMap = new HashMap<Integer, Integer>();
        if (CollectionUtils.isNotEmpty(secondAbilityTotalList)) {
            for (IraSecondAbilityTotalDto temp : secondAbilityTotalList) {
                if (temp == null) continue;
                Integer secondType = temp.getSecondAbilityType();
                Integer questionTotalNum = temp.getQuestionTotalNum();
                secondTotalNumMap.put(secondType, questionTotalNum);
            }
        }
        return secondTotalNumMap;
    }

    private List<IraFirstAbilityReportDto> createFirstAbilities(IraReportDto iraReportDto, List<IraSecondAbilityTotalDto> secondAbilityTotalList) {
        String mapCode = iraReportDto.getMapCode();
        String uid = iraReportDto.getUid();
        String reportCode = iraReportDto.getReportCode();
        if (StringUtils.isNotBlank((CharSequence)mapCode) && StringUtils.isNotBlank((CharSequence)uid) && CollectionUtils.isNotEmpty(secondAbilityTotalList)) {
            Map firstMapBySql = this.getFirstReportMap(reportCode);
            ArrayList<IraFirstAbilityReportDto> firstList = new ArrayList<IraFirstAbilityReportDto>();
            List questionTypeList = this.listQuestionAbilityType(mapCode);
            Map typeMap = this.typeMapTran(questionTypeList);
            if (MapUtils.isNotEmpty((Map)typeMap)) {
                Map secondTotalNumMap = this.secondTotalNumMapTran(secondAbilityTotalList);
                Map mapMap = this.secondAbilityData(typeMap, uid, mapCode);
                Map secondQuestionNumMap = (Map)mapMap.get("answerNum");
                Map secondQuestionScoreMap = (Map)mapMap.get("answerScore");
                IraFirstAbilityBaseData secondRead = new IraFirstAbilityBaseData(this);
                IraFirstAbilityBaseData secondLearn = new IraFirstAbilityBaseData(this);
                IraFirstAbilityBaseData secondListen = new IraFirstAbilityBaseData(this);
                IraFirstAbilityBaseData secondSpeech = new IraFirstAbilityBaseData(this);
                Map firstReportMap = this.createSecondAbilities(secondTotalNumMap, secondQuestionNumMap, secondQuestionScoreMap, secondRead, secondLearn, secondListen, firstMapBySql);
                int lastIraNumRead = this.getLastIraNum(firstMapBySql, 1);
                int lastIraNumLearn = this.getLastIraNum(firstMapBySql, 2);
                int lastIraNumListen = this.getLastIraNum(firstMapBySql, 4);
                IraFirstAbilityReportDto firstAbilityReportDtoRead = this.getfirstData(firstReportMap, reportCode, secondRead, lastIraNumRead, "READ", 1, 2);
                IraFirstAbilityReportDto firstAbilityReportDtoLearn = this.getfirstData(firstReportMap, reportCode, secondLearn, lastIraNumLearn, "LEARN", 2, 1);
                IraFirstAbilityReportDto firstAbilityReportDtoListen = this.getfirstData(firstReportMap, reportCode, secondListen, lastIraNumListen, "LISTEN", 4, 4);
                List courseList = this.userCourseMapper.getSpeechScoreByUidAndMapCode(uid, mapCode);
                List speechSecondAbilityList = this.generateSpeechSecondAbility(firstMapBySql, secondSpeech, secondTotalNumMap, courseList);
                IraFirstAbilityReportDto firstAbilityReportDtoSpeech = this.generateSpeechFirstAbility(speechSecondAbilityList, iraReportDto, secondSpeech, courseList, secondTotalNumMap);
                firstList.add(firstAbilityReportDtoRead);
                firstList.add(firstAbilityReportDtoLearn);
                firstList.add(firstAbilityReportDtoSpeech);
                firstList.add(firstAbilityReportDtoListen);
            }
            return firstList;
        }
        return null;
    }

    private int getLastIraNum(Map<Integer, IraFirstAbilityReportDto> firstMapBySql, int type) {
        IraFirstAbilityReportDto reportDto;
        int lastIraNum = 0;
        if (firstMapBySql != null && (reportDto = firstMapBySql.get(type)) != null) {
            lastIraNum = reportDto.getIraNum();
        }
        return lastIraNum;
    }

    private IraFirstAbilityReportDto getfirstData(Map<String, List<IraSecondAbilityReportDto>> firstReportMap, String reportCode, IraFirstAbilityBaseData secondRead, int lastIraNum, String type, int firstType, int idx) {
        List<IraSecondAbilityReportDto> list = firstReportMap.get(type);
        int iraNum = this.txFloat(secondRead.getSecondScoreCount(), secondRead.getSecondTotalScoreCount());
        IraFirstAbilityReportDto firstAbilityReportDto = IraFirstAbilityReportDto.builder().firstCode(list.get(0).getFirstCode()).reportCode(reportCode).iraNum(Integer.valueOf(iraNum)).iraNumChange(Integer.valueOf(iraNum - lastIraNum < 0 ? 0 : iraNum - lastIraNum)).interactTotal(Integer.valueOf(secondRead.getSecondTotalQuestionNumCount())).interactFinished(Integer.valueOf(secondRead.getSecondQuestionNumCount())).interactQuality(this.txFloatScore(secondRead.getSecondScoreCount(), secondRead.getSecondQuestionNumCount() * 3)).firstType(Integer.valueOf(firstType)).secondAbilitys(list).reportTime(new Date()).status(DataStatusEnum.NORMAL.getCode()).saveStatus(secondRead.getStatus()).idx(Integer.valueOf(idx)).build();
        return firstAbilityReportDto;
    }

    private Map<String, List<IraSecondAbilityReportDto>> createSecondAbilities(Map<Integer, Integer> secondTotalNumMap, Map<Integer, Integer> secondQuestionNumMap, Map<Integer, Integer> secondQuestionScoreMap, IraFirstAbilityBaseData secondRead, IraFirstAbilityBaseData secondLearn, IraFirstAbilityBaseData secondListen, Map<Integer, IraFirstAbilityReportDto> firstMapBySql) {
        this.buildFirstCodeData(secondRead, firstMapBySql.get(1));
        this.buildFirstCodeData(secondLearn, firstMapBySql.get(2));
        this.buildFirstCodeData(secondListen, firstMapBySql.get(4));
        HashMap<String, List<IraSecondAbilityReportDto>> firstReportMap = new HashMap<String, List<IraSecondAbilityReportDto>>();
        for (AbilitySecondTypeEnum e : AbilitySecondTypeEnum.values()) {
            Integer firstType;
            int secondType = e.getCode();
            if (secondType <= 0 || (firstType = (Integer)abilityTypeMap.get(secondType)) == null) continue;
            int secondTotalQuestionNum = 0;
            String showStatus = ShowStatusEnum.NOT_INSPECT.getDesc();
            if (secondTotalNumMap != null && secondTotalNumMap.get(secondType) != null) {
                secondTotalQuestionNum = secondTotalNumMap.get(secondType);
                showStatus = secondQuestionNumMap != null && secondQuestionNumMap.get(secondType) != null ? ShowStatusEnum.BEGINNING.getDesc() : ShowStatusEnum.UNLOCKED.getDesc();
            }
            int secondTotalScore = secondTotalQuestionNum * 3;
            int secondAnswerQuestionNum = 0;
            if (secondQuestionNumMap != null && secondQuestionNumMap.get(secondType) != null) {
                secondAnswerQuestionNum = secondQuestionNumMap.get(secondType);
            }
            int secondAnswerScore = 0;
            if (secondQuestionScoreMap != null && secondQuestionScoreMap.get(secondType) != null) {
                secondAnswerScore = secondQuestionScoreMap.get(secondType);
            }
            IraSecondAbilityReportDto secondAbilityReportDto = IraSecondAbilityReportDto.builder().rateScore(Integer.valueOf(this.txFloat(secondAnswerScore, secondTotalScore))).firstType(firstType).secondType(Integer.valueOf(secondType)).reportTime(new Date()).status("NORMAL").showStatus(showStatus).build();
            if (firstType == 1) {
                this.buildData(secondRead, secondAbilityReportDto, secondAnswerScore, secondTotalScore, secondAnswerQuestionNum, secondTotalQuestionNum);
                this.buildFirstMapData(firstReportMap, secondAbilityReportDto, "READ");
            }
            if (firstType == 2) {
                this.buildData(secondLearn, secondAbilityReportDto, secondAnswerScore, secondTotalScore, secondAnswerQuestionNum, secondTotalQuestionNum);
                this.buildFirstMapData(firstReportMap, secondAbilityReportDto, "LEARN");
            }
            if (firstType != 4) continue;
            this.buildData(secondListen, secondAbilityReportDto, secondAnswerScore, secondTotalScore, secondAnswerQuestionNum, secondTotalQuestionNum);
            this.buildFirstMapData(firstReportMap, secondAbilityReportDto, "LISTEN");
        }
        return firstReportMap;
    }

    private void buildFirstCodeData(IraFirstAbilityBaseData secondRead, IraFirstAbilityReportDto reportDto) {
        if (reportDto == null) {
            secondRead.setFirstCode(CoreUtil.createCommonsCore((String)"F", (int)4));
            secondRead.setStatus(1);
        } else {
            secondRead.setFirstCode(reportDto.getFirstCode());
            secondRead.setStatus(0);
        }
    }

    private void buildData(IraFirstAbilityBaseData secondData, IraSecondAbilityReportDto secondReportDto, int secondAnswerScore, int secondTotalScore, int secondAnswerQuestionNum, int secondTotalQuestionNum) {
        secondReportDto.setFirstCode(secondData.getFirstCode());
        secondData.setSecondScoreCount(secondData.getSecondScoreCount() + secondAnswerScore);
        secondData.setSecondTotalScoreCount(secondData.getSecondTotalScoreCount() + secondTotalScore);
        secondData.setSecondQuestionNumCount(secondData.getSecondQuestionNumCount() + secondAnswerQuestionNum);
        secondData.setSecondTotalQuestionNumCount(secondData.getSecondTotalQuestionNumCount() + secondTotalQuestionNum);
    }

    private void buildFirstMapData(Map<String, List<IraSecondAbilityReportDto>> firstReportMap, IraSecondAbilityReportDto secondReportDto, String type) {
        List<IraSecondAbilityReportDto> tempList = firstReportMap.get(type);
        if (CollectionUtils.isEmpty(tempList)) {
            tempList = new ArrayList<IraSecondAbilityReportDto>();
        }
        tempList.add(secondReportDto);
        firstReportMap.put(type, tempList);
    }

    public int txFloat(int a, int b) {
        if (b == 0) {
            return 0;
        }
        float number = (float)a / (float)b * 100.0f;
        DecimalFormat df = new DecimalFormat("#");
        df.setRoundingMode(RoundingMode.HALF_UP);
        Integer value = Integer.valueOf(df.format(number));
        if (value == null) {
            return 0;
        }
        return value;
    }

    public Float txFloatScore(int a, int b) {
        if (b == 0) {
            return Float.valueOf(0.0f);
        }
        float number = (float)a / (float)b;
        DecimalFormat df = new DecimalFormat("0.00");
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Float.valueOf(df.format(number));
    }

    private Map<String, Map<Integer, Integer>> secondAbilityData(Map<String, Integer> typeMap, String uid, String mapCode) {
        List questionScoreList;
        HashMap<String, Map<Integer, Integer>> mapMap = new HashMap<String, Map<Integer, Integer>>();
        HashMap<Integer, Integer> secondQuestionNumMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> secondQuestionScoreMap = new HashMap<Integer, Integer>();
        if (MapUtils.isNotEmpty(typeMap) && CollectionUtils.isNotEmpty((Collection)(questionScoreList = this.listQuestionScore(uid, mapCode)))) {
            for (IraQuestionScoreDto temp : questionScoreList) {
                if (temp == null) continue;
                String missionCode = temp.getMissionCode();
                String pageId = temp.getPageId();
                String groupId = temp.getGroupId();
                String questionId = temp.getQuestionId();
                Integer questionScore = temp.getQuestionScore();
                String key = missionCode + pageId + groupId + questionId;
                Integer questionType = typeMap.get(key);
                if (questionType == null || questionType <= 0) continue;
                Integer secondScoreCount = (Integer)secondQuestionScoreMap.get(questionType);
                if (secondScoreCount == null) {
                    secondQuestionScoreMap.put(questionType, questionScore);
                } else {
                    secondScoreCount = secondScoreCount + questionScore;
                    secondQuestionScoreMap.put(questionType, secondScoreCount);
                }
                Integer numCount = (Integer)secondQuestionNumMap.get(questionType);
                if (numCount == null) {
                    secondQuestionNumMap.put(questionType, 1);
                    continue;
                }
                numCount = numCount + 1;
                secondQuestionNumMap.put(questionType, numCount);
            }
        }
        mapMap.put("answerNum", secondQuestionNumMap);
        mapMap.put("answerScore", secondQuestionScoreMap);
        return mapMap;
    }

    private List<IraSecondAbilityReportDto> generateSpeechSecondAbility(Map<Integer, IraFirstAbilityReportDto> firstMapBySql, IraFirstAbilityBaseData secondSpeech, Map<Integer, Integer> secondTotalNumMap, List<UserCourse> courseList) {
        int speechFluencyRateScore = 0;
        int speechAccuracyRateScore = 0;
        String speechFluencyShowStatus = ShowStatusEnum.NOT_INSPECT.getDesc();
        String speechAccuracyShowStatus = ShowStatusEnum.NOT_INSPECT.getDesc();
        String speechIntegrityShowStatus = ShowStatusEnum.NOT_INSPECT.getDesc();
        if (MapUtils.isNotEmpty(secondTotalNumMap)) {
            Integer speechIntegrityQuestionNum;
            Integer speechAccuracyQuestionNum;
            Integer speechFluencyQuestionNum = secondTotalNumMap.get(AbilitySecondTypeEnum.\u6d41\u5229\u5ea6.getCode());
            if (null != speechFluencyQuestionNum && 0 != speechFluencyQuestionNum) {
                speechFluencyShowStatus = ShowStatusEnum.UNLOCKED.getDesc();
            }
            if (null != (speechAccuracyQuestionNum = secondTotalNumMap.get(AbilitySecondTypeEnum.\u97f3\u51c6\u5ea6.getCode())) && 0 != speechAccuracyQuestionNum) {
                speechAccuracyShowStatus = ShowStatusEnum.UNLOCKED.getDesc();
            }
            if (null != (speechIntegrityQuestionNum = secondTotalNumMap.get(AbilitySecondTypeEnum.\u5b8c\u6574\u5ea6.getCode())) && 0 != speechIntegrityQuestionNum) {
                speechIntegrityShowStatus = ShowStatusEnum.UNLOCKED.getDesc();
            }
        }
        ArrayList<IraSecondAbilityReportDto> list = new ArrayList<IraSecondAbilityReportDto>();
        this.buildFirstCodeData(secondSpeech, firstMapBySql.get(3));
        String firstCode = secondSpeech.getFirstCode();
        if (CollectionUtils.isNotEmpty(courseList) && CollectionUtils.isNotEmpty(courseList = courseList.stream().filter(e -> null != e.getSpeechFluency()).filter(e -> null != e.getSpeechAccuracy()).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(courseList = courseList.stream().filter(e -> 0.0 != e.getSpeechAccuracy() || 0.0 != e.getSpeechFluency()).collect(Collectors.toList()))) {
            speechFluencyShowStatus = ShowStatusEnum.BEGINNING.getDesc();
            speechAccuracyShowStatus = ShowStatusEnum.BEGINNING.getDesc();
            speechFluencyRateScore = (int)courseList.stream().filter(e -> 0.0 != e.getSpeechFluency()).mapToDouble(UserCourse::getSpeechFluency).average().orElse(0.0);
            speechAccuracyRateScore = (int)courseList.stream().filter(e -> 0.0 != e.getSpeechAccuracy()).mapToDouble(UserCourse::getSpeechAccuracy).average().orElse(0.0);
        }
        IraSecondAbilityReportDto speechFluencyReport = IraSecondAbilityReportDto.builder().firstCode(firstCode).rateScore(Integer.valueOf(speechFluencyRateScore)).firstType(Integer.valueOf(AbilityTypeEnum.\u53e3\u8bed\u80fd\u529b.getCode())).secondType(Integer.valueOf(AbilitySecondTypeEnum.\u6d41\u5229\u5ea6.getCode())).reportTime(new Date()).showStatus(speechFluencyShowStatus).status(DataStatusEnum.NORMAL.getCode()).build();
        IraSecondAbilityReportDto speechAccuracyReport = IraSecondAbilityReportDto.builder().firstCode(firstCode).rateScore(Integer.valueOf(speechAccuracyRateScore)).firstType(Integer.valueOf(AbilityTypeEnum.\u53e3\u8bed\u80fd\u529b.getCode())).secondType(Integer.valueOf(AbilitySecondTypeEnum.\u97f3\u51c6\u5ea6.getCode())).reportTime(new Date()).showStatus(speechAccuracyShowStatus).status(DataStatusEnum.NORMAL.getCode()).build();
        IraSecondAbilityReportDto speechIntegrityReport = IraSecondAbilityReportDto.builder().firstCode(firstCode).rateScore(Integer.valueOf(0)).firstType(Integer.valueOf(AbilityTypeEnum.\u53e3\u8bed\u80fd\u529b.getCode())).secondType(Integer.valueOf(AbilitySecondTypeEnum.\u5b8c\u6574\u5ea6.getCode())).reportTime(new Date()).showStatus(speechIntegrityShowStatus).status(DataStatusEnum.NORMAL.getCode()).build();
        list.add(speechAccuracyReport);
        list.add(speechIntegrityReport);
        list.add(speechFluencyReport);
        return list;
    }

    private IraFirstAbilityReportDto generateSpeechFirstAbility(List<IraSecondAbilityReportDto> secondAbilities, IraReportDto iraReportDto, IraFirstAbilityBaseData secondSpeech, List<UserCourse> courseList, Map<Integer, Integer> secondTotalNumMap) {
        if (CollectionUtils.isNotEmpty(secondAbilities)) {
            Integer speechFluencyTotalQuestionNum = secondTotalNumMap.get(AbilitySecondTypeEnum.\u6d41\u5229\u5ea6.getCode());
            Integer speechAccuracyTotalQuestionNum = secondTotalNumMap.get(AbilitySecondTypeEnum.\u97f3\u51c6\u5ea6.getCode());
            Integer speechIntegrityTotalQuestionNum = secondTotalNumMap.get(AbilitySecondTypeEnum.\u5b8c\u6574\u5ea6.getCode());
            int totalQuestionNum = (Integer)ObjectUtils.defaultIfNull((Object)speechFluencyTotalQuestionNum, (Object)0) + (Integer)ObjectUtils.defaultIfNull((Object)speechAccuracyTotalQuestionNum, (Object)0) + (Integer)ObjectUtils.defaultIfNull((Object)speechIntegrityTotalQuestionNum, (Object)0);
            if (0 == totalQuestionNum) {
                return null;
            }
            int newIraNum = 0;
            if (CollectionUtils.isNotEmpty(courseList)) {
                double speechAccuracySum = courseList.stream().filter(e -> e.getSpeechAccuracy() != null && e.getSpeechAccuracy() > 0.0).mapToDouble(UserCourse::getSpeechAccuracy).sum();
                double speechFluencySum = courseList.stream().filter(e -> e.getSpeechFluency() != null && e.getSpeechFluency() > 0.0).mapToDouble(UserCourse::getSpeechFluency).sum();
                newIraNum = (int)(speechAccuracySum + speechFluencySum) / (totalQuestionNum * 100) * 100;
            }
            float interactQuality = (float)secondAbilities.stream().filter(e -> StringUtils.equalsIgnoreCase((CharSequence)e.getShowStatus(), (CharSequence)ShowStatusEnum.BEGINNING.getDesc())).mapToDouble(IraSecondAbilityReportDto::getRateScore).sum() / 200.0f;
            int answeredQuestionNum = this.userCourseMapper.getCompletedSpeechByUidAndMapCode(iraReportDto.getUid(), iraReportDto.getMapCode());
            Integer oldIraNum = this.iraFirstAbilityReportMapper.getLastIraNumByUidAndMapCode(iraReportDto.getUid(), iraReportDto.getMapCode(), AbilityTypeEnum.\u53e3\u8bed\u80fd\u529b.getCode());
            int iraNumChange = 0;
            if (Objects.nonNull(oldIraNum)) {
                iraNumChange = newIraNum - oldIraNum;
            }
            return IraFirstAbilityReportDto.builder().firstCode(secondSpeech.getFirstCode()).reportCode(iraReportDto.getReportCode()).iraNum(Integer.valueOf(newIraNum > 100 ? 100 : newIraNum)).iraNumChange(Integer.valueOf(iraNumChange < 0 ? 0 : iraNumChange)).interactTotal(Integer.valueOf(totalQuestionNum)).interactFinished(Integer.valueOf(answeredQuestionNum > totalQuestionNum ? totalQuestionNum : answeredQuestionNum)).interactQuality(Float.valueOf(interactQuality)).firstType(Integer.valueOf(AbilityTypeEnum.\u53e3\u8bed\u80fd\u529b.getCode())).reportTime(new Date()).idx(Integer.valueOf(3)).saveStatus(secondSpeech.getStatus()).secondAbilitys(secondAbilities).status(DataStatusEnum.NORMAL.getCode()).build();
        }
        return null;
    }

    static {
        abilityTypeMap.put(1, 1);
        abilityTypeMap.put(2, 1);
        abilityTypeMap.put(3, 1);
        abilityTypeMap.put(4, 2);
        abilityTypeMap.put(5, 2);
        abilityTypeMap.put(6, 2);
        abilityTypeMap.put(7, 2);
        abilityTypeMap.put(11, 4);
    }
}

