/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.CourseBook;
import com.ella.resource.domain.QuestionRecord;
import com.ella.resource.domain.ResQuestion;
import com.ella.resource.domain.UserCourse;
import com.ella.resource.domain.UserCourseExample;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.appdto.AnalysisTestInfoDto;
import com.ella.resource.dto.appdto.TestRecordDto;
import com.ella.resource.dto.request.app.TestAnswerRequest;
import com.ella.resource.mapper.CourseBookMapper;
import com.ella.resource.mapper.ResQuestionMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.AbstractEnTest;
import com.ella.resource.service.transactional.RpcService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CourseTestServiceImpl
extends AbstractEnTest {
    private static final Logger log = LogManager.getLogger(CourseTestServiceImpl.class);
    @Autowired
    private ResQuestionMapper resQuestionMapper;
    @Autowired
    private CourseBookMapper courseBookMapper;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private RpcService rpcService;

    protected AnalysisTestInfoDto doAnalysisTestAnswer(TestAnswerRequest request, BaseMission mission) {
        AnalysisTestInfoDto result = new AnalysisTestInfoDto();
        result.setIsPass(this.isPass(request, mission));
        CourseBook courseBook = this.courseBookMapper.selectByPrimaryKey(mission.getResourceId());
        result.setAnalysisResult((Object)courseBook);
        return result;
    }

    protected void afterCompletion(TestAnswerRequest request, BaseMission mission, UserMission userMission) {
        log.info("CourseTestServiceImpl.afterCompletion mission :{}", (Object)mission);
        Integer passNum = this.getPassNum(request);
        if (passNum > userMission.getCorrectNum()) {
            log.info("CourseTestServiceImpl.afterCompletion addUserStoneNum param {},{},{} ", (Object)request.getUid(), (Object)mission.getId(), (Object)this.getPassNum(request));
            this.rpcService.addUserStoneNum(request.getUid(), mission.getId(), Integer.valueOf(passNum - userMission.getCorrectNum()));
            userMission.setCorrectNum(passNum);
        }
        Integer totalNum = request.getAnswerInfoList().size();
        userMission.setTestNum(totalNum);
        userMission.setStatus("PASS");
        this.userMissionMapper.updateByPrimaryKeySelective(userMission);
        UserCourse userCourse = new UserCourse();
        userCourse.setStatus("PASS");
        UserCourseExample example1 = new UserCourseExample();
        example1.createCriteria().andUidEqualTo(request.getUid()).andMissionCodeEqualTo(mission.getMissionCode());
        log.info("CourseTestServiceImpl.afterCompletion begin updateByPrimaryKeySelective");
        this.userCourseMapper.updateByExampleSelective(userCourse, example1);
    }

    protected List<ResQuestion> getResQuestion(Long resourceId) {
        return this.resQuestionMapper.selectCourseQuestionByCourseId(resourceId);
    }

    protected void doQuestionRecord(TestRecordDto result, List<QuestionRecord> questionRecords, BaseMission mission) {
    }
}

