/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.domain.ActivitySendGoods;
import com.ella.resource.dto.ActivitySendGoodsDto;
import com.ella.resource.dto.PageDto;
import com.ella.resource.dto.request.activity.EditActivitySendGoodsRequest;
import com.ella.resource.dto.request.activity.FindActivityRequest;
import com.ella.resource.dto.request.activity.SaveActivitySendGoodsRequest;
import com.ella.resource.mapper.ActivitySendGoodsMapper;
import com.ella.resource.service.transactional.ActivityTService;
import com.github.pagehelper.PageHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityTServiceImpl
implements ActivityTService {
    private static final Logger log = LoggerFactory.getLogger(ActivityTServiceImpl.class);
    @Autowired
    ActivitySendGoodsMapper mapper;

    @Transactional(rollbackFor={Exception.class})
    public int saveActivitySendGoods(SaveActivitySendGoodsRequest request) {
        ActivitySendGoods activity = new ActivitySendGoods();
        BeanUtils.copyProperties((Object)request, (Object)activity);
        activity.setActivityCode(String.valueOf(IdWrokerUtils.nextId()));
        activity.setActivityType(DataEnum.ActivityTypeEnum.DIRECTIONAL.getCode());
        activity.setActivityStatus("WAITING");
        Date now = Calendar.getInstance().getTime();
        activity.setCreateTime(now);
        activity.setUpdateTime(now);
        int result = this.mapper.insertSelective(activity);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateActivitySendGoods(EditActivitySendGoodsRequest request) {
        ActivitySendGoods activity = new ActivitySendGoods();
        BeanUtils.copyProperties((Object)request, (Object)activity);
        activity.setUpdateTime(Calendar.getInstance().getTime());
        int result = this.mapper.updateByPrimaryKeySelective(activity);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public ActivitySendGoodsDto selectActivityById(FindActivityRequest request) {
        ActivitySendGoods result = this.mapper.selectByPrimaryKey(request.getId());
        ActivitySendGoodsDto dto = new ActivitySendGoodsDto();
        BeanUtils.copyProperties((Object)result, (Object)dto);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ActivitySendGoodsDto> selectAllActivity(PageDto request) {
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List list = this.mapper.selectAll();
        return list;
    }
}

