/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.dto.ClientTypeEnum;
import com.ella.resource.api.WordWallService;
import com.ella.resource.domain.WordSentence;
import com.ella.resource.domain.WordSentenceExample;
import com.ella.resource.domain.WordWall;
import com.ella.resource.domain.WordWallExample;
import com.ella.resource.dto.request.AddWordReq;
import com.ella.resource.dto.request.SelectWordReq;
import com.ella.resource.dto.request.app.PutUserWordWallRequest;
import com.ella.resource.mapper.WordSentenceMapper;
import com.ella.resource.mapper.WordWallMapper;
import com.ella.resource.utils.ResponseParamUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WordWallServiceImpl
implements WordWallService {
    private static final Logger log = LogManager.getLogger(WordWallServiceImpl.class);
    @Autowired(required=false)
    private WordWallMapper wordWallMapper;
    @Autowired
    private TransactionTemplate template;
    @Autowired
    private WordSentenceMapper wordSentenceMapper;

    @RequestMapping(value={"expotExcle/v1"}, method={RequestMethod.GET})
    public ResponseParams<List<List<String>>> expotExcle() {
        ArrayList lists = new ArrayList();
        ArrayList<String> strings = new ArrayList<String>();
        WordWallExample wordWallExample = new WordWallExample();
        wordWallExample.createCriteria().andUidEqualTo("").andStatusEqualTo("NORMAL");
        wordWallExample.setOrderByClause("initial asc");
        List wordWalls = this.wordWallMapper.selectByExample(wordWallExample);
        for (int i = 0; i < wordWalls.size(); ++i) {
            WordWall wordWall = (WordWall)wordWalls.get(i);
            strings.add(wordWall.getWord());
            if ((i + 1) % 15 != 0 && i != wordWalls.size() - 1) continue;
            lists.add(strings);
            strings = new ArrayList();
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, lists);
    }

    public ResponseParams addWord(@RequestBody AddWordReq req) {
        if (StringUtils.isEmpty((String)req.getWord()) && StringUtils.isEmpty((String)req.getType())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)false);
        }
        if (!ClientTypeEnum.OTS.getCode().equals(req.getType())) {
            WordWall wordWall = new WordWall();
            wordWall.setStatus("NORMAL");
            wordWall.setInitial(req.getWord().substring(0, 1).toUpperCase());
            wordWall.setCreateTime(new Date());
            wordWall.setUid(req.getUid());
            wordWall.setUpdateTime(new Date());
            wordWall.setWord(req.getWord());
            this.wordWallMapper.insert(wordWall);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        if (StringUtils.isNotEmpty((String)req.getStatus())) {
            WordWallExample wordWallExample = new WordWallExample();
            wordWallExample.createCriteria().andStatusEqualTo("NORMAL").andUidEqualTo("").andWordEqualTo(req.getWord());
            List wordWalls = this.wordWallMapper.selectByExample(wordWallExample);
            if (!CollectionUtils.isEmpty((Collection)wordWalls)) {
                ((WordWall)wordWalls.get(0)).setStatus("EXCEPTION");
                this.wordWallMapper.updateByPrimaryKey((WordWall)wordWalls.get(0));
            }
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(req.getWord());
        this.addBachWord(strings);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    @RequestMapping(value={"selectWord/V1"}, method={RequestMethod.POST})
    public ResponseParams selectWord(@RequestBody SelectWordReq req) {
        log.info("\u5355\u8bcd\u5899\u67e5\u8be2---> {}", (Object)JSONObject.toJSONString((Object)req));
        if (StringUtils.isEmpty((String)req.getType())) {
            return ResponseParams.build((String)CommonRetCode.PARAM_ERROR.getCode(), (String)CommonRetCode.PARAM_ERROR.getMsg());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        ArrayList list = new ArrayList();
        List wordWalls = this.getDefaultWord(req.getInitial());
        if (ClientTypeEnum.OTS.getCode().equals(req.getType())) {
            map.put("count", Integer.valueOf(wordWalls.size()));
            wordWalls.forEach(item -> list.add(item.getWord()));
            map.put("words", list);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, map);
        }
        WordWallExample wordWallExample = new WordWallExample();
        wordWallExample.setOrderByClause("initial asc");
        WordWallExample.Criteria criteria = wordWallExample.createCriteria();
        criteria.andUidEqualTo(req.getUid()).andStatusEqualTo("NORMAL");
        if (StringUtils.isNotEmpty((String)req.getInitial())) {
            criteria.andInitialEqualTo(req.getInitial());
        }
        wordWalls = this.wordWallMapper.selectByExample(wordWallExample);
        wordWalls.addAll(this.getDefaultWord(req.getInitial()));
        map.put("count", Integer.valueOf(wordWalls.size()));
        wordWalls.stream().sorted(Comparator.comparing(WordWall::getInitial)).forEach(item -> list.add(item.getWord()));
        map.put("words", list);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, map);
    }

    public boolean addBachWord(List<String> list) {
        ArrayList wordWalls = new ArrayList();
        return (Boolean)this.template.execute(tx -> {
            list.forEach(item -> {
                WordWallExample wordWallExample = new WordWallExample();
                wordWallExample.createCriteria().andWordEqualTo(item).andStatusEqualTo("NORMAL").andUidEqualTo("");
                if (CollectionUtils.isEmpty((Collection)this.wordWallMapper.selectByExample(wordWallExample))) {
                    WordWall wordWall = new WordWall();
                    wordWall.setCreateTime(new Date());
                    wordWall.setWord(item);
                    wordWall.setStatus("NORMAL");
                    wordWall.setDefaultWord("Y");
                    wordWall.setInitial(item.substring(0, 1).toUpperCase());
                    wordWall.setCreateTime(new Date());
                    wordWalls.add(wordWall);
                } else {
                    log.error("\u6279\u91cf\u63d2\u5165\u5355\u8bcd:---> {} \u5931\u8d25,\u8be5\u5355\u8bcd\u5df2\u7ecf\u5b58\u5728", item);
                }
            });
            if (!CollectionUtils.isEmpty((Collection)wordWalls)) {
                this.wordWallMapper.insertBatch((List)wordWalls);
            }
            return true;
        });
    }

    public ResponseParams<?> addBachWordStr(String contentsJson) {
        List contents = (List)JSON.parseObject((String)contentsJson, ArrayList.class);
        contents.forEach(arg_0 -> this.addBachWord(arg_0));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    @Transactional(rollbackFor={Exception.class})
    @EnableValidate
    public ResponseParams<Boolean> putUserWordWall(@RequestBody PutUserWordWallRequest request) {
        WordWallExample wordExample = new WordWallExample();
        wordExample.createCriteria().andUidEqualTo(request.getUid()).andWordEqualTo(request.getWord()).andStatusEqualTo("NORMAL");
        List wordWalls = this.wordWallMapper.selectByExample(wordExample);
        if (CollectionUtils.isEmpty((Collection)wordWalls)) {
            this.wordWallMapper.insertSelective(WordWall.builder().word(request.getWord()).createTime(new Date()).initial(String.valueOf(request.getWord().toCharArray()[0]).toUpperCase()).uid(request.getUid()).status("NORMAL").build());
        }
        WordSentenceExample sentenceExample = new WordSentenceExample();
        sentenceExample.createCriteria().andUidEqualTo(request.getUid()).andBookCodeEqualTo(request.getBookCode()).andMissionCodeEqualTo(request.getMissionCode()).andPageNumEqualTo(request.getPageNum()).andWordEqualTo(request.getWord()).andSentenceEqualTo(request.getSentence()).andStatusEqualTo("NORMAL");
        List wordSentences = this.wordSentenceMapper.selectByExample(sentenceExample);
        if (CollectionUtils.isEmpty((Collection)wordSentences)) {
            this.wordSentenceMapper.insertSelective(WordSentence.builder().uid(request.getUid()).bookCode(request.getBookCode()).missionCode(request.getMissionCode()).pageNum(request.getPageNum()).word(request.getWord()).sentence(request.getSentence()).status("NORMAL").createTime(new Date()).ellaSpeechUrl(request.getEllaSpeechUrl()).build());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private List<WordWall> getDefaultWord(String initial) {
        WordWallExample wordWallExample = new WordWallExample();
        wordWallExample.setOrderByClause("initial asc");
        WordWallExample.Criteria criteria = wordWallExample.createCriteria().andDefaultWordEqualTo("Y").andStatusEqualTo("NORMAL");
        if (StringUtils.isNotEmpty((String)initial)) {
            criteria.andInitialEqualTo(initial);
        }
        return this.wordWallMapper.selectByExample(wordWallExample);
    }
}

