/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.order.dto.ClientTypeEnum;
import com.ella.resource.api.UserSendGoodsService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.domain.CourseBook;
import com.ella.resource.domain.CourseBookExample;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.PictureBook;
import com.ella.resource.domain.PictureBookExample;
import com.ella.resource.domain.UserBook;
import com.ella.resource.domain.UserBookExample;
import com.ella.resource.domain.UserCourse;
import com.ella.resource.domain.UserCourseExample;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMapExample;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserMissionExample;
import com.ella.resource.dto.sendgoods.FetchTypeEnum;
import com.ella.resource.dto.sendgoods.ResTypeEnum;
import com.ella.resource.dto.sendgoods.SendGoodsToUserRequest;
import com.ella.resource.dto.sendgoods.StatusEnum;
import com.ella.resource.mapper.CourseBookMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.PictureBookMapper;
import com.ella.resource.mapper.UserBookMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.dto.account.AccountTypeEnum;
import com.ella.user.dto.account.ModifyUserEllaCoinRequest;
import com.ella.user.dto.account.MoneyChangeTypeEnum;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserSendGoodsServiceImpl
implements UserSendGoodsService {
    private static final Logger log = LogManager.getLogger(UserSendGoodsServiceImpl.class);
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private UserBookMapper userBookMapper;
    @Autowired
    private UserAccountService accountService;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private CourseBookMapper courseBookMapper;
    @Autowired
    private PictureBookMapper picureBookMapper;

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<Boolean> sendGoodsToUser(@RequestBody SendGoodsToUserRequest req) {
        log.info("sendGoodsToUser --- req :{}", (Object)req);
        for (String itemCode : req.getItems().keySet()) {
            if (ResTypeEnum.MAP == req.getItems().get(itemCode)) {
                this.sendUserMap(itemCode, req.getUserId());
                continue;
            }
            if (ResTypeEnum.MESSION == req.getItems().get(itemCode)) {
                this.sendUserMission(itemCode, req.getUserId());
                continue;
            }
            if (ResTypeEnum.BOOK == req.getItems().get(itemCode)) {
                this.sendUserBook(itemCode, req.getUserId());
                continue;
            }
            log.error("sendGoodsToUser \u4e0d\u652f\u6301\u7684\u5546\u54c1\u7c7b\u578b : {}", (Object)req);
        }
        this.callUserAccountService(req);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private void sendUserMap(String itemCode, String usrId) {
        Date now;
        Map map = this.mapMapper.selectByMapCode(itemCode);
        UserMapExample examp = new UserMapExample();
        examp.createCriteria().andMapCodeEqualTo(itemCode).andUidEqualTo(usrId);
        int count = this.userMapMapper.countByExample(examp);
        UserMap userMap = null;
        if (count == 0) {
            userMap = new UserMap();
            BeanUtils.copyProperties((Object)map, (Object)userMap);
            now = Calendar.getInstance().getTime();
            userMap.setCreateTime(now);
            userMap.setUpdateTime(now);
            userMap.setUid(usrId);
            userMap.setId(Long.valueOf(IdWrokerUtils.nextId()));
            this.userMapMapper.insertSelective(userMap);
        } else {
            UserMap updateMap = new UserMap();
            updateMap.setFetchType(FetchTypeEnum.BUY.getCode());
            UserMapExample userMapExam = new UserMapExample();
            userMapExam.createCriteria().andMapCodeEqualTo(itemCode).andUidEqualTo(usrId);
            this.userMapMapper.updateByExampleSelective(updateMap, userMapExam);
        }
        if (userMap == null) {
            userMap = new UserMap();
            now = Calendar.getInstance().getTime();
            userMap.setMapCode(itemCode);
            userMap.setUid(usrId);
            userMap.setCreateTime(now);
            userMap.setUpdateTime(now);
        }
        this.sendUserMission(userMap);
    }

    private void sendUserMission(String itemCode, String userId) {
        Mission queryMission = new Mission();
        queryMission.setMissionCode(itemCode);
        List missionList = this.missionMapper.selectMissionList(queryMission);
        if (missionList == null || missionList.isEmpty()) {
            return;
        }
        UserMissionExample exam = new UserMissionExample();
        exam.createCriteria().andMissionCodeEqualTo(((Mission)missionList.get(0)).getMissionCode()).andUidEqualTo(userId);
        int count = this.userMissionMapper.countByExample(exam);
        if (count == 0) {
            return;
        }
        Mission mission = (Mission)missionList.get(0);
        UserMission userMission = new UserMission();
        BeanUtils.copyProperties(missionList.get(0), (Object)userMission);
        userMission.setId(Long.valueOf(IdWrokerUtils.nextId()));
        userMission.setUid(userId);
        userMission.setMissionCode(itemCode);
        userMission.setFetchType(FetchTypeEnum.BUY.getCode());
        userMission.setStatus("NOTSTARTED");
        Date now = Calendar.getInstance().getTime();
        userMission.setCreateTime(now);
        userMission.setUpdateTime(now);
        this.userMissionMapper.insert(userMission);
        if (DataEnum.MissionType.TYPE_COURSE.getType().equals(mission.getMissionType())) {
            this.sendUserCourse(mission, userId, now);
        } else if (DataEnum.MissionType.TYPE_HIDE.getType().equals(mission.getMissionType())) {
            this.sendUserBook(mission.getResourceId(), userId, now);
        }
    }

    private void sendUserBook(String itemCode, String userId) {
        UserBookExample exam = new UserBookExample();
        exam.createCriteria().andBookCodeEqualTo(itemCode).andUidEqualTo(userId);
        int count = this.userBookMapper.countByExample(exam);
        if (count > 0) {
            return;
        }
        UserBook userBook = new UserBook();
        userBook.setBookCode(itemCode);
        userBook.setId(Long.valueOf(IdWrokerUtils.nextId()));
        userBook.setStatus("NORMAL");
        userBook.setFetchType(FetchTypeEnum.BUY.getCode());
        Date now = Calendar.getInstance().getTime();
        userBook.setCreateTime(now);
        userBook.setUpdateTime(now);
        userBook.setLastReadTime(now);
        userBook.setUid(userId);
        this.userBookMapper.insert(userBook);
    }

    private void sendUserBook(Integer id, String userId, Date now) {
        PictureBook pitureBook = this.picureBookMapper.selectByPrimaryKey(id);
        if (pitureBook == null) {
            return;
        }
        UserBook userBook = new UserBook();
        userBook.setBookCode(pitureBook.getBookCode());
        userBook.setId(Long.valueOf(IdWrokerUtils.nextId()));
        userBook.setStatus("NOTSTARTED");
        userBook.setFetchType(FetchTypeEnum.BUY.getCode());
        userBook.setCreateTime(now);
        userBook.setUpdateTime(now);
        userBook.setLastReadTime(now);
        userBook.setUid(userId);
        this.userBookMapper.insert(userBook);
    }

    private void sendUserCourse(Mission mission, String userId, Date now) {
        CourseBook courseBook = this.courseBookMapper.selectByPrimaryKey(mission.getResourceId());
        if (courseBook == null) {
            return;
        }
        UserCourseExample exam = new UserCourseExample();
        exam.createCriteria().andBookCodeEqualTo(courseBook.getBookCode()).andUidEqualTo(userId);
        int count = this.userCourseMapper.countByExample(exam);
        if (count == 0) {
            return;
        }
        Map map = this.mapMapper.selectByMapCode(mission.getMapCode());
        UserCourse userCourse = new UserCourse();
        userCourse.setId(Long.valueOf(IdWrokerUtils.nextId()));
        userCourse.setBookCode(courseBook.getBookCode());
        userCourse.setStatus("NOTSTARTED");
        userCourse.setCourseCode(courseBook.getCourseCode());
        userCourse.setMapCode(mission.getMapCode());
        userCourse.setLevelCode(map.getLevelCode());
        userCourse.setCreateTime(now);
        userCourse.setUpdateTime(now);
        userCourse.setUid(userId);
        this.userCourseMapper.insert(userCourse);
    }

    private void sendUserMission(UserMap userMap) {
        Mission queryMission = new Mission();
        queryMission.setMapCode(userMap.getMapCode());
        List missionList = this.missionMapper.selectMissionList(queryMission);
        if (missionList == null || missionList.isEmpty()) {
            return;
        }
        ArrayList<UserMission> userMissions = new ArrayList<UserMission>();
        if (missionList != null && !missionList.isEmpty()) {
            java.util.Map map = this.getUserAlreadHasMission(userMap.getMapCode(), userMap.getUid());
            ArrayList<Integer> userCourseIds = new ArrayList<Integer>();
            ArrayList<Integer> userBookIds = new ArrayList<Integer>();
            for (Mission mission : missionList) {
                if (map != null && map.get(mission.getMissionCode()) != null) continue;
                UserMission userMission = new UserMission();
                BeanUtils.copyProperties((Object)mission, (Object)userMission);
                userMission.setId(Long.valueOf(IdWrokerUtils.nextId()));
                userMission.setUid(userMap.getUid());
                userMission.setStatus("NOTSTARTED");
                userMission.setFetchType(FetchTypeEnum.BUY.getCode());
                userMission.setCreateTime(userMap.getCreateTime());
                userMission.setUpdateTime(userMap.getUpdateTime());
                if (DataEnum.MissionType.TYPE_COURSE.getTypeValue().equals(mission.getMissionType())) {
                    userCourseIds.add(mission.getResourceId());
                } else if (DataEnum.MissionType.TYPE_HIDE.getTypeValue().equals(mission.getMissionType())) {
                    userBookIds.add(mission.getResourceId());
                }
                userMissions.add(userMission);
            }
            this.userMissionMapper.batchInsert(userMissions);
            this.sendUserCourse(userCourseIds, userMap);
            this.sendUserBook(userBookIds, userMap);
        }
    }

    private void sendUserBook(List<Integer> itemIds, UserMap userMap) {
        if (itemIds.isEmpty()) {
            return;
        }
        PictureBookExample exam = new PictureBookExample();
        exam.createCriteria().andStatusEqualTo(StatusEnum.NORMAL.getCode()).andIdIn(itemIds);
        List list = this.picureBookMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return;
        }
        java.util.Map map = this.getUserAlreadHasBook(list, userMap.getUid());
        ArrayList<UserBook> books = new ArrayList<UserBook>();
        for (PictureBook book : list) {
            if (map != null && map.get(book.getBookCode()) != null) continue;
            UserBook userBook = new UserBook();
            userBook.setBookCode(book.getBookCode());
            userBook.setId(Long.valueOf(IdWrokerUtils.nextId()));
            userBook.setStatus("NOTSTARTED");
            userBook.setFetchType(FetchTypeEnum.BUY.getCode());
            userBook.setCreateTime(userMap.getCreateTime());
            userBook.setUpdateTime(userMap.getUpdateTime());
            userBook.setUid(userMap.getUid());
            books.add(userBook);
        }
        this.userBookMapper.batchInsert(books);
    }

    private void sendUserCourse(List<Integer> itemIds, UserMap userMap) {
        if (itemIds.isEmpty()) {
            return;
        }
        CourseBookExample exam = new CourseBookExample();
        exam.createCriteria().andStatusEqualTo(StatusEnum.NORMAL.getCode()).andIdIn(itemIds);
        List list = this.courseBookMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return;
        }
        java.util.Map map = this.getUserAlreadHasCourse(list, userMap.getUid());
        ArrayList<UserCourse> userCourses = new ArrayList<UserCourse>();
        for (CourseBook book : list) {
            if (map != null && map.get(book.getBookCode()) != null) continue;
            UserCourse userCourse = new UserCourse();
            userCourse.setId(Long.valueOf(IdWrokerUtils.nextId()));
            userCourse.setBookCode(book.getBookCode());
            userCourse.setStatus("NOTSTARTED");
            userCourse.setCourseCode(book.getCourseCode());
            userCourse.setMapCode(userMap.getMapCode());
            userCourse.setCreateTime(userMap.getCreateTime());
            userCourse.setUpdateTime(userMap.getUpdateTime());
            userCourse.setUid(userMap.getUid());
            userCourses.add(userCourse);
        }
        this.userCourseMapper.batchInsert(userCourses);
    }

    private java.util.Map<String, UserMission> getUserAlreadHasMission(String mapCode, String usrId) {
        UserMissionExample exam = new UserMissionExample();
        exam.createCriteria().andMapCodeEqualTo(mapCode).andUidEqualTo(usrId);
        List list = this.userMissionMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, UserMission> map = new HashMap<String, UserMission>();
        for (UserMission um : list) {
            map.put(um.getMissionCode(), um);
        }
        return map;
    }

    private java.util.Map<String, UserBook> getUserAlreadHasBook(List<PictureBook> books, String usrId) {
        ArrayList<String> codes = new ArrayList<String>();
        for (PictureBook book : books) {
            codes.add(book.getBookCode());
        }
        UserBookExample exam = new UserBookExample();
        exam.createCriteria().andBookCodeIn(codes).andUidEqualTo(usrId);
        List list = this.userBookMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, UserBook> map = new HashMap<String, UserBook>();
        for (UserBook um : list) {
            map.put(um.getBookCode(), um);
        }
        return map;
    }

    private java.util.Map<String, UserCourse> getUserAlreadHasCourse(List<CourseBook> books, String usrId) {
        ArrayList<String> codes = new ArrayList<String>();
        for (CourseBook book : books) {
            codes.add(book.getBookCode());
        }
        UserCourseExample exam = new UserCourseExample();
        exam.createCriteria().andBookCodeIn(codes).andUidEqualTo(usrId);
        List list = this.userCourseMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, UserCourse> map = new HashMap<String, UserCourse>();
        for (UserCourse um : list) {
            map.put(um.getBookCode(), um);
        }
        return map;
    }

    private void callUserAccountService(SendGoodsToUserRequest param) {
        log.info("callUserAccountService -- change money start orderNo : {}", (Object)param.getOrderNo());
        ModifyUserEllaCoinRequest req = new ModifyUserEllaCoinRequest();
        req.setOrderNo(param.getOrderNo());
        req.setChangeMoney(param.getOrderActual());
        req.setChangeType(MoneyChangeTypeEnum.MINUS);
        req.setTimex(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
        if (ClientTypeEnum.IOS.getCode().equalsIgnoreCase(param.getClientType())) {
            req.setApplicableObject(AccountTypeEnum.IOS_ACCOUNT);
        } else {
            req.setApplicableObject(AccountTypeEnum.NORMAL_ACCOUNT);
        }
        req.setUid(param.getUserId());
        ResponseParams response = this.accountService.modifyUserEllaCoin(req);
        log.info("callUserAccountService --  change money response :{}", (Object)response);
        if (response == null || !CommonRetCode.SUCCESS.getCode().equals(response.getCode()) || response.getData() == null || !((Boolean)response.getData()).booleanValue()) {
            throw new EllaEnglishException(response.getCode(), response.getMessage(), null);
        }
        log.info("callUserAccountService -- change money success end orderNo : {}", (Object)param.getOrderNo());
    }
}

